// gpu/ipc/common/sync_token.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_SYNC_TOKEN_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_SYNC_TOKEN_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "gpu/ipc/common/sync_token.mojom-shared-internal.h"


namespace gpu::mojom {
class SyncTokenDataView;



}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::SyncTokenDataView> {
  using Data = ::gpu::mojom::internal::SyncToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


enum class CommandBufferNamespace : int32_t {
  
  INVALID = -1,
  
  GPU_IO = 0,
  
  IN_PROCESS = 1,
  
  VIZ_SKIA_OUTPUT_SURFACE = 2,
  
  VIZ_SKIA_OUTPUT_SURFACE_NON_DDL = 3,
  
  GPU_CHANNEL_SHARED_IMAGE_INTERFACE = 4,
  
  WEBNN_CONTEXT_INTERFACE = 5,
  kMinValue = -1,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, CommandBufferNamespace value);
inline bool IsKnownEnumValue(CommandBufferNamespace value) {
  return internal::CommandBufferNamespace_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SyncTokenDataView {
 public:
  SyncTokenDataView() = default;

  SyncTokenDataView(
      internal::SyncToken_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool verified_flush() const {
    return data_->verified_flush;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNamespaceId(UserType* output) const {
    auto data_value = data_->namespace_id;
    return mojo::internal::Deserialize<::gpu::mojom::CommandBufferNamespace>(
        data_value, output);
  }
  CommandBufferNamespace namespace_id() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::CommandBufferNamespace>(data_->namespace_id));
  }
  uint64_t command_buffer_id() const {
    return data_->command_buffer_id;
  }
  uint64_t release_count() const {
    return data_->release_count;
  }
 private:
  internal::SyncToken_Data* data_ = nullptr;
};


}  // gpu::mojom

#endif  // GPU_IPC_COMMON_SYNC_TOKEN_MOJOM_DATA_VIEW_H_