// gpu/ipc/common/shared_image_metadata.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "gpu/ipc/common/shared_image_metadata.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "skia/public/mojom/surface_origin.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"


namespace gpu::mojom {
class SharedImageMetadataDataView;



}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::SharedImageMetadataDataView> {
  using Data = ::gpu::mojom::internal::SharedImageMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


class SharedImageMetadataDataView {
 public:
  SharedImageMetadataDataView() = default;

  SharedImageMetadataDataView(
      internal::SharedImageMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFormatDataView(
      ::viz::mojom::SharedImageFormatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) {
    
    auto* pointer = !data_->format.is_null() ? &data_->format : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::SharedImageFormatDataView>(
        pointer, output, message_);
  }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpace(UserType* output) {
    
    auto* pointer = data_->color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSurfaceOrigin(UserType* output) const {
    auto data_value = data_->surface_origin;
    return mojo::internal::Deserialize<::skia::mojom::SurfaceOrigin>(
        data_value, output);
  }
  ::skia::mojom::SurfaceOrigin surface_origin() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::SurfaceOrigin>(data_->surface_origin));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAlphaType(UserType* output) const {
    auto data_value = data_->alpha_type;
    return mojo::internal::Deserialize<::skia::mojom::AlphaType>(
        data_value, output);
  }
  ::skia::mojom::AlphaType alpha_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::AlphaType>(data_->alpha_type));
  }
  uint32_t usage() const {
    return data_->usage;
  }
 private:
  internal::SharedImageMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

#endif  // GPU_IPC_COMMON_SHARED_IMAGE_METADATA_MOJOM_DATA_VIEW_H_