// gpu/ipc/common/shared_image_capabilities.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_SHARED_IMAGE_CAPABILITIES_MOJOM_BLINK_H_
#define GPU_IPC_COMMON_SHARED_IMAGE_CAPABILITIES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/shared_image_capabilities.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/shared_image_capabilities.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/shared_image_capabilities.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gpu::mojom::blink {








class BLINK_PLATFORM_EXPORT SharedImageCapabilities {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedImageCapabilities, T>::value>;
  using DataView = SharedImageCapabilitiesDataView;
  using Data_ = internal::SharedImageCapabilities_Data;

  template <typename... Args>
  static SharedImageCapabilitiesPtr New(Args&&... args) {
    return SharedImageCapabilitiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedImageCapabilitiesPtr From(const U& u) {
    return mojo::TypeConverter<SharedImageCapabilitiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedImageCapabilities>::Convert(*this);
  }


  SharedImageCapabilities();

  SharedImageCapabilities(
      bool supports_scanout_shared_images,
      bool supports_luminance_shared_images,
      bool supports_r16_shared_images,
      bool supports_native_nv12_mappable_shared_images,
      bool is_r16f_supported,
      bool disable_r8_shared_images,
      bool disable_webgpu_shared_images,
      bool disable_one_component_textures,
      bool shared_image_d3d,
      bool shared_image_swap_chain,
      uint32_t texture_target_for_io_surfaces);


  ~SharedImageCapabilities();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedImageCapabilitiesPtr>
  SharedImageCapabilitiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedImageCapabilities::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedImageCapabilities::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedImageCapabilities::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedImageCapabilities::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedImageCapabilities::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedImageCapabilities::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedImageCapabilities_UnserializedMessageContext<
            UserType, SharedImageCapabilities::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedImageCapabilities::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedImageCapabilities::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedImageCapabilities_UnserializedMessageContext<
            UserType, SharedImageCapabilities::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedImageCapabilities::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool supports_scanout_shared_images;
  
  bool supports_luminance_shared_images;
  
  bool supports_r16_shared_images;
  
  bool supports_native_nv12_mappable_shared_images;
  
  bool is_r16f_supported;
  
  bool disable_r8_shared_images;
  
  bool disable_webgpu_shared_images;
  
  bool disable_one_component_textures;
  
  bool shared_image_d3d;
  
  bool shared_image_swap_chain;
  
  uint32_t texture_target_for_io_surfaces;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedImageCapabilities::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedImageCapabilities::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedImageCapabilities::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedImageCapabilities::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SharedImageCapabilitiesPtr SharedImageCapabilities::Clone() const {
  return New(
      mojo::Clone(supports_scanout_shared_images),
      mojo::Clone(supports_luminance_shared_images),
      mojo::Clone(supports_r16_shared_images),
      mojo::Clone(supports_native_nv12_mappable_shared_images),
      mojo::Clone(is_r16f_supported),
      mojo::Clone(disable_r8_shared_images),
      mojo::Clone(disable_webgpu_shared_images),
      mojo::Clone(disable_one_component_textures),
      mojo::Clone(shared_image_d3d),
      mojo::Clone(shared_image_swap_chain),
      mojo::Clone(texture_target_for_io_surfaces)
  );
}

template <typename T, SharedImageCapabilities::EnableIfSame<T>*>
bool SharedImageCapabilities::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->supports_scanout_shared_images, other_struct.supports_scanout_shared_images))
    return false;
  if (!mojo::Equals(this->supports_luminance_shared_images, other_struct.supports_luminance_shared_images))
    return false;
  if (!mojo::Equals(this->supports_r16_shared_images, other_struct.supports_r16_shared_images))
    return false;
  if (!mojo::Equals(this->supports_native_nv12_mappable_shared_images, other_struct.supports_native_nv12_mappable_shared_images))
    return false;
  if (!mojo::Equals(this->is_r16f_supported, other_struct.is_r16f_supported))
    return false;
  if (!mojo::Equals(this->disable_r8_shared_images, other_struct.disable_r8_shared_images))
    return false;
  if (!mojo::Equals(this->disable_webgpu_shared_images, other_struct.disable_webgpu_shared_images))
    return false;
  if (!mojo::Equals(this->disable_one_component_textures, other_struct.disable_one_component_textures))
    return false;
  if (!mojo::Equals(this->shared_image_d3d, other_struct.shared_image_d3d))
    return false;
  if (!mojo::Equals(this->shared_image_swap_chain, other_struct.shared_image_swap_chain))
    return false;
  if (!mojo::Equals(this->texture_target_for_io_surfaces, other_struct.texture_target_for_io_surfaces))
    return false;
  return true;
}

template <typename T, SharedImageCapabilities::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.supports_scanout_shared_images < rhs.supports_scanout_shared_images)
    return true;
  if (rhs.supports_scanout_shared_images < lhs.supports_scanout_shared_images)
    return false;
  if (lhs.supports_luminance_shared_images < rhs.supports_luminance_shared_images)
    return true;
  if (rhs.supports_luminance_shared_images < lhs.supports_luminance_shared_images)
    return false;
  if (lhs.supports_r16_shared_images < rhs.supports_r16_shared_images)
    return true;
  if (rhs.supports_r16_shared_images < lhs.supports_r16_shared_images)
    return false;
  if (lhs.supports_native_nv12_mappable_shared_images < rhs.supports_native_nv12_mappable_shared_images)
    return true;
  if (rhs.supports_native_nv12_mappable_shared_images < lhs.supports_native_nv12_mappable_shared_images)
    return false;
  if (lhs.is_r16f_supported < rhs.is_r16f_supported)
    return true;
  if (rhs.is_r16f_supported < lhs.is_r16f_supported)
    return false;
  if (lhs.disable_r8_shared_images < rhs.disable_r8_shared_images)
    return true;
  if (rhs.disable_r8_shared_images < lhs.disable_r8_shared_images)
    return false;
  if (lhs.disable_webgpu_shared_images < rhs.disable_webgpu_shared_images)
    return true;
  if (rhs.disable_webgpu_shared_images < lhs.disable_webgpu_shared_images)
    return false;
  if (lhs.disable_one_component_textures < rhs.disable_one_component_textures)
    return true;
  if (rhs.disable_one_component_textures < lhs.disable_one_component_textures)
    return false;
  if (lhs.shared_image_d3d < rhs.shared_image_d3d)
    return true;
  if (rhs.shared_image_d3d < lhs.shared_image_d3d)
    return false;
  if (lhs.shared_image_swap_chain < rhs.shared_image_swap_chain)
    return true;
  if (rhs.shared_image_swap_chain < lhs.shared_image_swap_chain)
    return false;
  if (lhs.texture_target_for_io_surfaces < rhs.texture_target_for_io_surfaces)
    return true;
  if (rhs.texture_target_for_io_surfaces < lhs.texture_target_for_io_surfaces)
    return false;
  return false;
}


}  // gpu::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::gpu::mojom::blink::SharedImageCapabilities::DataView,
                                         ::gpu::mojom::blink::SharedImageCapabilitiesPtr> {
  static bool IsNull(const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::blink::SharedImageCapabilitiesPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::blink::SharedImageCapabilities::supports_scanout_shared_images) supports_scanout_shared_images(
      const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) {
    return input->supports_scanout_shared_images;
  }

  static decltype(::gpu::mojom::blink::SharedImageCapabilities::supports_luminance_shared_images) supports_luminance_shared_images(
      const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) {
    return input->supports_luminance_shared_images;
  }

  static decltype(::gpu::mojom::blink::SharedImageCapabilities::supports_r16_shared_images) supports_r16_shared_images(
      const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) {
    return input->supports_r16_shared_images;
  }

  static decltype(::gpu::mojom::blink::SharedImageCapabilities::supports_native_nv12_mappable_shared_images) supports_native_nv12_mappable_shared_images(
      const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) {
    return input->supports_native_nv12_mappable_shared_images;
  }

  static decltype(::gpu::mojom::blink::SharedImageCapabilities::is_r16f_supported) is_r16f_supported(
      const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) {
    return input->is_r16f_supported;
  }

  static decltype(::gpu::mojom::blink::SharedImageCapabilities::disable_r8_shared_images) disable_r8_shared_images(
      const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) {
    return input->disable_r8_shared_images;
  }

  static decltype(::gpu::mojom::blink::SharedImageCapabilities::disable_webgpu_shared_images) disable_webgpu_shared_images(
      const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) {
    return input->disable_webgpu_shared_images;
  }

  static decltype(::gpu::mojom::blink::SharedImageCapabilities::disable_one_component_textures) disable_one_component_textures(
      const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) {
    return input->disable_one_component_textures;
  }

  static decltype(::gpu::mojom::blink::SharedImageCapabilities::shared_image_d3d) shared_image_d3d(
      const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) {
    return input->shared_image_d3d;
  }

  static decltype(::gpu::mojom::blink::SharedImageCapabilities::shared_image_swap_chain) shared_image_swap_chain(
      const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) {
    return input->shared_image_swap_chain;
  }

  static decltype(::gpu::mojom::blink::SharedImageCapabilities::texture_target_for_io_surfaces) texture_target_for_io_surfaces(
      const ::gpu::mojom::blink::SharedImageCapabilitiesPtr& input) {
    return input->texture_target_for_io_surfaces;
  }

  static bool Read(::gpu::mojom::blink::SharedImageCapabilities::DataView input, ::gpu::mojom::blink::SharedImageCapabilitiesPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_SHARED_IMAGE_CAPABILITIES_MOJOM_BLINK_H_