// gpu/ipc/common/memory_stats.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_MEMORY_STATS_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_MEMORY_STATS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/memory_stats.mojom-shared-internal.h"




#include "gpu/ipc/common/memory_stats.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VideoMemoryProcessStatsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VideoMemoryProcessStatsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VideoMemoryProcessStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->video_memory_bytes = Traits::video_memory_bytes(input);

    fragment->has_duplicates = Traits::has_duplicates(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VideoMemoryProcessStats_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VideoMemoryProcessStatsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VideoMemoryUsageStatsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VideoMemoryUsageStatsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VideoMemoryUsageStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::process_map(input)) in_process_map = Traits::process_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->process_map)::BaseType>
        process_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& process_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<int32_t, ::gpu::mojom::VideoMemoryProcessStatsDataView>>(
      in_process_map,
      process_map_fragment,
      &process_map_validate_params);

    fragment->process_map.Set(
        process_map_fragment.is_null() ? nullptr : process_map_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->process_map.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null process_map in VideoMemoryUsageStats struct");

    fragment->bytes_allocated = Traits::bytes_allocated(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VideoMemoryUsageStats_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VideoMemoryUsageStatsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {



inline void VideoMemoryUsageStatsDataView::GetProcessMapDataView(
    mojo::MapDataView<int32_t, VideoMemoryProcessStatsDataView>* output) {
  auto pointer = data_->process_map.Get();
  *output = mojo::MapDataView<int32_t, VideoMemoryProcessStatsDataView>(pointer, message_);
}



}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // GPU_IPC_COMMON_MEMORY_STATS_MOJOM_SHARED_H_