// gpu/ipc/common/mailbox_holder.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_MAILBOX_HOLDER_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_MAILBOX_HOLDER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "gpu/ipc/common/mailbox_holder.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"


namespace gpu::mojom {
class MailboxHolderDataView;



}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::MailboxHolderDataView> {
  using Data = ::gpu::mojom::internal::MailboxHolder_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


class MailboxHolderDataView {
 public:
  MailboxHolderDataView() = default;

  MailboxHolderDataView(
      internal::MailboxHolder_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  uint32_t texture_target() const {
    return data_->texture_target;
  }
 private:
  internal::MailboxHolder_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

#endif  // GPU_IPC_COMMON_MAILBOX_HOLDER_MOJOM_DATA_VIEW_H_