// gpu/ipc/common/mailbox.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_MAILBOX_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_MAILBOX_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/mailbox.mojom-shared-internal.h"




#include "gpu/ipc/common/mailbox.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::MailboxDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::MailboxDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::Mailbox_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType>
        name_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
        mojo::internal::GetArrayValidator<16, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int8_t>>(
      in_name,
      name_fragment,
      &name_validate_params);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in Mailbox struct");
  }

  static bool Deserialize(::gpu::mojom::internal::Mailbox_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::MailboxDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {

inline void MailboxDataView::GetNameDataView(
    mojo::ArrayDataView<int8_t>* output) {
  auto pointer = data_->name.Get();
  *output = mojo::ArrayDataView<int8_t>(pointer, message_);
}



}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // GPU_IPC_COMMON_MAILBOX_MOJOM_SHARED_H_