// gpu/ipc/common/gpu_preferences.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_BLINK_H_
#define GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/gpu_preferences.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_preferences.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_preferences.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/gfx/mojom/buffer_types.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gpu::mojom::blink {








class  GpuPreferences {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuPreferences, T>::value>;
  using DataView = GpuPreferencesDataView;
  using Data_ = internal::GpuPreferences_Data;

  template <typename... Args>
  static GpuPreferencesPtr New(Args&&... args) {
    return GpuPreferencesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuPreferencesPtr From(const U& u) {
    return mojo::TypeConverter<GpuPreferencesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuPreferences>::Convert(*this);
  }


  GpuPreferences();

  GpuPreferences(
      bool disable_accelerated_video_decode,
      bool disable_accelerated_video_encode,
      bool gpu_startup_dialog,
      bool disable_gpu_watchdog,
      bool gpu_sandbox_start_early,
      bool enable_low_latency_dxva,
      bool enable_zero_copy_dxgi_video,
      bool enable_nv12_dxgi_video,
      bool disable_software_rasterizer,
      bool log_gpu_control_list_decisions,
      bool compile_shader_always_succeeds,
      bool disable_gl_error_limit,
      bool disable_glsl_translator,
      bool disable_shader_name_hashing,
      bool enable_gpu_command_logging,
      bool enable_gpu_debugging,
      bool enable_gpu_service_logging_gpu,
      bool enable_gpu_driver_debug_logging,
      bool disable_gpu_program_cache,
      bool enforce_gl_minimums,
      uint32_t force_gpu_mem_discardable_limit_bytes,
      uint32_t force_max_texture_size,
      uint32_t gpu_program_cache_size,
      bool disable_gpu_shader_disk_cache,
      bool enable_threaded_texture_mailboxes,
      bool gl_shader_interm_output,
      bool perform_graphite_precompilation,
      bool enable_gpu_service_logging,
      bool enable_gpu_service_tracing,
      bool use_passthrough_cmd_decoder,
      bool ignore_gpu_blocklist,
      bool watchdog_starts_backgrounded,
      GrContextType gr_context_type,
      VulkanImplementationName use_vulkan,
      bool enable_vulkan_protected_memory,
      bool disable_vulkan_surface,
      bool disable_vulkan_fallback_to_gl_for_testing,
      uint32_t vulkan_heap_memory_limit,
      uint32_t vulkan_sync_cpu_memory_limit,
      bool enable_gpu_benchmarking_extension,
      bool enable_webgpu,
      bool enable_unsafe_webgpu,
      bool enable_webgpu_developer_features,
      bool enable_webgpu_experimental_features,
      WebGPUAdapterName use_webgpu_adapter,
      WebGPUPowerPreference use_webgpu_power_preference,
      bool force_webgpu_compat,
      DawnBackendValidationLevel enable_dawn_backend_validation,
      ::blink::Vector<::blink::String> enabled_dawn_features_list,
      ::blink::Vector<::blink::String> disabled_dawn_features_list,
      bool enable_perf_data_collection,
      bool enable_native_gpu_memory_buffers,
      bool force_separate_egl_display_for_webgl_testing);


  ~GpuPreferences();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuPreferencesPtr>
  GpuPreferencesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuPreferences::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuPreferences::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuPreferences::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuPreferences_UnserializedMessageContext<
            UserType, GpuPreferences::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GpuPreferences::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GpuPreferences::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuPreferences_UnserializedMessageContext<
            UserType, GpuPreferences::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuPreferences::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool disable_accelerated_video_decode;
  
  bool disable_accelerated_video_encode;
  
  bool gpu_startup_dialog;
  
  bool disable_gpu_watchdog;
  
  bool gpu_sandbox_start_early;
  
  bool enable_low_latency_dxva;
  
  bool enable_zero_copy_dxgi_video;
  
  bool enable_nv12_dxgi_video;
  
  bool disable_software_rasterizer;
  
  bool log_gpu_control_list_decisions;
  
  bool compile_shader_always_succeeds;
  
  bool disable_gl_error_limit;
  
  bool disable_glsl_translator;
  
  bool disable_shader_name_hashing;
  
  bool enable_gpu_command_logging;
  
  bool enable_gpu_debugging;
  
  bool enable_gpu_service_logging_gpu;
  
  bool enable_gpu_driver_debug_logging;
  
  bool disable_gpu_program_cache;
  
  bool enforce_gl_minimums;
  
  uint32_t force_gpu_mem_discardable_limit_bytes;
  
  uint32_t force_max_texture_size;
  
  uint32_t gpu_program_cache_size;
  
  bool disable_gpu_shader_disk_cache;
  
  bool enable_threaded_texture_mailboxes;
  
  bool gl_shader_interm_output;
  
  bool perform_graphite_precompilation;
  
  bool enable_gpu_service_logging;
  
  bool enable_gpu_service_tracing;
  
  bool use_passthrough_cmd_decoder;
  
  bool ignore_gpu_blocklist;
  
  bool watchdog_starts_backgrounded;
  
  GrContextType gr_context_type;
  
  VulkanImplementationName use_vulkan;
  
  bool enable_vulkan_protected_memory;
  
  bool disable_vulkan_surface;
  
  bool disable_vulkan_fallback_to_gl_for_testing;
  
  uint32_t vulkan_heap_memory_limit;
  
  uint32_t vulkan_sync_cpu_memory_limit;
  
  bool enable_gpu_benchmarking_extension;
  
  bool enable_webgpu;
  
  bool enable_unsafe_webgpu;
  
  bool enable_webgpu_developer_features;
  
  bool enable_webgpu_experimental_features;
  
  WebGPUAdapterName use_webgpu_adapter;
  
  WebGPUPowerPreference use_webgpu_power_preference;
  
  bool force_webgpu_compat;
  
  DawnBackendValidationLevel enable_dawn_backend_validation;
  
  ::blink::Vector<::blink::String> enabled_dawn_features_list;
  
  ::blink::Vector<::blink::String> disabled_dawn_features_list;
  
  bool enable_perf_data_collection;
  
  bool enable_native_gpu_memory_buffers;
  
  bool force_separate_egl_display_for_webgl_testing;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GpuPreferencesPtr GpuPreferences::Clone() const {
  return New(
      mojo::Clone(disable_accelerated_video_decode),
      mojo::Clone(disable_accelerated_video_encode),
      mojo::Clone(gpu_startup_dialog),
      mojo::Clone(disable_gpu_watchdog),
      mojo::Clone(gpu_sandbox_start_early),
      mojo::Clone(enable_low_latency_dxva),
      mojo::Clone(enable_zero_copy_dxgi_video),
      mojo::Clone(enable_nv12_dxgi_video),
      mojo::Clone(disable_software_rasterizer),
      mojo::Clone(log_gpu_control_list_decisions),
      mojo::Clone(compile_shader_always_succeeds),
      mojo::Clone(disable_gl_error_limit),
      mojo::Clone(disable_glsl_translator),
      mojo::Clone(disable_shader_name_hashing),
      mojo::Clone(enable_gpu_command_logging),
      mojo::Clone(enable_gpu_debugging),
      mojo::Clone(enable_gpu_service_logging_gpu),
      mojo::Clone(enable_gpu_driver_debug_logging),
      mojo::Clone(disable_gpu_program_cache),
      mojo::Clone(enforce_gl_minimums),
      mojo::Clone(force_gpu_mem_discardable_limit_bytes),
      mojo::Clone(force_max_texture_size),
      mojo::Clone(gpu_program_cache_size),
      mojo::Clone(disable_gpu_shader_disk_cache),
      mojo::Clone(enable_threaded_texture_mailboxes),
      mojo::Clone(gl_shader_interm_output),
      mojo::Clone(perform_graphite_precompilation),
      mojo::Clone(enable_gpu_service_logging),
      mojo::Clone(enable_gpu_service_tracing),
      mojo::Clone(use_passthrough_cmd_decoder),
      mojo::Clone(ignore_gpu_blocklist),
      mojo::Clone(watchdog_starts_backgrounded),
      mojo::Clone(gr_context_type),
      mojo::Clone(use_vulkan),
      mojo::Clone(enable_vulkan_protected_memory),
      mojo::Clone(disable_vulkan_surface),
      mojo::Clone(disable_vulkan_fallback_to_gl_for_testing),
      mojo::Clone(vulkan_heap_memory_limit),
      mojo::Clone(vulkan_sync_cpu_memory_limit),
      mojo::Clone(enable_gpu_benchmarking_extension),
      mojo::Clone(enable_webgpu),
      mojo::Clone(enable_unsafe_webgpu),
      mojo::Clone(enable_webgpu_developer_features),
      mojo::Clone(enable_webgpu_experimental_features),
      mojo::Clone(use_webgpu_adapter),
      mojo::Clone(use_webgpu_power_preference),
      mojo::Clone(force_webgpu_compat),
      mojo::Clone(enable_dawn_backend_validation),
      mojo::Clone(enabled_dawn_features_list),
      mojo::Clone(disabled_dawn_features_list),
      mojo::Clone(enable_perf_data_collection),
      mojo::Clone(enable_native_gpu_memory_buffers),
      mojo::Clone(force_separate_egl_display_for_webgl_testing)
  );
}

template <typename T, GpuPreferences::EnableIfSame<T>*>
bool GpuPreferences::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->disable_accelerated_video_decode, other_struct.disable_accelerated_video_decode))
    return false;
  if (!mojo::Equals(this->disable_accelerated_video_encode, other_struct.disable_accelerated_video_encode))
    return false;
  if (!mojo::Equals(this->gpu_startup_dialog, other_struct.gpu_startup_dialog))
    return false;
  if (!mojo::Equals(this->disable_gpu_watchdog, other_struct.disable_gpu_watchdog))
    return false;
  if (!mojo::Equals(this->gpu_sandbox_start_early, other_struct.gpu_sandbox_start_early))
    return false;
  if (!mojo::Equals(this->enable_low_latency_dxva, other_struct.enable_low_latency_dxva))
    return false;
  if (!mojo::Equals(this->enable_zero_copy_dxgi_video, other_struct.enable_zero_copy_dxgi_video))
    return false;
  if (!mojo::Equals(this->enable_nv12_dxgi_video, other_struct.enable_nv12_dxgi_video))
    return false;
  if (!mojo::Equals(this->disable_software_rasterizer, other_struct.disable_software_rasterizer))
    return false;
  if (!mojo::Equals(this->log_gpu_control_list_decisions, other_struct.log_gpu_control_list_decisions))
    return false;
  if (!mojo::Equals(this->compile_shader_always_succeeds, other_struct.compile_shader_always_succeeds))
    return false;
  if (!mojo::Equals(this->disable_gl_error_limit, other_struct.disable_gl_error_limit))
    return false;
  if (!mojo::Equals(this->disable_glsl_translator, other_struct.disable_glsl_translator))
    return false;
  if (!mojo::Equals(this->disable_shader_name_hashing, other_struct.disable_shader_name_hashing))
    return false;
  if (!mojo::Equals(this->enable_gpu_command_logging, other_struct.enable_gpu_command_logging))
    return false;
  if (!mojo::Equals(this->enable_gpu_debugging, other_struct.enable_gpu_debugging))
    return false;
  if (!mojo::Equals(this->enable_gpu_service_logging_gpu, other_struct.enable_gpu_service_logging_gpu))
    return false;
  if (!mojo::Equals(this->enable_gpu_driver_debug_logging, other_struct.enable_gpu_driver_debug_logging))
    return false;
  if (!mojo::Equals(this->disable_gpu_program_cache, other_struct.disable_gpu_program_cache))
    return false;
  if (!mojo::Equals(this->enforce_gl_minimums, other_struct.enforce_gl_minimums))
    return false;
  if (!mojo::Equals(this->force_gpu_mem_discardable_limit_bytes, other_struct.force_gpu_mem_discardable_limit_bytes))
    return false;
  if (!mojo::Equals(this->force_max_texture_size, other_struct.force_max_texture_size))
    return false;
  if (!mojo::Equals(this->gpu_program_cache_size, other_struct.gpu_program_cache_size))
    return false;
  if (!mojo::Equals(this->disable_gpu_shader_disk_cache, other_struct.disable_gpu_shader_disk_cache))
    return false;
  if (!mojo::Equals(this->enable_threaded_texture_mailboxes, other_struct.enable_threaded_texture_mailboxes))
    return false;
  if (!mojo::Equals(this->gl_shader_interm_output, other_struct.gl_shader_interm_output))
    return false;
  if (!mojo::Equals(this->perform_graphite_precompilation, other_struct.perform_graphite_precompilation))
    return false;
  if (!mojo::Equals(this->enable_gpu_service_logging, other_struct.enable_gpu_service_logging))
    return false;
  if (!mojo::Equals(this->enable_gpu_service_tracing, other_struct.enable_gpu_service_tracing))
    return false;
  if (!mojo::Equals(this->use_passthrough_cmd_decoder, other_struct.use_passthrough_cmd_decoder))
    return false;
  if (!mojo::Equals(this->ignore_gpu_blocklist, other_struct.ignore_gpu_blocklist))
    return false;
  if (!mojo::Equals(this->watchdog_starts_backgrounded, other_struct.watchdog_starts_backgrounded))
    return false;
  if (!mojo::Equals(this->gr_context_type, other_struct.gr_context_type))
    return false;
  if (!mojo::Equals(this->use_vulkan, other_struct.use_vulkan))
    return false;
  if (!mojo::Equals(this->enable_vulkan_protected_memory, other_struct.enable_vulkan_protected_memory))
    return false;
  if (!mojo::Equals(this->disable_vulkan_surface, other_struct.disable_vulkan_surface))
    return false;
  if (!mojo::Equals(this->disable_vulkan_fallback_to_gl_for_testing, other_struct.disable_vulkan_fallback_to_gl_for_testing))
    return false;
  if (!mojo::Equals(this->vulkan_heap_memory_limit, other_struct.vulkan_heap_memory_limit))
    return false;
  if (!mojo::Equals(this->vulkan_sync_cpu_memory_limit, other_struct.vulkan_sync_cpu_memory_limit))
    return false;
  if (!mojo::Equals(this->enable_gpu_benchmarking_extension, other_struct.enable_gpu_benchmarking_extension))
    return false;
  if (!mojo::Equals(this->enable_webgpu, other_struct.enable_webgpu))
    return false;
  if (!mojo::Equals(this->enable_unsafe_webgpu, other_struct.enable_unsafe_webgpu))
    return false;
  if (!mojo::Equals(this->enable_webgpu_developer_features, other_struct.enable_webgpu_developer_features))
    return false;
  if (!mojo::Equals(this->enable_webgpu_experimental_features, other_struct.enable_webgpu_experimental_features))
    return false;
  if (!mojo::Equals(this->use_webgpu_adapter, other_struct.use_webgpu_adapter))
    return false;
  if (!mojo::Equals(this->use_webgpu_power_preference, other_struct.use_webgpu_power_preference))
    return false;
  if (!mojo::Equals(this->force_webgpu_compat, other_struct.force_webgpu_compat))
    return false;
  if (!mojo::Equals(this->enable_dawn_backend_validation, other_struct.enable_dawn_backend_validation))
    return false;
  if (!mojo::Equals(this->enabled_dawn_features_list, other_struct.enabled_dawn_features_list))
    return false;
  if (!mojo::Equals(this->disabled_dawn_features_list, other_struct.disabled_dawn_features_list))
    return false;
  if (!mojo::Equals(this->enable_perf_data_collection, other_struct.enable_perf_data_collection))
    return false;
  if (!mojo::Equals(this->enable_native_gpu_memory_buffers, other_struct.enable_native_gpu_memory_buffers))
    return false;
  if (!mojo::Equals(this->force_separate_egl_display_for_webgl_testing, other_struct.force_separate_egl_display_for_webgl_testing))
    return false;
  return true;
}

template <typename T, GpuPreferences::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.disable_accelerated_video_decode < rhs.disable_accelerated_video_decode)
    return true;
  if (rhs.disable_accelerated_video_decode < lhs.disable_accelerated_video_decode)
    return false;
  if (lhs.disable_accelerated_video_encode < rhs.disable_accelerated_video_encode)
    return true;
  if (rhs.disable_accelerated_video_encode < lhs.disable_accelerated_video_encode)
    return false;
  if (lhs.gpu_startup_dialog < rhs.gpu_startup_dialog)
    return true;
  if (rhs.gpu_startup_dialog < lhs.gpu_startup_dialog)
    return false;
  if (lhs.disable_gpu_watchdog < rhs.disable_gpu_watchdog)
    return true;
  if (rhs.disable_gpu_watchdog < lhs.disable_gpu_watchdog)
    return false;
  if (lhs.gpu_sandbox_start_early < rhs.gpu_sandbox_start_early)
    return true;
  if (rhs.gpu_sandbox_start_early < lhs.gpu_sandbox_start_early)
    return false;
  if (lhs.enable_low_latency_dxva < rhs.enable_low_latency_dxva)
    return true;
  if (rhs.enable_low_latency_dxva < lhs.enable_low_latency_dxva)
    return false;
  if (lhs.enable_zero_copy_dxgi_video < rhs.enable_zero_copy_dxgi_video)
    return true;
  if (rhs.enable_zero_copy_dxgi_video < lhs.enable_zero_copy_dxgi_video)
    return false;
  if (lhs.enable_nv12_dxgi_video < rhs.enable_nv12_dxgi_video)
    return true;
  if (rhs.enable_nv12_dxgi_video < lhs.enable_nv12_dxgi_video)
    return false;
  if (lhs.disable_software_rasterizer < rhs.disable_software_rasterizer)
    return true;
  if (rhs.disable_software_rasterizer < lhs.disable_software_rasterizer)
    return false;
  if (lhs.log_gpu_control_list_decisions < rhs.log_gpu_control_list_decisions)
    return true;
  if (rhs.log_gpu_control_list_decisions < lhs.log_gpu_control_list_decisions)
    return false;
  if (lhs.compile_shader_always_succeeds < rhs.compile_shader_always_succeeds)
    return true;
  if (rhs.compile_shader_always_succeeds < lhs.compile_shader_always_succeeds)
    return false;
  if (lhs.disable_gl_error_limit < rhs.disable_gl_error_limit)
    return true;
  if (rhs.disable_gl_error_limit < lhs.disable_gl_error_limit)
    return false;
  if (lhs.disable_glsl_translator < rhs.disable_glsl_translator)
    return true;
  if (rhs.disable_glsl_translator < lhs.disable_glsl_translator)
    return false;
  if (lhs.disable_shader_name_hashing < rhs.disable_shader_name_hashing)
    return true;
  if (rhs.disable_shader_name_hashing < lhs.disable_shader_name_hashing)
    return false;
  if (lhs.enable_gpu_command_logging < rhs.enable_gpu_command_logging)
    return true;
  if (rhs.enable_gpu_command_logging < lhs.enable_gpu_command_logging)
    return false;
  if (lhs.enable_gpu_debugging < rhs.enable_gpu_debugging)
    return true;
  if (rhs.enable_gpu_debugging < lhs.enable_gpu_debugging)
    return false;
  if (lhs.enable_gpu_service_logging_gpu < rhs.enable_gpu_service_logging_gpu)
    return true;
  if (rhs.enable_gpu_service_logging_gpu < lhs.enable_gpu_service_logging_gpu)
    return false;
  if (lhs.enable_gpu_driver_debug_logging < rhs.enable_gpu_driver_debug_logging)
    return true;
  if (rhs.enable_gpu_driver_debug_logging < lhs.enable_gpu_driver_debug_logging)
    return false;
  if (lhs.disable_gpu_program_cache < rhs.disable_gpu_program_cache)
    return true;
  if (rhs.disable_gpu_program_cache < lhs.disable_gpu_program_cache)
    return false;
  if (lhs.enforce_gl_minimums < rhs.enforce_gl_minimums)
    return true;
  if (rhs.enforce_gl_minimums < lhs.enforce_gl_minimums)
    return false;
  if (lhs.force_gpu_mem_discardable_limit_bytes < rhs.force_gpu_mem_discardable_limit_bytes)
    return true;
  if (rhs.force_gpu_mem_discardable_limit_bytes < lhs.force_gpu_mem_discardable_limit_bytes)
    return false;
  if (lhs.force_max_texture_size < rhs.force_max_texture_size)
    return true;
  if (rhs.force_max_texture_size < lhs.force_max_texture_size)
    return false;
  if (lhs.gpu_program_cache_size < rhs.gpu_program_cache_size)
    return true;
  if (rhs.gpu_program_cache_size < lhs.gpu_program_cache_size)
    return false;
  if (lhs.disable_gpu_shader_disk_cache < rhs.disable_gpu_shader_disk_cache)
    return true;
  if (rhs.disable_gpu_shader_disk_cache < lhs.disable_gpu_shader_disk_cache)
    return false;
  if (lhs.enable_threaded_texture_mailboxes < rhs.enable_threaded_texture_mailboxes)
    return true;
  if (rhs.enable_threaded_texture_mailboxes < lhs.enable_threaded_texture_mailboxes)
    return false;
  if (lhs.gl_shader_interm_output < rhs.gl_shader_interm_output)
    return true;
  if (rhs.gl_shader_interm_output < lhs.gl_shader_interm_output)
    return false;
  if (lhs.perform_graphite_precompilation < rhs.perform_graphite_precompilation)
    return true;
  if (rhs.perform_graphite_precompilation < lhs.perform_graphite_precompilation)
    return false;
  if (lhs.enable_gpu_service_logging < rhs.enable_gpu_service_logging)
    return true;
  if (rhs.enable_gpu_service_logging < lhs.enable_gpu_service_logging)
    return false;
  if (lhs.enable_gpu_service_tracing < rhs.enable_gpu_service_tracing)
    return true;
  if (rhs.enable_gpu_service_tracing < lhs.enable_gpu_service_tracing)
    return false;
  if (lhs.use_passthrough_cmd_decoder < rhs.use_passthrough_cmd_decoder)
    return true;
  if (rhs.use_passthrough_cmd_decoder < lhs.use_passthrough_cmd_decoder)
    return false;
  if (lhs.ignore_gpu_blocklist < rhs.ignore_gpu_blocklist)
    return true;
  if (rhs.ignore_gpu_blocklist < lhs.ignore_gpu_blocklist)
    return false;
  if (lhs.watchdog_starts_backgrounded < rhs.watchdog_starts_backgrounded)
    return true;
  if (rhs.watchdog_starts_backgrounded < lhs.watchdog_starts_backgrounded)
    return false;
  if (lhs.gr_context_type < rhs.gr_context_type)
    return true;
  if (rhs.gr_context_type < lhs.gr_context_type)
    return false;
  if (lhs.use_vulkan < rhs.use_vulkan)
    return true;
  if (rhs.use_vulkan < lhs.use_vulkan)
    return false;
  if (lhs.enable_vulkan_protected_memory < rhs.enable_vulkan_protected_memory)
    return true;
  if (rhs.enable_vulkan_protected_memory < lhs.enable_vulkan_protected_memory)
    return false;
  if (lhs.disable_vulkan_surface < rhs.disable_vulkan_surface)
    return true;
  if (rhs.disable_vulkan_surface < lhs.disable_vulkan_surface)
    return false;
  if (lhs.disable_vulkan_fallback_to_gl_for_testing < rhs.disable_vulkan_fallback_to_gl_for_testing)
    return true;
  if (rhs.disable_vulkan_fallback_to_gl_for_testing < lhs.disable_vulkan_fallback_to_gl_for_testing)
    return false;
  if (lhs.vulkan_heap_memory_limit < rhs.vulkan_heap_memory_limit)
    return true;
  if (rhs.vulkan_heap_memory_limit < lhs.vulkan_heap_memory_limit)
    return false;
  if (lhs.vulkan_sync_cpu_memory_limit < rhs.vulkan_sync_cpu_memory_limit)
    return true;
  if (rhs.vulkan_sync_cpu_memory_limit < lhs.vulkan_sync_cpu_memory_limit)
    return false;
  if (lhs.enable_gpu_benchmarking_extension < rhs.enable_gpu_benchmarking_extension)
    return true;
  if (rhs.enable_gpu_benchmarking_extension < lhs.enable_gpu_benchmarking_extension)
    return false;
  if (lhs.enable_webgpu < rhs.enable_webgpu)
    return true;
  if (rhs.enable_webgpu < lhs.enable_webgpu)
    return false;
  if (lhs.enable_unsafe_webgpu < rhs.enable_unsafe_webgpu)
    return true;
  if (rhs.enable_unsafe_webgpu < lhs.enable_unsafe_webgpu)
    return false;
  if (lhs.enable_webgpu_developer_features < rhs.enable_webgpu_developer_features)
    return true;
  if (rhs.enable_webgpu_developer_features < lhs.enable_webgpu_developer_features)
    return false;
  if (lhs.enable_webgpu_experimental_features < rhs.enable_webgpu_experimental_features)
    return true;
  if (rhs.enable_webgpu_experimental_features < lhs.enable_webgpu_experimental_features)
    return false;
  if (lhs.use_webgpu_adapter < rhs.use_webgpu_adapter)
    return true;
  if (rhs.use_webgpu_adapter < lhs.use_webgpu_adapter)
    return false;
  if (lhs.use_webgpu_power_preference < rhs.use_webgpu_power_preference)
    return true;
  if (rhs.use_webgpu_power_preference < lhs.use_webgpu_power_preference)
    return false;
  if (lhs.force_webgpu_compat < rhs.force_webgpu_compat)
    return true;
  if (rhs.force_webgpu_compat < lhs.force_webgpu_compat)
    return false;
  if (lhs.enable_dawn_backend_validation < rhs.enable_dawn_backend_validation)
    return true;
  if (rhs.enable_dawn_backend_validation < lhs.enable_dawn_backend_validation)
    return false;
  if (lhs.enabled_dawn_features_list < rhs.enabled_dawn_features_list)
    return true;
  if (rhs.enabled_dawn_features_list < lhs.enabled_dawn_features_list)
    return false;
  if (lhs.disabled_dawn_features_list < rhs.disabled_dawn_features_list)
    return true;
  if (rhs.disabled_dawn_features_list < lhs.disabled_dawn_features_list)
    return false;
  if (lhs.enable_perf_data_collection < rhs.enable_perf_data_collection)
    return true;
  if (rhs.enable_perf_data_collection < lhs.enable_perf_data_collection)
    return false;
  if (lhs.enable_native_gpu_memory_buffers < rhs.enable_native_gpu_memory_buffers)
    return true;
  if (rhs.enable_native_gpu_memory_buffers < lhs.enable_native_gpu_memory_buffers)
    return false;
  if (lhs.force_separate_egl_display_for_webgl_testing < rhs.force_separate_egl_display_for_webgl_testing)
    return true;
  if (rhs.force_separate_egl_display_for_webgl_testing < lhs.force_separate_egl_display_for_webgl_testing)
    return false;
  return false;
}


}  // gpu::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::gpu::mojom::blink::GpuPreferences::DataView,
                                         ::gpu::mojom::blink::GpuPreferencesPtr> {
  static bool IsNull(const ::gpu::mojom::blink::GpuPreferencesPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::blink::GpuPreferencesPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::blink::GpuPreferences::disable_accelerated_video_decode) disable_accelerated_video_decode(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disable_accelerated_video_decode;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::disable_accelerated_video_encode) disable_accelerated_video_encode(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disable_accelerated_video_encode;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::gpu_startup_dialog) gpu_startup_dialog(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->gpu_startup_dialog;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::disable_gpu_watchdog) disable_gpu_watchdog(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disable_gpu_watchdog;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::gpu_sandbox_start_early) gpu_sandbox_start_early(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->gpu_sandbox_start_early;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_low_latency_dxva) enable_low_latency_dxva(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_low_latency_dxva;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_zero_copy_dxgi_video) enable_zero_copy_dxgi_video(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_zero_copy_dxgi_video;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_nv12_dxgi_video) enable_nv12_dxgi_video(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_nv12_dxgi_video;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::disable_software_rasterizer) disable_software_rasterizer(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disable_software_rasterizer;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::log_gpu_control_list_decisions) log_gpu_control_list_decisions(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->log_gpu_control_list_decisions;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::compile_shader_always_succeeds) compile_shader_always_succeeds(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->compile_shader_always_succeeds;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::disable_gl_error_limit) disable_gl_error_limit(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disable_gl_error_limit;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::disable_glsl_translator) disable_glsl_translator(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disable_glsl_translator;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::disable_shader_name_hashing) disable_shader_name_hashing(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disable_shader_name_hashing;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_gpu_command_logging) enable_gpu_command_logging(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_gpu_command_logging;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_gpu_debugging) enable_gpu_debugging(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_gpu_debugging;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_gpu_service_logging_gpu) enable_gpu_service_logging_gpu(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_gpu_service_logging_gpu;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_gpu_driver_debug_logging) enable_gpu_driver_debug_logging(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_gpu_driver_debug_logging;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::disable_gpu_program_cache) disable_gpu_program_cache(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disable_gpu_program_cache;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enforce_gl_minimums) enforce_gl_minimums(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enforce_gl_minimums;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::force_gpu_mem_discardable_limit_bytes) force_gpu_mem_discardable_limit_bytes(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->force_gpu_mem_discardable_limit_bytes;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::force_max_texture_size) force_max_texture_size(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->force_max_texture_size;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::gpu_program_cache_size) gpu_program_cache_size(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->gpu_program_cache_size;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::disable_gpu_shader_disk_cache) disable_gpu_shader_disk_cache(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disable_gpu_shader_disk_cache;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_threaded_texture_mailboxes) enable_threaded_texture_mailboxes(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_threaded_texture_mailboxes;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::gl_shader_interm_output) gl_shader_interm_output(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->gl_shader_interm_output;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::perform_graphite_precompilation) perform_graphite_precompilation(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->perform_graphite_precompilation;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_gpu_service_logging) enable_gpu_service_logging(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_gpu_service_logging;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_gpu_service_tracing) enable_gpu_service_tracing(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_gpu_service_tracing;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::use_passthrough_cmd_decoder) use_passthrough_cmd_decoder(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->use_passthrough_cmd_decoder;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::ignore_gpu_blocklist) ignore_gpu_blocklist(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->ignore_gpu_blocklist;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::watchdog_starts_backgrounded) watchdog_starts_backgrounded(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->watchdog_starts_backgrounded;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::gr_context_type) gr_context_type(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->gr_context_type;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::use_vulkan) use_vulkan(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->use_vulkan;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_vulkan_protected_memory) enable_vulkan_protected_memory(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_vulkan_protected_memory;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::disable_vulkan_surface) disable_vulkan_surface(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disable_vulkan_surface;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::disable_vulkan_fallback_to_gl_for_testing) disable_vulkan_fallback_to_gl_for_testing(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disable_vulkan_fallback_to_gl_for_testing;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::vulkan_heap_memory_limit) vulkan_heap_memory_limit(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->vulkan_heap_memory_limit;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::vulkan_sync_cpu_memory_limit) vulkan_sync_cpu_memory_limit(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->vulkan_sync_cpu_memory_limit;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_gpu_benchmarking_extension) enable_gpu_benchmarking_extension(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_gpu_benchmarking_extension;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_webgpu) enable_webgpu(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_webgpu;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_unsafe_webgpu) enable_unsafe_webgpu(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_unsafe_webgpu;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_webgpu_developer_features) enable_webgpu_developer_features(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_webgpu_developer_features;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_webgpu_experimental_features) enable_webgpu_experimental_features(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_webgpu_experimental_features;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::use_webgpu_adapter) use_webgpu_adapter(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->use_webgpu_adapter;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::use_webgpu_power_preference) use_webgpu_power_preference(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->use_webgpu_power_preference;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::force_webgpu_compat) force_webgpu_compat(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->force_webgpu_compat;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_dawn_backend_validation) enable_dawn_backend_validation(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_dawn_backend_validation;
  }

  static const decltype(::gpu::mojom::blink::GpuPreferences::enabled_dawn_features_list)& enabled_dawn_features_list(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enabled_dawn_features_list;
  }

  static const decltype(::gpu::mojom::blink::GpuPreferences::disabled_dawn_features_list)& disabled_dawn_features_list(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->disabled_dawn_features_list;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_perf_data_collection) enable_perf_data_collection(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_perf_data_collection;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::enable_native_gpu_memory_buffers) enable_native_gpu_memory_buffers(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->enable_native_gpu_memory_buffers;
  }

  static decltype(::gpu::mojom::blink::GpuPreferences::force_separate_egl_display_for_webgl_testing) force_separate_egl_display_for_webgl_testing(
      const ::gpu::mojom::blink::GpuPreferencesPtr& input) {
    return input->force_separate_egl_display_for_webgl_testing;
  }

  static bool Read(::gpu::mojom::blink::GpuPreferences::DataView input, ::gpu::mojom::blink::GpuPreferencesPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_BLINK_H_