// gpu/ipc/common/gpu_preferences.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/gpu_preferences.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_preferences.mojom-params-data.h"
#include "gpu/ipc/common/gpu_preferences.mojom-shared-message-ids.h"

#include "gpu/ipc/common/gpu_preferences.mojom-blink-import-headers.h"
#include "gpu/ipc/common/gpu_preferences.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace gpu::mojom::blink {
GpuPreferences::GpuPreferences()
    : disable_accelerated_video_decode(),
      disable_accelerated_video_encode(),
      gpu_startup_dialog(),
      disable_gpu_watchdog(),
      gpu_sandbox_start_early(),
      enable_low_latency_dxva(),
      enable_zero_copy_dxgi_video(),
      enable_nv12_dxgi_video(),
      disable_software_rasterizer(),
      log_gpu_control_list_decisions(),
      compile_shader_always_succeeds(),
      disable_gl_error_limit(),
      disable_glsl_translator(),
      disable_shader_name_hashing(),
      enable_gpu_command_logging(),
      enable_gpu_debugging(),
      enable_gpu_service_logging_gpu(),
      enable_gpu_driver_debug_logging(),
      disable_gpu_program_cache(),
      enforce_gl_minimums(),
      force_gpu_mem_discardable_limit_bytes(),
      force_max_texture_size(),
      gpu_program_cache_size(),
      disable_gpu_shader_disk_cache(),
      enable_threaded_texture_mailboxes(),
      gl_shader_interm_output(),
      perform_graphite_precompilation(),
      enable_gpu_service_logging(),
      enable_gpu_service_tracing(),
      use_passthrough_cmd_decoder(),
      ignore_gpu_blocklist(),
      watchdog_starts_backgrounded(),
      gr_context_type(),
      use_vulkan(),
      enable_vulkan_protected_memory(),
      disable_vulkan_surface(),
      disable_vulkan_fallback_to_gl_for_testing(),
      vulkan_heap_memory_limit(),
      vulkan_sync_cpu_memory_limit(),
      enable_gpu_benchmarking_extension(),
      enable_webgpu(),
      enable_unsafe_webgpu(),
      enable_webgpu_developer_features(),
      enable_webgpu_experimental_features(),
      use_webgpu_adapter(),
      use_webgpu_power_preference(),
      force_webgpu_compat(),
      enable_dawn_backend_validation(),
      enabled_dawn_features_list(),
      disabled_dawn_features_list(),
      enable_perf_data_collection(),
      enable_native_gpu_memory_buffers(),
      force_separate_egl_display_for_webgl_testing() {}

GpuPreferences::GpuPreferences(
    bool disable_accelerated_video_decode_in,
    bool disable_accelerated_video_encode_in,
    bool gpu_startup_dialog_in,
    bool disable_gpu_watchdog_in,
    bool gpu_sandbox_start_early_in,
    bool enable_low_latency_dxva_in,
    bool enable_zero_copy_dxgi_video_in,
    bool enable_nv12_dxgi_video_in,
    bool disable_software_rasterizer_in,
    bool log_gpu_control_list_decisions_in,
    bool compile_shader_always_succeeds_in,
    bool disable_gl_error_limit_in,
    bool disable_glsl_translator_in,
    bool disable_shader_name_hashing_in,
    bool enable_gpu_command_logging_in,
    bool enable_gpu_debugging_in,
    bool enable_gpu_service_logging_gpu_in,
    bool enable_gpu_driver_debug_logging_in,
    bool disable_gpu_program_cache_in,
    bool enforce_gl_minimums_in,
    uint32_t force_gpu_mem_discardable_limit_bytes_in,
    uint32_t force_max_texture_size_in,
    uint32_t gpu_program_cache_size_in,
    bool disable_gpu_shader_disk_cache_in,
    bool enable_threaded_texture_mailboxes_in,
    bool gl_shader_interm_output_in,
    bool perform_graphite_precompilation_in,
    bool enable_gpu_service_logging_in,
    bool enable_gpu_service_tracing_in,
    bool use_passthrough_cmd_decoder_in,
    bool ignore_gpu_blocklist_in,
    bool watchdog_starts_backgrounded_in,
    GrContextType gr_context_type_in,
    VulkanImplementationName use_vulkan_in,
    bool enable_vulkan_protected_memory_in,
    bool disable_vulkan_surface_in,
    bool disable_vulkan_fallback_to_gl_for_testing_in,
    uint32_t vulkan_heap_memory_limit_in,
    uint32_t vulkan_sync_cpu_memory_limit_in,
    bool enable_gpu_benchmarking_extension_in,
    bool enable_webgpu_in,
    bool enable_unsafe_webgpu_in,
    bool enable_webgpu_developer_features_in,
    bool enable_webgpu_experimental_features_in,
    WebGPUAdapterName use_webgpu_adapter_in,
    WebGPUPowerPreference use_webgpu_power_preference_in,
    bool force_webgpu_compat_in,
    DawnBackendValidationLevel enable_dawn_backend_validation_in,
    ::blink::Vector<::blink::String> enabled_dawn_features_list_in,
    ::blink::Vector<::blink::String> disabled_dawn_features_list_in,
    bool enable_perf_data_collection_in,
    bool enable_native_gpu_memory_buffers_in,
    bool force_separate_egl_display_for_webgl_testing_in)
    : disable_accelerated_video_decode(std::move(disable_accelerated_video_decode_in)),
      disable_accelerated_video_encode(std::move(disable_accelerated_video_encode_in)),
      gpu_startup_dialog(std::move(gpu_startup_dialog_in)),
      disable_gpu_watchdog(std::move(disable_gpu_watchdog_in)),
      gpu_sandbox_start_early(std::move(gpu_sandbox_start_early_in)),
      enable_low_latency_dxva(std::move(enable_low_latency_dxva_in)),
      enable_zero_copy_dxgi_video(std::move(enable_zero_copy_dxgi_video_in)),
      enable_nv12_dxgi_video(std::move(enable_nv12_dxgi_video_in)),
      disable_software_rasterizer(std::move(disable_software_rasterizer_in)),
      log_gpu_control_list_decisions(std::move(log_gpu_control_list_decisions_in)),
      compile_shader_always_succeeds(std::move(compile_shader_always_succeeds_in)),
      disable_gl_error_limit(std::move(disable_gl_error_limit_in)),
      disable_glsl_translator(std::move(disable_glsl_translator_in)),
      disable_shader_name_hashing(std::move(disable_shader_name_hashing_in)),
      enable_gpu_command_logging(std::move(enable_gpu_command_logging_in)),
      enable_gpu_debugging(std::move(enable_gpu_debugging_in)),
      enable_gpu_service_logging_gpu(std::move(enable_gpu_service_logging_gpu_in)),
      enable_gpu_driver_debug_logging(std::move(enable_gpu_driver_debug_logging_in)),
      disable_gpu_program_cache(std::move(disable_gpu_program_cache_in)),
      enforce_gl_minimums(std::move(enforce_gl_minimums_in)),
      force_gpu_mem_discardable_limit_bytes(std::move(force_gpu_mem_discardable_limit_bytes_in)),
      force_max_texture_size(std::move(force_max_texture_size_in)),
      gpu_program_cache_size(std::move(gpu_program_cache_size_in)),
      disable_gpu_shader_disk_cache(std::move(disable_gpu_shader_disk_cache_in)),
      enable_threaded_texture_mailboxes(std::move(enable_threaded_texture_mailboxes_in)),
      gl_shader_interm_output(std::move(gl_shader_interm_output_in)),
      perform_graphite_precompilation(std::move(perform_graphite_precompilation_in)),
      enable_gpu_service_logging(std::move(enable_gpu_service_logging_in)),
      enable_gpu_service_tracing(std::move(enable_gpu_service_tracing_in)),
      use_passthrough_cmd_decoder(std::move(use_passthrough_cmd_decoder_in)),
      ignore_gpu_blocklist(std::move(ignore_gpu_blocklist_in)),
      watchdog_starts_backgrounded(std::move(watchdog_starts_backgrounded_in)),
      gr_context_type(std::move(gr_context_type_in)),
      use_vulkan(std::move(use_vulkan_in)),
      enable_vulkan_protected_memory(std::move(enable_vulkan_protected_memory_in)),
      disable_vulkan_surface(std::move(disable_vulkan_surface_in)),
      disable_vulkan_fallback_to_gl_for_testing(std::move(disable_vulkan_fallback_to_gl_for_testing_in)),
      vulkan_heap_memory_limit(std::move(vulkan_heap_memory_limit_in)),
      vulkan_sync_cpu_memory_limit(std::move(vulkan_sync_cpu_memory_limit_in)),
      enable_gpu_benchmarking_extension(std::move(enable_gpu_benchmarking_extension_in)),
      enable_webgpu(std::move(enable_webgpu_in)),
      enable_unsafe_webgpu(std::move(enable_unsafe_webgpu_in)),
      enable_webgpu_developer_features(std::move(enable_webgpu_developer_features_in)),
      enable_webgpu_experimental_features(std::move(enable_webgpu_experimental_features_in)),
      use_webgpu_adapter(std::move(use_webgpu_adapter_in)),
      use_webgpu_power_preference(std::move(use_webgpu_power_preference_in)),
      force_webgpu_compat(std::move(force_webgpu_compat_in)),
      enable_dawn_backend_validation(std::move(enable_dawn_backend_validation_in)),
      enabled_dawn_features_list(std::move(enabled_dawn_features_list_in)),
      disabled_dawn_features_list(std::move(disabled_dawn_features_list_in)),
      enable_perf_data_collection(std::move(enable_perf_data_collection_in)),
      enable_native_gpu_memory_buffers(std::move(enable_native_gpu_memory_buffers_in)),
      force_separate_egl_display_for_webgl_testing(std::move(force_separate_egl_display_for_webgl_testing_in)) {}

GpuPreferences::~GpuPreferences() = default;

void GpuPreferences::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_accelerated_video_decode"), this->disable_accelerated_video_decode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_accelerated_video_encode"), this->disable_accelerated_video_encode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_startup_dialog"), this->gpu_startup_dialog,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_gpu_watchdog"), this->disable_gpu_watchdog,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_sandbox_start_early"), this->gpu_sandbox_start_early,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_low_latency_dxva"), this->enable_low_latency_dxva,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_zero_copy_dxgi_video"), this->enable_zero_copy_dxgi_video,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_nv12_dxgi_video"), this->enable_nv12_dxgi_video,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_software_rasterizer"), this->disable_software_rasterizer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "log_gpu_control_list_decisions"), this->log_gpu_control_list_decisions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compile_shader_always_succeeds"), this->compile_shader_always_succeeds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_gl_error_limit"), this->disable_gl_error_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_glsl_translator"), this->disable_glsl_translator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_shader_name_hashing"), this->disable_shader_name_hashing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_command_logging"), this->enable_gpu_command_logging,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_debugging"), this->enable_gpu_debugging,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_service_logging_gpu"), this->enable_gpu_service_logging_gpu,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_driver_debug_logging"), this->enable_gpu_driver_debug_logging,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_gpu_program_cache"), this->disable_gpu_program_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enforce_gl_minimums"), this->enforce_gl_minimums,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_gpu_mem_discardable_limit_bytes"), this->force_gpu_mem_discardable_limit_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_max_texture_size"), this->force_max_texture_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_program_cache_size"), this->gpu_program_cache_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_gpu_shader_disk_cache"), this->disable_gpu_shader_disk_cache,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_threaded_texture_mailboxes"), this->enable_threaded_texture_mailboxes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gl_shader_interm_output"), this->gl_shader_interm_output,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "perform_graphite_precompilation"), this->perform_graphite_precompilation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_service_logging"), this->enable_gpu_service_logging,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_service_tracing"), this->enable_gpu_service_tracing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_passthrough_cmd_decoder"), this->use_passthrough_cmd_decoder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ignore_gpu_blocklist"), this->ignore_gpu_blocklist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "watchdog_starts_backgrounded"), this->watchdog_starts_backgrounded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gr_context_type"), this->gr_context_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GrContextType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_vulkan"), this->use_vulkan,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VulkanImplementationName>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_vulkan_protected_memory"), this->enable_vulkan_protected_memory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_vulkan_surface"), this->disable_vulkan_surface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_vulkan_fallback_to_gl_for_testing"), this->disable_vulkan_fallback_to_gl_for_testing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vulkan_heap_memory_limit"), this->vulkan_heap_memory_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vulkan_sync_cpu_memory_limit"), this->vulkan_sync_cpu_memory_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_gpu_benchmarking_extension"), this->enable_gpu_benchmarking_extension,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_webgpu"), this->enable_webgpu,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_unsafe_webgpu"), this->enable_unsafe_webgpu,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_webgpu_developer_features"), this->enable_webgpu_developer_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_webgpu_experimental_features"), this->enable_webgpu_experimental_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_webgpu_adapter"), this->use_webgpu_adapter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebGPUAdapterName>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_webgpu_power_preference"), this->use_webgpu_power_preference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebGPUPowerPreference>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_webgpu_compat"), this->force_webgpu_compat,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_dawn_backend_validation"), this->enable_dawn_backend_validation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DawnBackendValidationLevel>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled_dawn_features_list"), this->enabled_dawn_features_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disabled_dawn_features_list"), this->disabled_dawn_features_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_perf_data_collection"), this->enable_perf_data_collection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_native_gpu_memory_buffers"), this->enable_native_gpu_memory_buffers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_separate_egl_display_for_webgl_testing"), this->force_separate_egl_display_for_webgl_testing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuPreferences::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // gpu::mojom::blink


namespace mojo {


// static
bool StructTraits<::gpu::mojom::blink::GpuPreferences::DataView, ::gpu::mojom::blink::GpuPreferencesPtr>::Read(
    ::gpu::mojom::blink::GpuPreferences::DataView input,
    ::gpu::mojom::blink::GpuPreferencesPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::GpuPreferencesPtr result(::gpu::mojom::blink::GpuPreferences::New());
  
      if (success)
        result->disable_accelerated_video_decode = input.disable_accelerated_video_decode();
      if (success)
        result->disable_accelerated_video_encode = input.disable_accelerated_video_encode();
      if (success)
        result->gpu_startup_dialog = input.gpu_startup_dialog();
      if (success)
        result->disable_gpu_watchdog = input.disable_gpu_watchdog();
      if (success)
        result->gpu_sandbox_start_early = input.gpu_sandbox_start_early();
      if (success)
        result->enable_low_latency_dxva = input.enable_low_latency_dxva();
      if (success)
        result->enable_zero_copy_dxgi_video = input.enable_zero_copy_dxgi_video();
      if (success)
        result->enable_nv12_dxgi_video = input.enable_nv12_dxgi_video();
      if (success)
        result->disable_software_rasterizer = input.disable_software_rasterizer();
      if (success)
        result->log_gpu_control_list_decisions = input.log_gpu_control_list_decisions();
      if (success)
        result->compile_shader_always_succeeds = input.compile_shader_always_succeeds();
      if (success)
        result->disable_gl_error_limit = input.disable_gl_error_limit();
      if (success)
        result->disable_glsl_translator = input.disable_glsl_translator();
      if (success)
        result->disable_shader_name_hashing = input.disable_shader_name_hashing();
      if (success)
        result->enable_gpu_command_logging = input.enable_gpu_command_logging();
      if (success)
        result->enable_gpu_debugging = input.enable_gpu_debugging();
      if (success)
        result->enable_gpu_service_logging_gpu = input.enable_gpu_service_logging_gpu();
      if (success)
        result->enable_gpu_driver_debug_logging = input.enable_gpu_driver_debug_logging();
      if (success)
        result->disable_gpu_program_cache = input.disable_gpu_program_cache();
      if (success)
        result->enforce_gl_minimums = input.enforce_gl_minimums();
      if (success)
        result->force_gpu_mem_discardable_limit_bytes = input.force_gpu_mem_discardable_limit_bytes();
      if (success)
        result->force_max_texture_size = input.force_max_texture_size();
      if (success)
        result->gpu_program_cache_size = input.gpu_program_cache_size();
      if (success)
        result->disable_gpu_shader_disk_cache = input.disable_gpu_shader_disk_cache();
      if (success)
        result->enable_threaded_texture_mailboxes = input.enable_threaded_texture_mailboxes();
      if (success)
        result->gl_shader_interm_output = input.gl_shader_interm_output();
      if (success)
        result->perform_graphite_precompilation = input.perform_graphite_precompilation();
      if (success)
        result->enable_gpu_service_logging = input.enable_gpu_service_logging();
      if (success)
        result->enable_gpu_service_tracing = input.enable_gpu_service_tracing();
      if (success)
        result->use_passthrough_cmd_decoder = input.use_passthrough_cmd_decoder();
      if (success)
        result->ignore_gpu_blocklist = input.ignore_gpu_blocklist();
      if (success)
        result->watchdog_starts_backgrounded = input.watchdog_starts_backgrounded();
      if (success && !input.ReadGrContextType(&result->gr_context_type))
        success = false;
      if (success && !input.ReadUseVulkan(&result->use_vulkan))
        success = false;
      if (success)
        result->enable_vulkan_protected_memory = input.enable_vulkan_protected_memory();
      if (success)
        result->disable_vulkan_surface = input.disable_vulkan_surface();
      if (success)
        result->disable_vulkan_fallback_to_gl_for_testing = input.disable_vulkan_fallback_to_gl_for_testing();
      if (success)
        result->vulkan_heap_memory_limit = input.vulkan_heap_memory_limit();
      if (success)
        result->vulkan_sync_cpu_memory_limit = input.vulkan_sync_cpu_memory_limit();
      if (success)
        result->enable_gpu_benchmarking_extension = input.enable_gpu_benchmarking_extension();
      if (success)
        result->enable_webgpu = input.enable_webgpu();
      if (success)
        result->enable_unsafe_webgpu = input.enable_unsafe_webgpu();
      if (success)
        result->enable_webgpu_developer_features = input.enable_webgpu_developer_features();
      if (success)
        result->enable_webgpu_experimental_features = input.enable_webgpu_experimental_features();
      if (success && !input.ReadUseWebgpuAdapter(&result->use_webgpu_adapter))
        success = false;
      if (success && !input.ReadUseWebgpuPowerPreference(&result->use_webgpu_power_preference))
        success = false;
      if (success)
        result->force_webgpu_compat = input.force_webgpu_compat();
      if (success && !input.ReadEnableDawnBackendValidation(&result->enable_dawn_backend_validation))
        success = false;
      if (success && !input.ReadEnabledDawnFeaturesList(&result->enabled_dawn_features_list))
        success = false;
      if (success && !input.ReadDisabledDawnFeaturesList(&result->disabled_dawn_features_list))
        success = false;
      if (success)
        result->enable_perf_data_collection = input.enable_perf_data_collection();
      if (success)
        result->enable_native_gpu_memory_buffers = input.enable_native_gpu_memory_buffers();
      if (success)
        result->force_separate_egl_display_for_webgl_testing = input.force_separate_egl_display_for_webgl_testing();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gpu::mojom::blink {




}  // gpu::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif