// gpu/ipc/common/gpu_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_INFO_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_GPU_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/gpu_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gl/mojom/gl_implementation.mojom-shared.h"
#include "ui/gl/mojom/gpu_preference.mojom-shared.h"




#include "gpu/ipc/common/gpu_info.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::gpu::mojom::SkiaBackendType>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::SkiaBackendType> {};

template <>
struct hash<::gpu::mojom::VideoCodecProfile>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::VideoCodecProfile> {};

template <>
struct hash<::gpu::mojom::ImageDecodeAcceleratorType>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::ImageDecodeAcceleratorType> {};

template <>
struct hash<::gpu::mojom::ImageDecodeAcceleratorSubsampling>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::ImageDecodeAcceleratorSubsampling> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::SkiaBackendType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::SkiaBackendType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::SkiaBackendType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VideoCodecProfile, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::VideoCodecProfile, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::VideoCodecProfile>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::ImageDecodeAcceleratorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::ImageDecodeAcceleratorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::ImageDecodeAcceleratorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::ImageDecodeAcceleratorSubsampling, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::ImageDecodeAcceleratorSubsampling, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::ImageDecodeAcceleratorSubsampling>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GpuDeviceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::GpuDeviceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::GpuDevice_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->vendor_id = Traits::vendor_id(input);

    fragment->device_id = Traits::device_id(input);

    fragment->active = Traits::active(input);

    decltype(Traits::vendor_string(input)) in_vendor_string = Traits::vendor_string(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->vendor_string)::BaseType> vendor_string_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_vendor_string,
      vendor_string_fragment);

    fragment->vendor_string.Set(
        vendor_string_fragment.is_null() ? nullptr : vendor_string_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->vendor_string.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vendor_string in GpuDevice struct");

    decltype(Traits::device_string(input)) in_device_string = Traits::device_string(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_string)::BaseType> device_string_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_device_string,
      device_string_fragment);

    fragment->device_string.Set(
        device_string_fragment.is_null() ? nullptr : device_string_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_string.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_string in GpuDevice struct");

    decltype(Traits::driver_vendor(input)) in_driver_vendor = Traits::driver_vendor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->driver_vendor)::BaseType> driver_vendor_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_driver_vendor,
      driver_vendor_fragment);

    fragment->driver_vendor.Set(
        driver_vendor_fragment.is_null() ? nullptr : driver_vendor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->driver_vendor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null driver_vendor in GpuDevice struct");

    decltype(Traits::driver_version(input)) in_driver_version = Traits::driver_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->driver_version)::BaseType> driver_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_driver_version,
      driver_version_fragment);

    fragment->driver_version.Set(
        driver_version_fragment.is_null() ? nullptr : driver_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->driver_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null driver_version in GpuDevice struct");

    
    mojo::internal::Serialize<::gl::mojom::GpuPreference>(
      Traits::gpu_preference(input),
      &fragment->gpu_preference);
  }

  static bool Deserialize(::gpu::mojom::internal::GpuDevice_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::GpuDeviceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VideoDecodeAcceleratorSupportedProfile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::gpu::mojom::VideoCodecProfile>(
      Traits::profile(input),
      &fragment->profile);

    decltype(Traits::max_resolution(input)) in_max_resolution = Traits::max_resolution(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->max_resolution)::BaseType> max_resolution_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_max_resolution,
      max_resolution_fragment);

    fragment->max_resolution.Set(
        max_resolution_fragment.is_null() ? nullptr : max_resolution_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->max_resolution.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_resolution in VideoDecodeAcceleratorSupportedProfile struct");

    decltype(Traits::min_resolution(input)) in_min_resolution = Traits::min_resolution(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->min_resolution)::BaseType> min_resolution_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_min_resolution,
      min_resolution_fragment);

    fragment->min_resolution.Set(
        min_resolution_fragment.is_null() ? nullptr : min_resolution_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->min_resolution.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_resolution in VideoDecodeAcceleratorSupportedProfile struct");

    fragment->encrypted_only = Traits::encrypted_only(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VideoDecodeAcceleratorSupportedProfile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VideoDecodeAcceleratorCapabilitiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VideoDecodeAcceleratorCapabilitiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VideoDecodeAcceleratorCapabilities_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::supported_profiles(input)) in_supported_profiles = Traits::supported_profiles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_profiles)::BaseType>
        supported_profiles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_profiles_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView>>(
      in_supported_profiles,
      supported_profiles_fragment,
      &supported_profiles_validate_params);

    fragment->supported_profiles.Set(
        supported_profiles_fragment.is_null() ? nullptr : supported_profiles_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supported_profiles.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_profiles in VideoDecodeAcceleratorCapabilities struct");

    fragment->flags = Traits::flags(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VideoDecodeAcceleratorCapabilities_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VideoDecodeAcceleratorCapabilitiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VideoEncodeAcceleratorSupportedProfileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VideoEncodeAcceleratorSupportedProfileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VideoEncodeAcceleratorSupportedProfile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::gpu::mojom::VideoCodecProfile>(
      Traits::profile(input),
      &fragment->profile);

    decltype(Traits::min_resolution(input)) in_min_resolution = Traits::min_resolution(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->min_resolution)::BaseType> min_resolution_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_min_resolution,
      min_resolution_fragment);

    fragment->min_resolution.Set(
        min_resolution_fragment.is_null() ? nullptr : min_resolution_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->min_resolution.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_resolution in VideoEncodeAcceleratorSupportedProfile struct");

    decltype(Traits::max_resolution(input)) in_max_resolution = Traits::max_resolution(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->max_resolution)::BaseType> max_resolution_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_max_resolution,
      max_resolution_fragment);

    fragment->max_resolution.Set(
        max_resolution_fragment.is_null() ? nullptr : max_resolution_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->max_resolution.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_resolution in VideoEncodeAcceleratorSupportedProfile struct");

    fragment->max_framerate_numerator = Traits::max_framerate_numerator(input);

    fragment->max_framerate_denominator = Traits::max_framerate_denominator(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VideoEncodeAcceleratorSupportedProfile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VideoEncodeAcceleratorSupportedProfileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::ImageDecodeAcceleratorSupportedProfileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::ImageDecodeAcceleratorSupportedProfileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::ImageDecodeAcceleratorSupportedProfile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::gpu::mojom::ImageDecodeAcceleratorType>(
      Traits::image_type(input),
      &fragment->image_type);

    decltype(Traits::min_encoded_dimensions(input)) in_min_encoded_dimensions = Traits::min_encoded_dimensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->min_encoded_dimensions)::BaseType> min_encoded_dimensions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_min_encoded_dimensions,
      min_encoded_dimensions_fragment);

    fragment->min_encoded_dimensions.Set(
        min_encoded_dimensions_fragment.is_null() ? nullptr : min_encoded_dimensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->min_encoded_dimensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_encoded_dimensions in ImageDecodeAcceleratorSupportedProfile struct");

    decltype(Traits::max_encoded_dimensions(input)) in_max_encoded_dimensions = Traits::max_encoded_dimensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->max_encoded_dimensions)::BaseType> max_encoded_dimensions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_max_encoded_dimensions,
      max_encoded_dimensions_fragment);

    fragment->max_encoded_dimensions.Set(
        max_encoded_dimensions_fragment.is_null() ? nullptr : max_encoded_dimensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->max_encoded_dimensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_encoded_dimensions in ImageDecodeAcceleratorSupportedProfile struct");

    decltype(Traits::subsamplings(input)) in_subsamplings = Traits::subsamplings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subsamplings)::BaseType>
        subsamplings_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& subsamplings_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::gpu::mojom::internal::ImageDecodeAcceleratorSubsampling_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::ImageDecodeAcceleratorSubsampling>>(
      in_subsamplings,
      subsamplings_fragment,
      &subsamplings_validate_params);

    fragment->subsamplings.Set(
        subsamplings_fragment.is_null() ? nullptr : subsamplings_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subsamplings.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subsamplings in ImageDecodeAcceleratorSupportedProfile struct");
  }

  static bool Deserialize(::gpu::mojom::internal::ImageDecodeAcceleratorSupportedProfile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::ImageDecodeAcceleratorSupportedProfileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GpuInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::GpuInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::GpuInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::initialization_time(input)) in_initialization_time = Traits::initialization_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initialization_time)::BaseType> initialization_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_initialization_time,
      initialization_time_fragment);

    fragment->initialization_time.Set(
        initialization_time_fragment.is_null() ? nullptr : initialization_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->initialization_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initialization_time in GpuInfo struct");

    fragment->optimus = Traits::optimus(input);

    fragment->amd_switchable = Traits::amd_switchable(input);

    decltype(Traits::gpu(input)) in_gpu = Traits::gpu(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gpu)::BaseType> gpu_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::GpuDeviceDataView>(
      in_gpu,
      gpu_fragment);

    fragment->gpu.Set(
        gpu_fragment.is_null() ? nullptr : gpu_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->gpu.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu in GpuInfo struct");

    decltype(Traits::secondary_gpus(input)) in_secondary_gpus = Traits::secondary_gpus(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->secondary_gpus)::BaseType>
        secondary_gpus_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& secondary_gpus_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::GpuDeviceDataView>>(
      in_secondary_gpus,
      secondary_gpus_fragment,
      &secondary_gpus_validate_params);

    fragment->secondary_gpus.Set(
        secondary_gpus_fragment.is_null() ? nullptr : secondary_gpus_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->secondary_gpus.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null secondary_gpus in GpuInfo struct");

    decltype(Traits::npus(input)) in_npus = Traits::npus(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->npus)::BaseType>
        npus_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& npus_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::GpuDeviceDataView>>(
      in_npus,
      npus_fragment,
      &npus_validate_params);

    fragment->npus.Set(
        npus_fragment.is_null() ? nullptr : npus_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->npus.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null npus in GpuInfo struct");

    decltype(Traits::pixel_shader_version(input)) in_pixel_shader_version = Traits::pixel_shader_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pixel_shader_version)::BaseType> pixel_shader_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_pixel_shader_version,
      pixel_shader_version_fragment);

    fragment->pixel_shader_version.Set(
        pixel_shader_version_fragment.is_null() ? nullptr : pixel_shader_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pixel_shader_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pixel_shader_version in GpuInfo struct");

    decltype(Traits::vertex_shader_version(input)) in_vertex_shader_version = Traits::vertex_shader_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->vertex_shader_version)::BaseType> vertex_shader_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_vertex_shader_version,
      vertex_shader_version_fragment);

    fragment->vertex_shader_version.Set(
        vertex_shader_version_fragment.is_null() ? nullptr : vertex_shader_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->vertex_shader_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vertex_shader_version in GpuInfo struct");

    decltype(Traits::max_msaa_samples(input)) in_max_msaa_samples = Traits::max_msaa_samples(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->max_msaa_samples)::BaseType> max_msaa_samples_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_max_msaa_samples,
      max_msaa_samples_fragment);

    fragment->max_msaa_samples.Set(
        max_msaa_samples_fragment.is_null() ? nullptr : max_msaa_samples_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->max_msaa_samples.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_msaa_samples in GpuInfo struct");

    decltype(Traits::machine_model_name(input)) in_machine_model_name = Traits::machine_model_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->machine_model_name)::BaseType> machine_model_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_machine_model_name,
      machine_model_name_fragment);

    fragment->machine_model_name.Set(
        machine_model_name_fragment.is_null() ? nullptr : machine_model_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->machine_model_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null machine_model_name in GpuInfo struct");

    decltype(Traits::machine_model_version(input)) in_machine_model_version = Traits::machine_model_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->machine_model_version)::BaseType> machine_model_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_machine_model_version,
      machine_model_version_fragment);

    fragment->machine_model_version.Set(
        machine_model_version_fragment.is_null() ? nullptr : machine_model_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->machine_model_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null machine_model_version in GpuInfo struct");

    decltype(Traits::display_type(input)) in_display_type = Traits::display_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_type)::BaseType> display_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_type,
      display_type_fragment);

    fragment->display_type.Set(
        display_type_fragment.is_null() ? nullptr : display_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_type in GpuInfo struct");

    
    mojo::internal::Serialize<::gpu::mojom::SkiaBackendType>(
      Traits::skia_backend_type(input),
      &fragment->skia_backend_type);

    decltype(Traits::gl_version(input)) in_gl_version = Traits::gl_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gl_version)::BaseType> gl_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_gl_version,
      gl_version_fragment);

    fragment->gl_version.Set(
        gl_version_fragment.is_null() ? nullptr : gl_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->gl_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gl_version in GpuInfo struct");

    decltype(Traits::gl_vendor(input)) in_gl_vendor = Traits::gl_vendor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gl_vendor)::BaseType> gl_vendor_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_gl_vendor,
      gl_vendor_fragment);

    fragment->gl_vendor.Set(
        gl_vendor_fragment.is_null() ? nullptr : gl_vendor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->gl_vendor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gl_vendor in GpuInfo struct");

    decltype(Traits::gl_renderer(input)) in_gl_renderer = Traits::gl_renderer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gl_renderer)::BaseType> gl_renderer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_gl_renderer,
      gl_renderer_fragment);

    fragment->gl_renderer.Set(
        gl_renderer_fragment.is_null() ? nullptr : gl_renderer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->gl_renderer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gl_renderer in GpuInfo struct");

    decltype(Traits::gl_extensions(input)) in_gl_extensions = Traits::gl_extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gl_extensions)::BaseType> gl_extensions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_gl_extensions,
      gl_extensions_fragment);

    fragment->gl_extensions.Set(
        gl_extensions_fragment.is_null() ? nullptr : gl_extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->gl_extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gl_extensions in GpuInfo struct");

    decltype(Traits::gl_ws_vendor(input)) in_gl_ws_vendor = Traits::gl_ws_vendor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gl_ws_vendor)::BaseType> gl_ws_vendor_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_gl_ws_vendor,
      gl_ws_vendor_fragment);

    fragment->gl_ws_vendor.Set(
        gl_ws_vendor_fragment.is_null() ? nullptr : gl_ws_vendor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->gl_ws_vendor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gl_ws_vendor in GpuInfo struct");

    decltype(Traits::gl_ws_version(input)) in_gl_ws_version = Traits::gl_ws_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gl_ws_version)::BaseType> gl_ws_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_gl_ws_version,
      gl_ws_version_fragment);

    fragment->gl_ws_version.Set(
        gl_ws_version_fragment.is_null() ? nullptr : gl_ws_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->gl_ws_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gl_ws_version in GpuInfo struct");

    decltype(Traits::gl_ws_extensions(input)) in_gl_ws_extensions = Traits::gl_ws_extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gl_ws_extensions)::BaseType> gl_ws_extensions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_gl_ws_extensions,
      gl_ws_extensions_fragment);

    fragment->gl_ws_extensions.Set(
        gl_ws_extensions_fragment.is_null() ? nullptr : gl_ws_extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->gl_ws_extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gl_ws_extensions in GpuInfo struct");

    fragment->gl_reset_notification_strategy = Traits::gl_reset_notification_strategy(input);

    decltype(Traits::gl_implementation_parts(input)) in_gl_implementation_parts = Traits::gl_implementation_parts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gl_implementation_parts)::BaseType> gl_implementation_parts_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gl::mojom::GLImplementationPartsDataView>(
      in_gl_implementation_parts,
      gl_implementation_parts_fragment);

    fragment->gl_implementation_parts.Set(
        gl_implementation_parts_fragment.is_null() ? nullptr : gl_implementation_parts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->gl_implementation_parts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gl_implementation_parts in GpuInfo struct");

    decltype(Traits::direct_rendering_version(input)) in_direct_rendering_version = Traits::direct_rendering_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->direct_rendering_version)::BaseType> direct_rendering_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_direct_rendering_version,
      direct_rendering_version_fragment);

    fragment->direct_rendering_version.Set(
        direct_rendering_version_fragment.is_null() ? nullptr : direct_rendering_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->direct_rendering_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null direct_rendering_version in GpuInfo struct");

    fragment->sandboxed = Traits::sandboxed(input);

    fragment->in_process_gpu = Traits::in_process_gpu(input);

    fragment->passthrough_cmd_decoder = Traits::passthrough_cmd_decoder(input);

    fragment->can_support_threaded_texture_mailbox = Traits::can_support_threaded_texture_mailbox(input);

    decltype(Traits::video_decode_accelerator_supported_profiles(input)) in_video_decode_accelerator_supported_profiles = Traits::video_decode_accelerator_supported_profiles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->video_decode_accelerator_supported_profiles)::BaseType>
        video_decode_accelerator_supported_profiles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& video_decode_accelerator_supported_profiles_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView>>(
      in_video_decode_accelerator_supported_profiles,
      video_decode_accelerator_supported_profiles_fragment,
      &video_decode_accelerator_supported_profiles_validate_params);

    fragment->video_decode_accelerator_supported_profiles.Set(
        video_decode_accelerator_supported_profiles_fragment.is_null() ? nullptr : video_decode_accelerator_supported_profiles_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->video_decode_accelerator_supported_profiles.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null video_decode_accelerator_supported_profiles in GpuInfo struct");

    decltype(Traits::video_encode_accelerator_supported_profiles(input)) in_video_encode_accelerator_supported_profiles = Traits::video_encode_accelerator_supported_profiles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->video_encode_accelerator_supported_profiles)::BaseType>
        video_encode_accelerator_supported_profiles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& video_encode_accelerator_supported_profiles_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VideoEncodeAcceleratorSupportedProfileDataView>>(
      in_video_encode_accelerator_supported_profiles,
      video_encode_accelerator_supported_profiles_fragment,
      &video_encode_accelerator_supported_profiles_validate_params);

    fragment->video_encode_accelerator_supported_profiles.Set(
        video_encode_accelerator_supported_profiles_fragment.is_null() ? nullptr : video_encode_accelerator_supported_profiles_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->video_encode_accelerator_supported_profiles.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null video_encode_accelerator_supported_profiles in GpuInfo struct");

    fragment->jpeg_decode_accelerator_supported = Traits::jpeg_decode_accelerator_supported(input);

    fragment->subpixel_font_rendering = Traits::subpixel_font_rendering(input);

    fragment->visibility_callback_call_count = Traits::visibility_callback_call_count(input);
  }

  static bool Deserialize(::gpu::mojom::internal::GpuInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::GpuInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {

inline void GpuDeviceDataView::GetVendorStringDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->vendor_string.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuDeviceDataView::GetDeviceStringDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_string.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuDeviceDataView::GetDriverVendorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->driver_vendor.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuDeviceDataView::GetDriverVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->driver_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void VideoDecodeAcceleratorSupportedProfileDataView::GetMaxResolutionDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->max_resolution.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoDecodeAcceleratorSupportedProfileDataView::GetMinResolutionDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->min_resolution.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void VideoDecodeAcceleratorCapabilitiesDataView::GetSupportedProfilesDataView(
    mojo::ArrayDataView<VideoDecodeAcceleratorSupportedProfileDataView>* output) {
  auto pointer = data_->supported_profiles.Get();
  *output = mojo::ArrayDataView<VideoDecodeAcceleratorSupportedProfileDataView>(pointer, message_);
}


inline void VideoEncodeAcceleratorSupportedProfileDataView::GetMinResolutionDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->min_resolution.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoEncodeAcceleratorSupportedProfileDataView::GetMaxResolutionDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->max_resolution.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void ImageDecodeAcceleratorSupportedProfileDataView::GetMinEncodedDimensionsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->min_encoded_dimensions.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void ImageDecodeAcceleratorSupportedProfileDataView::GetMaxEncodedDimensionsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->max_encoded_dimensions.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void ImageDecodeAcceleratorSupportedProfileDataView::GetSubsamplingsDataView(
    mojo::ArrayDataView<ImageDecodeAcceleratorSubsampling>* output) {
  auto pointer = data_->subsamplings.Get();
  *output = mojo::ArrayDataView<ImageDecodeAcceleratorSubsampling>(pointer, message_);
}


inline void GpuInfoDataView::GetInitializationTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->initialization_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void GpuInfoDataView::GetGpuDataView(
    GpuDeviceDataView* output) {
  auto pointer = data_->gpu.Get();
  *output = GpuDeviceDataView(pointer, message_);
}
inline void GpuInfoDataView::GetSecondaryGpusDataView(
    mojo::ArrayDataView<GpuDeviceDataView>* output) {
  auto pointer = data_->secondary_gpus.Get();
  *output = mojo::ArrayDataView<GpuDeviceDataView>(pointer, message_);
}
inline void GpuInfoDataView::GetNpusDataView(
    mojo::ArrayDataView<GpuDeviceDataView>* output) {
  auto pointer = data_->npus.Get();
  *output = mojo::ArrayDataView<GpuDeviceDataView>(pointer, message_);
}
inline void GpuInfoDataView::GetPixelShaderVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->pixel_shader_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetVertexShaderVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->vertex_shader_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetMaxMsaaSamplesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->max_msaa_samples.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetMachineModelNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->machine_model_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetMachineModelVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->machine_model_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetDisplayTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetGlVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->gl_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetGlVendorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->gl_vendor.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetGlRendererDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->gl_renderer.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetGlExtensionsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->gl_extensions.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetGlWsVendorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->gl_ws_vendor.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetGlWsVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->gl_ws_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetGlWsExtensionsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->gl_ws_extensions.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetGlImplementationPartsDataView(
    ::gl::mojom::GLImplementationPartsDataView* output) {
  auto pointer = data_->gl_implementation_parts.Get();
  *output = ::gl::mojom::GLImplementationPartsDataView(pointer, message_);
}
inline void GpuInfoDataView::GetDirectRenderingVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->direct_rendering_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuInfoDataView::GetVideoDecodeAcceleratorSupportedProfilesDataView(
    mojo::ArrayDataView<VideoDecodeAcceleratorSupportedProfileDataView>* output) {
  auto pointer = data_->video_decode_accelerator_supported_profiles.Get();
  *output = mojo::ArrayDataView<VideoDecodeAcceleratorSupportedProfileDataView>(pointer, message_);
}
inline void GpuInfoDataView::GetVideoEncodeAcceleratorSupportedProfilesDataView(
    mojo::ArrayDataView<VideoEncodeAcceleratorSupportedProfileDataView>* output) {
  auto pointer = data_->video_encode_accelerator_supported_profiles.Get();
  *output = mojo::ArrayDataView<VideoEncodeAcceleratorSupportedProfileDataView>(pointer, message_);
}



}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::SkiaBackendType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::SkiaBackendType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::VideoCodecProfile> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::VideoCodecProfile value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::ImageDecodeAcceleratorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::ImageDecodeAcceleratorType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::ImageDecodeAcceleratorSubsampling> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::ImageDecodeAcceleratorSubsampling value);
};

} // namespace perfetto

#endif  // GPU_IPC_COMMON_GPU_INFO_MOJOM_SHARED_H_