// gpu/ipc/common/gpu_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_INFO_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_GPU_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "gpu/ipc/common/gpu_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gl/mojom/gl_implementation.mojom-shared.h"
#include "ui/gl/mojom/gpu_preference.mojom-shared.h"


namespace gpu::mojom {
class GpuDeviceDataView;

class VideoDecodeAcceleratorSupportedProfileDataView;

class VideoDecodeAcceleratorCapabilitiesDataView;

class VideoEncodeAcceleratorSupportedProfileDataView;

class ImageDecodeAcceleratorSupportedProfileDataView;

class GpuInfoDataView;



}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::GpuDeviceDataView> {
  using Data = ::gpu::mojom::internal::GpuDevice_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView> {
  using Data = ::gpu::mojom::internal::VideoDecodeAcceleratorSupportedProfile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VideoDecodeAcceleratorCapabilitiesDataView> {
  using Data = ::gpu::mojom::internal::VideoDecodeAcceleratorCapabilities_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VideoEncodeAcceleratorSupportedProfileDataView> {
  using Data = ::gpu::mojom::internal::VideoEncodeAcceleratorSupportedProfile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::ImageDecodeAcceleratorSupportedProfileDataView> {
  using Data = ::gpu::mojom::internal::ImageDecodeAcceleratorSupportedProfile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::GpuInfoDataView> {
  using Data = ::gpu::mojom::internal::GpuInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


enum class SkiaBackendType : int32_t {
  
  kUnknown = 0,
  
  kNone = 1,
  
  kGaneshGL = 2,
  
  kGaneshVulkan = 3,
  
  kGraphiteDawnVulkan = 4,
  
  kGraphiteDawnMetal = 5,
  
  kGraphiteDawnD3D11 = 6,
  
  kGraphiteDawnD3D12 = 7,
  
  kGraphiteMetal = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, SkiaBackendType value);
inline bool IsKnownEnumValue(SkiaBackendType value) {
  return internal::SkiaBackendType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VideoCodecProfile : int32_t {
  
  VIDEO_CODEC_PROFILE_UNKNOWN = -1,
  
  H264PROFILE_BASELINE = 0,
  
  H264PROFILE_MAIN = 1,
  
  H264PROFILE_EXTENDED = 2,
  
  H264PROFILE_HIGH = 3,
  
  H264PROFILE_HIGH10PROFILE = 4,
  
  H264PROFILE_HIGH422PROFILE = 5,
  
  H264PROFILE_HIGH444PREDICTIVEPROFILE = 6,
  
  H264PROFILE_SCALABLEBASELINE = 7,
  
  H264PROFILE_SCALABLEHIGH = 8,
  
  H264PROFILE_STEREOHIGH = 9,
  
  H264PROFILE_MULTIVIEWHIGH = 10,
  
  VP8PROFILE_ANY = 11,
  
  VP9PROFILE_PROFILE0 = 12,
  
  VP9PROFILE_PROFILE1 = 13,
  
  VP9PROFILE_PROFILE2 = 14,
  
  VP9PROFILE_PROFILE3 = 15,
  
  HEVCPROFILE_MAIN = 16,
  
  HEVCPROFILE_MAIN10 = 17,
  
  HEVCPROFILE_MAIN_STILL_PICTURE = 18,
  
  DOLBYVISION_PROFILE0 = 19,
  
  DOLBYVISION_PROFILE5 = 21,
  
  DOLBYVISION_PROFILE7 = 22,
  
  THEORAPROFILE_ANY = 23,
  
  AV1PROFILE_PROFILE_MAIN = 24,
  
  AV1PROFILE_PROFILE_HIGH = 25,
  
  AV1PROFILE_PROFILE_PRO = 26,
  
  DOLBYVISION_PROFILE8 = 27,
  
  DOLBYVISION_PROFILE9 = 28,
  
  HEVCPROFILE_REXT = 29,
  
  HEVCPROFILE_HIGH_THROUGHPUT = 30,
  
  HEVCPROFILE_MULTIVIEW_MAIN = 31,
  
  HEVCPROFILE_SCALABLE_MAIN = 32,
  
  HEVCPROFILE_3D_MAIN = 33,
  
  HEVCPROFILE_SCREEN_EXTENDED = 34,
  
  HEVCPROFILE_SCALABLE_REXT = 35,
  
  HEVCPROFILE_HIGH_THROUGHPUT_SCREEN_EXTENDED = 36,
  
  VVCPROFILE_MAIN10 = 37,
  
  VVCPROFILE_MAIN12 = 38,
  
  VVCPROFILE_MAIN12_INTRA = 39,
  
  VVCPROIFLE_MULTILAYER_MAIN10 = 40,
  
  VVCPROFILE_MAIN10_444 = 41,
  
  VVCPROFILE_MAIN12_444 = 42,
  
  VVCPROFILE_MAIN16_444 = 43,
  
  VVCPROFILE_MAIN12_444_INTRA = 44,
  
  VVCPROFILE_MAIN16_444_INTRA = 45,
  
  VVCPROFILE_MULTILAYER_MAIN10_444 = 46,
  
  VVCPROFILE_MAIN10_STILL_PICTURE = 47,
  
  VVCPROFILE_MAIN12_STILL_PICTURE = 48,
  
  VVCPROFILE_MAIN10_444_STILL_PICTURE = 49,
  
  VVCPROFILE_MAIN12_444_STILL_PICTURE = 50,
  
  VVCPROFILE_MAIN16_444_STILL_PICTURE = 51,
  kMinValue = -1,
  kMaxValue = 51,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, VideoCodecProfile value);
inline bool IsKnownEnumValue(VideoCodecProfile value) {
  return internal::VideoCodecProfile_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ImageDecodeAcceleratorType : int32_t {
  
  kJpeg = 0,
  
  kWebP = 1,
  
  kUnknown = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, ImageDecodeAcceleratorType value);
inline bool IsKnownEnumValue(ImageDecodeAcceleratorType value) {
  return internal::ImageDecodeAcceleratorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ImageDecodeAcceleratorSubsampling : int32_t {
  
  k420 = 0,
  
  k422 = 1,
  
  k444 = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, ImageDecodeAcceleratorSubsampling value);
inline bool IsKnownEnumValue(ImageDecodeAcceleratorSubsampling value) {
  return internal::ImageDecodeAcceleratorSubsampling_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GpuDeviceDataView {
 public:
  GpuDeviceDataView() = default;

  GpuDeviceDataView(
      internal::GpuDevice_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t vendor_id() const {
    return data_->vendor_id;
  }
  uint32_t device_id() const {
    return data_->device_id;
  }
  bool active() const {
    return data_->active;
  }
  inline void GetVendorStringDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVendorString(UserType* output) {
    
    auto* pointer = data_->vendor_string.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceStringDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceString(UserType* output) {
    
    auto* pointer = data_->device_string.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDriverVendorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDriverVendor(UserType* output) {
    
    auto* pointer = data_->driver_vendor.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDriverVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDriverVersion(UserType* output) {
    
    auto* pointer = data_->driver_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadGpuPreference(UserType* output) const {
    auto data_value = data_->gpu_preference;
    return mojo::internal::Deserialize<::gl::mojom::GpuPreference>(
        data_value, output);
  }
  ::gl::mojom::GpuPreference gpu_preference() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gl::mojom::GpuPreference>(data_->gpu_preference));
  }
 private:
  internal::GpuDevice_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecodeAcceleratorSupportedProfileDataView {
 public:
  VideoDecodeAcceleratorSupportedProfileDataView() = default;

  VideoDecodeAcceleratorSupportedProfileDataView(
      internal::VideoDecodeAcceleratorSupportedProfile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::gpu::mojom::VideoCodecProfile>(
        data_value, output);
  }
  VideoCodecProfile profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::VideoCodecProfile>(data_->profile));
  }
  inline void GetMaxResolutionDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxResolution(UserType* output) {
    
    auto* pointer = data_->max_resolution.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetMinResolutionDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinResolution(UserType* output) {
    
    auto* pointer = data_->min_resolution.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool encrypted_only() const {
    return data_->encrypted_only;
  }
 private:
  internal::VideoDecodeAcceleratorSupportedProfile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoDecodeAcceleratorCapabilitiesDataView {
 public:
  VideoDecodeAcceleratorCapabilitiesDataView() = default;

  VideoDecodeAcceleratorCapabilitiesDataView(
      internal::VideoDecodeAcceleratorCapabilities_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSupportedProfilesDataView(
      mojo::ArrayDataView<VideoDecodeAcceleratorSupportedProfileDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedProfiles(UserType* output) {
    
    auto* pointer = data_->supported_profiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView>>(
        pointer, output, message_);
  }
  uint32_t flags() const {
    return data_->flags;
  }
 private:
  internal::VideoDecodeAcceleratorCapabilities_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAcceleratorSupportedProfileDataView {
 public:
  VideoEncodeAcceleratorSupportedProfileDataView() = default;

  VideoEncodeAcceleratorSupportedProfileDataView(
      internal::VideoEncodeAcceleratorSupportedProfile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) const {
    auto data_value = data_->profile;
    return mojo::internal::Deserialize<::gpu::mojom::VideoCodecProfile>(
        data_value, output);
  }
  VideoCodecProfile profile() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::VideoCodecProfile>(data_->profile));
  }
  inline void GetMinResolutionDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinResolution(UserType* output) {
    
    auto* pointer = data_->min_resolution.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetMaxResolutionDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxResolution(UserType* output) {
    
    auto* pointer = data_->max_resolution.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  uint32_t max_framerate_numerator() const {
    return data_->max_framerate_numerator;
  }
  uint32_t max_framerate_denominator() const {
    return data_->max_framerate_denominator;
  }
 private:
  internal::VideoEncodeAcceleratorSupportedProfile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ImageDecodeAcceleratorSupportedProfileDataView {
 public:
  ImageDecodeAcceleratorSupportedProfileDataView() = default;

  ImageDecodeAcceleratorSupportedProfileDataView(
      internal::ImageDecodeAcceleratorSupportedProfile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadImageType(UserType* output) const {
    auto data_value = data_->image_type;
    return mojo::internal::Deserialize<::gpu::mojom::ImageDecodeAcceleratorType>(
        data_value, output);
  }
  ImageDecodeAcceleratorType image_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::ImageDecodeAcceleratorType>(data_->image_type));
  }
  inline void GetMinEncodedDimensionsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinEncodedDimensions(UserType* output) {
    
    auto* pointer = data_->min_encoded_dimensions.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetMaxEncodedDimensionsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxEncodedDimensions(UserType* output) {
    
    auto* pointer = data_->max_encoded_dimensions.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetSubsamplingsDataView(
      mojo::ArrayDataView<ImageDecodeAcceleratorSubsampling>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubsamplings(UserType* output) {
    
    auto* pointer = data_->subsamplings.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::ImageDecodeAcceleratorSubsampling>>(
        pointer, output, message_);
  }
 private:
  internal::ImageDecodeAcceleratorSupportedProfile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuInfoDataView {
 public:
  GpuInfoDataView() = default;

  GpuInfoDataView(
      internal::GpuInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInitializationTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitializationTime(UserType* output) {
    
    auto* pointer = data_->initialization_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool optimus() const {
    return data_->optimus;
  }
  bool amd_switchable() const {
    return data_->amd_switchable;
  }
  inline void GetGpuDataView(
      GpuDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpu(UserType* output) {
    
    auto* pointer = data_->gpu.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GpuDeviceDataView>(
        pointer, output, message_);
  }
  inline void GetSecondaryGpusDataView(
      mojo::ArrayDataView<GpuDeviceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSecondaryGpus(UserType* output) {
    
    auto* pointer = data_->secondary_gpus.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::GpuDeviceDataView>>(
        pointer, output, message_);
  }
  inline void GetNpusDataView(
      mojo::ArrayDataView<GpuDeviceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNpus(UserType* output) {
    
    auto* pointer = data_->npus.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::GpuDeviceDataView>>(
        pointer, output, message_);
  }
  inline void GetPixelShaderVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelShaderVersion(UserType* output) {
    
    auto* pointer = data_->pixel_shader_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVertexShaderVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVertexShaderVersion(UserType* output) {
    
    auto* pointer = data_->vertex_shader_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMaxMsaaSamplesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxMsaaSamples(UserType* output) {
    
    auto* pointer = data_->max_msaa_samples.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMachineModelNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMachineModelName(UserType* output) {
    
    auto* pointer = data_->machine_model_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMachineModelVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMachineModelVersion(UserType* output) {
    
    auto* pointer = data_->machine_model_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayType(UserType* output) {
    
    auto* pointer = data_->display_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSkiaBackendType(UserType* output) const {
    auto data_value = data_->skia_backend_type;
    return mojo::internal::Deserialize<::gpu::mojom::SkiaBackendType>(
        data_value, output);
  }
  SkiaBackendType skia_backend_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::SkiaBackendType>(data_->skia_backend_type));
  }
  inline void GetGlVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGlVersion(UserType* output) {
    
    auto* pointer = data_->gl_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGlVendorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGlVendor(UserType* output) {
    
    auto* pointer = data_->gl_vendor.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGlRendererDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGlRenderer(UserType* output) {
    
    auto* pointer = data_->gl_renderer.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGlExtensionsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGlExtensions(UserType* output) {
    
    auto* pointer = data_->gl_extensions.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGlWsVendorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGlWsVendor(UserType* output) {
    
    auto* pointer = data_->gl_ws_vendor.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGlWsVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGlWsVersion(UserType* output) {
    
    auto* pointer = data_->gl_ws_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGlWsExtensionsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGlWsExtensions(UserType* output) {
    
    auto* pointer = data_->gl_ws_extensions.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t gl_reset_notification_strategy() const {
    return data_->gl_reset_notification_strategy;
  }
  inline void GetGlImplementationPartsDataView(
      ::gl::mojom::GLImplementationPartsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGlImplementationParts(UserType* output) {
    
    auto* pointer = data_->gl_implementation_parts.Get();
    return mojo::internal::Deserialize<::gl::mojom::GLImplementationPartsDataView>(
        pointer, output, message_);
  }
  inline void GetDirectRenderingVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectRenderingVersion(UserType* output) {
    
    auto* pointer = data_->direct_rendering_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool sandboxed() const {
    return data_->sandboxed;
  }
  bool in_process_gpu() const {
    return data_->in_process_gpu;
  }
  bool passthrough_cmd_decoder() const {
    return data_->passthrough_cmd_decoder;
  }
  bool can_support_threaded_texture_mailbox() const {
    return data_->can_support_threaded_texture_mailbox;
  }
  inline void GetVideoDecodeAcceleratorSupportedProfilesDataView(
      mojo::ArrayDataView<VideoDecodeAcceleratorSupportedProfileDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoDecodeAcceleratorSupportedProfiles(UserType* output) {
    
    auto* pointer = data_->video_decode_accelerator_supported_profiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VideoDecodeAcceleratorSupportedProfileDataView>>(
        pointer, output, message_);
  }
  inline void GetVideoEncodeAcceleratorSupportedProfilesDataView(
      mojo::ArrayDataView<VideoEncodeAcceleratorSupportedProfileDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVideoEncodeAcceleratorSupportedProfiles(UserType* output) {
    
    auto* pointer = data_->video_encode_accelerator_supported_profiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::VideoEncodeAcceleratorSupportedProfileDataView>>(
        pointer, output, message_);
  }
  bool jpeg_decode_accelerator_supported() const {
    return data_->jpeg_decode_accelerator_supported;
  }
  bool subpixel_font_rendering() const {
    return data_->subpixel_font_rendering;
  }
  uint32_t visibility_callback_call_count() const {
    return data_->visibility_callback_call_count;
  }
 private:
  internal::GpuInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

#endif  // GPU_IPC_COMMON_GPU_INFO_MOJOM_DATA_VIEW_H_