// gpu/ipc/common/gpu_disk_cache_type.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/gpu_disk_cache_type.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_disk_cache_type.mojom-params-data.h"
#include "gpu/ipc/common/gpu_disk_cache_type.mojom-shared-message-ids.h"

#include "gpu/ipc/common/gpu_disk_cache_type.mojom-import-headers.h"
#include "gpu/ipc/common/gpu_disk_cache_type.mojom-test-utils.h"


namespace gpu::mojom {
GpuDiskCacheGlShaderHandle::GpuDiskCacheGlShaderHandle()
    : value() {}

GpuDiskCacheGlShaderHandle::GpuDiskCacheGlShaderHandle(
    int32_t value_in)
    : value(std::move(value_in)) {}

GpuDiskCacheGlShaderHandle::~GpuDiskCacheGlShaderHandle() = default;

void GpuDiskCacheGlShaderHandle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuDiskCacheGlShaderHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuDiskCacheDawnWebGPUHandle::GpuDiskCacheDawnWebGPUHandle()
    : value() {}

GpuDiskCacheDawnWebGPUHandle::GpuDiskCacheDawnWebGPUHandle(
    int32_t value_in)
    : value(std::move(value_in)) {}

GpuDiskCacheDawnWebGPUHandle::~GpuDiskCacheDawnWebGPUHandle() = default;

void GpuDiskCacheDawnWebGPUHandle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuDiskCacheDawnWebGPUHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuDiskCacheDawnGraphiteHandle::GpuDiskCacheDawnGraphiteHandle()
    : value() {}

GpuDiskCacheDawnGraphiteHandle::GpuDiskCacheDawnGraphiteHandle(
    int32_t value_in)
    : value(std::move(value_in)) {}

GpuDiskCacheDawnGraphiteHandle::~GpuDiskCacheDawnGraphiteHandle() = default;

void GpuDiskCacheDawnGraphiteHandle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuDiskCacheDawnGraphiteHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuDiskCacheHandlePtr
GpuDiskCacheHandle::NewGlShaderHandle(
    const ::gpu::GpuDiskCacheGlShaderHandle& value) {
  return GpuDiskCacheHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGlShaderHandle)>,
      std::move(value));
}

GpuDiskCacheHandlePtr
GpuDiskCacheHandle::NewDawnWebgpuHandle(
    const ::gpu::GpuDiskCacheDawnWebGPUHandle& value) {
  return GpuDiskCacheHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDawnWebgpuHandle)>,
      std::move(value));
}

GpuDiskCacheHandlePtr
GpuDiskCacheHandle::NewDawnGraphiteHandle(
    const ::gpu::GpuDiskCacheDawnGraphiteHandle& value) {
  return GpuDiskCacheHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDawnGraphiteHandle)>,
      std::move(value));
}

GpuDiskCacheHandle::GpuDiskCacheHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kGlShaderHandle)>,
    const ::gpu::GpuDiskCacheGlShaderHandle& value)
    : tag_(Tag::kGlShaderHandle),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGlShaderHandle)>,
            std::move(value)) {}

GpuDiskCacheHandle::GpuDiskCacheHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kDawnWebgpuHandle)>,
    const ::gpu::GpuDiskCacheDawnWebGPUHandle& value)
    : tag_(Tag::kDawnWebgpuHandle),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDawnWebgpuHandle)>,
            std::move(value)) {}

GpuDiskCacheHandle::GpuDiskCacheHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kDawnGraphiteHandle)>,
    const ::gpu::GpuDiskCacheDawnGraphiteHandle& value)
    : tag_(Tag::kDawnGraphiteHandle),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDawnGraphiteHandle)>,
            std::move(value)) {}
GpuDiskCacheHandle::~GpuDiskCacheHandle() {
  DestroyActive();
}

void GpuDiskCacheHandle::set_gl_shader_handle(const ::gpu::GpuDiskCacheGlShaderHandle& gl_shader_handle) {
  if (tag_ == Tag::kGlShaderHandle) {
    data_.gl_shader_handle = std::move(gl_shader_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kGlShaderHandle;
    new (&data_.gl_shader_handle) ::gpu::GpuDiskCacheGlShaderHandle(
        std::move(gl_shader_handle));
  }
}

void GpuDiskCacheHandle::set_dawn_webgpu_handle(const ::gpu::GpuDiskCacheDawnWebGPUHandle& dawn_webgpu_handle) {
  if (tag_ == Tag::kDawnWebgpuHandle) {
    data_.dawn_webgpu_handle = std::move(dawn_webgpu_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kDawnWebgpuHandle;
    new (&data_.dawn_webgpu_handle) ::gpu::GpuDiskCacheDawnWebGPUHandle(
        std::move(dawn_webgpu_handle));
  }
}

void GpuDiskCacheHandle::set_dawn_graphite_handle(const ::gpu::GpuDiskCacheDawnGraphiteHandle& dawn_graphite_handle) {
  if (tag_ == Tag::kDawnGraphiteHandle) {
    data_.dawn_graphite_handle = std::move(dawn_graphite_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kDawnGraphiteHandle;
    new (&data_.dawn_graphite_handle) ::gpu::GpuDiskCacheDawnGraphiteHandle(
        std::move(dawn_graphite_handle));
  }
}


GpuDiskCacheHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGlShaderHandle)>,
    const ::gpu::GpuDiskCacheGlShaderHandle& value)
    : gl_shader_handle(std::move(value)) {}

GpuDiskCacheHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDawnWebgpuHandle)>,
    const ::gpu::GpuDiskCacheDawnWebGPUHandle& value)
    : dawn_webgpu_handle(std::move(value)) {}

GpuDiskCacheHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDawnGraphiteHandle)>,
    const ::gpu::GpuDiskCacheDawnGraphiteHandle& value)
    : dawn_graphite_handle(std::move(value)) {}

void GpuDiskCacheHandle::DestroyActive() {
  switch (tag_) {

    case Tag::kGlShaderHandle:
      std::destroy_at(&data_.gl_shader_handle);
      break;
    case Tag::kDawnWebgpuHandle:
      std::destroy_at(&data_.dawn_webgpu_handle);
      break;
    case Tag::kDawnGraphiteHandle:
      std::destroy_at(&data_.dawn_graphite_handle);
      break;
  }
}

bool GpuDiskCacheHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // gpu::mojom


namespace mojo {


// static
bool StructTraits<::gpu::mojom::GpuDiskCacheGlShaderHandle::DataView, ::gpu::mojom::GpuDiskCacheGlShaderHandlePtr>::Read(
    ::gpu::mojom::GpuDiskCacheGlShaderHandle::DataView input,
    ::gpu::mojom::GpuDiskCacheGlShaderHandlePtr* output) {
  bool success = true;
  ::gpu::mojom::GpuDiskCacheGlShaderHandlePtr result(::gpu::mojom::GpuDiskCacheGlShaderHandle::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::GpuDiskCacheDawnWebGPUHandle::DataView, ::gpu::mojom::GpuDiskCacheDawnWebGPUHandlePtr>::Read(
    ::gpu::mojom::GpuDiskCacheDawnWebGPUHandle::DataView input,
    ::gpu::mojom::GpuDiskCacheDawnWebGPUHandlePtr* output) {
  bool success = true;
  ::gpu::mojom::GpuDiskCacheDawnWebGPUHandlePtr result(::gpu::mojom::GpuDiskCacheDawnWebGPUHandle::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::GpuDiskCacheDawnGraphiteHandle::DataView, ::gpu::mojom::GpuDiskCacheDawnGraphiteHandlePtr>::Read(
    ::gpu::mojom::GpuDiskCacheDawnGraphiteHandle::DataView input,
    ::gpu::mojom::GpuDiskCacheDawnGraphiteHandlePtr* output) {
  bool success = true;
  ::gpu::mojom::GpuDiskCacheDawnGraphiteHandlePtr result(::gpu::mojom::GpuDiskCacheDawnGraphiteHandle::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::gpu::mojom::GpuDiskCacheHandle::DataView, ::gpu::mojom::GpuDiskCacheHandlePtr>::Read(
    ::gpu::mojom::GpuDiskCacheHandle::DataView input,
    ::gpu::mojom::GpuDiskCacheHandlePtr* output) {
  using UnionType = ::gpu::mojom::GpuDiskCacheHandle;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kGlShaderHandle: {
      ::gpu::GpuDiskCacheGlShaderHandle result_gl_shader_handle{};
      if (!input.ReadGlShaderHandle(&result_gl_shader_handle))
        return false;

      *output = UnionType::NewGlShaderHandle(
          std::move(result_gl_shader_handle));
      break;
    }
    case Tag::kDawnWebgpuHandle: {
      ::gpu::GpuDiskCacheDawnWebGPUHandle result_dawn_webgpu_handle{};
      if (!input.ReadDawnWebgpuHandle(&result_dawn_webgpu_handle))
        return false;

      *output = UnionType::NewDawnWebgpuHandle(
          std::move(result_dawn_webgpu_handle));
      break;
    }
    case Tag::kDawnGraphiteHandle: {
      ::gpu::GpuDiskCacheDawnGraphiteHandle result_dawn_graphite_handle{};
      if (!input.ReadDawnGraphiteHandle(&result_dawn_graphite_handle))
        return false;

      *output = UnionType::NewDawnGraphiteHandle(
          std::move(result_dawn_graphite_handle));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gpu::mojom {




}  // gpu::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif