// gpu/ipc/common/gpu_disk_cache_type.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_DISK_CACHE_TYPE_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_GPU_DISK_CACHE_TYPE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/gpu_disk_cache_type.mojom-shared-internal.h"




#include "gpu/ipc/common/gpu_disk_cache_type.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::gpu::mojom::GpuDiskCacheType>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::GpuDiskCacheType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GpuDiskCacheType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::GpuDiskCacheType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::GpuDiskCacheType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GpuDiskCacheGlShaderHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::GpuDiskCacheGlShaderHandleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::GpuDiskCacheGlShaderHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::gpu::mojom::internal::GpuDiskCacheGlShaderHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::GpuDiskCacheGlShaderHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GpuDiskCacheDawnWebGPUHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::GpuDiskCacheDawnWebGPUHandleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::GpuDiskCacheDawnWebGPUHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::gpu::mojom::internal::GpuDiskCacheDawnWebGPUHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::GpuDiskCacheDawnWebGPUHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GpuDiskCacheDawnGraphiteHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::GpuDiskCacheDawnGraphiteHandleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::GpuDiskCacheDawnGraphiteHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::gpu::mojom::internal::GpuDiskCacheDawnGraphiteHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::GpuDiskCacheDawnGraphiteHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GpuDiskCacheHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gpu::mojom::GpuDiskCacheHandleDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gpu::mojom::internal::GpuDiskCacheHandle_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::gpu::mojom::GpuDiskCacheHandleDataView::Tag::kGlShaderHandle: {
    decltype(Traits::gl_shader_handle(input))
    in_gl_shader_handle = Traits::gl_shader_handle(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gl_shader_handle)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::GpuDiskCacheGlShaderHandleDataView>(
  in_gl_shader_handle,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gl_shader_handle in GpuDiskCacheHandle union");
    fragment->data.f_gl_shader_handle.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::GpuDiskCacheHandleDataView::Tag::kDawnWebgpuHandle: {
    decltype(Traits::dawn_webgpu_handle(input))
    in_dawn_webgpu_handle = Traits::dawn_webgpu_handle(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_dawn_webgpu_handle)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::GpuDiskCacheDawnWebGPUHandleDataView>(
  in_dawn_webgpu_handle,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null dawn_webgpu_handle in GpuDiskCacheHandle union");
    fragment->data.f_dawn_webgpu_handle.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::gpu::mojom::GpuDiskCacheHandleDataView::Tag::kDawnGraphiteHandle: {
    decltype(Traits::dawn_graphite_handle(input))
    in_dawn_graphite_handle = Traits::dawn_graphite_handle(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_dawn_graphite_handle)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::GpuDiskCacheDawnGraphiteHandleDataView>(
  in_dawn_graphite_handle,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null dawn_graphite_handle in GpuDiskCacheHandle union");
    fragment->data.f_dawn_graphite_handle.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::gpu::mojom::internal::GpuDiskCacheHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::GpuDiskCacheHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {







inline void GpuDiskCacheHandleDataView::GetGlShaderHandleDataView(
    GpuDiskCacheGlShaderHandleDataView* output) const {
  CHECK(is_gl_shader_handle());
  *output = GpuDiskCacheGlShaderHandleDataView(data_->data.f_gl_shader_handle.Get(), message_);
}
inline void GpuDiskCacheHandleDataView::GetDawnWebgpuHandleDataView(
    GpuDiskCacheDawnWebGPUHandleDataView* output) const {
  CHECK(is_dawn_webgpu_handle());
  *output = GpuDiskCacheDawnWebGPUHandleDataView(data_->data.f_dawn_webgpu_handle.Get(), message_);
}
inline void GpuDiskCacheHandleDataView::GetDawnGraphiteHandleDataView(
    GpuDiskCacheDawnGraphiteHandleDataView* output) const {
  CHECK(is_dawn_graphite_handle());
  *output = GpuDiskCacheDawnGraphiteHandleDataView(data_->data.f_dawn_graphite_handle.Get(), message_);
}


}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::GpuDiskCacheType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::GpuDiskCacheType value);
};

} // namespace perfetto

#endif  // GPU_IPC_COMMON_GPU_DISK_CACHE_TYPE_MOJOM_SHARED_H_