// gpu/ipc/common/gpu_disk_cache_type.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_DISK_CACHE_TYPE_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_GPU_DISK_CACHE_TYPE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "gpu/ipc/common/gpu_disk_cache_type.mojom-shared-internal.h"


namespace gpu::mojom {
class GpuDiskCacheGlShaderHandleDataView;

class GpuDiskCacheDawnWebGPUHandleDataView;

class GpuDiskCacheDawnGraphiteHandleDataView;

class GpuDiskCacheHandleDataView;


}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::GpuDiskCacheGlShaderHandleDataView> {
  using Data = ::gpu::mojom::internal::GpuDiskCacheGlShaderHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::GpuDiskCacheDawnWebGPUHandleDataView> {
  using Data = ::gpu::mojom::internal::GpuDiskCacheDawnWebGPUHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::GpuDiskCacheDawnGraphiteHandleDataView> {
  using Data = ::gpu::mojom::internal::GpuDiskCacheDawnGraphiteHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::GpuDiskCacheHandleDataView> {
  using Data = ::gpu::mojom::internal::GpuDiskCacheHandle_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


enum class GpuDiskCacheType : int32_t {
  
  kGlShaders = 0,
  
  kDawnWebGPU = 1,
  
  kDawnGraphite = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, GpuDiskCacheType value);
inline bool IsKnownEnumValue(GpuDiskCacheType value) {
  return internal::GpuDiskCacheType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GpuDiskCacheGlShaderHandleDataView {
 public:
  GpuDiskCacheGlShaderHandleDataView() = default;

  GpuDiskCacheGlShaderHandleDataView(
      internal::GpuDiskCacheGlShaderHandle_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t value() const {
    return data_->value;
  }
 private:
  internal::GpuDiskCacheGlShaderHandle_Data* data_ = nullptr;
};


class GpuDiskCacheDawnWebGPUHandleDataView {
 public:
  GpuDiskCacheDawnWebGPUHandleDataView() = default;

  GpuDiskCacheDawnWebGPUHandleDataView(
      internal::GpuDiskCacheDawnWebGPUHandle_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t value() const {
    return data_->value;
  }
 private:
  internal::GpuDiskCacheDawnWebGPUHandle_Data* data_ = nullptr;
};


class GpuDiskCacheDawnGraphiteHandleDataView {
 public:
  GpuDiskCacheDawnGraphiteHandleDataView() = default;

  GpuDiskCacheDawnGraphiteHandleDataView(
      internal::GpuDiskCacheDawnGraphiteHandle_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t value() const {
    return data_->value;
  }
 private:
  internal::GpuDiskCacheDawnGraphiteHandle_Data* data_ = nullptr;
};


class GpuDiskCacheHandleDataView {
 public:
  using Tag = internal::GpuDiskCacheHandle_Data::GpuDiskCacheHandle_Tag;

  GpuDiskCacheHandleDataView() = default;

  GpuDiskCacheHandleDataView(
      internal::GpuDiskCacheHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_gl_shader_handle() const { return data_->tag == Tag::kGlShaderHandle; }
  inline void GetGlShaderHandleDataView(
      GpuDiskCacheGlShaderHandleDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGlShaderHandle(UserType* output) const {
    
    CHECK(is_gl_shader_handle());
    return mojo::internal::Deserialize<::gpu::mojom::GpuDiskCacheGlShaderHandleDataView>(
        data_->data.f_gl_shader_handle.Get(), output, message_);
  }
  bool is_dawn_webgpu_handle() const { return data_->tag == Tag::kDawnWebgpuHandle; }
  inline void GetDawnWebgpuHandleDataView(
      GpuDiskCacheDawnWebGPUHandleDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDawnWebgpuHandle(UserType* output) const {
    
    CHECK(is_dawn_webgpu_handle());
    return mojo::internal::Deserialize<::gpu::mojom::GpuDiskCacheDawnWebGPUHandleDataView>(
        data_->data.f_dawn_webgpu_handle.Get(), output, message_);
  }
  bool is_dawn_graphite_handle() const { return data_->tag == Tag::kDawnGraphiteHandle; }
  inline void GetDawnGraphiteHandleDataView(
      GpuDiskCacheDawnGraphiteHandleDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDawnGraphiteHandle(UserType* output) const {
    
    CHECK(is_dawn_graphite_handle());
    return mojo::internal::Deserialize<::gpu::mojom::GpuDiskCacheDawnGraphiteHandleDataView>(
        data_->data.f_dawn_graphite_handle.Get(), output, message_);
  }

 private:
  internal::GpuDiskCacheHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // gpu::mojom

#endif  // GPU_IPC_COMMON_GPU_DISK_CACHE_TYPE_MOJOM_DATA_VIEW_H_