// gpu/ipc/common/gpu_disk_cache_type.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_DISK_CACHE_TYPE_MOJOM_BLINK_H_
#define GPU_IPC_COMMON_GPU_DISK_CACHE_TYPE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/gpu_disk_cache_type.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_disk_cache_type.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_disk_cache_type.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gpu::mojom::blink {





class BLINK_PLATFORM_EXPORT GpuDiskCacheGlShaderHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuDiskCacheGlShaderHandle, T>::value>;
  using DataView = GpuDiskCacheGlShaderHandleDataView;
  using Data_ = internal::GpuDiskCacheGlShaderHandle_Data;

  template <typename... Args>
  static GpuDiskCacheGlShaderHandlePtr New(Args&&... args) {
    return GpuDiskCacheGlShaderHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuDiskCacheGlShaderHandlePtr From(const U& u) {
    return mojo::TypeConverter<GpuDiskCacheGlShaderHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuDiskCacheGlShaderHandle>::Convert(*this);
  }


  GpuDiskCacheGlShaderHandle();

  explicit GpuDiskCacheGlShaderHandle(
      int32_t value);


  ~GpuDiskCacheGlShaderHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuDiskCacheGlShaderHandlePtr>
  GpuDiskCacheGlShaderHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuDiskCacheGlShaderHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GpuDiskCacheGlShaderHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GpuDiskCacheGlShaderHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuDiskCacheGlShaderHandle::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuDiskCacheGlShaderHandle::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuDiskCacheGlShaderHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuDiskCacheGlShaderHandle_UnserializedMessageContext<
            UserType, GpuDiskCacheGlShaderHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GpuDiskCacheGlShaderHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GpuDiskCacheGlShaderHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuDiskCacheGlShaderHandle_UnserializedMessageContext<
            UserType, GpuDiskCacheGlShaderHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuDiskCacheGlShaderHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuDiskCacheGlShaderHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuDiskCacheGlShaderHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuDiskCacheGlShaderHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuDiskCacheGlShaderHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT GpuDiskCacheDawnWebGPUHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuDiskCacheDawnWebGPUHandle, T>::value>;
  using DataView = GpuDiskCacheDawnWebGPUHandleDataView;
  using Data_ = internal::GpuDiskCacheDawnWebGPUHandle_Data;

  template <typename... Args>
  static GpuDiskCacheDawnWebGPUHandlePtr New(Args&&... args) {
    return GpuDiskCacheDawnWebGPUHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuDiskCacheDawnWebGPUHandlePtr From(const U& u) {
    return mojo::TypeConverter<GpuDiskCacheDawnWebGPUHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuDiskCacheDawnWebGPUHandle>::Convert(*this);
  }


  GpuDiskCacheDawnWebGPUHandle();

  explicit GpuDiskCacheDawnWebGPUHandle(
      int32_t value);


  ~GpuDiskCacheDawnWebGPUHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuDiskCacheDawnWebGPUHandlePtr>
  GpuDiskCacheDawnWebGPUHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuDiskCacheDawnWebGPUHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GpuDiskCacheDawnWebGPUHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GpuDiskCacheDawnWebGPUHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuDiskCacheDawnWebGPUHandle::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuDiskCacheDawnWebGPUHandle::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuDiskCacheDawnWebGPUHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuDiskCacheDawnWebGPUHandle_UnserializedMessageContext<
            UserType, GpuDiskCacheDawnWebGPUHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GpuDiskCacheDawnWebGPUHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GpuDiskCacheDawnWebGPUHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuDiskCacheDawnWebGPUHandle_UnserializedMessageContext<
            UserType, GpuDiskCacheDawnWebGPUHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuDiskCacheDawnWebGPUHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuDiskCacheDawnWebGPUHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuDiskCacheDawnWebGPUHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuDiskCacheDawnWebGPUHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuDiskCacheDawnWebGPUHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT GpuDiskCacheDawnGraphiteHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuDiskCacheDawnGraphiteHandle, T>::value>;
  using DataView = GpuDiskCacheDawnGraphiteHandleDataView;
  using Data_ = internal::GpuDiskCacheDawnGraphiteHandle_Data;

  template <typename... Args>
  static GpuDiskCacheDawnGraphiteHandlePtr New(Args&&... args) {
    return GpuDiskCacheDawnGraphiteHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuDiskCacheDawnGraphiteHandlePtr From(const U& u) {
    return mojo::TypeConverter<GpuDiskCacheDawnGraphiteHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuDiskCacheDawnGraphiteHandle>::Convert(*this);
  }


  GpuDiskCacheDawnGraphiteHandle();

  explicit GpuDiskCacheDawnGraphiteHandle(
      int32_t value);


  ~GpuDiskCacheDawnGraphiteHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuDiskCacheDawnGraphiteHandlePtr>
  GpuDiskCacheDawnGraphiteHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuDiskCacheDawnGraphiteHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GpuDiskCacheDawnGraphiteHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GpuDiskCacheDawnGraphiteHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuDiskCacheDawnGraphiteHandle::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuDiskCacheDawnGraphiteHandle::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuDiskCacheDawnGraphiteHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuDiskCacheDawnGraphiteHandle_UnserializedMessageContext<
            UserType, GpuDiskCacheDawnGraphiteHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GpuDiskCacheDawnGraphiteHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GpuDiskCacheDawnGraphiteHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuDiskCacheDawnGraphiteHandle_UnserializedMessageContext<
            UserType, GpuDiskCacheDawnGraphiteHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuDiskCacheDawnGraphiteHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuDiskCacheDawnGraphiteHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuDiskCacheDawnGraphiteHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuDiskCacheDawnGraphiteHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuDiskCacheDawnGraphiteHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT GpuDiskCacheHandle {
 public:
  using DataView = GpuDiskCacheHandleDataView;
  using Data_ = internal::GpuDiskCacheHandle_Data;
  using Tag = Data_::GpuDiskCacheHandle_Tag;

  template <typename... Args>
  static GpuDiskCacheHandlePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |gl_shader_handle|.
  static GpuDiskCacheHandlePtr NewGlShaderHandle(
      GpuDiskCacheGlShaderHandlePtr value);
  // Construct an instance holding |dawn_webgpu_handle|.
  static GpuDiskCacheHandlePtr NewDawnWebgpuHandle(
      GpuDiskCacheDawnWebGPUHandlePtr value);
  // Construct an instance holding |dawn_graphite_handle|.
  static GpuDiskCacheHandlePtr NewDawnGraphiteHandle(
      GpuDiskCacheDawnGraphiteHandlePtr value);

  template <typename U>
  static GpuDiskCacheHandlePtr From(const U& u) {
    return mojo::TypeConverter<GpuDiskCacheHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuDiskCacheHandle>::Convert(*this);
  }
  ~GpuDiskCacheHandle();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GpuDiskCacheHandle(const GpuDiskCacheHandle& other) = delete;
  GpuDiskCacheHandle& operator=(const GpuDiskCacheHandle& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GpuDiskCacheHandlePtr>
  GpuDiskCacheHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GpuDiskCacheHandle>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GpuDiskCacheHandle>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_gl_shader_handle() const { return tag_ == Tag::kGlShaderHandle; }
  const GpuDiskCacheGlShaderHandlePtr& get_gl_shader_handle() const {
    CHECK(tag_ == Tag::kGlShaderHandle);
    return data_.gl_shader_handle;
  }
  GpuDiskCacheGlShaderHandlePtr& get_gl_shader_handle() {
    CHECK(tag_ == Tag::kGlShaderHandle);
    return data_.gl_shader_handle;
  }
  void set_gl_shader_handle(GpuDiskCacheGlShaderHandlePtr gl_shader_handle);

  bool is_dawn_webgpu_handle() const { return tag_ == Tag::kDawnWebgpuHandle; }
  const GpuDiskCacheDawnWebGPUHandlePtr& get_dawn_webgpu_handle() const {
    CHECK(tag_ == Tag::kDawnWebgpuHandle);
    return data_.dawn_webgpu_handle;
  }
  GpuDiskCacheDawnWebGPUHandlePtr& get_dawn_webgpu_handle() {
    CHECK(tag_ == Tag::kDawnWebgpuHandle);
    return data_.dawn_webgpu_handle;
  }
  void set_dawn_webgpu_handle(GpuDiskCacheDawnWebGPUHandlePtr dawn_webgpu_handle);

  bool is_dawn_graphite_handle() const { return tag_ == Tag::kDawnGraphiteHandle; }
  const GpuDiskCacheDawnGraphiteHandlePtr& get_dawn_graphite_handle() const {
    CHECK(tag_ == Tag::kDawnGraphiteHandle);
    return data_.dawn_graphite_handle;
  }
  GpuDiskCacheDawnGraphiteHandlePtr& get_dawn_graphite_handle() {
    CHECK(tag_ == Tag::kDawnGraphiteHandle);
    return data_.dawn_graphite_handle;
  }
  void set_dawn_graphite_handle(GpuDiskCacheDawnGraphiteHandlePtr dawn_graphite_handle);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuDiskCacheHandle::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GpuDiskCacheHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kGlShaderHandle)>,
        GpuDiskCacheGlShaderHandlePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDawnWebgpuHandle)>,
        GpuDiskCacheDawnWebGPUHandlePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDawnGraphiteHandle)>,
        GpuDiskCacheDawnGraphiteHandlePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    GpuDiskCacheGlShaderHandlePtr gl_shader_handle;
    GpuDiskCacheDawnWebGPUHandlePtr dawn_webgpu_handle;
    GpuDiskCacheDawnGraphiteHandlePtr dawn_graphite_handle;
  };

  GpuDiskCacheHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kGlShaderHandle)>,
      GpuDiskCacheGlShaderHandlePtr value);
  GpuDiskCacheHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kDawnWebgpuHandle)>,
      GpuDiskCacheDawnWebGPUHandlePtr value);
  GpuDiskCacheHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kDawnGraphiteHandle)>,
      GpuDiskCacheDawnGraphiteHandlePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};




template <typename UnionPtrType>
GpuDiskCacheHandlePtr GpuDiskCacheHandle::Clone() const {
  switch (tag_) {
    case Tag::kGlShaderHandle:
      return NewGlShaderHandle(
          mojo::Clone(data_.gl_shader_handle));
    case Tag::kDawnWebgpuHandle:
      return NewDawnWebgpuHandle(
          mojo::Clone(data_.dawn_webgpu_handle));
    case Tag::kDawnGraphiteHandle:
      return NewDawnGraphiteHandle(
          mojo::Clone(data_.dawn_graphite_handle));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GpuDiskCacheHandle>::value>::type*>
bool GpuDiskCacheHandle::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kGlShaderHandle:
      return mojo::Equals(data_.gl_shader_handle, other.data_.gl_shader_handle);
    case Tag::kDawnWebgpuHandle:
      return mojo::Equals(data_.dawn_webgpu_handle, other.data_.dawn_webgpu_handle);
    case Tag::kDawnGraphiteHandle:
      return mojo::Equals(data_.dawn_graphite_handle, other.data_.dawn_graphite_handle);
  }

  return false;
}
template <typename StructPtrType>
GpuDiskCacheGlShaderHandlePtr GpuDiskCacheGlShaderHandle::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, GpuDiskCacheGlShaderHandle::EnableIfSame<T>*>
bool GpuDiskCacheGlShaderHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, GpuDiskCacheGlShaderHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
GpuDiskCacheDawnWebGPUHandlePtr GpuDiskCacheDawnWebGPUHandle::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, GpuDiskCacheDawnWebGPUHandle::EnableIfSame<T>*>
bool GpuDiskCacheDawnWebGPUHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, GpuDiskCacheDawnWebGPUHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
GpuDiskCacheDawnGraphiteHandlePtr GpuDiskCacheDawnGraphiteHandle::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, GpuDiskCacheDawnGraphiteHandle::EnableIfSame<T>*>
bool GpuDiskCacheDawnGraphiteHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, GpuDiskCacheDawnGraphiteHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // gpu::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::gpu::mojom::blink::GpuDiskCacheGlShaderHandle::DataView,
                                         ::gpu::mojom::blink::GpuDiskCacheGlShaderHandlePtr> {
  static bool IsNull(const ::gpu::mojom::blink::GpuDiskCacheGlShaderHandlePtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::blink::GpuDiskCacheGlShaderHandlePtr* output) { output->reset(); }

  static decltype(::gpu::mojom::blink::GpuDiskCacheGlShaderHandle::value) value(
      const ::gpu::mojom::blink::GpuDiskCacheGlShaderHandlePtr& input) {
    return input->value;
  }

  static bool Read(::gpu::mojom::blink::GpuDiskCacheGlShaderHandle::DataView input, ::gpu::mojom::blink::GpuDiskCacheGlShaderHandlePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandle::DataView,
                                         ::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandlePtr> {
  static bool IsNull(const ::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandlePtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandlePtr* output) { output->reset(); }

  static decltype(::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandle::value) value(
      const ::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandlePtr& input) {
    return input->value;
  }

  static bool Read(::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandle::DataView input, ::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandlePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandle::DataView,
                                         ::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandlePtr> {
  static bool IsNull(const ::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandlePtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandlePtr* output) { output->reset(); }

  static decltype(::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandle::value) value(
      const ::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandlePtr& input) {
    return input->value;
  }

  static bool Read(::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandle::DataView input, ::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandlePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::gpu::mojom::blink::GpuDiskCacheHandle::DataView,
                                        ::gpu::mojom::blink::GpuDiskCacheHandlePtr> {
  static bool IsNull(const ::gpu::mojom::blink::GpuDiskCacheHandlePtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::blink::GpuDiskCacheHandlePtr* output) { output->reset(); }

  static ::gpu::mojom::blink::GpuDiskCacheHandle::Tag GetTag(const ::gpu::mojom::blink::GpuDiskCacheHandlePtr& input) {
    return input->which();
  }

  static const ::gpu::mojom::blink::GpuDiskCacheGlShaderHandlePtr& gl_shader_handle(const ::gpu::mojom::blink::GpuDiskCacheHandlePtr& input) {
    return input->get_gl_shader_handle();
  }

  static const ::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandlePtr& dawn_webgpu_handle(const ::gpu::mojom::blink::GpuDiskCacheHandlePtr& input) {
    return input->get_dawn_webgpu_handle();
  }

  static const ::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandlePtr& dawn_graphite_handle(const ::gpu::mojom::blink::GpuDiskCacheHandlePtr& input) {
    return input->get_dawn_graphite_handle();
  }

  static bool Read(::gpu::mojom::blink::GpuDiskCacheHandle::DataView input, ::gpu::mojom::blink::GpuDiskCacheHandlePtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_GPU_DISK_CACHE_TYPE_MOJOM_BLINK_H_