// gpu/ipc/common/gpu_channel.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_TEST_UTILS_H_
#define GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_TEST_UTILS_H_

#include "gpu/ipc/common/gpu_channel.mojom.h"
#include "gpu/gpu_export.h"


namespace gpu::mojom {


class GPU_EXPORT GpuChannelInterceptorForTesting : public GpuChannel {
  virtual GpuChannel* GetForwardingInterface() = 0;
  void CrashForTesting() override;
  void TerminateForTesting() override;
  void GetChannelToken(GetChannelTokenCallback callback) override;
  void Flush(FlushCallback callback) override;
  void GetSharedMemoryForFlushId(GetSharedMemoryForFlushIdCallback callback) override;
  void CreateCommandBuffer(CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, CreateCommandBufferCallback callback) override;
  void DestroyCommandBuffer(int32_t routing_id, DestroyCommandBufferCallback callback) override;
  void FlushDeferredRequests(std::vector<DeferredRequestPtr> requests, uint32_t flushed_deferred_message_id) override;
  void CreateGpuMemoryBuffer(const ::gfx::Size& size, const ::viz::SharedImageFormat& format, ::gfx::BufferUsage buffer_usage, CreateGpuMemoryBufferCallback callback) override;
  void WaitForTokenInRange(int32_t routing_id, int32_t start, int32_t end, WaitForTokenInRangeCallback callback) override;
  void WaitForGetOffsetInRange(int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, WaitForGetOffsetInRangeCallback callback) override;
};
class GPU_EXPORT GpuChannelAsyncWaiter {
 public:
  explicit GpuChannelAsyncWaiter(GpuChannel* proxy);

  GpuChannelAsyncWaiter(const GpuChannelAsyncWaiter&) = delete;
  GpuChannelAsyncWaiter& operator=(const GpuChannelAsyncWaiter&) = delete;

  ~GpuChannelAsyncWaiter();
  void GetChannelToken(
      ::base::UnguessableToken* out_token);
  ::base::UnguessableToken GetChannelToken();
  void Flush(
      );
  
  void GetSharedMemoryForFlushId(
      ::base::ReadOnlySharedMemoryRegion* out_version_buffer);
  ::base::ReadOnlySharedMemoryRegion GetSharedMemoryForFlushId();
  void CreateCommandBuffer(
      CreateCommandBufferParamsPtr params, int32_t routing_id, ::base::UnsafeSharedMemoryRegion shared_state, ::mojo::PendingAssociatedReceiver<CommandBuffer> receiver, ::mojo::PendingAssociatedRemote<CommandBufferClient> client, ::gpu::ContextResult* out_result, ::gpu::Capabilities* out_capabilties, ::gpu::GLCapabilities* out_gl_capabilities);
  
  void DestroyCommandBuffer(
      int32_t routing_id);
  
  void CreateGpuMemoryBuffer(
      const ::gfx::Size& size, const ::viz::SharedImageFormat& format, ::gfx::BufferUsage buffer_usage, ::gfx::GpuMemoryBufferHandle* out_buffer_handle);
  ::gfx::GpuMemoryBufferHandle CreateGpuMemoryBuffer(const ::gfx::Size& size, const ::viz::SharedImageFormat& format, ::gfx::BufferUsage buffer_usage);
  void WaitForTokenInRange(
      int32_t routing_id, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state);
  ::gpu::CommandBuffer::State WaitForTokenInRange(int32_t routing_id, int32_t start, int32_t end);
  void WaitForGetOffsetInRange(
      int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end, ::gpu::CommandBuffer::State* out_state);
  ::gpu::CommandBuffer::State WaitForGetOffsetInRange(int32_t routing_id, uint32_t set_get_buffer_count, int32_t start, int32_t end);

 private:
  GpuChannel* const proxy_;
};


class GPU_EXPORT CommandBufferInterceptorForTesting : public CommandBuffer {
  virtual CommandBuffer* GetForwardingInterface() = 0;
  void SetGetBuffer(int32_t shm_id) override;
  void RegisterTransferBuffer(int32_t id, ::base::UnsafeSharedMemoryRegion buffer) override;
  void CreateGpuFenceFromHandle(uint32_t gpu_fence_id, ::gfx::GpuFenceHandle fence_handle) override;
  void GetGpuFenceHandle(uint32_t id, GetGpuFenceHandleCallback callback) override;
  void SignalSyncToken(const ::gpu::SyncToken& sync_token, uint32_t signal_id) override;
  void SignalQuery(uint32_t query, uint32_t signal_id) override;
};
class GPU_EXPORT CommandBufferAsyncWaiter {
 public:
  explicit CommandBufferAsyncWaiter(CommandBuffer* proxy);

  CommandBufferAsyncWaiter(const CommandBufferAsyncWaiter&) = delete;
  CommandBufferAsyncWaiter& operator=(const CommandBufferAsyncWaiter&) = delete;

  ~CommandBufferAsyncWaiter();
  void GetGpuFenceHandle(
      uint32_t id, ::gfx::GpuFenceHandle* out_fence_handle);
  ::gfx::GpuFenceHandle GetGpuFenceHandle(uint32_t id);

 private:
  CommandBuffer* const proxy_;
};


class GPU_EXPORT CommandBufferClientInterceptorForTesting : public CommandBufferClient {
  virtual CommandBufferClient* GetForwardingInterface() = 0;
  void OnConsoleMessage(const std::string& message) override;
  void OnGpuSwitched() override;
  void OnDestroyed(::gpu::error::ContextLostReason reason, ::gpu::error::Error error) override;
  void OnReturnData(const std::vector<uint8_t>& data) override;
  void OnSignalAck(uint32_t signal_id, const ::gpu::CommandBuffer::State& state) override;
};
class GPU_EXPORT CommandBufferClientAsyncWaiter {
 public:
  explicit CommandBufferClientAsyncWaiter(CommandBufferClient* proxy);

  CommandBufferClientAsyncWaiter(const CommandBufferClientAsyncWaiter&) = delete;
  CommandBufferClientAsyncWaiter& operator=(const CommandBufferClientAsyncWaiter&) = delete;

  ~CommandBufferClientAsyncWaiter();

 private:
  CommandBufferClient* const proxy_;
};




}  // gpu::mojom

#endif  // GPU_IPC_COMMON_GPU_CHANNEL_MOJOM_TEST_UTILS_H_