// gpu/ipc/common/exported_shared_image.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "gpu/ipc/common/exported_shared_image.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"


namespace gpu::mojom {
class ExportedSharedImageDataView;



}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::ExportedSharedImageDataView> {
  using Data = ::gpu::mojom::internal::ExportedSharedImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


class ExportedSharedImageDataView {
 public:
  ExportedSharedImageDataView() = default;

  ExportedSharedImageDataView(
      internal::ExportedSharedImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      ::gpu::mojom::SharedImageMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetCreationSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreationSyncToken(UserType* output) {
    
    auto* pointer = data_->creation_sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  inline void GetDebugLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugLabel(UserType* output) {
    
    auto* pointer = data_->debug_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBufferHandleDataView(
      ::gfx::mojom::GpuMemoryBufferHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBufferHandle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::GpuMemoryBufferHandleDataView, UserType>(),
    "Attempting to read the optional `buffer_handle` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBufferHandle` instead "
    "of `ReadBufferHandle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->buffer_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBufferUsage(UserType* output) const {
    if (!data_->buffer_usage_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::gfx::mojom::BufferUsage>(
        data_->buffer_usage_$value, &output->emplace());
  }
  std::optional<::gfx::mojom::BufferUsage> buffer_usage() const {
    if (!data_->buffer_usage_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::BufferUsage>(data_->buffer_usage_$value));
  }
  uint32_t texture_target() const {
    return data_->texture_target;
  }
  bool is_software() const {
    return data_->is_software;
  }
 private:
  internal::ExportedSharedImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

#endif  // GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_DATA_VIEW_H_