// extensions/common/mojom/url_pattern_set.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_SHARED_H_
#define EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/url_pattern_set.mojom-shared-internal.h"




#include "extensions/common/mojom/url_pattern_set.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::URLPatternDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::URLPatternDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::URLPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->valid_schemes = Traits::valid_schemes(input);

    decltype(Traits::pattern(input)) in_pattern = Traits::pattern(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pattern)::BaseType> pattern_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_pattern,
      pattern_fragment);

    fragment->pattern.Set(
        pattern_fragment.is_null() ? nullptr : pattern_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pattern.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pattern in URLPattern struct");
  }

  static bool Deserialize(::extensions::mojom::internal::URLPattern_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::URLPatternDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::URLPatternSetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::URLPatternSetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::URLPatternSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::patterns(input)) in_patterns = Traits::patterns(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->patterns)::BaseType>
        patterns_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& patterns_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::URLPatternDataView>>(
      in_patterns,
      patterns_fragment,
      &patterns_validate_params);

    fragment->patterns.Set(
        patterns_fragment.is_null() ? nullptr : patterns_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->patterns.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null patterns in URLPatternSet struct");
  }

  static bool Deserialize(::extensions::mojom::internal::URLPatternSet_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::URLPatternSetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace extensions::mojom {

inline void URLPatternDataView::GetPatternDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->pattern.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void URLPatternSetDataView::GetPatternsDataView(
    mojo::ArrayDataView<URLPatternDataView>* output) {
  auto pointer = data_->patterns.Get();
  *output = mojo::ArrayDataView<URLPatternDataView>(pointer, message_);
}



}  // extensions::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_SHARED_H_