// extensions/common/mojom/url_pattern_set.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_SEND_VALIDATION_H_
#define EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_SEND_VALIDATION_H_

#include "extensions/common/mojom/url_pattern_set.mojom-shared-internal.h"

#include "extensions/common/mojom/url_pattern_set.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::URLPatternDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::URLPatternDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::URLPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->valid_schemes = Traits::valid_schemes(input);

      decltype(Traits::pattern(input)) in_pattern = Traits::pattern(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pattern)::BaseType> pattern_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_pattern,
        pattern_fragment);

      fragment->pattern.Set(
          pattern_fragment.is_null() ? nullptr : pattern_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pattern.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pattern in URLPattern struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::URLPatternSetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::URLPatternSetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::URLPatternSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::patterns(input)) in_patterns = Traits::patterns(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->patterns)::BaseType>
          patterns_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& patterns_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::URLPatternDataView>, send_validation>(
        in_patterns,
        patterns_fragment,
        &patterns_validate_params);

      fragment->patterns.Set(
          patterns_fragment.is_null() ? nullptr : patterns_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->patterns.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null patterns in URLPatternSet struct");
  }
};

}  // namespace mojo::internal

#endif  // EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_SEND_VALIDATION_H_