// extensions/common/mojom/stack_frame.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'extensions/common/mojom/stack_frame.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('extensions.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../mojo/public/mojom/base/string16.mojom.js');
  }



  function StackFrame(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StackFrame.prototype.initDefaults_ = function() {
    this.lineNumber = 0;
    this.columnNumber = 0;
    this.source = null;
    this.function = null;
  };
  StackFrame.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StackFrame.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate StackFrame.source
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StackFrame.function
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StackFrame.encodedSize = codec.kStructHeaderSize + 24;

  StackFrame.decode = function(decoder) {
    var packed;
    var val = new StackFrame();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lineNumber =
        decoder.decodeStruct(codec.Uint32);
    val.columnNumber =
        decoder.decodeStruct(codec.Uint32);
    val.source =
        decoder.decodeStructPointer(string16$.String16);
    val.function =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  StackFrame.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StackFrame.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.lineNumber);
    encoder.encodeStruct(codec.Uint32, val.columnNumber);
    encoder.encodeStructPointer(string16$.String16, val.source);
    encoder.encodeStructPointer(string16$.String16, val.function);
  };
  exports.StackFrame = StackFrame;
})();