// extensions/common/mojom/stack_frame.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_STACK_FRAME_MOJOM_SEND_VALIDATION_H_
#define EXTENSIONS_COMMON_MOJOM_STACK_FRAME_MOJOM_SEND_VALIDATION_H_

#include "extensions/common/mojom/stack_frame.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"

#include "extensions/common/mojom/stack_frame.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::StackFrameDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::StackFrameDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::StackFrame_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->line_number = Traits::line_number(input);

      fragment->column_number = Traits::column_number(input);

      decltype(Traits::source(input)) in_source = Traits::source(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source)::BaseType> source_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_source,
        source_fragment);

      fragment->source.Set(
          source_fragment.is_null() ? nullptr : source_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source in StackFrame struct");

      decltype(Traits::function(input)) in_function = Traits::function(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->function)::BaseType> function_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_function,
        function_fragment);

      fragment->function.Set(
          function_fragment.is_null() ? nullptr : function_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->function.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null function in StackFrame struct");
  }
};

}  // namespace mojo::internal

#endif  // EXTENSIONS_COMMON_MOJOM_STACK_FRAME_MOJOM_SEND_VALIDATION_H_