// extensions/common/mojom/service_worker_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Uuid as mojoBase_mojom_Uuid,
  UuidSpec as mojoBase_mojom_UuidSpec
} from '../../../mojo/public/mojom/base/uuid.mojom.m.js';

import {
  ListValue as mojoBase_mojom_ListValue,
  ListValueSpec as mojoBase_mojom_ListValueSpec
} from '../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  ServiceWorkerToken as blink_mojom_ServiceWorkerToken,
  ServiceWorkerTokenSpec as blink_mojom_ServiceWorkerTokenSpec
} from '../../../third_party/blink/public/mojom/tokens/tokens.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../url/mojom/url.mojom.m.js';

import {
  EventDispatcherRemote as extensions_mojom_EventDispatcherRemote,
  EventDispatcherPendingReceiver as extensions_mojom_EventDispatcherPendingReceiver
} from './event_dispatcher.mojom.m.js';

import {
  ExtensionId as extensions_mojom_ExtensionId,
  ExtensionIdSpec as extensions_mojom_ExtensionIdSpec
} from './extension_id.mojom.m.js';

import {
  ExtraResponseData as extensions_mojom_ExtraResponseData,
  ExtraResponseDataSpec as extensions_mojom_ExtraResponseDataSpec
} from './extra_response_data.mojom.m.js';

import {
  RequestParams as extensions_mojom_RequestParams,
  RequestParamsSpec as extensions_mojom_RequestParamsSpec
} from './frame.mojom.m.js';

import {
  ChannelType as extensions_mojom_ChannelType,
  ChannelTypeSpec as extensions_mojom_ChannelTypeSpec,
  MessagePortRemote as extensions_mojom_MessagePortRemote,
  MessagePortPendingReceiver as extensions_mojom_MessagePortPendingReceiver,
  MessagePortHostRemote as extensions_mojom_MessagePortHostRemote,
  MessagePortHostPendingReceiver as extensions_mojom_MessagePortHostPendingReceiver,
  ExternalConnectionInfo as extensions_mojom_ExternalConnectionInfo,
  ExternalConnectionInfoSpec as extensions_mojom_ExternalConnectionInfoSpec,
  PortId as extensions_mojom_PortId,
  PortIdSpec as extensions_mojom_PortIdSpec
} from './message_port.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.ServiceWorkerHost', scope);
  }
}

/** @interface */
export class ServiceWorkerHostInterface {
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   * @param { !blink_mojom_ServiceWorkerToken } serviceWorkerToken
   * @param { !Object } eventDispatcher
   */

  didInitializeServiceWorkerContext(extensionId, serviceWorkerVersionId, workerThreadId, serviceWorkerToken, eventDispatcher) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !mojoBase_mojom_UnguessableToken } activationToken
   * @param { !url_mojom_Url } serviceWorkerScope
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   */

  didStartServiceWorkerContext(extensionId, activationToken, serviceWorkerScope, serviceWorkerVersionId, workerThreadId) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !mojoBase_mojom_UnguessableToken } activationToken
   * @param { !url_mojom_Url } serviceWorkerScope
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   */

  didStopServiceWorkerContext(extensionId, activationToken, serviceWorkerScope, serviceWorkerVersionId, workerThreadId) {}
  
  /**
   * @param { !extensions_mojom_RequestParams } params
   * @return {!Promise<{
        success: !boolean,
        responseWrapper: !mojoBase_mojom_ListValue,
        error: !string,
        extraData: ?extensions_mojom_ExtraResponseData,
   *  }>}
   */

  requestWorker(params) {}
  
  /**
   * @param { !mojoBase_mojom_Uuid } requestUuid
   */

  workerResponseAck(requestUuid) {}
  
  /**
   * @param { !extensions_mojom_ExternalConnectionInfo } info
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToExtension(info, channelType, channelName, portId, port, portHost) {}
  
  /**
   * @param { !string } nativeAppName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToNativeApp(nativeAppName, portId, port, portHost) {}
  
  /**
   * @param { !number } tabId
   * @param { !number } frameId
   * @param { ?string } documentId
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToTab(tabId, frameId, documentId, channelType, channelName, portId, port, portHost) {}
}

/**
 * @implements { ServiceWorkerHostInterface }
 */
export class ServiceWorkerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   * @param { !blink_mojom_ServiceWorkerToken } serviceWorkerToken
   * @param { !Object } eventDispatcher
   */

  didInitializeServiceWorkerContext(
      extensionId,
      serviceWorkerVersionId,
      workerThreadId,
      serviceWorkerToken,
      eventDispatcher) {
    this.proxy.sendMessage(
        0,
        ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsSpec.$,
        null,
        [
          extensionId,
          serviceWorkerVersionId,
          workerThreadId,
          serviceWorkerToken,
          eventDispatcher
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !mojoBase_mojom_UnguessableToken } activationToken
   * @param { !url_mojom_Url } serviceWorkerScope
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   */

  didStartServiceWorkerContext(
      extensionId,
      activationToken,
      serviceWorkerScope,
      serviceWorkerVersionId,
      workerThreadId) {
    this.proxy.sendMessage(
        1,
        ServiceWorkerHost_DidStartServiceWorkerContext_ParamsSpec.$,
        null,
        [
          extensionId,
          activationToken,
          serviceWorkerScope,
          serviceWorkerVersionId,
          workerThreadId
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !mojoBase_mojom_UnguessableToken } activationToken
   * @param { !url_mojom_Url } serviceWorkerScope
   * @param { !bigint } serviceWorkerVersionId
   * @param { !number } workerThreadId
   */

  didStopServiceWorkerContext(
      extensionId,
      activationToken,
      serviceWorkerScope,
      serviceWorkerVersionId,
      workerThreadId) {
    this.proxy.sendMessage(
        2,
        ServiceWorkerHost_DidStopServiceWorkerContext_ParamsSpec.$,
        null,
        [
          extensionId,
          activationToken,
          serviceWorkerScope,
          serviceWorkerVersionId,
          workerThreadId
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_RequestParams } params
   * @return {!Promise<{
        success: !boolean,
        responseWrapper: !mojoBase_mojom_ListValue,
        error: !string,
        extraData: ?extensions_mojom_ExtraResponseData,
   *  }>}
   */

  requestWorker(
      params) {
    return this.proxy.sendMessage(
        3,
        ServiceWorkerHost_RequestWorker_ParamsSpec.$,
        ServiceWorkerHost_RequestWorker_ResponseParamsSpec.$,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_Uuid } requestUuid
   */

  workerResponseAck(
      requestUuid) {
    this.proxy.sendMessage(
        4,
        ServiceWorkerHost_WorkerResponseAck_ParamsSpec.$,
        null,
        [
          requestUuid
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExternalConnectionInfo } info
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToExtension(
      info,
      channelType,
      channelName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        5,
        ServiceWorkerHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        [
          info,
          channelType,
          channelName,
          portId,
          port,
          portHost
        ],
        false);
  }

  
  /**
   * @param { !string } nativeAppName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToNativeApp(
      nativeAppName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        6,
        ServiceWorkerHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        [
          nativeAppName,
          portId,
          port,
          portHost
        ],
        false);
  }

  
  /**
   * @param { !number } tabId
   * @param { !number } frameId
   * @param { ?string } documentId
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_PortId } portId
   * @param { !Object } port
   * @param { !Object } portHost
   */

  openChannelToTab(
      tabId,
      frameId,
      documentId,
      channelType,
      channelName,
      portId,
      port,
      portHost) {
    this.proxy.sendMessage(
        7,
        ServiceWorkerHost_OpenChannelToTab_ParamsSpec.$,
        null,
        [
          tabId,
          frameId,
          documentId,
          channelType,
          channelName,
          portId,
          port,
          portHost
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerHostReceiver {
  /**
   * @param {!ServiceWorkerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsSpec.$,
        null,
        impl.didInitializeServiceWorkerContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerHost_DidStartServiceWorkerContext_ParamsSpec.$,
        null,
        impl.didStartServiceWorkerContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerHost_DidStopServiceWorkerContext_ParamsSpec.$,
        null,
        impl.didStopServiceWorkerContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ServiceWorkerHost_RequestWorker_ParamsSpec.$,
        ServiceWorkerHost_RequestWorker_ResponseParamsSpec.$,
        impl.requestWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ServiceWorkerHost_WorkerResponseAck_ParamsSpec.$,
        null,
        impl.workerResponseAck.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ServiceWorkerHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        impl.openChannelToExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ServiceWorkerHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        impl.openChannelToNativeApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ServiceWorkerHost_OpenChannelToTab_ParamsSpec.$,
        null,
        impl.openChannelToTab.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.ServiceWorkerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerHostRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didInitializeServiceWorkerContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsSpec.$,
        null,
        this.didInitializeServiceWorkerContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStartServiceWorkerContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerHost_DidStartServiceWorkerContext_ParamsSpec.$,
        null,
        this.didStartServiceWorkerContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStopServiceWorkerContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerHost_DidStopServiceWorkerContext_ParamsSpec.$,
        null,
        this.didStopServiceWorkerContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ServiceWorkerHost_RequestWorker_ParamsSpec.$,
        ServiceWorkerHost_RequestWorker_ResponseParamsSpec.$,
        this.requestWorker.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.workerResponseAck =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ServiceWorkerHost_WorkerResponseAck_ParamsSpec.$,
        null,
        this.workerResponseAck.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ServiceWorkerHost_OpenChannelToExtension_ParamsSpec.$,
        null,
        this.openChannelToExtension.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToNativeApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ServiceWorkerHost_OpenChannelToNativeApp_ParamsSpec.$,
        null,
        this.openChannelToNativeApp.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openChannelToTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ServiceWorkerHost_OpenChannelToTab_ParamsSpec.$,
        null,
        this.openChannelToTab.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_DidStartServiceWorkerContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_DidStopServiceWorkerContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_RequestWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_RequestWorker_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_WorkerResponseAck_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_OpenChannelToExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_OpenChannelToNativeApp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_OpenChannelToTab_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsSpec.$,
    'ServiceWorkerHost_DidInitializeServiceWorkerContext_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerVersionId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'workerThreadId', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerToken', 24,
        0,
        blink_mojom_ServiceWorkerTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventDispatcher', 32,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions_mojom_EventDispatcherRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ServiceWorkerHost_DidInitializeServiceWorkerContext_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !bigint } */
    this.serviceWorkerVersionId;
    /** @type { !number } */
    this.workerThreadId;
    /** @type { !blink_mojom_ServiceWorkerToken } */
    this.serviceWorkerToken;
    /** @type { !Object } */
    this.eventDispatcher;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_DidStartServiceWorkerContext_ParamsSpec.$,
    'ServiceWorkerHost_DidStartServiceWorkerContext_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'activationToken', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerScope', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerVersionId', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'workerThreadId', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ServiceWorkerHost_DidStartServiceWorkerContext_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.activationToken;
    /** @type { !url_mojom_Url } */
    this.serviceWorkerScope;
    /** @type { !bigint } */
    this.serviceWorkerVersionId;
    /** @type { !number } */
    this.workerThreadId;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_DidStopServiceWorkerContext_ParamsSpec.$,
    'ServiceWorkerHost_DidStopServiceWorkerContext_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'activationToken', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerScope', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerVersionId', 24,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'workerThreadId', 32,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ServiceWorkerHost_DidStopServiceWorkerContext_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.activationToken;
    /** @type { !url_mojom_Url } */
    this.serviceWorkerScope;
    /** @type { !bigint } */
    this.serviceWorkerVersionId;
    /** @type { !number } */
    this.workerThreadId;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_RequestWorker_ParamsSpec.$,
    'ServiceWorkerHost_RequestWorker_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        extensions_mojom_RequestParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_RequestWorker_Params {
  constructor() {
    /** @type { !extensions_mojom_RequestParams } */
    this.params;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_RequestWorker_ResponseParamsSpec.$,
    'ServiceWorkerHost_RequestWorker_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseWrapper', 8,
        0,
        mojoBase_mojom_ListValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extraData', 24,
        0,
        extensions_mojom_ExtraResponseDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ServiceWorkerHost_RequestWorker_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !mojoBase_mojom_ListValue } */
    this.responseWrapper;
    /** @type { !string } */
    this.error;
    /** @type { (extensions_mojom_ExtraResponseData|undefined) } */
    this.extraData;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_WorkerResponseAck_ParamsSpec.$,
    'ServiceWorkerHost_WorkerResponseAck_Params',
    [
      mojo.internal.StructField(
        'requestUuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_WorkerResponseAck_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Uuid } */
    this.requestUuid;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_OpenChannelToExtension_ParamsSpec.$,
    'ServiceWorkerHost_OpenChannelToExtension_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        extensions_mojom_ExternalConnectionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelType', 8,
        0,
        extensions_mojom_ChannelTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portId', 24,
        0,
        extensions_mojom_PortIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'port', 32,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions_mojom_MessagePortRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portHost', 12,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions_mojom_MessagePortHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ServiceWorkerHost_OpenChannelToExtension_Params {
  constructor() {
    /** @type { !extensions_mojom_ExternalConnectionInfo } */
    this.info;
    /** @type { !extensions_mojom_ChannelType } */
    this.channelType;
    /** @type { !string } */
    this.channelName;
    /** @type { !extensions_mojom_PortId } */
    this.portId;
    /** @type { !Object } */
    this.port;
    /** @type { !Object } */
    this.portHost;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_OpenChannelToNativeApp_ParamsSpec.$,
    'ServiceWorkerHost_OpenChannelToNativeApp_Params',
    [
      mojo.internal.StructField(
        'nativeAppName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portId', 8,
        0,
        extensions_mojom_PortIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'port', 16,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions_mojom_MessagePortRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portHost', 24,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions_mojom_MessagePortHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ServiceWorkerHost_OpenChannelToNativeApp_Params {
  constructor() {
    /** @type { !string } */
    this.nativeAppName;
    /** @type { !extensions_mojom_PortId } */
    this.portId;
    /** @type { !Object } */
    this.port;
    /** @type { !Object } */
    this.portHost;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_OpenChannelToTab_ParamsSpec.$,
    'ServiceWorkerHost_OpenChannelToTab_Params',
    [
      mojo.internal.StructField(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'documentId', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelType', 16,
        0,
        extensions_mojom_ChannelTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelName', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portId', 32,
        0,
        extensions_mojom_PortIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'port', 40,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions_mojom_MessagePortRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portHost', 20,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions_mojom_MessagePortHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ServiceWorkerHost_OpenChannelToTab_Params {
  constructor() {
    /** @type { !number } */
    this.tabId;
    /** @type { !number } */
    this.frameId;
    /** @type { (string|undefined) } */
    this.documentId;
    /** @type { !extensions_mojom_ChannelType } */
    this.channelType;
    /** @type { !string } */
    this.channelName;
    /** @type { !extensions_mojom_PortId } */
    this.portId;
    /** @type { !Object } */
    this.port;
    /** @type { !Object } */
    this.portHost;
  }
}

