// extensions/common/mojom/service_worker_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'extensions/common/mojom/service_worker_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('extensions.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var uuid$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/uuid.mojom', '../../../mojo/public/mojom/base/uuid.mojom.js');
  }
  var event_dispatcher$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/event_dispatcher.mojom', 'event_dispatcher.mojom.js');
  }
  var extension_id$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/extension_id.mojom', 'extension_id.mojom.js');
  }
  var extra_response_data$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/extra_response_data.mojom', 'extra_response_data.mojom.js');
  }
  var frame$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/frame.mojom', 'frame.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../mojo/public/mojom/base/values.mojom.js');
  }
  var message_port$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/message_port.mojom', 'message_port.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../../../third_party/blink/public/mojom/tokens/tokens.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../url/mojom/url.mojom.js');
  }



  function ServiceWorkerHost_DidInitializeServiceWorkerContext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerHost_DidInitializeServiceWorkerContext_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.serviceWorkerVersionId = 0;
    this.workerThreadId = 0;
    this.serviceWorkerToken = null;
    this.eventDispatcher = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  ServiceWorkerHost_DidInitializeServiceWorkerContext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerHost_DidInitializeServiceWorkerContext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_DidInitializeServiceWorkerContext_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ServiceWorkerHost_DidInitializeServiceWorkerContext_Params.serviceWorkerToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, tokens$.ServiceWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_DidInitializeServiceWorkerContext_Params.eventDispatcher
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 32, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerHost_DidInitializeServiceWorkerContext_Params.encodedSize = codec.kStructHeaderSize + 40;

  ServiceWorkerHost_DidInitializeServiceWorkerContext_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerHost_DidInitializeServiceWorkerContext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.serviceWorkerVersionId =
        decoder.decodeStruct(codec.Int64);
    val.workerThreadId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.serviceWorkerToken =
        decoder.decodeStructPointer(tokens$.ServiceWorkerToken);
    val.eventDispatcher =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    return val;
  };

  ServiceWorkerHost_DidInitializeServiceWorkerContext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerHost_DidInitializeServiceWorkerContext_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerVersionId);
    encoder.encodeStruct(codec.Int32, val.workerThreadId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(tokens$.ServiceWorkerToken, val.serviceWorkerToken);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.eventDispatcher);
  };
  function ServiceWorkerHost_DidStartServiceWorkerContext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerHost_DidStartServiceWorkerContext_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.activationToken = null;
    this.serviceWorkerScope = null;
    this.serviceWorkerVersionId = 0;
    this.workerThreadId = 0;
  };
  ServiceWorkerHost_DidStartServiceWorkerContext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerHost_DidStartServiceWorkerContext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_DidStartServiceWorkerContext_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_DidStartServiceWorkerContext_Params.activationToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_DidStartServiceWorkerContext_Params.serviceWorkerScope
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ServiceWorkerHost_DidStartServiceWorkerContext_Params.encodedSize = codec.kStructHeaderSize + 40;

  ServiceWorkerHost_DidStartServiceWorkerContext_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerHost_DidStartServiceWorkerContext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.activationToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.serviceWorkerScope =
        decoder.decodeStructPointer(url$.Url);
    val.serviceWorkerVersionId =
        decoder.decodeStruct(codec.Int64);
    val.workerThreadId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerHost_DidStartServiceWorkerContext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerHost_DidStartServiceWorkerContext_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.activationToken);
    encoder.encodeStructPointer(url$.Url, val.serviceWorkerScope);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerVersionId);
    encoder.encodeStruct(codec.Int32, val.workerThreadId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceWorkerHost_DidStopServiceWorkerContext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerHost_DidStopServiceWorkerContext_Params.prototype.initDefaults_ = function() {
    this.extensionId = null;
    this.activationToken = null;
    this.serviceWorkerScope = null;
    this.serviceWorkerVersionId = 0;
    this.workerThreadId = 0;
  };
  ServiceWorkerHost_DidStopServiceWorkerContext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerHost_DidStopServiceWorkerContext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_DidStopServiceWorkerContext_Params.extensionId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, extension_id$.ExtensionId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_DidStopServiceWorkerContext_Params.activationToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_DidStopServiceWorkerContext_Params.serviceWorkerScope
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ServiceWorkerHost_DidStopServiceWorkerContext_Params.encodedSize = codec.kStructHeaderSize + 40;

  ServiceWorkerHost_DidStopServiceWorkerContext_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerHost_DidStopServiceWorkerContext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.extensionId =
        decoder.decodeStructPointer(extension_id$.ExtensionId);
    val.activationToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.serviceWorkerScope =
        decoder.decodeStructPointer(url$.Url);
    val.serviceWorkerVersionId =
        decoder.decodeStruct(codec.Int64);
    val.workerThreadId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerHost_DidStopServiceWorkerContext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerHost_DidStopServiceWorkerContext_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(extension_id$.ExtensionId, val.extensionId);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.activationToken);
    encoder.encodeStructPointer(url$.Url, val.serviceWorkerScope);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerVersionId);
    encoder.encodeStruct(codec.Int32, val.workerThreadId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceWorkerHost_RequestWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerHost_RequestWorker_Params.prototype.initDefaults_ = function() {
    this.params = null;
  };
  ServiceWorkerHost_RequestWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerHost_RequestWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_RequestWorker_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, frame$.RequestParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerHost_RequestWorker_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerHost_RequestWorker_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerHost_RequestWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(frame$.RequestParams);
    return val;
  };

  ServiceWorkerHost_RequestWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerHost_RequestWorker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(frame$.RequestParams, val.params);
  };
  function ServiceWorkerHost_RequestWorker_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerHost_RequestWorker_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.responseWrapper = null;
    this.error = null;
    this.extraData = null;
  };
  ServiceWorkerHost_RequestWorker_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerHost_RequestWorker_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ServiceWorkerHost_RequestWorker_ResponseParams.responseWrapper
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, values$.ListValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_RequestWorker_ResponseParams.error
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_RequestWorker_ResponseParams.extraData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, extra_response_data$.ExtraResponseData, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerHost_RequestWorker_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  ServiceWorkerHost_RequestWorker_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerHost_RequestWorker_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.responseWrapper =
        decoder.decodeStructPointer(values$.ListValue);
    val.error =
        decoder.decodeStruct(codec.String);
    val.extraData =
        decoder.decodeStructPointer(extra_response_data$.ExtraResponseData);
    return val;
  };

  ServiceWorkerHost_RequestWorker_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerHost_RequestWorker_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(values$.ListValue, val.responseWrapper);
    encoder.encodeStruct(codec.String, val.error);
    encoder.encodeStructPointer(extra_response_data$.ExtraResponseData, val.extraData);
  };
  function ServiceWorkerHost_WorkerResponseAck_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerHost_WorkerResponseAck_Params.prototype.initDefaults_ = function() {
    this.requestUuid = null;
  };
  ServiceWorkerHost_WorkerResponseAck_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerHost_WorkerResponseAck_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_WorkerResponseAck_Params.requestUuid
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, uuid$.Uuid, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerHost_WorkerResponseAck_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerHost_WorkerResponseAck_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerHost_WorkerResponseAck_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestUuid =
        decoder.decodeStructPointer(uuid$.Uuid);
    return val;
  };

  ServiceWorkerHost_WorkerResponseAck_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerHost_WorkerResponseAck_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(uuid$.Uuid, val.requestUuid);
  };
  function ServiceWorkerHost_OpenChannelToExtension_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerHost_OpenChannelToExtension_Params.prototype.initDefaults_ = function() {
    this.info = null;
    this.channelType = 0;
    this.portHost = new associatedBindings.AssociatedInterfaceRequest();
    this.channelName = null;
    this.portId = null;
    this.port = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  ServiceWorkerHost_OpenChannelToExtension_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerHost_OpenChannelToExtension_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToExtension_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, message_port$.ExternalConnectionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToExtension_Params.channelType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, message_port$.ChannelType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToExtension_Params.channelName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToExtension_Params.portId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, message_port$.PortId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToExtension_Params.port
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 32, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToExtension_Params.portHost
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 12, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerHost_OpenChannelToExtension_Params.encodedSize = codec.kStructHeaderSize + 40;

  ServiceWorkerHost_OpenChannelToExtension_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerHost_OpenChannelToExtension_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(message_port$.ExternalConnectionInfo);
    val.channelType =
        decoder.decodeStruct(new codec.Enum(message_port$.ChannelType));
    val.portHost =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.channelName =
        decoder.decodeStruct(codec.String);
    val.portId =
        decoder.decodeStructPointer(message_port$.PortId);
    val.port =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    return val;
  };

  ServiceWorkerHost_OpenChannelToExtension_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerHost_OpenChannelToExtension_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(message_port$.ExternalConnectionInfo, val.info);
    encoder.encodeStruct(codec.Int32, val.channelType);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.portHost);
    encoder.encodeStruct(codec.String, val.channelName);
    encoder.encodeStructPointer(message_port$.PortId, val.portId);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.port);
  };
  function ServiceWorkerHost_OpenChannelToNativeApp_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerHost_OpenChannelToNativeApp_Params.prototype.initDefaults_ = function() {
    this.nativeAppName = null;
    this.portId = null;
    this.port = new associatedBindings.AssociatedInterfacePtrInfo();
    this.portHost = new associatedBindings.AssociatedInterfaceRequest();
  };
  ServiceWorkerHost_OpenChannelToNativeApp_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerHost_OpenChannelToNativeApp_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToNativeApp_Params.nativeAppName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToNativeApp_Params.portId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, message_port$.PortId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToNativeApp_Params.port
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToNativeApp_Params.portHost
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerHost_OpenChannelToNativeApp_Params.encodedSize = codec.kStructHeaderSize + 32;

  ServiceWorkerHost_OpenChannelToNativeApp_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerHost_OpenChannelToNativeApp_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.nativeAppName =
        decoder.decodeStruct(codec.String);
    val.portId =
        decoder.decodeStructPointer(message_port$.PortId);
    val.port =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.portHost =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerHost_OpenChannelToNativeApp_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerHost_OpenChannelToNativeApp_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.nativeAppName);
    encoder.encodeStructPointer(message_port$.PortId, val.portId);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.port);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.portHost);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceWorkerHost_OpenChannelToTab_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerHost_OpenChannelToTab_Params.prototype.initDefaults_ = function() {
    this.tabId = 0;
    this.frameId = 0;
    this.documentId = null;
    this.channelType = 0;
    this.portHost = new associatedBindings.AssociatedInterfaceRequest();
    this.channelName = null;
    this.portId = null;
    this.port = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  ServiceWorkerHost_OpenChannelToTab_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerHost_OpenChannelToTab_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ServiceWorkerHost_OpenChannelToTab_Params.documentId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToTab_Params.channelType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, message_port$.ChannelType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToTab_Params.channelName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToTab_Params.portId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, message_port$.PortId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToTab_Params.port
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 40, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerHost_OpenChannelToTab_Params.portHost
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 20, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerHost_OpenChannelToTab_Params.encodedSize = codec.kStructHeaderSize + 48;

  ServiceWorkerHost_OpenChannelToTab_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerHost_OpenChannelToTab_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tabId =
        decoder.decodeStruct(codec.Int32);
    val.frameId =
        decoder.decodeStruct(codec.Int32);
    val.documentId =
        decoder.decodeStruct(codec.String);
    val.channelType =
        decoder.decodeStruct(new codec.Enum(message_port$.ChannelType));
    val.portHost =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.channelName =
        decoder.decodeStruct(codec.String);
    val.portId =
        decoder.decodeStructPointer(message_port$.PortId);
    val.port =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    return val;
  };

  ServiceWorkerHost_OpenChannelToTab_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerHost_OpenChannelToTab_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.tabId);
    encoder.encodeStruct(codec.Int32, val.frameId);
    encoder.encodeStruct(codec.String, val.documentId);
    encoder.encodeStruct(codec.Int32, val.channelType);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.portHost);
    encoder.encodeStruct(codec.String, val.channelName);
    encoder.encodeStructPointer(message_port$.PortId, val.portId);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.port);
  };
  var kServiceWorkerHost_DidInitializeServiceWorkerContext_Name = 0;
  var kServiceWorkerHost_DidStartServiceWorkerContext_Name = 1;
  var kServiceWorkerHost_DidStopServiceWorkerContext_Name = 2;
  var kServiceWorkerHost_RequestWorker_Name = 3;
  var kServiceWorkerHost_WorkerResponseAck_Name = 4;
  var kServiceWorkerHost_OpenChannelToExtension_Name = 5;
  var kServiceWorkerHost_OpenChannelToNativeApp_Name = 6;
  var kServiceWorkerHost_OpenChannelToTab_Name = 7;

  function ServiceWorkerHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ServiceWorkerHost,
                                                   handleOrPtrInfo);
  }

  function ServiceWorkerHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ServiceWorkerHost, associatedInterfacePtrInfo);
  }

  ServiceWorkerHostAssociatedPtr.prototype =
      Object.create(ServiceWorkerHostPtr.prototype);
  ServiceWorkerHostAssociatedPtr.prototype.constructor =
      ServiceWorkerHostAssociatedPtr;

  function ServiceWorkerHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  ServiceWorkerHostPtr.prototype.didInitializeServiceWorkerContext = function() {
    return ServiceWorkerHostProxy.prototype.didInitializeServiceWorkerContext
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerHostProxy.prototype.didInitializeServiceWorkerContext = function(extensionId, serviceWorkerVersionId, workerThreadId, serviceWorkerToken, eventDispatcher) {
    var params_ = new ServiceWorkerHost_DidInitializeServiceWorkerContext_Params();
    params_.extensionId = extensionId;
    params_.serviceWorkerVersionId = serviceWorkerVersionId;
    params_.workerThreadId = workerThreadId;
    params_.serviceWorkerToken = serviceWorkerToken;
    params_.eventDispatcher = eventDispatcher;
    var builder = new codec.MessageV2Builder(
        kServiceWorkerHost_DidInitializeServiceWorkerContext_Name,
        codec.align(ServiceWorkerHost_DidInitializeServiceWorkerContext_Params.encodedSize));
    builder.setPayload(ServiceWorkerHost_DidInitializeServiceWorkerContext_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerHostPtr.prototype.didStartServiceWorkerContext = function() {
    return ServiceWorkerHostProxy.prototype.didStartServiceWorkerContext
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerHostProxy.prototype.didStartServiceWorkerContext = function(extensionId, activationToken, serviceWorkerScope, serviceWorkerVersionId, workerThreadId) {
    var params_ = new ServiceWorkerHost_DidStartServiceWorkerContext_Params();
    params_.extensionId = extensionId;
    params_.activationToken = activationToken;
    params_.serviceWorkerScope = serviceWorkerScope;
    params_.serviceWorkerVersionId = serviceWorkerVersionId;
    params_.workerThreadId = workerThreadId;
    var builder = new codec.MessageV0Builder(
        kServiceWorkerHost_DidStartServiceWorkerContext_Name,
        codec.align(ServiceWorkerHost_DidStartServiceWorkerContext_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerHost_DidStartServiceWorkerContext_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerHostPtr.prototype.didStopServiceWorkerContext = function() {
    return ServiceWorkerHostProxy.prototype.didStopServiceWorkerContext
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerHostProxy.prototype.didStopServiceWorkerContext = function(extensionId, activationToken, serviceWorkerScope, serviceWorkerVersionId, workerThreadId) {
    var params_ = new ServiceWorkerHost_DidStopServiceWorkerContext_Params();
    params_.extensionId = extensionId;
    params_.activationToken = activationToken;
    params_.serviceWorkerScope = serviceWorkerScope;
    params_.serviceWorkerVersionId = serviceWorkerVersionId;
    params_.workerThreadId = workerThreadId;
    var builder = new codec.MessageV0Builder(
        kServiceWorkerHost_DidStopServiceWorkerContext_Name,
        codec.align(ServiceWorkerHost_DidStopServiceWorkerContext_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerHost_DidStopServiceWorkerContext_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerHostPtr.prototype.requestWorker = function() {
    return ServiceWorkerHostProxy.prototype.requestWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerHostProxy.prototype.requestWorker = function(params) {
    var params_ = new ServiceWorkerHost_RequestWorker_Params();
    params_.params = params;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kServiceWorkerHost_RequestWorker_Name,
          codec.align(ServiceWorkerHost_RequestWorker_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ServiceWorkerHost_RequestWorker_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorkerHost_RequestWorker_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ServiceWorkerHostPtr.prototype.workerResponseAck = function() {
    return ServiceWorkerHostProxy.prototype.workerResponseAck
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerHostProxy.prototype.workerResponseAck = function(requestUuid) {
    var params_ = new ServiceWorkerHost_WorkerResponseAck_Params();
    params_.requestUuid = requestUuid;
    var builder = new codec.MessageV0Builder(
        kServiceWorkerHost_WorkerResponseAck_Name,
        codec.align(ServiceWorkerHost_WorkerResponseAck_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerHost_WorkerResponseAck_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerHostPtr.prototype.openChannelToExtension = function() {
    return ServiceWorkerHostProxy.prototype.openChannelToExtension
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerHostProxy.prototype.openChannelToExtension = function(info, channelType, channelName, portId, port, portHost) {
    var params_ = new ServiceWorkerHost_OpenChannelToExtension_Params();
    params_.info = info;
    params_.channelType = channelType;
    params_.channelName = channelName;
    params_.portId = portId;
    params_.port = port;
    params_.portHost = portHost;
    var builder = new codec.MessageV2Builder(
        kServiceWorkerHost_OpenChannelToExtension_Name,
        codec.align(ServiceWorkerHost_OpenChannelToExtension_Params.encodedSize));
    builder.setPayload(ServiceWorkerHost_OpenChannelToExtension_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerHostPtr.prototype.openChannelToNativeApp = function() {
    return ServiceWorkerHostProxy.prototype.openChannelToNativeApp
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerHostProxy.prototype.openChannelToNativeApp = function(nativeAppName, portId, port, portHost) {
    var params_ = new ServiceWorkerHost_OpenChannelToNativeApp_Params();
    params_.nativeAppName = nativeAppName;
    params_.portId = portId;
    params_.port = port;
    params_.portHost = portHost;
    var builder = new codec.MessageV2Builder(
        kServiceWorkerHost_OpenChannelToNativeApp_Name,
        codec.align(ServiceWorkerHost_OpenChannelToNativeApp_Params.encodedSize));
    builder.setPayload(ServiceWorkerHost_OpenChannelToNativeApp_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerHostPtr.prototype.openChannelToTab = function() {
    return ServiceWorkerHostProxy.prototype.openChannelToTab
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerHostProxy.prototype.openChannelToTab = function(tabId, frameId, documentId, channelType, channelName, portId, port, portHost) {
    var params_ = new ServiceWorkerHost_OpenChannelToTab_Params();
    params_.tabId = tabId;
    params_.frameId = frameId;
    params_.documentId = documentId;
    params_.channelType = channelType;
    params_.channelName = channelName;
    params_.portId = portId;
    params_.port = port;
    params_.portHost = portHost;
    var builder = new codec.MessageV2Builder(
        kServiceWorkerHost_OpenChannelToTab_Name,
        codec.align(ServiceWorkerHost_OpenChannelToTab_Params.encodedSize));
    builder.setPayload(ServiceWorkerHost_OpenChannelToTab_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ServiceWorkerHostStub(delegate) {
    this.delegate_ = delegate;
  }
  ServiceWorkerHostStub.prototype.didInitializeServiceWorkerContext = function(extensionId, serviceWorkerVersionId, workerThreadId, serviceWorkerToken, eventDispatcher) {
    return this.delegate_ && this.delegate_.didInitializeServiceWorkerContext && this.delegate_.didInitializeServiceWorkerContext(extensionId, serviceWorkerVersionId, workerThreadId, serviceWorkerToken, eventDispatcher);
  }
  ServiceWorkerHostStub.prototype.didStartServiceWorkerContext = function(extensionId, activationToken, serviceWorkerScope, serviceWorkerVersionId, workerThreadId) {
    return this.delegate_ && this.delegate_.didStartServiceWorkerContext && this.delegate_.didStartServiceWorkerContext(extensionId, activationToken, serviceWorkerScope, serviceWorkerVersionId, workerThreadId);
  }
  ServiceWorkerHostStub.prototype.didStopServiceWorkerContext = function(extensionId, activationToken, serviceWorkerScope, serviceWorkerVersionId, workerThreadId) {
    return this.delegate_ && this.delegate_.didStopServiceWorkerContext && this.delegate_.didStopServiceWorkerContext(extensionId, activationToken, serviceWorkerScope, serviceWorkerVersionId, workerThreadId);
  }
  ServiceWorkerHostStub.prototype.requestWorker = function(params) {
    return this.delegate_ && this.delegate_.requestWorker && this.delegate_.requestWorker(params);
  }
  ServiceWorkerHostStub.prototype.workerResponseAck = function(requestUuid) {
    return this.delegate_ && this.delegate_.workerResponseAck && this.delegate_.workerResponseAck(requestUuid);
  }
  ServiceWorkerHostStub.prototype.openChannelToExtension = function(info, channelType, channelName, portId, port, portHost) {
    return this.delegate_ && this.delegate_.openChannelToExtension && this.delegate_.openChannelToExtension(info, channelType, channelName, portId, port, portHost);
  }
  ServiceWorkerHostStub.prototype.openChannelToNativeApp = function(nativeAppName, portId, port, portHost) {
    return this.delegate_ && this.delegate_.openChannelToNativeApp && this.delegate_.openChannelToNativeApp(nativeAppName, portId, port, portHost);
  }
  ServiceWorkerHostStub.prototype.openChannelToTab = function(tabId, frameId, documentId, channelType, channelName, portId, port, portHost) {
    return this.delegate_ && this.delegate_.openChannelToTab && this.delegate_.openChannelToTab(tabId, frameId, documentId, channelType, channelName, portId, port, portHost);
  }

  ServiceWorkerHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceWorkerHost_DidInitializeServiceWorkerContext_Name:
      var params = reader.decodeStruct(ServiceWorkerHost_DidInitializeServiceWorkerContext_Params);
      this.didInitializeServiceWorkerContext(params.extensionId, params.serviceWorkerVersionId, params.workerThreadId, params.serviceWorkerToken, params.eventDispatcher);
      return true;
    case kServiceWorkerHost_DidStartServiceWorkerContext_Name:
      var params = reader.decodeStruct(ServiceWorkerHost_DidStartServiceWorkerContext_Params);
      this.didStartServiceWorkerContext(params.extensionId, params.activationToken, params.serviceWorkerScope, params.serviceWorkerVersionId, params.workerThreadId);
      return true;
    case kServiceWorkerHost_DidStopServiceWorkerContext_Name:
      var params = reader.decodeStruct(ServiceWorkerHost_DidStopServiceWorkerContext_Params);
      this.didStopServiceWorkerContext(params.extensionId, params.activationToken, params.serviceWorkerScope, params.serviceWorkerVersionId, params.workerThreadId);
      return true;
    case kServiceWorkerHost_WorkerResponseAck_Name:
      var params = reader.decodeStruct(ServiceWorkerHost_WorkerResponseAck_Params);
      this.workerResponseAck(params.requestUuid);
      return true;
    case kServiceWorkerHost_OpenChannelToExtension_Name:
      var params = reader.decodeStruct(ServiceWorkerHost_OpenChannelToExtension_Params);
      this.openChannelToExtension(params.info, params.channelType, params.channelName, params.portId, params.port, params.portHost);
      return true;
    case kServiceWorkerHost_OpenChannelToNativeApp_Name:
      var params = reader.decodeStruct(ServiceWorkerHost_OpenChannelToNativeApp_Params);
      this.openChannelToNativeApp(params.nativeAppName, params.portId, params.port, params.portHost);
      return true;
    case kServiceWorkerHost_OpenChannelToTab_Name:
      var params = reader.decodeStruct(ServiceWorkerHost_OpenChannelToTab_Params);
      this.openChannelToTab(params.tabId, params.frameId, params.documentId, params.channelType, params.channelName, params.portId, params.port, params.portHost);
      return true;
    default:
      return false;
    }
  };

  ServiceWorkerHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceWorkerHost_RequestWorker_Name:
      var params = reader.decodeStruct(ServiceWorkerHost_RequestWorker_Params);
      this.requestWorker(params.params).then(function(response) {
        var responseParams =
            new ServiceWorkerHost_RequestWorker_ResponseParams();
        responseParams.success = response.success;
        responseParams.responseWrapper = response.responseWrapper;
        responseParams.error = response.error;
        responseParams.extraData = response.extraData;
        var builder = new codec.MessageV1Builder(
            kServiceWorkerHost_RequestWorker_Name,
            codec.align(ServiceWorkerHost_RequestWorker_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ServiceWorkerHost_RequestWorker_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateServiceWorkerHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kServiceWorkerHost_DidInitializeServiceWorkerContext_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerHost_DidInitializeServiceWorkerContext_Params;
      break;
      case kServiceWorkerHost_DidStartServiceWorkerContext_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerHost_DidStartServiceWorkerContext_Params;
      break;
      case kServiceWorkerHost_DidStopServiceWorkerContext_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerHost_DidStopServiceWorkerContext_Params;
      break;
      case kServiceWorkerHost_RequestWorker_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorkerHost_RequestWorker_Params;
      break;
      case kServiceWorkerHost_WorkerResponseAck_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerHost_WorkerResponseAck_Params;
      break;
      case kServiceWorkerHost_OpenChannelToExtension_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerHost_OpenChannelToExtension_Params;
      break;
      case kServiceWorkerHost_OpenChannelToNativeApp_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerHost_OpenChannelToNativeApp_Params;
      break;
      case kServiceWorkerHost_OpenChannelToTab_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerHost_OpenChannelToTab_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateServiceWorkerHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kServiceWorkerHost_RequestWorker_Name:
        if (message.isResponse())
          paramsClass = ServiceWorkerHost_RequestWorker_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ServiceWorkerHost = {
    name: 'extensions.mojom.ServiceWorkerHost',
    kVersion: 0,
    ptrClass: ServiceWorkerHostPtr,
    proxyClass: ServiceWorkerHostProxy,
    stubClass: ServiceWorkerHostStub,
    validateRequest: validateServiceWorkerHostRequest,
    validateResponse: validateServiceWorkerHostResponse,
  };
  ServiceWorkerHostStub.prototype.validator = validateServiceWorkerHostRequest;
  ServiceWorkerHostProxy.prototype.validator = validateServiceWorkerHostResponse;
  exports.ServiceWorkerHost = ServiceWorkerHost;
  exports.ServiceWorkerHostPtr = ServiceWorkerHostPtr;
  exports.ServiceWorkerHostAssociatedPtr = ServiceWorkerHostAssociatedPtr;
})();