// extensions/common/mojom/service_worker.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  ChannelType as extensions_mojom_ChannelType,
  ChannelTypeSpec as extensions_mojom_ChannelTypeSpec,
  MessagePortRemote as extensions_mojom_MessagePortRemote,
  MessagePortPendingReceiver as extensions_mojom_MessagePortPendingReceiver,
  MessagePortHostRemote as extensions_mojom_MessagePortHostRemote,
  MessagePortHostPendingReceiver as extensions_mojom_MessagePortHostPendingReceiver,
  ExternalConnectionInfo as extensions_mojom_ExternalConnectionInfo,
  ExternalConnectionInfoSpec as extensions_mojom_ExternalConnectionInfoSpec,
  PortId as extensions_mojom_PortId,
  PortIdSpec as extensions_mojom_PortIdSpec,
  TabConnectionInfo as extensions_mojom_TabConnectionInfo,
  TabConnectionInfoSpec as extensions_mojom_TabConnectionInfoSpec
} from './message_port.mojom.m.js';

import {
  PermissionSet as extensions_mojom_PermissionSet,
  PermissionSetSpec as extensions_mojom_PermissionSetSpec
} from './permission_set.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.ServiceWorker', scope);
  }
}

/** @interface */
export class ServiceWorkerInterface {
  
  /**
   * @param { !extensions_mojom_PermissionSet } activePermissions
   * @param { !extensions_mojom_PermissionSet } withheldPermissions
   */

  updatePermissions(activePermissions, withheldPermissions) {}
  
  /**
   * @param { !extensions_mojom_PortId } portId
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_TabConnectionInfo } tabInfo
   * @param { !extensions_mojom_ExternalConnectionInfo } externalConnectionInfo
   * @param { !Object } port
   * @param { !Object } portHost
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  dispatchOnConnect(portId, channelType, channelName, tabInfo, externalConnectionInfo, port, portHost) {}
}

/**
 * @implements { ServiceWorkerInterface }
 */
export class ServiceWorkerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !extensions_mojom_PermissionSet } activePermissions
   * @param { !extensions_mojom_PermissionSet } withheldPermissions
   */

  updatePermissions(
      activePermissions,
      withheldPermissions) {
    this.proxy.sendMessage(
        0,
        ServiceWorker_UpdatePermissions_ParamsSpec.$,
        null,
        [
          activePermissions,
          withheldPermissions
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_PortId } portId
   * @param { !extensions_mojom_ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions_mojom_TabConnectionInfo } tabInfo
   * @param { !extensions_mojom_ExternalConnectionInfo } externalConnectionInfo
   * @param { !Object } port
   * @param { !Object } portHost
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  dispatchOnConnect(
      portId,
      channelType,
      channelName,
      tabInfo,
      externalConnectionInfo,
      port,
      portHost) {
    return this.proxy.sendMessage(
        1,
        ServiceWorker_DispatchOnConnect_ParamsSpec.$,
        ServiceWorker_DispatchOnConnect_ResponseParamsSpec.$,
        [
          portId,
          channelType,
          channelName,
          tabInfo,
          externalConnectionInfo,
          port,
          portHost
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerReceiver {
  /**
   * @param {!ServiceWorkerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorker_UpdatePermissions_ParamsSpec.$,
        null,
        impl.updatePermissions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorker_DispatchOnConnect_ParamsSpec.$,
        ServiceWorker_DispatchOnConnect_ResponseParamsSpec.$,
        impl.dispatchOnConnect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorker {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.ServiceWorker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updatePermissions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorker_UpdatePermissions_ParamsSpec.$,
        null,
        this.updatePermissions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchOnConnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorker_DispatchOnConnect_ParamsSpec.$,
        ServiceWorker_DispatchOnConnect_ResponseParamsSpec.$,
        this.dispatchOnConnect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_UpdatePermissions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchOnConnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchOnConnect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServiceWorker_UpdatePermissions_ParamsSpec.$,
    'ServiceWorker_UpdatePermissions_Params',
    [
      mojo.internal.StructField(
        'activePermissions', 0,
        0,
        extensions_mojom_PermissionSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'withheldPermissions', 8,
        0,
        extensions_mojom_PermissionSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorker_UpdatePermissions_Params {
  constructor() {
    /** @type { !extensions_mojom_PermissionSet } */
    this.activePermissions;
    /** @type { !extensions_mojom_PermissionSet } */
    this.withheldPermissions;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchOnConnect_ParamsSpec.$,
    'ServiceWorker_DispatchOnConnect_Params',
    [
      mojo.internal.StructField(
        'portId', 0,
        0,
        extensions_mojom_PortIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelType', 8,
        0,
        extensions_mojom_ChannelTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tabInfo', 24,
        0,
        extensions_mojom_TabConnectionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'externalConnectionInfo', 32,
        0,
        extensions_mojom_ExternalConnectionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'port', 12,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions_mojom_MessagePortPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portHost', 40,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions_mojom_MessagePortHostRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ServiceWorker_DispatchOnConnect_Params {
  constructor() {
    /** @type { !extensions_mojom_PortId } */
    this.portId;
    /** @type { !extensions_mojom_ChannelType } */
    this.channelType;
    /** @type { !string } */
    this.channelName;
    /** @type { !extensions_mojom_TabConnectionInfo } */
    this.tabInfo;
    /** @type { !extensions_mojom_ExternalConnectionInfo } */
    this.externalConnectionInfo;
    /** @type { !Object } */
    this.port;
    /** @type { !Object } */
    this.portHost;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchOnConnect_ResponseParamsSpec.$,
    'ServiceWorker_DispatchOnConnect_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchOnConnect_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}

