// extensions/common/mojom/service_worker.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'extensions/common/mojom/service_worker.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('extensions.mojom');
  var message_port$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/message_port.mojom', 'message_port.mojom.js');
  }
  var permission_set$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/permission_set.mojom', 'permission_set.mojom.js');
  }



  function ServiceWorker_UpdatePermissions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorker_UpdatePermissions_Params.prototype.initDefaults_ = function() {
    this.activePermissions = null;
    this.withheldPermissions = null;
  };
  ServiceWorker_UpdatePermissions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorker_UpdatePermissions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorker_UpdatePermissions_Params.activePermissions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, permission_set$.PermissionSet, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorker_UpdatePermissions_Params.withheldPermissions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, permission_set$.PermissionSet, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorker_UpdatePermissions_Params.encodedSize = codec.kStructHeaderSize + 16;

  ServiceWorker_UpdatePermissions_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorker_UpdatePermissions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.activePermissions =
        decoder.decodeStructPointer(permission_set$.PermissionSet);
    val.withheldPermissions =
        decoder.decodeStructPointer(permission_set$.PermissionSet);
    return val;
  };

  ServiceWorker_UpdatePermissions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorker_UpdatePermissions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(permission_set$.PermissionSet, val.activePermissions);
    encoder.encodeStructPointer(permission_set$.PermissionSet, val.withheldPermissions);
  };
  function ServiceWorker_DispatchOnConnect_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorker_DispatchOnConnect_Params.prototype.initDefaults_ = function() {
    this.portId = null;
    this.channelType = 0;
    this.port = new associatedBindings.AssociatedInterfaceRequest();
    this.channelName = null;
    this.tabInfo = null;
    this.externalConnectionInfo = null;
    this.portHost = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  ServiceWorker_DispatchOnConnect_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorker_DispatchOnConnect_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorker_DispatchOnConnect_Params.portId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, message_port$.PortId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorker_DispatchOnConnect_Params.channelType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, message_port$.ChannelType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorker_DispatchOnConnect_Params.channelName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorker_DispatchOnConnect_Params.tabInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, message_port$.TabConnectionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorker_DispatchOnConnect_Params.externalConnectionInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, message_port$.ExternalConnectionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorker_DispatchOnConnect_Params.port
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 12, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorker_DispatchOnConnect_Params.portHost
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 40, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorker_DispatchOnConnect_Params.encodedSize = codec.kStructHeaderSize + 48;

  ServiceWorker_DispatchOnConnect_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorker_DispatchOnConnect_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.portId =
        decoder.decodeStructPointer(message_port$.PortId);
    val.channelType =
        decoder.decodeStruct(new codec.Enum(message_port$.ChannelType));
    val.port =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.channelName =
        decoder.decodeStruct(codec.String);
    val.tabInfo =
        decoder.decodeStructPointer(message_port$.TabConnectionInfo);
    val.externalConnectionInfo =
        decoder.decodeStructPointer(message_port$.ExternalConnectionInfo);
    val.portHost =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    return val;
  };

  ServiceWorker_DispatchOnConnect_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorker_DispatchOnConnect_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(message_port$.PortId, val.portId);
    encoder.encodeStruct(codec.Int32, val.channelType);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.port);
    encoder.encodeStruct(codec.String, val.channelName);
    encoder.encodeStructPointer(message_port$.TabConnectionInfo, val.tabInfo);
    encoder.encodeStructPointer(message_port$.ExternalConnectionInfo, val.externalConnectionInfo);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.portHost);
  };
  function ServiceWorker_DispatchOnConnect_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorker_DispatchOnConnect_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  ServiceWorker_DispatchOnConnect_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorker_DispatchOnConnect_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ServiceWorker_DispatchOnConnect_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorker_DispatchOnConnect_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ServiceWorker_DispatchOnConnect_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorker_DispatchOnConnect_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorker_DispatchOnConnect_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kServiceWorker_UpdatePermissions_Name = 0;
  var kServiceWorker_DispatchOnConnect_Name = 1;

  function ServiceWorkerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ServiceWorker,
                                                   handleOrPtrInfo);
  }

  function ServiceWorkerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ServiceWorker, associatedInterfacePtrInfo);
  }

  ServiceWorkerAssociatedPtr.prototype =
      Object.create(ServiceWorkerPtr.prototype);
  ServiceWorkerAssociatedPtr.prototype.constructor =
      ServiceWorkerAssociatedPtr;

  function ServiceWorkerProxy(receiver) {
    this.receiver_ = receiver;
  }
  ServiceWorkerPtr.prototype.updatePermissions = function() {
    return ServiceWorkerProxy.prototype.updatePermissions
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerProxy.prototype.updatePermissions = function(activePermissions, withheldPermissions) {
    var params_ = new ServiceWorker_UpdatePermissions_Params();
    params_.activePermissions = activePermissions;
    params_.withheldPermissions = withheldPermissions;
    var builder = new codec.MessageV0Builder(
        kServiceWorker_UpdatePermissions_Name,
        codec.align(ServiceWorker_UpdatePermissions_Params.encodedSize));
    builder.encodeStruct(ServiceWorker_UpdatePermissions_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerPtr.prototype.dispatchOnConnect = function() {
    return ServiceWorkerProxy.prototype.dispatchOnConnect
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerProxy.prototype.dispatchOnConnect = function(portId, channelType, channelName, tabInfo, externalConnectionInfo, port, portHost) {
    var params_ = new ServiceWorker_DispatchOnConnect_Params();
    params_.portId = portId;
    params_.channelType = channelType;
    params_.channelName = channelName;
    params_.tabInfo = tabInfo;
    params_.externalConnectionInfo = externalConnectionInfo;
    params_.port = port;
    params_.portHost = portHost;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kServiceWorker_DispatchOnConnect_Name,
          codec.align(ServiceWorker_DispatchOnConnect_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(ServiceWorker_DispatchOnConnect_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ServiceWorker_DispatchOnConnect_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function ServiceWorkerStub(delegate) {
    this.delegate_ = delegate;
  }
  ServiceWorkerStub.prototype.updatePermissions = function(activePermissions, withheldPermissions) {
    return this.delegate_ && this.delegate_.updatePermissions && this.delegate_.updatePermissions(activePermissions, withheldPermissions);
  }
  ServiceWorkerStub.prototype.dispatchOnConnect = function(portId, channelType, channelName, tabInfo, externalConnectionInfo, port, portHost) {
    return this.delegate_ && this.delegate_.dispatchOnConnect && this.delegate_.dispatchOnConnect(portId, channelType, channelName, tabInfo, externalConnectionInfo, port, portHost);
  }

  ServiceWorkerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceWorker_UpdatePermissions_Name:
      var params = reader.decodeStruct(ServiceWorker_UpdatePermissions_Params);
      this.updatePermissions(params.activePermissions, params.withheldPermissions);
      return true;
    default:
      return false;
    }
  };

  ServiceWorkerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceWorker_DispatchOnConnect_Name:
      var params = reader.decodeStruct(ServiceWorker_DispatchOnConnect_Params);
      this.dispatchOnConnect(params.portId, params.channelType, params.channelName, params.tabInfo, params.externalConnectionInfo, params.port, params.portHost).then(function(response) {
        var responseParams =
            new ServiceWorker_DispatchOnConnect_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV2Builder(
            kServiceWorker_DispatchOnConnect_Name,
            codec.align(ServiceWorker_DispatchOnConnect_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(ServiceWorker_DispatchOnConnect_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateServiceWorkerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kServiceWorker_UpdatePermissions_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorker_UpdatePermissions_Params;
      break;
      case kServiceWorker_DispatchOnConnect_Name:
        if (message.expectsResponse())
          paramsClass = ServiceWorker_DispatchOnConnect_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateServiceWorkerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kServiceWorker_DispatchOnConnect_Name:
        if (message.isResponse())
          paramsClass = ServiceWorker_DispatchOnConnect_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ServiceWorker = {
    name: 'extensions.mojom.ServiceWorker',
    kVersion: 0,
    ptrClass: ServiceWorkerPtr,
    proxyClass: ServiceWorkerProxy,
    stubClass: ServiceWorkerStub,
    validateRequest: validateServiceWorkerRequest,
    validateResponse: validateServiceWorkerResponse,
  };
  ServiceWorkerStub.prototype.validator = validateServiceWorkerRequest;
  ServiceWorkerProxy.prototype.validator = validateServiceWorkerResponse;
  exports.ServiceWorker = ServiceWorker;
  exports.ServiceWorkerPtr = ServiceWorkerPtr;
  exports.ServiceWorkerAssociatedPtr = ServiceWorkerAssociatedPtr;
})();