// extensions/common/mojom/service_worker.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('extensions.mojom.ChannelType');
goog.require('extensions.mojom.MessagePort');
goog.require('extensions.mojom.MessagePortHost');
goog.require('extensions.mojom.ExternalConnectionInfo');
goog.require('extensions.mojom.PermissionSet');
goog.require('extensions.mojom.PortId');
goog.require('extensions.mojom.TabConnectionInfo');






goog.provide('extensions.mojom.ServiceWorker');
goog.provide('extensions.mojom.ServiceWorkerReceiver');
goog.provide('extensions.mojom.ServiceWorkerCallbackRouter');
goog.provide('extensions.mojom.ServiceWorkerInterface');
goog.provide('extensions.mojom.ServiceWorkerRemote');
goog.provide('extensions.mojom.ServiceWorkerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.ServiceWorkerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.ServiceWorker.$interfaceName,
        scope);
  }
};

/** @interface */
extensions.mojom.ServiceWorkerInterface = class {
  
  /**
   * @param { !extensions.mojom.PermissionSet } activePermissions
   * @param { !extensions.mojom.PermissionSet } withheldPermissions
   */

  updatePermissions(activePermissions, withheldPermissions) {}
  
  /**
   * @param { !extensions.mojom.PortId } portId
   * @param { !extensions.mojom.ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions.mojom.TabConnectionInfo } tabInfo
   * @param { !extensions.mojom.ExternalConnectionInfo } externalConnectionInfo
   * @param { !Object } port
   * @param { !Object } portHost
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  dispatchOnConnect(portId, channelType, channelName, tabInfo, externalConnectionInfo, port, portHost) {}
};

/**
 * @export
 * @implements { extensions.mojom.ServiceWorkerInterface }
 */
extensions.mojom.ServiceWorkerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.ServiceWorkerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.ServiceWorkerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.ServiceWorkerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !extensions.mojom.PermissionSet } activePermissions
   * @param { !extensions.mojom.PermissionSet } withheldPermissions
   */

  updatePermissions(
      activePermissions,
      withheldPermissions) {
    this.proxy.sendMessage(
        0,
        extensions.mojom.ServiceWorker_UpdatePermissions_ParamsSpec.$,
        null,
        [
          activePermissions,
          withheldPermissions
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.PortId } portId
   * @param { !extensions.mojom.ChannelType } channelType
   * @param { !string } channelName
   * @param { !extensions.mojom.TabConnectionInfo } tabInfo
   * @param { !extensions.mojom.ExternalConnectionInfo } externalConnectionInfo
   * @param { !Object } port
   * @param { !Object } portHost
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  dispatchOnConnect(
      portId,
      channelType,
      channelName,
      tabInfo,
      externalConnectionInfo,
      port,
      portHost) {
    return this.proxy.sendMessage(
        1,
        extensions.mojom.ServiceWorker_DispatchOnConnect_ParamsSpec.$,
        extensions.mojom.ServiceWorker_DispatchOnConnect_ResponseParamsSpec.$,
        [
          portId,
          channelType,
          channelName,
          tabInfo,
          externalConnectionInfo,
          port,
          portHost
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.ServiceWorkerReceiver = class {
  /**
   * @param {!extensions.mojom.ServiceWorkerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.ServiceWorkerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.ServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.ServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.ServiceWorker_UpdatePermissions_ParamsSpec.$,
        null,
        impl.updatePermissions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.ServiceWorker_DispatchOnConnect_ParamsSpec.$,
        extensions.mojom.ServiceWorker_DispatchOnConnect_ResponseParamsSpec.$,
        impl.dispatchOnConnect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.ServiceWorker = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.ServiceWorker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.ServiceWorkerRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.ServiceWorkerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.ServiceWorkerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.ServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.ServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updatePermissions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.ServiceWorker_UpdatePermissions_ParamsSpec.$,
        null,
        this.updatePermissions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchOnConnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.ServiceWorker_DispatchOnConnect_ParamsSpec.$,
        extensions.mojom.ServiceWorker_DispatchOnConnect_ResponseParamsSpec.$,
        this.dispatchOnConnect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('extensions.mojom.ServiceWorker_UpdatePermissions_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorker_UpdatePermissions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.ServiceWorker_DispatchOnConnect_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorker_DispatchOnConnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.ServiceWorker_DispatchOnConnect_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorker_DispatchOnConnect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    extensions.mojom.ServiceWorker_UpdatePermissions_ParamsSpec.$,
    'ServiceWorker_UpdatePermissions_Params',
    [
      mojo.internal.StructField(
        'activePermissions', 0,
        0,
        extensions.mojom.PermissionSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'withheldPermissions', 8,
        0,
        extensions.mojom.PermissionSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('extensions.mojom.ServiceWorker_UpdatePermissions_Params');

/** @record */
extensions.mojom.ServiceWorker_UpdatePermissions_Params = class {
  constructor() {
    /** @export { !extensions.mojom.PermissionSet } */
    this.activePermissions;
    /** @export { !extensions.mojom.PermissionSet } */
    this.withheldPermissions;
  }
};



mojo.internal.Struct(
    extensions.mojom.ServiceWorker_DispatchOnConnect_ParamsSpec.$,
    'ServiceWorker_DispatchOnConnect_Params',
    [
      mojo.internal.StructField(
        'portId', 0,
        0,
        extensions.mojom.PortIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelType', 8,
        0,
        extensions.mojom.ChannelTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'channelName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tabInfo', 24,
        0,
        extensions.mojom.TabConnectionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'externalConnectionInfo', 32,
        0,
        extensions.mojom.ExternalConnectionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'port', 12,
        0,
        mojo.internal.AssociatedInterfaceRequest(extensions.mojom.MessagePortPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portHost', 40,
        0,
        mojo.internal.AssociatedInterfaceProxy(extensions.mojom.MessagePortHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('extensions.mojom.ServiceWorker_DispatchOnConnect_Params');

/** @record */
extensions.mojom.ServiceWorker_DispatchOnConnect_Params = class {
  constructor() {
    /** @export { !extensions.mojom.PortId } */
    this.portId;
    /** @export { !extensions.mojom.ChannelType } */
    this.channelType;
    /** @export { !string } */
    this.channelName;
    /** @export { !extensions.mojom.TabConnectionInfo } */
    this.tabInfo;
    /** @export { !extensions.mojom.ExternalConnectionInfo } */
    this.externalConnectionInfo;
    /** @export { !Object } */
    this.port;
    /** @export { !Object } */
    this.portHost;
  }
};



mojo.internal.Struct(
    extensions.mojom.ServiceWorker_DispatchOnConnect_ResponseParamsSpec.$,
    'ServiceWorker_DispatchOnConnect_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('extensions.mojom.ServiceWorker_DispatchOnConnect_ResponseParams');

/** @record */
extensions.mojom.ServiceWorker_DispatchOnConnect_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};

