// extensions/common/mojom/renderer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  ReadOnlySharedMemoryRegion as mojoBase_mojom_ReadOnlySharedMemoryRegion,
  ReadOnlySharedMemoryRegionSpec as mojoBase_mojom_ReadOnlySharedMemoryRegionSpec
} from '../../../mojo/public/mojom/base/shared_memory.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  DictionaryValue as mojoBase_mojom_DictionaryValue,
  DictionaryValueSpec as mojoBase_mojom_DictionaryValueSpec
} from '../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  Channel as extensions_mojom_Channel,
  ChannelSpec as extensions_mojom_ChannelSpec
} from './channel.mojom.m.js';

import {
  ExtensionId as extensions_mojom_ExtensionId,
  ExtensionIdSpec as extensions_mojom_ExtensionIdSpec
} from './extension_id.mojom.m.js';

import {
  FeatureSessionType as extensions_mojom_FeatureSessionType,
  FeatureSessionTypeSpec as extensions_mojom_FeatureSessionTypeSpec
} from './feature_session_type.mojom.m.js';

import {
  HostID as extensions_mojom_HostID,
  HostIDSpec as extensions_mojom_HostIDSpec
} from './host_id.mojom.m.js';

import {
  ManifestLocation as extensions_mojom_ManifestLocation,
  ManifestLocationSpec as extensions_mojom_ManifestLocationSpec
} from './manifest.mojom.m.js';

import {
  PermissionSet as extensions_mojom_PermissionSet,
  PermissionSetSpec as extensions_mojom_PermissionSetSpec
} from './permission_set.mojom.m.js';

import {
  URLPatternSet as extensions_mojom_URLPatternSet,
  URLPatternSetSpec as extensions_mojom_URLPatternSetSpec
} from './url_pattern_set.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RendererPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.Renderer', scope);
  }
}

/** @interface */
export class RendererInterface {
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   */

  activateExtension(extensionId) {}
  
  /**
   * @param { !boolean } enabled
   */

  setActivityLoggingEnabled(enabled) {}
  
  /**
   * @param { !Array<!ExtensionLoadedParams> } params
   */

  loadExtensions(params) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   */

  unloadExtension(extensionId) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @return {!Promise}
   */

  suspendExtension(extensionId) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   */

  cancelSuspendExtension(extensionId) {}
  
  /**
   * @param { !boolean } developerModeOnly
   */

  setDeveloperMode(developerModeOnly) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !boolean } allowed
   */

  setUserScriptsAllowed(extensionId, allowed) {}
  
  /**
   * @param { !extensions_mojom_Channel } channel
   * @param { !extensions_mojom_FeatureSessionType } session
   */

  setSessionInfo(channel, session) {}
  
  /**
   * @param { !string } fontFamily
   * @param { !string } fontSize
   */

  setSystemFont(fontFamily, fontSize) {}
  
  /**
   * @param { !string } partitionId
   */

  setWebViewPartitionID(partitionId) {}
  
  /**
   * @param { !Array<!extensions_mojom_ExtensionId> } extensionIds
   */

  setScriptingAllowlist(extensionIds) {}
  
  /**
   * @param { !Array<!UserScriptWorldInfo> } infos
   */

  updateUserScriptWorlds(infos) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { ?string } worldId
   */

  clearUserScriptWorldConfig(extensionId, worldId) {}
  
  /**
   * @return {!Promise}
   */

  shouldSuspend() {}
  
  /**
   * @return {!Promise}
   */

  transferBlobs() {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !extensions_mojom_PermissionSet } activePermissions
   * @param { !extensions_mojom_PermissionSet } withheldPermissions
   * @param { !extensions_mojom_URLPatternSet } policyBlockedHosts
   * @param { !extensions_mojom_URLPatternSet } policyAllowedHosts
   * @param { !boolean } usesDefaultPolicyHostRestrictions
   */

  updatePermissions(extensionId, activePermissions, withheldPermissions, policyBlockedHosts, policyAllowedHosts, usesDefaultPolicyHostRestrictions) {}
  
  /**
   * @param { !extensions_mojom_URLPatternSet } defaultPolicyBlockedHosts
   * @param { !extensions_mojom_URLPatternSet } defaultPolicyAllowedHosts
   */

  updateDefaultPolicyHostRestrictions(defaultPolicyBlockedHosts, defaultPolicyAllowedHosts) {}
  
  /**
   * @param { !extensions_mojom_URLPatternSet } userBlockedHosts
   * @param { !extensions_mojom_URLPatternSet } userAllowedHosts
   */

  updateUserHostRestrictions(userBlockedHosts, userAllowedHosts) {}
  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !extensions_mojom_URLPatternSet } newHosts
   * @param { !number } tabId
   * @param { !boolean } updateOriginAllowlist
   */

  updateTabSpecificPermissions(extensionId, newHosts, tabId, updateOriginAllowlist) {}
  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } region
   * @param { !extensions_mojom_HostID } owner
   */

  updateUserScripts(region, owner) {}
  
  /**
   * @param { !Array<!extensions_mojom_ExtensionId> } extensionIds
   * @param { !number } tabId
   * @param { !boolean } updateOriginAllowlist
   */

  clearTabSpecificPermissions(extensionIds, tabId, updateOriginAllowlist) {}
  
  /**
   * @param { !Array<!string> } cssSelectors
   */

  watchPages(cssSelectors) {}
}

/**
 * @implements { RendererInterface }
 */
export class RendererRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RendererPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RendererPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RendererPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   */

  activateExtension(
      extensionId) {
    this.proxy.sendMessage(
        0,
        Renderer_ActivateExtension_ParamsSpec.$,
        null,
        [
          extensionId
        ],
        false);
  }

  
  /**
   * @param { !boolean } enabled
   */

  setActivityLoggingEnabled(
      enabled) {
    this.proxy.sendMessage(
        1,
        Renderer_SetActivityLoggingEnabled_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  
  /**
   * @param { !Array<!ExtensionLoadedParams> } params
   */

  loadExtensions(
      params) {
    this.proxy.sendMessage(
        2,
        Renderer_LoadExtensions_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   */

  unloadExtension(
      extensionId) {
    this.proxy.sendMessage(
        3,
        Renderer_UnloadExtension_ParamsSpec.$,
        null,
        [
          extensionId
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @return {!Promise}
   */

  suspendExtension(
      extensionId) {
    return this.proxy.sendMessage(
        4,
        Renderer_SuspendExtension_ParamsSpec.$,
        Renderer_SuspendExtension_ResponseParamsSpec.$,
        [
          extensionId
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   */

  cancelSuspendExtension(
      extensionId) {
    this.proxy.sendMessage(
        5,
        Renderer_CancelSuspendExtension_ParamsSpec.$,
        null,
        [
          extensionId
        ],
        false);
  }

  
  /**
   * @param { !boolean } developerModeOnly
   */

  setDeveloperMode(
      developerModeOnly) {
    this.proxy.sendMessage(
        6,
        Renderer_SetDeveloperMode_ParamsSpec.$,
        null,
        [
          developerModeOnly
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !boolean } allowed
   */

  setUserScriptsAllowed(
      extensionId,
      allowed) {
    this.proxy.sendMessage(
        7,
        Renderer_SetUserScriptsAllowed_ParamsSpec.$,
        null,
        [
          extensionId,
          allowed
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_Channel } channel
   * @param { !extensions_mojom_FeatureSessionType } session
   */

  setSessionInfo(
      channel,
      session) {
    this.proxy.sendMessage(
        8,
        Renderer_SetSessionInfo_ParamsSpec.$,
        null,
        [
          channel,
          session
        ],
        false);
  }

  
  /**
   * @param { !string } fontFamily
   * @param { !string } fontSize
   */

  setSystemFont(
      fontFamily,
      fontSize) {
    this.proxy.sendMessage(
        9,
        Renderer_SetSystemFont_ParamsSpec.$,
        null,
        [
          fontFamily,
          fontSize
        ],
        false);
  }

  
  /**
   * @param { !string } partitionId
   */

  setWebViewPartitionID(
      partitionId) {
    this.proxy.sendMessage(
        10,
        Renderer_SetWebViewPartitionID_ParamsSpec.$,
        null,
        [
          partitionId
        ],
        false);
  }

  
  /**
   * @param { !Array<!extensions_mojom_ExtensionId> } extensionIds
   */

  setScriptingAllowlist(
      extensionIds) {
    this.proxy.sendMessage(
        11,
        Renderer_SetScriptingAllowlist_ParamsSpec.$,
        null,
        [
          extensionIds
        ],
        false);
  }

  
  /**
   * @param { !Array<!UserScriptWorldInfo> } infos
   */

  updateUserScriptWorlds(
      infos) {
    this.proxy.sendMessage(
        12,
        Renderer_UpdateUserScriptWorlds_ParamsSpec.$,
        null,
        [
          infos
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { ?string } worldId
   */

  clearUserScriptWorldConfig(
      extensionId,
      worldId) {
    this.proxy.sendMessage(
        13,
        Renderer_ClearUserScriptWorldConfig_ParamsSpec.$,
        null,
        [
          extensionId,
          worldId
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  shouldSuspend() {
    return this.proxy.sendMessage(
        14,
        Renderer_ShouldSuspend_ParamsSpec.$,
        Renderer_ShouldSuspend_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  transferBlobs() {
    return this.proxy.sendMessage(
        15,
        Renderer_TransferBlobs_ParamsSpec.$,
        Renderer_TransferBlobs_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !extensions_mojom_PermissionSet } activePermissions
   * @param { !extensions_mojom_PermissionSet } withheldPermissions
   * @param { !extensions_mojom_URLPatternSet } policyBlockedHosts
   * @param { !extensions_mojom_URLPatternSet } policyAllowedHosts
   * @param { !boolean } usesDefaultPolicyHostRestrictions
   */

  updatePermissions(
      extensionId,
      activePermissions,
      withheldPermissions,
      policyBlockedHosts,
      policyAllowedHosts,
      usesDefaultPolicyHostRestrictions) {
    this.proxy.sendMessage(
        16,
        Renderer_UpdatePermissions_ParamsSpec.$,
        null,
        [
          extensionId,
          activePermissions,
          withheldPermissions,
          policyBlockedHosts,
          policyAllowedHosts,
          usesDefaultPolicyHostRestrictions
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_URLPatternSet } defaultPolicyBlockedHosts
   * @param { !extensions_mojom_URLPatternSet } defaultPolicyAllowedHosts
   */

  updateDefaultPolicyHostRestrictions(
      defaultPolicyBlockedHosts,
      defaultPolicyAllowedHosts) {
    this.proxy.sendMessage(
        17,
        Renderer_UpdateDefaultPolicyHostRestrictions_ParamsSpec.$,
        null,
        [
          defaultPolicyBlockedHosts,
          defaultPolicyAllowedHosts
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_URLPatternSet } userBlockedHosts
   * @param { !extensions_mojom_URLPatternSet } userAllowedHosts
   */

  updateUserHostRestrictions(
      userBlockedHosts,
      userAllowedHosts) {
    this.proxy.sendMessage(
        18,
        Renderer_UpdateUserHostRestrictions_ParamsSpec.$,
        null,
        [
          userBlockedHosts,
          userAllowedHosts
        ],
        false);
  }

  
  /**
   * @param { !extensions_mojom_ExtensionId } extensionId
   * @param { !extensions_mojom_URLPatternSet } newHosts
   * @param { !number } tabId
   * @param { !boolean } updateOriginAllowlist
   */

  updateTabSpecificPermissions(
      extensionId,
      newHosts,
      tabId,
      updateOriginAllowlist) {
    this.proxy.sendMessage(
        19,
        Renderer_UpdateTabSpecificPermissions_ParamsSpec.$,
        null,
        [
          extensionId,
          newHosts,
          tabId,
          updateOriginAllowlist
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } region
   * @param { !extensions_mojom_HostID } owner
   */

  updateUserScripts(
      region,
      owner) {
    this.proxy.sendMessage(
        20,
        Renderer_UpdateUserScripts_ParamsSpec.$,
        null,
        [
          region,
          owner
        ],
        false);
  }

  
  /**
   * @param { !Array<!extensions_mojom_ExtensionId> } extensionIds
   * @param { !number } tabId
   * @param { !boolean } updateOriginAllowlist
   */

  clearTabSpecificPermissions(
      extensionIds,
      tabId,
      updateOriginAllowlist) {
    this.proxy.sendMessage(
        21,
        Renderer_ClearTabSpecificPermissions_ParamsSpec.$,
        null,
        [
          extensionIds,
          tabId,
          updateOriginAllowlist
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } cssSelectors
   */

  watchPages(
      cssSelectors) {
    this.proxy.sendMessage(
        22,
        Renderer_WatchPages_ParamsSpec.$,
        null,
        [
          cssSelectors
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Renderer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RendererReceiver {
  /**
   * @param {!RendererInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RendererRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RendererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Renderer_ActivateExtension_ParamsSpec.$,
        null,
        impl.activateExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Renderer_SetActivityLoggingEnabled_ParamsSpec.$,
        null,
        impl.setActivityLoggingEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Renderer_LoadExtensions_ParamsSpec.$,
        null,
        impl.loadExtensions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Renderer_UnloadExtension_ParamsSpec.$,
        null,
        impl.unloadExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Renderer_SuspendExtension_ParamsSpec.$,
        Renderer_SuspendExtension_ResponseParamsSpec.$,
        impl.suspendExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Renderer_CancelSuspendExtension_ParamsSpec.$,
        null,
        impl.cancelSuspendExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Renderer_SetDeveloperMode_ParamsSpec.$,
        null,
        impl.setDeveloperMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Renderer_SetUserScriptsAllowed_ParamsSpec.$,
        null,
        impl.setUserScriptsAllowed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        Renderer_SetSessionInfo_ParamsSpec.$,
        null,
        impl.setSessionInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        Renderer_SetSystemFont_ParamsSpec.$,
        null,
        impl.setSystemFont.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        Renderer_SetWebViewPartitionID_ParamsSpec.$,
        null,
        impl.setWebViewPartitionID.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        Renderer_SetScriptingAllowlist_ParamsSpec.$,
        null,
        impl.setScriptingAllowlist.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        Renderer_UpdateUserScriptWorlds_ParamsSpec.$,
        null,
        impl.updateUserScriptWorlds.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        Renderer_ClearUserScriptWorldConfig_ParamsSpec.$,
        null,
        impl.clearUserScriptWorldConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        Renderer_ShouldSuspend_ParamsSpec.$,
        Renderer_ShouldSuspend_ResponseParamsSpec.$,
        impl.shouldSuspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        Renderer_TransferBlobs_ParamsSpec.$,
        Renderer_TransferBlobs_ResponseParamsSpec.$,
        impl.transferBlobs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        Renderer_UpdatePermissions_ParamsSpec.$,
        null,
        impl.updatePermissions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        Renderer_UpdateDefaultPolicyHostRestrictions_ParamsSpec.$,
        null,
        impl.updateDefaultPolicyHostRestrictions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        Renderer_UpdateUserHostRestrictions_ParamsSpec.$,
        null,
        impl.updateUserHostRestrictions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        Renderer_UpdateTabSpecificPermissions_ParamsSpec.$,
        null,
        impl.updateTabSpecificPermissions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        Renderer_UpdateUserScripts_ParamsSpec.$,
        null,
        impl.updateUserScripts.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        Renderer_ClearTabSpecificPermissions_ParamsSpec.$,
        null,
        impl.clearTabSpecificPermissions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        Renderer_WatchPages_ParamsSpec.$,
        null,
        impl.watchPages.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Renderer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.Renderer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RendererRemote}
   */
  static getRemote() {
    let remote = new RendererRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Renderer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RendererCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RendererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RendererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.activateExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Renderer_ActivateExtension_ParamsSpec.$,
        null,
        this.activateExtension.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setActivityLoggingEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Renderer_SetActivityLoggingEnabled_ParamsSpec.$,
        null,
        this.setActivityLoggingEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadExtensions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Renderer_LoadExtensions_ParamsSpec.$,
        null,
        this.loadExtensions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unloadExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Renderer_UnloadExtension_ParamsSpec.$,
        null,
        this.unloadExtension.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspendExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Renderer_SuspendExtension_ParamsSpec.$,
        Renderer_SuspendExtension_ResponseParamsSpec.$,
        this.suspendExtension.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelSuspendExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Renderer_CancelSuspendExtension_ParamsSpec.$,
        null,
        this.cancelSuspendExtension.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setDeveloperMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Renderer_SetDeveloperMode_ParamsSpec.$,
        null,
        this.setDeveloperMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setUserScriptsAllowed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Renderer_SetUserScriptsAllowed_ParamsSpec.$,
        null,
        this.setUserScriptsAllowed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSessionInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        Renderer_SetSessionInfo_ParamsSpec.$,
        null,
        this.setSessionInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSystemFont =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        Renderer_SetSystemFont_ParamsSpec.$,
        null,
        this.setSystemFont.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setWebViewPartitionID =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        Renderer_SetWebViewPartitionID_ParamsSpec.$,
        null,
        this.setWebViewPartitionID.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setScriptingAllowlist =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        Renderer_SetScriptingAllowlist_ParamsSpec.$,
        null,
        this.setScriptingAllowlist.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUserScriptWorlds =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        Renderer_UpdateUserScriptWorlds_ParamsSpec.$,
        null,
        this.updateUserScriptWorlds.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearUserScriptWorldConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        Renderer_ClearUserScriptWorldConfig_ParamsSpec.$,
        null,
        this.clearUserScriptWorldConfig.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.shouldSuspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        Renderer_ShouldSuspend_ParamsSpec.$,
        Renderer_ShouldSuspend_ResponseParamsSpec.$,
        this.shouldSuspend.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.transferBlobs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        Renderer_TransferBlobs_ParamsSpec.$,
        Renderer_TransferBlobs_ResponseParamsSpec.$,
        this.transferBlobs.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updatePermissions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        Renderer_UpdatePermissions_ParamsSpec.$,
        null,
        this.updatePermissions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateDefaultPolicyHostRestrictions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        Renderer_UpdateDefaultPolicyHostRestrictions_ParamsSpec.$,
        null,
        this.updateDefaultPolicyHostRestrictions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUserHostRestrictions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        Renderer_UpdateUserHostRestrictions_ParamsSpec.$,
        null,
        this.updateUserHostRestrictions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTabSpecificPermissions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        Renderer_UpdateTabSpecificPermissions_ParamsSpec.$,
        null,
        this.updateTabSpecificPermissions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUserScripts =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        Renderer_UpdateUserScripts_ParamsSpec.$,
        null,
        this.updateUserScripts.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearTabSpecificPermissions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        Renderer_ClearTabSpecificPermissions_ParamsSpec.$,
        null,
        this.clearTabSpecificPermissions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.watchPages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        Renderer_WatchPages_ParamsSpec.$,
        null,
        this.watchPages.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ExtensionLoadedParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UserScriptWorldInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_ActivateExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetActivityLoggingEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_LoadExtensions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_UnloadExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SuspendExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SuspendExtension_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_CancelSuspendExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetDeveloperMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetUserScriptsAllowed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetSessionInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetSystemFont_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetWebViewPartitionID_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_SetScriptingAllowlist_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_UpdateUserScriptWorlds_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_ClearUserScriptWorldConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_ShouldSuspend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_ShouldSuspend_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_TransferBlobs_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_TransferBlobs_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_UpdatePermissions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_UpdateDefaultPolicyHostRestrictions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_UpdateUserHostRestrictions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_UpdateTabSpecificPermissions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_UpdateUserScripts_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_ClearTabSpecificPermissions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Renderer_WatchPages_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ExtensionLoadedParamsSpec.$,
    'ExtensionLoadedParams',
    [
      mojo.internal.StructField(
        'manifest', 0,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'location', 8,
        0,
        extensions_mojom_ManifestLocationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'path', 16,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'activePermissions', 24,
        0,
        extensions_mojom_PermissionSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'withheldPermissions', 32,
        0,
        extensions_mojom_PermissionSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tabSpecificPermissions', 40,
        0,
        mojo.internal.Map(mojo.internal.Int32, extensions_mojom_PermissionSetSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'policyBlockedHosts', 48,
        0,
        extensions_mojom_URLPatternSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'policyAllowedHosts', 56,
        0,
        extensions_mojom_URLPatternSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usesDefaultPolicyBlockedAllowedHosts', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userScriptsAllowed', 12,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'workerActivationToken', 72,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'creationFlags', 80,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'guid', 88,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 104],]);



/**
 * @record
 */
export class ExtensionLoadedParams {
  constructor() {
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.manifest;
    /** @type { !extensions_mojom_ManifestLocation } */
    this.location;
    /** @type { !mojoBase_mojom_FilePath } */
    this.path;
    /** @type { !extensions_mojom_PermissionSet } */
    this.activePermissions;
    /** @type { !extensions_mojom_PermissionSet } */
    this.withheldPermissions;
    /** @type { !Object<!number, !extensions_mojom_PermissionSet> } */
    this.tabSpecificPermissions;
    /** @type { !extensions_mojom_URLPatternSet } */
    this.policyBlockedHosts;
    /** @type { !extensions_mojom_URLPatternSet } */
    this.policyAllowedHosts;
    /** @type { !boolean } */
    this.usesDefaultPolicyBlockedAllowedHosts;
    /** @type { !boolean } */
    this.userScriptsAllowed;
    /** @type { !string } */
    this.id;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.workerActivationToken;
    /** @type { !number } */
    this.creationFlags;
    /** @type { !string } */
    this.guid;
  }
}



mojo.internal.Struct(
    UserScriptWorldInfoSpec.$,
    'UserScriptWorldInfo',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'worldId', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'csp', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableMessaging', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class UserScriptWorldInfo {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { (string|undefined) } */
    this.worldId;
    /** @type { (string|undefined) } */
    this.csp;
    /** @type { !boolean } */
    this.enableMessaging;
  }
}



mojo.internal.Struct(
    Renderer_ActivateExtension_ParamsSpec.$,
    'Renderer_ActivateExtension_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_ActivateExtension_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
  }
}



mojo.internal.Struct(
    Renderer_SetActivityLoggingEnabled_ParamsSpec.$,
    'Renderer_SetActivityLoggingEnabled_Params',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_SetActivityLoggingEnabled_Params {
  constructor() {
    /** @type { !boolean } */
    this.enabled;
  }
}



mojo.internal.Struct(
    Renderer_LoadExtensions_ParamsSpec.$,
    'Renderer_LoadExtensions_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        mojo.internal.Array(ExtensionLoadedParamsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_LoadExtensions_Params {
  constructor() {
    /** @type { !Array<!ExtensionLoadedParams> } */
    this.params;
  }
}



mojo.internal.Struct(
    Renderer_UnloadExtension_ParamsSpec.$,
    'Renderer_UnloadExtension_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_UnloadExtension_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
  }
}



mojo.internal.Struct(
    Renderer_SuspendExtension_ParamsSpec.$,
    'Renderer_SuspendExtension_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_SuspendExtension_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
  }
}



mojo.internal.Struct(
    Renderer_SuspendExtension_ResponseParamsSpec.$,
    'Renderer_SuspendExtension_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Renderer_SuspendExtension_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    Renderer_CancelSuspendExtension_ParamsSpec.$,
    'Renderer_CancelSuspendExtension_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_CancelSuspendExtension_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
  }
}



mojo.internal.Struct(
    Renderer_SetDeveloperMode_ParamsSpec.$,
    'Renderer_SetDeveloperMode_Params',
    [
      mojo.internal.StructField(
        'developerModeOnly', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_SetDeveloperMode_Params {
  constructor() {
    /** @type { !boolean } */
    this.developerModeOnly;
  }
}



mojo.internal.Struct(
    Renderer_SetUserScriptsAllowed_ParamsSpec.$,
    'Renderer_SetUserScriptsAllowed_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowed', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Renderer_SetUserScriptsAllowed_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !boolean } */
    this.allowed;
  }
}



mojo.internal.Struct(
    Renderer_SetSessionInfo_ParamsSpec.$,
    'Renderer_SetSessionInfo_Params',
    [
      mojo.internal.StructField(
        'channel', 0,
        0,
        extensions_mojom_ChannelSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'session', 4,
        0,
        extensions_mojom_FeatureSessionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_SetSessionInfo_Params {
  constructor() {
    /** @type { !extensions_mojom_Channel } */
    this.channel;
    /** @type { !extensions_mojom_FeatureSessionType } */
    this.session;
  }
}



mojo.internal.Struct(
    Renderer_SetSystemFont_ParamsSpec.$,
    'Renderer_SetSystemFont_Params',
    [
      mojo.internal.StructField(
        'fontFamily', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fontSize', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Renderer_SetSystemFont_Params {
  constructor() {
    /** @type { !string } */
    this.fontFamily;
    /** @type { !string } */
    this.fontSize;
  }
}



mojo.internal.Struct(
    Renderer_SetWebViewPartitionID_ParamsSpec.$,
    'Renderer_SetWebViewPartitionID_Params',
    [
      mojo.internal.StructField(
        'partitionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_SetWebViewPartitionID_Params {
  constructor() {
    /** @type { !string } */
    this.partitionId;
  }
}



mojo.internal.Struct(
    Renderer_SetScriptingAllowlist_ParamsSpec.$,
    'Renderer_SetScriptingAllowlist_Params',
    [
      mojo.internal.StructField(
        'extensionIds', 0,
        0,
        mojo.internal.Array(extensions_mojom_ExtensionIdSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_SetScriptingAllowlist_Params {
  constructor() {
    /** @type { !Array<!extensions_mojom_ExtensionId> } */
    this.extensionIds;
  }
}



mojo.internal.Struct(
    Renderer_UpdateUserScriptWorlds_ParamsSpec.$,
    'Renderer_UpdateUserScriptWorlds_Params',
    [
      mojo.internal.StructField(
        'infos', 0,
        0,
        mojo.internal.Array(UserScriptWorldInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_UpdateUserScriptWorlds_Params {
  constructor() {
    /** @type { !Array<!UserScriptWorldInfo> } */
    this.infos;
  }
}



mojo.internal.Struct(
    Renderer_ClearUserScriptWorldConfig_ParamsSpec.$,
    'Renderer_ClearUserScriptWorldConfig_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'worldId', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Renderer_ClearUserScriptWorldConfig_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { (string|undefined) } */
    this.worldId;
  }
}



mojo.internal.Struct(
    Renderer_ShouldSuspend_ParamsSpec.$,
    'Renderer_ShouldSuspend_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Renderer_ShouldSuspend_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Renderer_ShouldSuspend_ResponseParamsSpec.$,
    'Renderer_ShouldSuspend_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Renderer_ShouldSuspend_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    Renderer_TransferBlobs_ParamsSpec.$,
    'Renderer_TransferBlobs_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Renderer_TransferBlobs_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Renderer_TransferBlobs_ResponseParamsSpec.$,
    'Renderer_TransferBlobs_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Renderer_TransferBlobs_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    Renderer_UpdatePermissions_ParamsSpec.$,
    'Renderer_UpdatePermissions_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'activePermissions', 8,
        0,
        extensions_mojom_PermissionSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'withheldPermissions', 16,
        0,
        extensions_mojom_PermissionSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'policyBlockedHosts', 24,
        0,
        extensions_mojom_URLPatternSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'policyAllowedHosts', 32,
        0,
        extensions_mojom_URLPatternSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usesDefaultPolicyHostRestrictions', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class Renderer_UpdatePermissions_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !extensions_mojom_PermissionSet } */
    this.activePermissions;
    /** @type { !extensions_mojom_PermissionSet } */
    this.withheldPermissions;
    /** @type { !extensions_mojom_URLPatternSet } */
    this.policyBlockedHosts;
    /** @type { !extensions_mojom_URLPatternSet } */
    this.policyAllowedHosts;
    /** @type { !boolean } */
    this.usesDefaultPolicyHostRestrictions;
  }
}



mojo.internal.Struct(
    Renderer_UpdateDefaultPolicyHostRestrictions_ParamsSpec.$,
    'Renderer_UpdateDefaultPolicyHostRestrictions_Params',
    [
      mojo.internal.StructField(
        'defaultPolicyBlockedHosts', 0,
        0,
        extensions_mojom_URLPatternSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'defaultPolicyAllowedHosts', 8,
        0,
        extensions_mojom_URLPatternSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Renderer_UpdateDefaultPolicyHostRestrictions_Params {
  constructor() {
    /** @type { !extensions_mojom_URLPatternSet } */
    this.defaultPolicyBlockedHosts;
    /** @type { !extensions_mojom_URLPatternSet } */
    this.defaultPolicyAllowedHosts;
  }
}



mojo.internal.Struct(
    Renderer_UpdateUserHostRestrictions_ParamsSpec.$,
    'Renderer_UpdateUserHostRestrictions_Params',
    [
      mojo.internal.StructField(
        'userBlockedHosts', 0,
        0,
        extensions_mojom_URLPatternSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userAllowedHosts', 8,
        0,
        extensions_mojom_URLPatternSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Renderer_UpdateUserHostRestrictions_Params {
  constructor() {
    /** @type { !extensions_mojom_URLPatternSet } */
    this.userBlockedHosts;
    /** @type { !extensions_mojom_URLPatternSet } */
    this.userAllowedHosts;
  }
}



mojo.internal.Struct(
    Renderer_UpdateTabSpecificPermissions_ParamsSpec.$,
    'Renderer_UpdateTabSpecificPermissions_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions_mojom_ExtensionIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newHosts', 8,
        0,
        extensions_mojom_URLPatternSetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tabId', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updateOriginAllowlist', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class Renderer_UpdateTabSpecificPermissions_Params {
  constructor() {
    /** @type { !extensions_mojom_ExtensionId } */
    this.extensionId;
    /** @type { !extensions_mojom_URLPatternSet } */
    this.newHosts;
    /** @type { !number } */
    this.tabId;
    /** @type { !boolean } */
    this.updateOriginAllowlist;
  }
}



mojo.internal.Struct(
    Renderer_UpdateUserScripts_ParamsSpec.$,
    'Renderer_UpdateUserScripts_Params',
    [
      mojo.internal.StructField(
        'region', 0,
        0,
        mojoBase_mojom_ReadOnlySharedMemoryRegionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'owner', 8,
        0,
        extensions_mojom_HostIDSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Renderer_UpdateUserScripts_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlySharedMemoryRegion } */
    this.region;
    /** @type { !extensions_mojom_HostID } */
    this.owner;
  }
}



mojo.internal.Struct(
    Renderer_ClearTabSpecificPermissions_ParamsSpec.$,
    'Renderer_ClearTabSpecificPermissions_Params',
    [
      mojo.internal.StructField(
        'extensionIds', 0,
        0,
        mojo.internal.Array(extensions_mojom_ExtensionIdSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tabId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updateOriginAllowlist', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Renderer_ClearTabSpecificPermissions_Params {
  constructor() {
    /** @type { !Array<!extensions_mojom_ExtensionId> } */
    this.extensionIds;
    /** @type { !number } */
    this.tabId;
    /** @type { !boolean } */
    this.updateOriginAllowlist;
  }
}



mojo.internal.Struct(
    Renderer_WatchPages_ParamsSpec.$,
    'Renderer_WatchPages_Params',
    [
      mojo.internal.StructField(
        'cssSelectors', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Renderer_WatchPages_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.cssSelectors;
  }
}

