// extensions/common/mojom/renderer.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_PARAMS_DATA_H_
#define EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace extensions::mojom {
namespace internal {
class  Renderer_ActivateExtension_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::extensions::mojom::internal::ExtensionId_Data> extension_id;

 private:
  friend class mojo::internal::MessageFragment<Renderer_ActivateExtension_Params_Data>;

  Renderer_ActivateExtension_Params_Data();
  ~Renderer_ActivateExtension_Params_Data() = delete;
};
static_assert(sizeof(Renderer_ActivateExtension_Params_Data) == 16,
              "Bad sizeof(Renderer_ActivateExtension_Params_Data)");
class  Renderer_SetActivityLoggingEnabled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enabled : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetActivityLoggingEnabled_Params_Data>;

  Renderer_SetActivityLoggingEnabled_Params_Data();
  ~Renderer_SetActivityLoggingEnabled_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetActivityLoggingEnabled_Params_Data) == 16,
              "Bad sizeof(Renderer_SetActivityLoggingEnabled_Params_Data)");
class  Renderer_LoadExtensions_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ExtensionLoadedParams_Data>>> params;

 private:
  friend class mojo::internal::MessageFragment<Renderer_LoadExtensions_Params_Data>;

  Renderer_LoadExtensions_Params_Data();
  ~Renderer_LoadExtensions_Params_Data() = delete;
};
static_assert(sizeof(Renderer_LoadExtensions_Params_Data) == 16,
              "Bad sizeof(Renderer_LoadExtensions_Params_Data)");
class  Renderer_UnloadExtension_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::extensions::mojom::internal::ExtensionId_Data> extension_id;

 private:
  friend class mojo::internal::MessageFragment<Renderer_UnloadExtension_Params_Data>;

  Renderer_UnloadExtension_Params_Data();
  ~Renderer_UnloadExtension_Params_Data() = delete;
};
static_assert(sizeof(Renderer_UnloadExtension_Params_Data) == 16,
              "Bad sizeof(Renderer_UnloadExtension_Params_Data)");
class  Renderer_SuspendExtension_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::extensions::mojom::internal::ExtensionId_Data> extension_id;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SuspendExtension_Params_Data>;

  Renderer_SuspendExtension_Params_Data();
  ~Renderer_SuspendExtension_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SuspendExtension_Params_Data) == 16,
              "Bad sizeof(Renderer_SuspendExtension_Params_Data)");
class  Renderer_SuspendExtension_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SuspendExtension_ResponseParams_Data>;

  Renderer_SuspendExtension_ResponseParams_Data();
  ~Renderer_SuspendExtension_ResponseParams_Data() = delete;
};
static_assert(sizeof(Renderer_SuspendExtension_ResponseParams_Data) == 8,
              "Bad sizeof(Renderer_SuspendExtension_ResponseParams_Data)");
class  Renderer_CancelSuspendExtension_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::extensions::mojom::internal::ExtensionId_Data> extension_id;

 private:
  friend class mojo::internal::MessageFragment<Renderer_CancelSuspendExtension_Params_Data>;

  Renderer_CancelSuspendExtension_Params_Data();
  ~Renderer_CancelSuspendExtension_Params_Data() = delete;
};
static_assert(sizeof(Renderer_CancelSuspendExtension_Params_Data) == 16,
              "Bad sizeof(Renderer_CancelSuspendExtension_Params_Data)");
class  Renderer_SetDeveloperMode_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t developer_mode_only : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetDeveloperMode_Params_Data>;

  Renderer_SetDeveloperMode_Params_Data();
  ~Renderer_SetDeveloperMode_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetDeveloperMode_Params_Data) == 16,
              "Bad sizeof(Renderer_SetDeveloperMode_Params_Data)");
class  Renderer_SetUserScriptsAllowed_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::extensions::mojom::internal::ExtensionId_Data> extension_id;
  uint8_t allowed : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetUserScriptsAllowed_Params_Data>;

  Renderer_SetUserScriptsAllowed_Params_Data();
  ~Renderer_SetUserScriptsAllowed_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetUserScriptsAllowed_Params_Data) == 24,
              "Bad sizeof(Renderer_SetUserScriptsAllowed_Params_Data)");
class  Renderer_SetSessionInfo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t channel;
  int32_t session;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetSessionInfo_Params_Data>;

  Renderer_SetSessionInfo_Params_Data();
  ~Renderer_SetSessionInfo_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetSessionInfo_Params_Data) == 16,
              "Bad sizeof(Renderer_SetSessionInfo_Params_Data)");
class  Renderer_SetSystemFont_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> font_family;
  mojo::internal::Pointer<mojo::internal::String_Data> font_size;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetSystemFont_Params_Data>;

  Renderer_SetSystemFont_Params_Data();
  ~Renderer_SetSystemFont_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetSystemFont_Params_Data) == 24,
              "Bad sizeof(Renderer_SetSystemFont_Params_Data)");
class  Renderer_SetWebViewPartitionID_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> partition_id;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetWebViewPartitionID_Params_Data>;

  Renderer_SetWebViewPartitionID_Params_Data();
  ~Renderer_SetWebViewPartitionID_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetWebViewPartitionID_Params_Data) == 16,
              "Bad sizeof(Renderer_SetWebViewPartitionID_Params_Data)");
class  Renderer_SetScriptingAllowlist_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::extensions::mojom::internal::ExtensionId_Data>>> extension_ids;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetScriptingAllowlist_Params_Data>;

  Renderer_SetScriptingAllowlist_Params_Data();
  ~Renderer_SetScriptingAllowlist_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetScriptingAllowlist_Params_Data) == 16,
              "Bad sizeof(Renderer_SetScriptingAllowlist_Params_Data)");
class  Renderer_UpdateUserScriptWorlds_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::UserScriptWorldInfo_Data>>> infos;

 private:
  friend class mojo::internal::MessageFragment<Renderer_UpdateUserScriptWorlds_Params_Data>;

  Renderer_UpdateUserScriptWorlds_Params_Data();
  ~Renderer_UpdateUserScriptWorlds_Params_Data() = delete;
};
static_assert(sizeof(Renderer_UpdateUserScriptWorlds_Params_Data) == 16,
              "Bad sizeof(Renderer_UpdateUserScriptWorlds_Params_Data)");
class  Renderer_ClearUserScriptWorldConfig_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::extensions::mojom::internal::ExtensionId_Data> extension_id;
  mojo::internal::Pointer<mojo::internal::String_Data> world_id;

 private:
  friend class mojo::internal::MessageFragment<Renderer_ClearUserScriptWorldConfig_Params_Data>;

  Renderer_ClearUserScriptWorldConfig_Params_Data();
  ~Renderer_ClearUserScriptWorldConfig_Params_Data() = delete;
};
static_assert(sizeof(Renderer_ClearUserScriptWorldConfig_Params_Data) == 24,
              "Bad sizeof(Renderer_ClearUserScriptWorldConfig_Params_Data)");
class  Renderer_ShouldSuspend_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Renderer_ShouldSuspend_Params_Data>;

  Renderer_ShouldSuspend_Params_Data();
  ~Renderer_ShouldSuspend_Params_Data() = delete;
};
static_assert(sizeof(Renderer_ShouldSuspend_Params_Data) == 8,
              "Bad sizeof(Renderer_ShouldSuspend_Params_Data)");
class  Renderer_ShouldSuspend_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Renderer_ShouldSuspend_ResponseParams_Data>;

  Renderer_ShouldSuspend_ResponseParams_Data();
  ~Renderer_ShouldSuspend_ResponseParams_Data() = delete;
};
static_assert(sizeof(Renderer_ShouldSuspend_ResponseParams_Data) == 8,
              "Bad sizeof(Renderer_ShouldSuspend_ResponseParams_Data)");
class  Renderer_TransferBlobs_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Renderer_TransferBlobs_Params_Data>;

  Renderer_TransferBlobs_Params_Data();
  ~Renderer_TransferBlobs_Params_Data() = delete;
};
static_assert(sizeof(Renderer_TransferBlobs_Params_Data) == 8,
              "Bad sizeof(Renderer_TransferBlobs_Params_Data)");
class  Renderer_TransferBlobs_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Renderer_TransferBlobs_ResponseParams_Data>;

  Renderer_TransferBlobs_ResponseParams_Data();
  ~Renderer_TransferBlobs_ResponseParams_Data() = delete;
};
static_assert(sizeof(Renderer_TransferBlobs_ResponseParams_Data) == 8,
              "Bad sizeof(Renderer_TransferBlobs_ResponseParams_Data)");
class  Renderer_UpdatePermissions_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::extensions::mojom::internal::ExtensionId_Data> extension_id;
  mojo::internal::Pointer<::extensions::mojom::internal::PermissionSet_Data> active_permissions;
  mojo::internal::Pointer<::extensions::mojom::internal::PermissionSet_Data> withheld_permissions;
  mojo::internal::Pointer<::extensions::mojom::internal::URLPatternSet_Data> policy_blocked_hosts;
  mojo::internal::Pointer<::extensions::mojom::internal::URLPatternSet_Data> policy_allowed_hosts;
  uint8_t uses_default_policy_host_restrictions : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Renderer_UpdatePermissions_Params_Data>;

  Renderer_UpdatePermissions_Params_Data();
  ~Renderer_UpdatePermissions_Params_Data() = delete;
};
static_assert(sizeof(Renderer_UpdatePermissions_Params_Data) == 56,
              "Bad sizeof(Renderer_UpdatePermissions_Params_Data)");
class  Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::extensions::mojom::internal::URLPatternSet_Data> default_policy_blocked_hosts;
  mojo::internal::Pointer<::extensions::mojom::internal::URLPatternSet_Data> default_policy_allowed_hosts;

 private:
  friend class mojo::internal::MessageFragment<Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data>;

  Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data();
  ~Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data() = delete;
};
static_assert(sizeof(Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data) == 24,
              "Bad sizeof(Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data)");
class  Renderer_UpdateUserHostRestrictions_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::extensions::mojom::internal::URLPatternSet_Data> user_blocked_hosts;
  mojo::internal::Pointer<::extensions::mojom::internal::URLPatternSet_Data> user_allowed_hosts;

 private:
  friend class mojo::internal::MessageFragment<Renderer_UpdateUserHostRestrictions_Params_Data>;

  Renderer_UpdateUserHostRestrictions_Params_Data();
  ~Renderer_UpdateUserHostRestrictions_Params_Data() = delete;
};
static_assert(sizeof(Renderer_UpdateUserHostRestrictions_Params_Data) == 24,
              "Bad sizeof(Renderer_UpdateUserHostRestrictions_Params_Data)");
class  Renderer_UpdateTabSpecificPermissions_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::extensions::mojom::internal::ExtensionId_Data> extension_id;
  mojo::internal::Pointer<::extensions::mojom::internal::URLPatternSet_Data> new_hosts;
  int32_t tab_id;
  uint8_t update_origin_allowlist : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<Renderer_UpdateTabSpecificPermissions_Params_Data>;

  Renderer_UpdateTabSpecificPermissions_Params_Data();
  ~Renderer_UpdateTabSpecificPermissions_Params_Data() = delete;
};
static_assert(sizeof(Renderer_UpdateTabSpecificPermissions_Params_Data) == 32,
              "Bad sizeof(Renderer_UpdateTabSpecificPermissions_Params_Data)");
class  Renderer_UpdateUserScripts_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> region;
  mojo::internal::Pointer<::extensions::mojom::internal::HostID_Data> owner;

 private:
  friend class mojo::internal::MessageFragment<Renderer_UpdateUserScripts_Params_Data>;

  Renderer_UpdateUserScripts_Params_Data();
  ~Renderer_UpdateUserScripts_Params_Data() = delete;
};
static_assert(sizeof(Renderer_UpdateUserScripts_Params_Data) == 24,
              "Bad sizeof(Renderer_UpdateUserScripts_Params_Data)");
class  Renderer_ClearTabSpecificPermissions_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::extensions::mojom::internal::ExtensionId_Data>>> extension_ids;
  int32_t tab_id;
  uint8_t update_origin_allowlist : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<Renderer_ClearTabSpecificPermissions_Params_Data>;

  Renderer_ClearTabSpecificPermissions_Params_Data();
  ~Renderer_ClearTabSpecificPermissions_Params_Data() = delete;
};
static_assert(sizeof(Renderer_ClearTabSpecificPermissions_Params_Data) == 24,
              "Bad sizeof(Renderer_ClearTabSpecificPermissions_Params_Data)");
class  Renderer_WatchPages_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> css_selectors;

 private:
  friend class mojo::internal::MessageFragment<Renderer_WatchPages_Params_Data>;

  Renderer_WatchPages_Params_Data();
  ~Renderer_WatchPages_Params_Data() = delete;
};
static_assert(sizeof(Renderer_WatchPages_Params_Data) == 16,
              "Bad sizeof(Renderer_WatchPages_Params_Data)");

}  // namespace internal


class Renderer_ActivateExtension_ParamsDataView {
 public:
  Renderer_ActivateExtension_ParamsDataView() = default;

  Renderer_ActivateExtension_ParamsDataView(
      internal::Renderer_ActivateExtension_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdDataView(
      ::extensions::mojom::ExtensionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::ExtensionIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_ActivateExtension_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_SetActivityLoggingEnabled_ParamsDataView {
 public:
  Renderer_SetActivityLoggingEnabled_ParamsDataView() = default;

  Renderer_SetActivityLoggingEnabled_ParamsDataView(
      internal::Renderer_SetActivityLoggingEnabled_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enabled() const {
    return data_->enabled;
  }
 private:
  internal::Renderer_SetActivityLoggingEnabled_Params_Data* data_ = nullptr;
};


class Renderer_LoadExtensions_ParamsDataView {
 public:
  Renderer_LoadExtensions_ParamsDataView() = default;

  Renderer_LoadExtensions_ParamsDataView(
      internal::Renderer_LoadExtensions_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      mojo::ArrayDataView<ExtensionLoadedParamsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::extensions::mojom::ExtensionLoadedParamsDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_LoadExtensions_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_UnloadExtension_ParamsDataView {
 public:
  Renderer_UnloadExtension_ParamsDataView() = default;

  Renderer_UnloadExtension_ParamsDataView(
      internal::Renderer_UnloadExtension_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdDataView(
      ::extensions::mojom::ExtensionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::ExtensionIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_UnloadExtension_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_SuspendExtension_ParamsDataView {
 public:
  Renderer_SuspendExtension_ParamsDataView() = default;

  Renderer_SuspendExtension_ParamsDataView(
      internal::Renderer_SuspendExtension_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdDataView(
      ::extensions::mojom::ExtensionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::ExtensionIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_SuspendExtension_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_SuspendExtension_ResponseParamsDataView {
 public:
  Renderer_SuspendExtension_ResponseParamsDataView() = default;

  Renderer_SuspendExtension_ResponseParamsDataView(
      internal::Renderer_SuspendExtension_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Renderer_SuspendExtension_ResponseParams_Data* data_ = nullptr;
};


class Renderer_CancelSuspendExtension_ParamsDataView {
 public:
  Renderer_CancelSuspendExtension_ParamsDataView() = default;

  Renderer_CancelSuspendExtension_ParamsDataView(
      internal::Renderer_CancelSuspendExtension_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdDataView(
      ::extensions::mojom::ExtensionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::ExtensionIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_CancelSuspendExtension_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_SetDeveloperMode_ParamsDataView {
 public:
  Renderer_SetDeveloperMode_ParamsDataView() = default;

  Renderer_SetDeveloperMode_ParamsDataView(
      internal::Renderer_SetDeveloperMode_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool developer_mode_only() const {
    return data_->developer_mode_only;
  }
 private:
  internal::Renderer_SetDeveloperMode_Params_Data* data_ = nullptr;
};


class Renderer_SetUserScriptsAllowed_ParamsDataView {
 public:
  Renderer_SetUserScriptsAllowed_ParamsDataView() = default;

  Renderer_SetUserScriptsAllowed_ParamsDataView(
      internal::Renderer_SetUserScriptsAllowed_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdDataView(
      ::extensions::mojom::ExtensionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::ExtensionIdDataView>(
        pointer, output, message_);
  }
  bool allowed() const {
    return data_->allowed;
  }
 private:
  internal::Renderer_SetUserScriptsAllowed_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_SetSessionInfo_ParamsDataView {
 public:
  Renderer_SetSessionInfo_ParamsDataView() = default;

  Renderer_SetSessionInfo_ParamsDataView(
      internal::Renderer_SetSessionInfo_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadChannel(UserType* output) const {
    auto data_value = data_->channel;
    return mojo::internal::Deserialize<::extensions::mojom::Channel>(
        data_value, output);
  }
  ::extensions::mojom::Channel channel() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::Channel>(data_->channel));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSession(UserType* output) const {
    auto data_value = data_->session;
    return mojo::internal::Deserialize<::extensions::mojom::FeatureSessionType>(
        data_value, output);
  }
  ::extensions::mojom::FeatureSessionType session() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::FeatureSessionType>(data_->session));
  }
 private:
  internal::Renderer_SetSessionInfo_Params_Data* data_ = nullptr;
};


class Renderer_SetSystemFont_ParamsDataView {
 public:
  Renderer_SetSystemFont_ParamsDataView() = default;

  Renderer_SetSystemFont_ParamsDataView(
      internal::Renderer_SetSystemFont_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFontFamilyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFontFamily(UserType* output) {
    
    auto* pointer = data_->font_family.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFontSizeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFontSize(UserType* output) {
    
    auto* pointer = data_->font_size.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_SetSystemFont_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_SetWebViewPartitionID_ParamsDataView {
 public:
  Renderer_SetWebViewPartitionID_ParamsDataView() = default;

  Renderer_SetWebViewPartitionID_ParamsDataView(
      internal::Renderer_SetWebViewPartitionID_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPartitionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPartitionId(UserType* output) {
    
    auto* pointer = data_->partition_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_SetWebViewPartitionID_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_SetScriptingAllowlist_ParamsDataView {
 public:
  Renderer_SetScriptingAllowlist_ParamsDataView() = default;

  Renderer_SetScriptingAllowlist_ParamsDataView(
      internal::Renderer_SetScriptingAllowlist_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdsDataView(
      mojo::ArrayDataView<::extensions::mojom::ExtensionIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionIds(UserType* output) {
    
    auto* pointer = data_->extension_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::extensions::mojom::ExtensionIdDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_SetScriptingAllowlist_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_UpdateUserScriptWorlds_ParamsDataView {
 public:
  Renderer_UpdateUserScriptWorlds_ParamsDataView() = default;

  Renderer_UpdateUserScriptWorlds_ParamsDataView(
      internal::Renderer_UpdateUserScriptWorlds_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfosDataView(
      mojo::ArrayDataView<UserScriptWorldInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfos(UserType* output) {
    
    auto* pointer = data_->infos.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::extensions::mojom::UserScriptWorldInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_UpdateUserScriptWorlds_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_ClearUserScriptWorldConfig_ParamsDataView {
 public:
  Renderer_ClearUserScriptWorldConfig_ParamsDataView() = default;

  Renderer_ClearUserScriptWorldConfig_ParamsDataView(
      internal::Renderer_ClearUserScriptWorldConfig_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdDataView(
      ::extensions::mojom::ExtensionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::ExtensionIdDataView>(
        pointer, output, message_);
  }
  inline void GetWorldIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWorldId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `world_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWorldId` instead "
    "of `ReadWorldId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->world_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_ClearUserScriptWorldConfig_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_ShouldSuspend_ParamsDataView {
 public:
  Renderer_ShouldSuspend_ParamsDataView() = default;

  Renderer_ShouldSuspend_ParamsDataView(
      internal::Renderer_ShouldSuspend_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Renderer_ShouldSuspend_Params_Data* data_ = nullptr;
};


class Renderer_ShouldSuspend_ResponseParamsDataView {
 public:
  Renderer_ShouldSuspend_ResponseParamsDataView() = default;

  Renderer_ShouldSuspend_ResponseParamsDataView(
      internal::Renderer_ShouldSuspend_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Renderer_ShouldSuspend_ResponseParams_Data* data_ = nullptr;
};


class Renderer_TransferBlobs_ParamsDataView {
 public:
  Renderer_TransferBlobs_ParamsDataView() = default;

  Renderer_TransferBlobs_ParamsDataView(
      internal::Renderer_TransferBlobs_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Renderer_TransferBlobs_Params_Data* data_ = nullptr;
};


class Renderer_TransferBlobs_ResponseParamsDataView {
 public:
  Renderer_TransferBlobs_ResponseParamsDataView() = default;

  Renderer_TransferBlobs_ResponseParamsDataView(
      internal::Renderer_TransferBlobs_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Renderer_TransferBlobs_ResponseParams_Data* data_ = nullptr;
};


class Renderer_UpdatePermissions_ParamsDataView {
 public:
  Renderer_UpdatePermissions_ParamsDataView() = default;

  Renderer_UpdatePermissions_ParamsDataView(
      internal::Renderer_UpdatePermissions_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdDataView(
      ::extensions::mojom::ExtensionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::ExtensionIdDataView>(
        pointer, output, message_);
  }
  inline void GetActivePermissionsDataView(
      ::extensions::mojom::PermissionSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActivePermissions(UserType* output) {
    
    auto* pointer = data_->active_permissions.Get();
    return mojo::internal::Deserialize<::extensions::mojom::PermissionSetDataView>(
        pointer, output, message_);
  }
  inline void GetWithheldPermissionsDataView(
      ::extensions::mojom::PermissionSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWithheldPermissions(UserType* output) {
    
    auto* pointer = data_->withheld_permissions.Get();
    return mojo::internal::Deserialize<::extensions::mojom::PermissionSetDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyBlockedHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyBlockedHosts(UserType* output) {
    
    auto* pointer = data_->policy_blocked_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyAllowedHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyAllowedHosts(UserType* output) {
    
    auto* pointer = data_->policy_allowed_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
  bool uses_default_policy_host_restrictions() const {
    return data_->uses_default_policy_host_restrictions;
  }
 private:
  internal::Renderer_UpdatePermissions_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_UpdateDefaultPolicyHostRestrictions_ParamsDataView {
 public:
  Renderer_UpdateDefaultPolicyHostRestrictions_ParamsDataView() = default;

  Renderer_UpdateDefaultPolicyHostRestrictions_ParamsDataView(
      internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDefaultPolicyBlockedHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultPolicyBlockedHosts(UserType* output) {
    
    auto* pointer = data_->default_policy_blocked_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
  inline void GetDefaultPolicyAllowedHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultPolicyAllowedHosts(UserType* output) {
    
    auto* pointer = data_->default_policy_allowed_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_UpdateDefaultPolicyHostRestrictions_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_UpdateUserHostRestrictions_ParamsDataView {
 public:
  Renderer_UpdateUserHostRestrictions_ParamsDataView() = default;

  Renderer_UpdateUserHostRestrictions_ParamsDataView(
      internal::Renderer_UpdateUserHostRestrictions_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUserBlockedHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserBlockedHosts(UserType* output) {
    
    auto* pointer = data_->user_blocked_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
  inline void GetUserAllowedHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserAllowedHosts(UserType* output) {
    
    auto* pointer = data_->user_allowed_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_UpdateUserHostRestrictions_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_UpdateTabSpecificPermissions_ParamsDataView {
 public:
  Renderer_UpdateTabSpecificPermissions_ParamsDataView() = default;

  Renderer_UpdateTabSpecificPermissions_ParamsDataView(
      internal::Renderer_UpdateTabSpecificPermissions_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdDataView(
      ::extensions::mojom::ExtensionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::ExtensionIdDataView>(
        pointer, output, message_);
  }
  inline void GetNewHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewHosts(UserType* output) {
    
    auto* pointer = data_->new_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  bool update_origin_allowlist() const {
    return data_->update_origin_allowlist;
  }
 private:
  internal::Renderer_UpdateTabSpecificPermissions_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_UpdateUserScripts_ParamsDataView {
 public:
  Renderer_UpdateUserScripts_ParamsDataView() = default;

  Renderer_UpdateUserScripts_ParamsDataView(
      internal::Renderer_UpdateUserScripts_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegion(UserType* output) {
    
    auto* pointer = data_->region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  inline void GetOwnerDataView(
      ::extensions::mojom::HostIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOwner(UserType* output) {
    
    auto* pointer = data_->owner.Get();
    return mojo::internal::Deserialize<::extensions::mojom::HostIDDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_UpdateUserScripts_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_ClearTabSpecificPermissions_ParamsDataView {
 public:
  Renderer_ClearTabSpecificPermissions_ParamsDataView() = default;

  Renderer_ClearTabSpecificPermissions_ParamsDataView(
      internal::Renderer_ClearTabSpecificPermissions_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdsDataView(
      mojo::ArrayDataView<::extensions::mojom::ExtensionIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionIds(UserType* output) {
    
    auto* pointer = data_->extension_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::extensions::mojom::ExtensionIdDataView>>(
        pointer, output, message_);
  }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  bool update_origin_allowlist() const {
    return data_->update_origin_allowlist;
  }
 private:
  internal::Renderer_ClearTabSpecificPermissions_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_WatchPages_ParamsDataView {
 public:
  Renderer_WatchPages_ParamsDataView() = default;

  Renderer_WatchPages_ParamsDataView(
      internal::Renderer_WatchPages_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCssSelectorsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCssSelectors(UserType* output) {
    
    auto* pointer = data_->css_selectors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_WatchPages_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void Renderer_ActivateExtension_ParamsDataView::GetExtensionIdDataView(
    ::extensions::mojom::ExtensionIdDataView* output) {
  auto pointer = data_->extension_id.Get();
  *output = ::extensions::mojom::ExtensionIdDataView(pointer, message_);
}




inline void Renderer_LoadExtensions_ParamsDataView::GetParamsDataView(
    mojo::ArrayDataView<ExtensionLoadedParamsDataView>* output) {
  auto pointer = data_->params.Get();
  *output = mojo::ArrayDataView<ExtensionLoadedParamsDataView>(pointer, message_);
}


inline void Renderer_UnloadExtension_ParamsDataView::GetExtensionIdDataView(
    ::extensions::mojom::ExtensionIdDataView* output) {
  auto pointer = data_->extension_id.Get();
  *output = ::extensions::mojom::ExtensionIdDataView(pointer, message_);
}


inline void Renderer_SuspendExtension_ParamsDataView::GetExtensionIdDataView(
    ::extensions::mojom::ExtensionIdDataView* output) {
  auto pointer = data_->extension_id.Get();
  *output = ::extensions::mojom::ExtensionIdDataView(pointer, message_);
}




inline void Renderer_CancelSuspendExtension_ParamsDataView::GetExtensionIdDataView(
    ::extensions::mojom::ExtensionIdDataView* output) {
  auto pointer = data_->extension_id.Get();
  *output = ::extensions::mojom::ExtensionIdDataView(pointer, message_);
}




inline void Renderer_SetUserScriptsAllowed_ParamsDataView::GetExtensionIdDataView(
    ::extensions::mojom::ExtensionIdDataView* output) {
  auto pointer = data_->extension_id.Get();
  *output = ::extensions::mojom::ExtensionIdDataView(pointer, message_);
}




inline void Renderer_SetSystemFont_ParamsDataView::GetFontFamilyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->font_family.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void Renderer_SetSystemFont_ParamsDataView::GetFontSizeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->font_size.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void Renderer_SetWebViewPartitionID_ParamsDataView::GetPartitionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->partition_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void Renderer_SetScriptingAllowlist_ParamsDataView::GetExtensionIdsDataView(
    mojo::ArrayDataView<::extensions::mojom::ExtensionIdDataView>* output) {
  auto pointer = data_->extension_ids.Get();
  *output = mojo::ArrayDataView<::extensions::mojom::ExtensionIdDataView>(pointer, message_);
}


inline void Renderer_UpdateUserScriptWorlds_ParamsDataView::GetInfosDataView(
    mojo::ArrayDataView<UserScriptWorldInfoDataView>* output) {
  auto pointer = data_->infos.Get();
  *output = mojo::ArrayDataView<UserScriptWorldInfoDataView>(pointer, message_);
}


inline void Renderer_ClearUserScriptWorldConfig_ParamsDataView::GetExtensionIdDataView(
    ::extensions::mojom::ExtensionIdDataView* output) {
  auto pointer = data_->extension_id.Get();
  *output = ::extensions::mojom::ExtensionIdDataView(pointer, message_);
}
inline void Renderer_ClearUserScriptWorldConfig_ParamsDataView::GetWorldIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->world_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}










inline void Renderer_UpdatePermissions_ParamsDataView::GetExtensionIdDataView(
    ::extensions::mojom::ExtensionIdDataView* output) {
  auto pointer = data_->extension_id.Get();
  *output = ::extensions::mojom::ExtensionIdDataView(pointer, message_);
}
inline void Renderer_UpdatePermissions_ParamsDataView::GetActivePermissionsDataView(
    ::extensions::mojom::PermissionSetDataView* output) {
  auto pointer = data_->active_permissions.Get();
  *output = ::extensions::mojom::PermissionSetDataView(pointer, message_);
}
inline void Renderer_UpdatePermissions_ParamsDataView::GetWithheldPermissionsDataView(
    ::extensions::mojom::PermissionSetDataView* output) {
  auto pointer = data_->withheld_permissions.Get();
  *output = ::extensions::mojom::PermissionSetDataView(pointer, message_);
}
inline void Renderer_UpdatePermissions_ParamsDataView::GetPolicyBlockedHostsDataView(
    ::extensions::mojom::URLPatternSetDataView* output) {
  auto pointer = data_->policy_blocked_hosts.Get();
  *output = ::extensions::mojom::URLPatternSetDataView(pointer, message_);
}
inline void Renderer_UpdatePermissions_ParamsDataView::GetPolicyAllowedHostsDataView(
    ::extensions::mojom::URLPatternSetDataView* output) {
  auto pointer = data_->policy_allowed_hosts.Get();
  *output = ::extensions::mojom::URLPatternSetDataView(pointer, message_);
}


inline void Renderer_UpdateDefaultPolicyHostRestrictions_ParamsDataView::GetDefaultPolicyBlockedHostsDataView(
    ::extensions::mojom::URLPatternSetDataView* output) {
  auto pointer = data_->default_policy_blocked_hosts.Get();
  *output = ::extensions::mojom::URLPatternSetDataView(pointer, message_);
}
inline void Renderer_UpdateDefaultPolicyHostRestrictions_ParamsDataView::GetDefaultPolicyAllowedHostsDataView(
    ::extensions::mojom::URLPatternSetDataView* output) {
  auto pointer = data_->default_policy_allowed_hosts.Get();
  *output = ::extensions::mojom::URLPatternSetDataView(pointer, message_);
}


inline void Renderer_UpdateUserHostRestrictions_ParamsDataView::GetUserBlockedHostsDataView(
    ::extensions::mojom::URLPatternSetDataView* output) {
  auto pointer = data_->user_blocked_hosts.Get();
  *output = ::extensions::mojom::URLPatternSetDataView(pointer, message_);
}
inline void Renderer_UpdateUserHostRestrictions_ParamsDataView::GetUserAllowedHostsDataView(
    ::extensions::mojom::URLPatternSetDataView* output) {
  auto pointer = data_->user_allowed_hosts.Get();
  *output = ::extensions::mojom::URLPatternSetDataView(pointer, message_);
}


inline void Renderer_UpdateTabSpecificPermissions_ParamsDataView::GetExtensionIdDataView(
    ::extensions::mojom::ExtensionIdDataView* output) {
  auto pointer = data_->extension_id.Get();
  *output = ::extensions::mojom::ExtensionIdDataView(pointer, message_);
}
inline void Renderer_UpdateTabSpecificPermissions_ParamsDataView::GetNewHostsDataView(
    ::extensions::mojom::URLPatternSetDataView* output) {
  auto pointer = data_->new_hosts.Get();
  *output = ::extensions::mojom::URLPatternSetDataView(pointer, message_);
}


inline void Renderer_UpdateUserScripts_ParamsDataView::GetRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}
inline void Renderer_UpdateUserScripts_ParamsDataView::GetOwnerDataView(
    ::extensions::mojom::HostIDDataView* output) {
  auto pointer = data_->owner.Get();
  *output = ::extensions::mojom::HostIDDataView(pointer, message_);
}


inline void Renderer_ClearTabSpecificPermissions_ParamsDataView::GetExtensionIdsDataView(
    mojo::ArrayDataView<::extensions::mojom::ExtensionIdDataView>* output) {
  auto pointer = data_->extension_ids.Get();
  *output = mojo::ArrayDataView<::extensions::mojom::ExtensionIdDataView>(pointer, message_);
}


inline void Renderer_WatchPages_ParamsDataView::GetCssSelectorsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->css_selectors.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // extensions::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_PARAMS_DATA_H_