// extensions/common/mojom/renderer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_DATA_VIEW_H_
#define EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "extensions/common/mojom/renderer.mojom-shared-internal.h"
#include "extensions/common/mojom/api_permission_id.mojom-shared.h"
#include "extensions/common/mojom/channel.mojom-shared.h"
#include "extensions/common/mojom/extension_id.mojom-shared.h"
#include "extensions/common/mojom/feature_session_type.mojom-shared.h"
#include "extensions/common/mojom/host_id.mojom-shared.h"
#include "extensions/common/mojom/manifest.mojom-shared.h"
#include "extensions/common/mojom/permission_set.mojom-shared.h"
#include "extensions/common/mojom/url_pattern_set.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"


namespace extensions::mojom {
class ExtensionLoadedParamsDataView;

class UserScriptWorldInfoDataView;



}  // extensions::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::ExtensionLoadedParamsDataView> {
  using Data = ::extensions::mojom::internal::ExtensionLoadedParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::UserScriptWorldInfoDataView> {
  using Data = ::extensions::mojom::internal::UserScriptWorldInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {
// Interface base classes. They are used for type safety check.
class RendererInterfaceBase {};

using RendererPtrDataView =
    mojo::InterfacePtrDataView<RendererInterfaceBase>;
using RendererRequestDataView =
    mojo::InterfaceRequestDataView<RendererInterfaceBase>;
using RendererAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RendererInterfaceBase>;
using RendererAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RendererInterfaceBase>;


class ExtensionLoadedParamsDataView {
 public:
  ExtensionLoadedParamsDataView() = default;

  ExtensionLoadedParamsDataView(
      internal::ExtensionLoadedParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetManifestDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManifest(UserType* output) {
    
    auto* pointer = data_->manifest.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) const {
    auto data_value = data_->location;
    return mojo::internal::Deserialize<::extensions::mojom::ManifestLocation>(
        data_value, output);
  }
  ::extensions::mojom::ManifestLocation location() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::ManifestLocation>(data_->location));
  }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetActivePermissionsDataView(
      ::extensions::mojom::PermissionSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActivePermissions(UserType* output) {
    
    auto* pointer = data_->active_permissions.Get();
    return mojo::internal::Deserialize<::extensions::mojom::PermissionSetDataView>(
        pointer, output, message_);
  }
  inline void GetWithheldPermissionsDataView(
      ::extensions::mojom::PermissionSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWithheldPermissions(UserType* output) {
    
    auto* pointer = data_->withheld_permissions.Get();
    return mojo::internal::Deserialize<::extensions::mojom::PermissionSetDataView>(
        pointer, output, message_);
  }
  inline void GetTabSpecificPermissionsDataView(
      mojo::MapDataView<int32_t, ::extensions::mojom::PermissionSetDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabSpecificPermissions(UserType* output) {
    
    auto* pointer = data_->tab_specific_permissions.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<int32_t, ::extensions::mojom::PermissionSetDataView>>(
        pointer, output, message_);
  }
  inline void GetPolicyBlockedHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyBlockedHosts(UserType* output) {
    
    auto* pointer = data_->policy_blocked_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyAllowedHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyAllowedHosts(UserType* output) {
    
    auto* pointer = data_->policy_allowed_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
  bool uses_default_policy_blocked_allowed_hosts() const {
    return data_->uses_default_policy_blocked_allowed_hosts;
  }
  bool user_scripts_allowed() const {
    return data_->user_scripts_allowed;
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetWorkerActivationTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWorkerActivationToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `worker_activation_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWorkerActivationToken` instead "
    "of `ReadWorkerActivationToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->worker_activation_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  int32_t creation_flags() const {
    return data_->creation_flags;
  }
  inline void GetGuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGuid(UserType* output) {
    
    auto* pointer = data_->guid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ExtensionLoadedParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UserScriptWorldInfoDataView {
 public:
  UserScriptWorldInfoDataView() = default;

  UserScriptWorldInfoDataView(
      internal::UserScriptWorldInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdDataView(
      ::extensions::mojom::ExtensionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::ExtensionIdDataView>(
        pointer, output, message_);
  }
  inline void GetWorldIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWorldId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `world_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWorldId` instead "
    "of `ReadWorldId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->world_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCspDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCsp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `csp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCsp` instead "
    "of `ReadCsp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->csp.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool enable_messaging() const {
    return data_->enable_messaging;
  }
 private:
  internal::UserScriptWorldInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // extensions::mojom

#endif  // EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_DATA_VIEW_H_