// extensions/common/mojom/permission_set.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/permission_set.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/permission_set.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/permission_set.mojom-forward.h"  // IWYU pragma: export
#include "extensions/common/mojom/api_permission_id.mojom.h"
#include "extensions/common/mojom/url_pattern_set.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include <string>
#include <vector>




#include "extensions/common/mojom/permission_set_mojom_traits.h"




namespace extensions::mojom {












class  APIPermission {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<APIPermission, T>::value>;
  using DataView = APIPermissionDataView;
  using Data_ = internal::APIPermission_Data;

  template <typename... Args>
  static APIPermissionPtr New(Args&&... args) {
    return APIPermissionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static APIPermissionPtr From(const U& u) {
    return mojo::TypeConverter<APIPermissionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, APIPermission>::Convert(*this);
  }


  APIPermission();

  APIPermission(
      ::extensions::mojom::APIPermissionID id,
      std::optional<::base::Value> value);

APIPermission(const APIPermission&) = delete;
APIPermission& operator=(const APIPermission&) = delete;

  ~APIPermission();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = APIPermissionPtr>
  APIPermissionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, APIPermission::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, APIPermission::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, APIPermission::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        APIPermission::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        APIPermission::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        APIPermission::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::APIPermission_UnserializedMessageContext<
            UserType, APIPermission::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<APIPermission::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return APIPermission::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::APIPermission_UnserializedMessageContext<
            UserType, APIPermission::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<APIPermission::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::extensions::mojom::APIPermissionID id;
  
  std::optional<::base::Value> value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, APIPermission::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, APIPermission::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, APIPermission::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, APIPermission::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  APIPermissionSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<APIPermissionSet, T>::value>;
  using DataView = APIPermissionSetDataView;
  using Data_ = internal::APIPermissionSet_Data;

  template <typename... Args>
  static APIPermissionSetPtr New(Args&&... args) {
    return APIPermissionSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static APIPermissionSetPtr From(const U& u) {
    return mojo::TypeConverter<APIPermissionSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, APIPermissionSet>::Convert(*this);
  }


  APIPermissionSet();

  explicit APIPermissionSet(
      base::flat_map<::extensions::mojom::APIPermissionID, ::std::unique_ptr<::extensions::APIPermission>> permission_map);

APIPermissionSet(const APIPermissionSet&) = delete;
APIPermissionSet& operator=(const APIPermissionSet&) = delete;

  ~APIPermissionSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = APIPermissionSetPtr>
  APIPermissionSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, APIPermissionSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, APIPermissionSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, APIPermissionSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        APIPermissionSet::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        APIPermissionSet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        APIPermissionSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::APIPermissionSet_UnserializedMessageContext<
            UserType, APIPermissionSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<APIPermissionSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return APIPermissionSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::APIPermissionSet_UnserializedMessageContext<
            UserType, APIPermissionSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<APIPermissionSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<::extensions::mojom::APIPermissionID, ::std::unique_ptr<::extensions::APIPermission>> permission_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, APIPermissionSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, APIPermissionSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, APIPermissionSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, APIPermissionSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ManifestPermission {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestPermission, T>::value>;
  using DataView = ManifestPermissionDataView;
  using Data_ = internal::ManifestPermission_Data;

  template <typename... Args>
  static ManifestPermissionPtr New(Args&&... args) {
    return ManifestPermissionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestPermissionPtr From(const U& u) {
    return mojo::TypeConverter<ManifestPermissionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestPermission>::Convert(*this);
  }


  ManifestPermission();

  ManifestPermission(
      const std::string& id,
      std::optional<::base::Value> value);

ManifestPermission(const ManifestPermission&) = delete;
ManifestPermission& operator=(const ManifestPermission&) = delete;

  ~ManifestPermission();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestPermissionPtr>
  ManifestPermissionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestPermission::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestPermission::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestPermission::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestPermission::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestPermission::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestPermission::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestPermission_UnserializedMessageContext<
            UserType, ManifestPermission::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestPermission::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestPermission::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestPermission_UnserializedMessageContext<
            UserType, ManifestPermission::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestPermission::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::optional<::base::Value> value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestPermission::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestPermission::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestPermission::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestPermission::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ManifestPermissionSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManifestPermissionSet, T>::value>;
  using DataView = ManifestPermissionSetDataView;
  using Data_ = internal::ManifestPermissionSet_Data;

  template <typename... Args>
  static ManifestPermissionSetPtr New(Args&&... args) {
    return ManifestPermissionSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManifestPermissionSetPtr From(const U& u) {
    return mojo::TypeConverter<ManifestPermissionSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManifestPermissionSet>::Convert(*this);
  }


  ManifestPermissionSet();

  explicit ManifestPermissionSet(
      base::flat_map<std::string, ::std::unique_ptr<::extensions::ManifestPermission>> permission_map);

ManifestPermissionSet(const ManifestPermissionSet&) = delete;
ManifestPermissionSet& operator=(const ManifestPermissionSet&) = delete;

  ~ManifestPermissionSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManifestPermissionSetPtr>
  ManifestPermissionSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManifestPermissionSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManifestPermissionSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManifestPermissionSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestPermissionSet::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManifestPermissionSet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManifestPermissionSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManifestPermissionSet_UnserializedMessageContext<
            UserType, ManifestPermissionSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManifestPermissionSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManifestPermissionSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManifestPermissionSet_UnserializedMessageContext<
            UserType, ManifestPermissionSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManifestPermissionSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<std::string, ::std::unique_ptr<::extensions::ManifestPermission>> permission_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManifestPermissionSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManifestPermissionSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManifestPermissionSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManifestPermissionSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PermissionSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PermissionSet, T>::value>;
  using DataView = PermissionSetDataView;
  using Data_ = internal::PermissionSet_Data;

  template <typename... Args>
  static PermissionSetPtr New(Args&&... args) {
    return PermissionSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PermissionSetPtr From(const U& u) {
    return mojo::TypeConverter<PermissionSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PermissionSet>::Convert(*this);
  }


  PermissionSet();

  PermissionSet(
      ::extensions::APIPermissionSet apis,
      ::extensions::ManifestPermissionSet manifest_permissions,
      ::extensions::URLPatternSet hosts,
      ::extensions::URLPatternSet user_script_hosts);

PermissionSet(const PermissionSet&) = delete;
PermissionSet& operator=(const PermissionSet&) = delete;

  ~PermissionSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PermissionSetPtr>
  PermissionSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PermissionSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PermissionSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PermissionSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionSet::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionSet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PermissionSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PermissionSet_UnserializedMessageContext<
            UserType, PermissionSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PermissionSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PermissionSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PermissionSet_UnserializedMessageContext<
            UserType, PermissionSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PermissionSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::extensions::APIPermissionSet apis;
  
  ::extensions::ManifestPermissionSet manifest_permissions;
  
  ::extensions::URLPatternSet hosts;
  
  ::extensions::URLPatternSet user_script_hosts;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PermissionSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PermissionSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PermissionSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PermissionSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
APIPermissionPtr APIPermission::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(value)
  );
}

template <typename T, APIPermission::EnableIfSame<T>*>
bool APIPermission::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, APIPermission::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
APIPermissionSetPtr APIPermissionSet::Clone() const {
  return New(
      mojo::Clone(permission_map)
  );
}

template <typename T, APIPermissionSet::EnableIfSame<T>*>
bool APIPermissionSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->permission_map, other_struct.permission_map))
    return false;
  return true;
}

template <typename T, APIPermissionSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.permission_map < rhs.permission_map)
    return true;
  if (rhs.permission_map < lhs.permission_map)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestPermissionPtr ManifestPermission::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(value)
  );
}

template <typename T, ManifestPermission::EnableIfSame<T>*>
bool ManifestPermission::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, ManifestPermission::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
ManifestPermissionSetPtr ManifestPermissionSet::Clone() const {
  return New(
      mojo::Clone(permission_map)
  );
}

template <typename T, ManifestPermissionSet::EnableIfSame<T>*>
bool ManifestPermissionSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->permission_map, other_struct.permission_map))
    return false;
  return true;
}

template <typename T, ManifestPermissionSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.permission_map < rhs.permission_map)
    return true;
  if (rhs.permission_map < lhs.permission_map)
    return false;
  return false;
}
template <typename StructPtrType>
PermissionSetPtr PermissionSet::Clone() const {
  return New(
      mojo::Clone(apis),
      mojo::Clone(manifest_permissions),
      mojo::Clone(hosts),
      mojo::Clone(user_script_hosts)
  );
}

template <typename T, PermissionSet::EnableIfSame<T>*>
bool PermissionSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->apis, other_struct.apis))
    return false;
  if (!mojo::Equals(this->manifest_permissions, other_struct.manifest_permissions))
    return false;
  if (!mojo::Equals(this->hosts, other_struct.hosts))
    return false;
  if (!mojo::Equals(this->user_script_hosts, other_struct.user_script_hosts))
    return false;
  return true;
}

template <typename T, PermissionSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.apis < rhs.apis)
    return true;
  if (rhs.apis < lhs.apis)
    return false;
  if (lhs.manifest_permissions < rhs.manifest_permissions)
    return true;
  if (rhs.manifest_permissions < lhs.manifest_permissions)
    return false;
  if (lhs.hosts < rhs.hosts)
    return true;
  if (rhs.hosts < lhs.hosts)
    return false;
  if (lhs.user_script_hosts < rhs.user_script_hosts)
    return true;
  if (rhs.user_script_hosts < lhs.user_script_hosts)
    return false;
  return false;
}


}  // extensions::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions::mojom::APIPermission::DataView,
                                         ::extensions::mojom::APIPermissionPtr> {
  static bool IsNull(const ::extensions::mojom::APIPermissionPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::APIPermissionPtr* output) { output->reset(); }

  static decltype(::extensions::mojom::APIPermission::id) id(
      const ::extensions::mojom::APIPermissionPtr& input) {
    return input->id;
  }

  static const decltype(::extensions::mojom::APIPermission::value)& value(
      const ::extensions::mojom::APIPermissionPtr& input) {
    return input->value;
  }

  static bool Read(::extensions::mojom::APIPermission::DataView input, ::extensions::mojom::APIPermissionPtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::APIPermissionSet::DataView,
                                         ::extensions::mojom::APIPermissionSetPtr> {
  static bool IsNull(const ::extensions::mojom::APIPermissionSetPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::APIPermissionSetPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::APIPermissionSet::permission_map)& permission_map(
      const ::extensions::mojom::APIPermissionSetPtr& input) {
    return input->permission_map;
  }

  static bool Read(::extensions::mojom::APIPermissionSet::DataView input, ::extensions::mojom::APIPermissionSetPtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::ManifestPermission::DataView,
                                         ::extensions::mojom::ManifestPermissionPtr> {
  static bool IsNull(const ::extensions::mojom::ManifestPermissionPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::ManifestPermissionPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::ManifestPermission::id)& id(
      const ::extensions::mojom::ManifestPermissionPtr& input) {
    return input->id;
  }

  static const decltype(::extensions::mojom::ManifestPermission::value)& value(
      const ::extensions::mojom::ManifestPermissionPtr& input) {
    return input->value;
  }

  static bool Read(::extensions::mojom::ManifestPermission::DataView input, ::extensions::mojom::ManifestPermissionPtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::ManifestPermissionSet::DataView,
                                         ::extensions::mojom::ManifestPermissionSetPtr> {
  static bool IsNull(const ::extensions::mojom::ManifestPermissionSetPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::ManifestPermissionSetPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::ManifestPermissionSet::permission_map)& permission_map(
      const ::extensions::mojom::ManifestPermissionSetPtr& input) {
    return input->permission_map;
  }

  static bool Read(::extensions::mojom::ManifestPermissionSet::DataView input, ::extensions::mojom::ManifestPermissionSetPtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::PermissionSet::DataView,
                                         ::extensions::mojom::PermissionSetPtr> {
  static bool IsNull(const ::extensions::mojom::PermissionSetPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::PermissionSetPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::PermissionSet::apis)& apis(
      const ::extensions::mojom::PermissionSetPtr& input) {
    return input->apis;
  }

  static const decltype(::extensions::mojom::PermissionSet::manifest_permissions)& manifest_permissions(
      const ::extensions::mojom::PermissionSetPtr& input) {
    return input->manifest_permissions;
  }

  static const decltype(::extensions::mojom::PermissionSet::hosts)& hosts(
      const ::extensions::mojom::PermissionSetPtr& input) {
    return input->hosts;
  }

  static const decltype(::extensions::mojom::PermissionSet::user_script_hosts)& user_script_hosts(
      const ::extensions::mojom::PermissionSetPtr& input) {
    return input->user_script_hosts;
  }

  static bool Read(::extensions::mojom::PermissionSet::DataView input, ::extensions::mojom::PermissionSetPtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_H_