// extensions/common/mojom/message_port.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('extensions.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
extensions.mojom.SerializationFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
extensions.mojom.SerializationFormat = {
  
  kStructuredCloned: 0,
  kJson: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
extensions.mojom.ChannelTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
extensions.mojom.ChannelType = {
  
  kSendMessage: 0,
  kSendRequest: 1,
  kConnect: 2,
  kNative: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
extensions.mojom.MessagingEndpointTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
extensions.mojom.MessagingEndpointType = {
  
  kExtension: 0,
  kWebPage: 1,
  kContentScript: 2,
  kUserScript: 3,
  kNativeApp: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.MessagePortPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.MessagePort.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { extensions.mojom.MessagePortInterface }
 */
extensions.mojom.MessagePortRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.MessagePortPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.MessagePortPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.MessagePortPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } error
   */

  dispatchDisconnect(
      error) {
    this.proxy.sendMessage(
        0,
        extensions.mojom.MessagePort_DispatchDisconnect_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.Message } message
   */

  deliverMessage(
      message) {
    this.proxy.sendMessage(
        1,
        extensions.mojom.MessagePort_DeliverMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MessagePort
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.MessagePortReceiver = class {
  /**
   * @param {!extensions.mojom.MessagePortInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.MessagePortRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.MessagePortRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.MessagePortRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.MessagePort_DispatchDisconnect_ParamsSpec.$,
        null,
        impl.dispatchDisconnect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.MessagePort_DeliverMessage_ParamsSpec.$,
        null,
        impl.deliverMessage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.MessagePort = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.MessagePort";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.MessagePortRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.MessagePortRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MessagePort
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.MessagePortCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.MessagePortRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.MessagePortRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchDisconnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.MessagePort_DispatchDisconnect_ParamsSpec.$,
        null,
        this.dispatchDisconnect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deliverMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.MessagePort_DeliverMessage_ParamsSpec.$,
        null,
        this.deliverMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.MessagePortHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.MessagePortHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { extensions.mojom.MessagePortHostInterface }
 */
extensions.mojom.MessagePortHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.MessagePortHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.MessagePortHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.MessagePortHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } closeChannel
   * @param { ?string } errorMessage
   */

  closePort(
      closeChannel,
      errorMessage) {
    this.proxy.sendMessage(
        0,
        extensions.mojom.MessagePortHost_ClosePort_ParamsSpec.$,
        null,
        [
          closeChannel,
          errorMessage
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.Message } message
   */

  postMessage(
      message) {
    this.proxy.sendMessage(
        1,
        extensions.mojom.MessagePortHost_PostMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  
  /**
   */

  responsePending() {
    this.proxy.sendMessage(
        2,
        extensions.mojom.MessagePortHost_ResponsePending_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MessagePortHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.MessagePortHostReceiver = class {
  /**
   * @param {!extensions.mojom.MessagePortHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.MessagePortHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.MessagePortHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.MessagePortHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.MessagePortHost_ClosePort_ParamsSpec.$,
        null,
        impl.closePort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.MessagePortHost_PostMessage_ParamsSpec.$,
        null,
        impl.postMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.MessagePortHost_ResponsePending_ParamsSpec.$,
        null,
        impl.responsePending.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.MessagePortHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.MessagePortHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.MessagePortHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.MessagePortHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MessagePortHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.MessagePortHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.MessagePortHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.MessagePortHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closePort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.MessagePortHost_ClosePort_ParamsSpec.$,
        null,
        this.closePort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.postMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.MessagePortHost_PostMessage_ParamsSpec.$,
        null,
        this.postMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.responsePending =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.MessagePortHost_ResponsePending_ParamsSpec.$,
        null,
        this.responsePending.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.PortIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MessagingEndpointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.TabConnectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ExternalConnectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MessageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MessagePort_DispatchDisconnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MessagePort_DeliverMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MessagePortHost_ClosePort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MessagePortHost_PostMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MessagePortHost_ResponsePending_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    extensions.mojom.PortIdSpec.$,
    'PortId',
    [
      mojo.internal.StructField(
        'contextId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portNumber', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isOpener', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serializationFormat', 16,
        0,
        extensions.mojom.SerializationFormatSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
extensions.mojom.PortId = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.contextId;
    /** @export { !number } */
    this.portNumber;
    /** @export { !boolean } */
    this.isOpener;
    /** @export { !extensions.mojom.SerializationFormat } */
    this.serializationFormat;
  }
};



mojo.internal.Struct(
    extensions.mojom.MessagingEndpointSpec.$,
    'MessagingEndpoint',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        extensions.mojom.MessagingEndpointTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extensionId', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nativeAppName', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
extensions.mojom.MessagingEndpoint = class {
  constructor() {
    /** @export { !extensions.mojom.MessagingEndpointType } */
    this.type;
    /** @export { (string|undefined) } */
    this.extensionId;
    /** @export { (string|undefined) } */
    this.nativeAppName;
  }
};



mojo.internal.Struct(
    extensions.mojom.TabConnectionInfoSpec.$,
    'TabConnectionInfo',
    [
      mojo.internal.StructField(
        'tab', 0,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameId', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'documentId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'documentLifecycle', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
extensions.mojom.TabConnectionInfo = class {
  constructor() {
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.tab;
    /** @export { !number } */
    this.frameId;
    /** @export { !string } */
    this.documentId;
    /** @export { !string } */
    this.documentLifecycle;
  }
};



mojo.internal.Struct(
    extensions.mojom.ExternalConnectionInfoSpec.$,
    'ExternalConnectionInfo',
    [
      mojo.internal.StructField(
        'sourceEndpoint', 0,
        0,
        extensions.mojom.MessagingEndpointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceUrl', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceOrigin', 24,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'guestProcessId', 32,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'guestRenderFrameRoutingId', 36,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
extensions.mojom.ExternalConnectionInfo = class {
  constructor() {
    /** @export { !extensions.mojom.MessagingEndpoint } */
    this.sourceEndpoint;
    /** @export { !string } */
    this.targetId;
    /** @export { !url.mojom.Url } */
    this.sourceUrl;
    /** @export { (url.mojom.Origin|undefined) } */
    this.sourceOrigin;
    /** @export { !number } */
    this.guestProcessId;
    /** @export { !number } */
    this.guestRenderFrameRoutingId;
  }
};



mojo.internal.Struct(
    extensions.mojom.MessageSpec.$,
    'Message',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'format', 8,
        0,
        extensions.mojom.SerializationFormatSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userGesture', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fromPrivilegedContext', 12,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.Message = class {
  constructor() {
    /** @export { !string } */
    this.data;
    /** @export { !extensions.mojom.SerializationFormat } */
    this.format;
    /** @export { !boolean } */
    this.userGesture;
    /** @export { !boolean } */
    this.fromPrivilegedContext;
  }
};



mojo.internal.Struct(
    extensions.mojom.MessagePort_DispatchDisconnect_ParamsSpec.$,
    'MessagePort_DispatchDisconnect_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.MessagePort_DispatchDisconnect_Params = class {
  constructor() {
    /** @export { !string } */
    this.error;
  }
};



mojo.internal.Struct(
    extensions.mojom.MessagePort_DeliverMessage_ParamsSpec.$,
    'MessagePort_DeliverMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        extensions.mojom.MessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.MessagePort_DeliverMessage_Params = class {
  constructor() {
    /** @export { !extensions.mojom.Message } */
    this.message;
  }
};



mojo.internal.Struct(
    extensions.mojom.MessagePortHost_ClosePort_ParamsSpec.$,
    'MessagePortHost_ClosePort_Params',
    [
      mojo.internal.StructField(
        'closeChannel', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.MessagePortHost_ClosePort_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.closeChannel;
    /** @export { (string|undefined) } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    extensions.mojom.MessagePortHost_PostMessage_ParamsSpec.$,
    'MessagePortHost_PostMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        extensions.mojom.MessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.MessagePortHost_PostMessage_Params = class {
  constructor() {
    /** @export { !extensions.mojom.Message } */
    this.message;
  }
};



mojo.internal.Struct(
    extensions.mojom.MessagePortHost_ResponsePending_ParamsSpec.$,
    'MessagePortHost_ResponsePending_Params',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mojom.MessagePortHost_ResponsePending_Params = class {
  constructor() {
  }
};

