// extensions/common/mojom/message_port.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_MESSAGE_PORT_MOJOM_DATA_VIEW_H_
#define EXTENSIONS_COMMON_MOJOM_MESSAGE_PORT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "extensions/common/mojom/message_port.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace extensions::mojom {
class PortIdDataView;

class MessagingEndpointDataView;

class TabConnectionInfoDataView;

class ExternalConnectionInfoDataView;

class MessageDataView;



}  // extensions::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::PortIdDataView> {
  using Data = ::extensions::mojom::internal::PortId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::MessagingEndpointDataView> {
  using Data = ::extensions::mojom::internal::MessagingEndpoint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::TabConnectionInfoDataView> {
  using Data = ::extensions::mojom::internal::TabConnectionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::ExternalConnectionInfoDataView> {
  using Data = ::extensions::mojom::internal::ExternalConnectionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::MessageDataView> {
  using Data = ::extensions::mojom::internal::Message_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {


enum class SerializationFormat : int32_t {
  
  kStructuredCloned = 0,
  
  kJson = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SerializationFormat value);
inline bool IsKnownEnumValue(SerializationFormat value) {
  return internal::SerializationFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ChannelType : int32_t {
  
  kSendMessage = 0,
  
  kSendRequest = 1,
  
  kConnect = 2,
  
  kNative = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ChannelType value);
inline bool IsKnownEnumValue(ChannelType value) {
  return internal::ChannelType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MessagingEndpointType : int32_t {
  
  kExtension = 0,
  
  kWebPage = 1,
  
  kContentScript = 2,
  
  kUserScript = 3,
  
  kNativeApp = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, MessagingEndpointType value);
inline bool IsKnownEnumValue(MessagingEndpointType value) {
  return internal::MessagingEndpointType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MessagePortInterfaceBase {};

using MessagePortPtrDataView =
    mojo::InterfacePtrDataView<MessagePortInterfaceBase>;
using MessagePortRequestDataView =
    mojo::InterfaceRequestDataView<MessagePortInterfaceBase>;
using MessagePortAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MessagePortInterfaceBase>;
using MessagePortAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MessagePortInterfaceBase>;
class MessagePortHostInterfaceBase {};

using MessagePortHostPtrDataView =
    mojo::InterfacePtrDataView<MessagePortHostInterfaceBase>;
using MessagePortHostRequestDataView =
    mojo::InterfaceRequestDataView<MessagePortHostInterfaceBase>;
using MessagePortHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MessagePortHostInterfaceBase>;
using MessagePortHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MessagePortHostInterfaceBase>;


class PortIdDataView {
 public:
  PortIdDataView() = default;

  PortIdDataView(
      internal::PortId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContextIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContextId(UserType* output) {
    
    auto* pointer = data_->context_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  int32_t port_number() const {
    return data_->port_number;
  }
  bool is_opener() const {
    return data_->is_opener;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSerializationFormat(UserType* output) const {
    auto data_value = data_->serialization_format;
    return mojo::internal::Deserialize<::extensions::mojom::SerializationFormat>(
        data_value, output);
  }
  SerializationFormat serialization_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::SerializationFormat>(data_->serialization_format));
  }
 private:
  internal::PortId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MessagingEndpointDataView {
 public:
  MessagingEndpointDataView() = default;

  MessagingEndpointDataView(
      internal::MessagingEndpoint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::extensions::mojom::MessagingEndpointType>(
        data_value, output);
  }
  MessagingEndpointType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::MessagingEndpointType>(data_->type));
  }
  inline void GetExtensionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `extension_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExtensionId` instead "
    "of `ReadExtensionId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNativeAppNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNativeAppName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `native_app_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNativeAppName` instead "
    "of `ReadNativeAppName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->native_app_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MessagingEndpoint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabConnectionInfoDataView {
 public:
  TabConnectionInfoDataView() = default;

  TabConnectionInfoDataView(
      internal::TabConnectionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTab(UserType* output) {
    
    auto* pointer = data_->tab.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
  int32_t frame_id() const {
    return data_->frame_id;
  }
  inline void GetDocumentIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentId(UserType* output) {
    
    auto* pointer = data_->document_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDocumentLifecycleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentLifecycle(UserType* output) {
    
    auto* pointer = data_->document_lifecycle.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabConnectionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ExternalConnectionInfoDataView {
 public:
  ExternalConnectionInfoDataView() = default;

  ExternalConnectionInfoDataView(
      internal::ExternalConnectionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourceEndpointDataView(
      MessagingEndpointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceEndpoint(UserType* output) {
    
    auto* pointer = data_->source_endpoint.Get();
    return mojo::internal::Deserialize<::extensions::mojom::MessagingEndpointDataView>(
        pointer, output, message_);
  }
  inline void GetTargetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetId(UserType* output) {
    
    auto* pointer = data_->target_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSourceUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceUrl(UserType* output) {
    
    auto* pointer = data_->source_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSourceOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `source_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceOrigin` instead "
    "of `ReadSourceOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->source_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  int32_t guest_process_id() const {
    return data_->guest_process_id;
  }
  int32_t guest_render_frame_routing_id() const {
    return data_->guest_render_frame_routing_id;
  }
 private:
  internal::ExternalConnectionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MessageDataView {
 public:
  MessageDataView() = default;

  MessageDataView(
      internal::Message_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::extensions::mojom::SerializationFormat>(
        data_value, output);
  }
  SerializationFormat format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::SerializationFormat>(data_->format));
  }
  bool user_gesture() const {
    return data_->user_gesture;
  }
  bool from_privileged_context() const {
    return data_->from_privileged_context;
  }
 private:
  internal::Message_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // extensions::mojom

#endif  // EXTENSIONS_COMMON_MOJOM_MESSAGE_PORT_MOJOM_DATA_VIEW_H_