// extensions/common/mojom/extra_response_data.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'extensions/common/mojom/extra_response_data.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('extensions.mojom');
  var serialized_blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/serialized_blob.mojom', '../../../third_party/blink/public/mojom/blob/serialized_blob.mojom.js');
  }



  function ExtraResponseData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ExtraResponseData.prototype.initDefaults_ = function() {
    this.blobs = null;
  };
  ExtraResponseData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ExtraResponseData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ExtraResponseData.blobs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(serialized_blob$.SerializedBlob), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ExtraResponseData.encodedSize = codec.kStructHeaderSize + 8;

  ExtraResponseData.decode = function(decoder) {
    var packed;
    var val = new ExtraResponseData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.blobs =
        decoder.decodeArrayPointer(new codec.PointerTo(serialized_blob$.SerializedBlob));
    return val;
  };

  ExtraResponseData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ExtraResponseData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(serialized_blob$.SerializedBlob), val.blobs);
  };
  exports.ExtraResponseData = ExtraResponseData;
})();