// extensions/common/mojom/extension_id.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_EXTENSION_ID_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_EXTENSION_ID_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/extension_id.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/extension_id.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/extension_id.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "extensions/common/mojom/extension_id_mojom_traits.h"




namespace extensions::mojom {





class  ExtensionId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtensionId, T>::value>;
  using DataView = ExtensionIdDataView;
  using Data_ = internal::ExtensionId_Data;

  template <typename... Args>
  static ExtensionIdPtr New(Args&&... args) {
    return ExtensionIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtensionIdPtr From(const U& u) {
    return mojo::TypeConverter<ExtensionIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtensionId>::Convert(*this);
  }


  ExtensionId();

  explicit ExtensionId(
      const std::string& id);


  ~ExtensionId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtensionIdPtr>
  ExtensionIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtensionId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtensionId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtensionId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionId::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtensionId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtensionId_UnserializedMessageContext<
            UserType, ExtensionId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtensionId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtensionId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtensionId_UnserializedMessageContext<
            UserType, ExtensionId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtensionId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtensionId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtensionId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtensionId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtensionId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
ExtensionIdPtr ExtensionId::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, ExtensionId::EnableIfSame<T>*>
bool ExtensionId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, ExtensionId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}


}  // extensions::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions::mojom::ExtensionId::DataView,
                                         ::extensions::mojom::ExtensionIdPtr> {
  static bool IsNull(const ::extensions::mojom::ExtensionIdPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::ExtensionIdPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::ExtensionId::id)& id(
      const ::extensions::mojom::ExtensionIdPtr& input) {
    return input->id;
  }

  static bool Read(::extensions::mojom::ExtensionId::DataView input, ::extensions::mojom::ExtensionIdPtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_EXTENSION_ID_MOJOM_H_