// extensions/common/mojom/event_router.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_EVENT_ROUTER_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_EVENT_ROUTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/event_router.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/event_router.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/event_router.mojom-forward.h"  // IWYU pragma: export
#include "extensions/common/mojom/extension_id.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions::mojom {

class EventRouterProxy;

template <typename ImplRefTraits>
class EventRouterStub;

class EventRouterRequestValidator;


class EventRouter
    : public EventRouterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "extensions.mojom.EventRouter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = EventRouterInterfaceBase;
  using Proxy_ = EventRouterProxy;

  template <typename ImplRefTraits>
  using Stub_ = EventRouterStub<ImplRefTraits>;

  using RequestValidator_ = EventRouterRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddListenerForMainThreadMinVersion = 0,
    kAddListenerForServiceWorkerMinVersion = 0,
    kAddLazyListenerForMainThreadMinVersion = 0,
    kAddLazyListenerForServiceWorkerMinVersion = 0,
    kAddFilteredListenerForMainThreadMinVersion = 0,
    kAddFilteredListenerForServiceWorkerMinVersion = 0,
    kRemoveListenerForMainThreadMinVersion = 0,
    kRemoveListenerForServiceWorkerMinVersion = 0,
    kRemoveLazyListenerForMainThreadMinVersion = 0,
    kRemoveLazyListenerForServiceWorkerMinVersion = 0,
    kRemoveFilteredListenerForMainThreadMinVersion = 0,
    kRemoveFilteredListenerForServiceWorkerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddListenerForMainThread_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddListenerForServiceWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddLazyListenerForMainThread_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddLazyListenerForServiceWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddFilteredListenerForMainThread_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddFilteredListenerForServiceWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveListenerForMainThread_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveListenerForServiceWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveLazyListenerForMainThread_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveLazyListenerForServiceWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveFilteredListenerForMainThread_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveFilteredListenerForServiceWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~EventRouter() = default;

  virtual void AddListenerForMainThread(EventListenerPtr event_listener) = 0;

  virtual void AddListenerForServiceWorker(EventListenerPtr event_listener) = 0;

  virtual void AddLazyListenerForMainThread(const ::extensions::ExtensionId& extension_id, const std::string& event_name) = 0;

  virtual void AddLazyListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const ::GURL& worker_scope_url, const std::string& event_name) = 0;

  virtual void AddFilteredListenerForMainThread(EventListenerOwnerPtr listener_owner, const std::string& event_name, ::base::Value::Dict filter, bool add_lazy_listener) = 0;

  virtual void AddFilteredListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const std::string& event_name, ServiceWorkerContextPtr service_worker_context, ::base::Value::Dict filter, bool add_lazy_listener) = 0;

  virtual void RemoveListenerForMainThread(EventListenerPtr event_listener) = 0;

  virtual void RemoveListenerForServiceWorker(EventListenerPtr event_listener) = 0;

  virtual void RemoveLazyListenerForMainThread(const ::extensions::ExtensionId& extension_id, const std::string& event_name) = 0;

  virtual void RemoveLazyListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const ::GURL& worker_scope_url, const std::string& event_name) = 0;

  virtual void RemoveFilteredListenerForMainThread(EventListenerOwnerPtr listener_owner, const std::string& event_name, ::base::Value::Dict filter, bool remove_lazy_listener) = 0;

  virtual void RemoveFilteredListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const std::string& event_name, ServiceWorkerContextPtr service_worker_context, ::base::Value::Dict filter, bool remove_lazy_listener) = 0;
};



class  EventRouterProxy
    : public EventRouter {
 public:
  using InterfaceType = EventRouter;

  explicit EventRouterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddListenerForMainThread(EventListenerPtr event_listener) final;
  
  void AddListenerForServiceWorker(EventListenerPtr event_listener) final;
  
  void AddLazyListenerForMainThread(const ::extensions::ExtensionId& extension_id, const std::string& event_name) final;
  
  void AddLazyListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const ::GURL& worker_scope_url, const std::string& event_name) final;
  
  void AddFilteredListenerForMainThread(EventListenerOwnerPtr listener_owner, const std::string& event_name, ::base::Value::Dict filter, bool add_lazy_listener) final;
  
  void AddFilteredListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const std::string& event_name, ServiceWorkerContextPtr service_worker_context, ::base::Value::Dict filter, bool add_lazy_listener) final;
  
  void RemoveListenerForMainThread(EventListenerPtr event_listener) final;
  
  void RemoveListenerForServiceWorker(EventListenerPtr event_listener) final;
  
  void RemoveLazyListenerForMainThread(const ::extensions::ExtensionId& extension_id, const std::string& event_name) final;
  
  void RemoveLazyListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const ::GURL& worker_scope_url, const std::string& event_name) final;
  
  void RemoveFilteredListenerForMainThread(EventListenerOwnerPtr listener_owner, const std::string& event_name, ::base::Value::Dict filter, bool remove_lazy_listener) final;
  
  void RemoveFilteredListenerForServiceWorker(const ::extensions::ExtensionId& extension_id, const std::string& event_name, ServiceWorkerContextPtr service_worker_context, ::base::Value::Dict filter, bool remove_lazy_listener) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  EventRouterStubDispatch {
 public:
  static bool Accept(EventRouter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EventRouter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EventRouter>>
class EventRouterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EventRouterStub() = default;
  ~EventRouterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EventRouterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EventRouterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  EventRouterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class  EventListenerOwner {
 public:
  using DataView = EventListenerOwnerDataView;
  using Data_ = internal::EventListenerOwner_Data;
  using Tag = Data_::EventListenerOwner_Tag;

  template <typename... Args>
  static EventListenerOwnerPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |extension_id|.
  static EventListenerOwnerPtr NewExtensionId(
      const ::extensions::ExtensionId& value);
  // Construct an instance holding |listener_url|.
  static EventListenerOwnerPtr NewListenerUrl(
      const ::GURL& value);

  template <typename U>
  static EventListenerOwnerPtr From(const U& u) {
    return mojo::TypeConverter<EventListenerOwnerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EventListenerOwner>::Convert(*this);
  }
  ~EventListenerOwner();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  EventListenerOwner(const EventListenerOwner& other) = delete;
  EventListenerOwner& operator=(const EventListenerOwner& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = EventListenerOwnerPtr>
  EventListenerOwnerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, EventListenerOwner>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, EventListenerOwner>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_extension_id() const { return tag_ == Tag::kExtensionId; }
  const ::extensions::ExtensionId& get_extension_id() const {
    CHECK(tag_ == Tag::kExtensionId);
    return data_.extension_id;
  }
  ::extensions::ExtensionId& get_extension_id() {
    CHECK(tag_ == Tag::kExtensionId);
    return data_.extension_id;
  }
  void set_extension_id(const ::extensions::ExtensionId& extension_id);

  bool is_listener_url() const { return tag_ == Tag::kListenerUrl; }
  const ::GURL& get_listener_url() const {
    CHECK(tag_ == Tag::kListenerUrl);
    return data_.listener_url;
  }
  ::GURL& get_listener_url() {
    CHECK(tag_ == Tag::kListenerUrl);
    return data_.listener_url;
  }
  void set_listener_url(const ::GURL& listener_url);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EventListenerOwner::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<EventListenerOwner::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kExtensionId)>,
        const ::extensions::ExtensionId& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kListenerUrl)>,
        const ::GURL& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::extensions::ExtensionId extension_id;
    ::GURL listener_url;
  };

  EventListenerOwner(
      std::in_place_index_t<static_cast<size_t>(Tag::kExtensionId)>,
      const ::extensions::ExtensionId& value);
  EventListenerOwner(
      std::in_place_index_t<static_cast<size_t>(Tag::kListenerUrl)>,
      const ::GURL& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  ServiceWorkerContext {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerContext, T>::value>;
  using DataView = ServiceWorkerContextDataView;
  using Data_ = internal::ServiceWorkerContext_Data;

  template <typename... Args>
  static ServiceWorkerContextPtr New(Args&&... args) {
    return ServiceWorkerContextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerContextPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerContextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerContext>::Convert(*this);
  }


  ServiceWorkerContext();

  ServiceWorkerContext(
      const ::GURL& scope_url,
      int64_t version_id,
      int32_t thread_id);


  ~ServiceWorkerContext();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerContextPtr>
  ServiceWorkerContextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerContext::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerContext::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerContext::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerContext::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerContext::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerContext::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerContext_UnserializedMessageContext<
            UserType, ServiceWorkerContext::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerContext::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerContext::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerContext_UnserializedMessageContext<
            UserType, ServiceWorkerContext::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerContext::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL scope_url;
  
  int64_t version_id;
  
  int32_t thread_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerContext::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerContext::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerContext::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerContext::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  EventListener {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EventListener, T>::value>;
  using DataView = EventListenerDataView;
  using Data_ = internal::EventListener_Data;

  template <typename... Args>
  static EventListenerPtr New(Args&&... args) {
    return EventListenerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EventListenerPtr From(const U& u) {
    return mojo::TypeConverter<EventListenerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EventListener>::Convert(*this);
  }


  EventListener();

  EventListener(
      EventListenerOwnerPtr listener_owner,
      const std::string& event_name,
      ServiceWorkerContextPtr service_worker_context,
      std::optional<::base::Value::Dict> filter);

EventListener(const EventListener&) = delete;
EventListener& operator=(const EventListener&) = delete;

  ~EventListener();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EventListenerPtr>
  EventListenerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EventListener::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EventListener::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EventListener::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventListener::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventListener::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EventListener::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EventListener_UnserializedMessageContext<
            UserType, EventListener::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EventListener::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EventListener::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EventListener_UnserializedMessageContext<
            UserType, EventListener::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EventListener::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  EventListenerOwnerPtr listener_owner;
  
  std::string event_name;
  
  ServiceWorkerContextPtr service_worker_context;
  
  std::optional<::base::Value::Dict> filter;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EventListener::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EventListener::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EventListener::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EventListener::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
EventListenerOwnerPtr EventListenerOwner::Clone() const {
  switch (tag_) {
    case Tag::kExtensionId:
      return NewExtensionId(
          mojo::Clone(data_.extension_id));
    case Tag::kListenerUrl:
      return NewListenerUrl(
          mojo::Clone(data_.listener_url));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, EventListenerOwner>::value>::type*>
bool EventListenerOwner::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kExtensionId:
      return mojo::Equals(data_.extension_id, other.data_.extension_id);
    case Tag::kListenerUrl:
      return mojo::Equals(data_.listener_url, other.data_.listener_url);
  }

  return false;
}
template <typename StructPtrType>
ServiceWorkerContextPtr ServiceWorkerContext::Clone() const {
  return New(
      mojo::Clone(scope_url),
      mojo::Clone(version_id),
      mojo::Clone(thread_id)
  );
}

template <typename T, ServiceWorkerContext::EnableIfSame<T>*>
bool ServiceWorkerContext::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scope_url, other_struct.scope_url))
    return false;
  if (!mojo::Equals(this->version_id, other_struct.version_id))
    return false;
  if (!mojo::Equals(this->thread_id, other_struct.thread_id))
    return false;
  return true;
}

template <typename T, ServiceWorkerContext::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scope_url < rhs.scope_url)
    return true;
  if (rhs.scope_url < lhs.scope_url)
    return false;
  if (lhs.version_id < rhs.version_id)
    return true;
  if (rhs.version_id < lhs.version_id)
    return false;
  if (lhs.thread_id < rhs.thread_id)
    return true;
  if (rhs.thread_id < lhs.thread_id)
    return false;
  return false;
}
template <typename StructPtrType>
EventListenerPtr EventListener::Clone() const {
  return New(
      mojo::Clone(listener_owner),
      mojo::Clone(event_name),
      mojo::Clone(service_worker_context),
      mojo::Clone(filter)
  );
}

template <typename T, EventListener::EnableIfSame<T>*>
bool EventListener::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->listener_owner, other_struct.listener_owner))
    return false;
  if (!mojo::Equals(this->event_name, other_struct.event_name))
    return false;
  if (!mojo::Equals(this->service_worker_context, other_struct.service_worker_context))
    return false;
  if (!mojo::Equals(this->filter, other_struct.filter))
    return false;
  return true;
}

template <typename T, EventListener::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.listener_owner < rhs.listener_owner)
    return true;
  if (rhs.listener_owner < lhs.listener_owner)
    return false;
  if (lhs.event_name < rhs.event_name)
    return true;
  if (rhs.event_name < lhs.event_name)
    return false;
  if (lhs.service_worker_context < rhs.service_worker_context)
    return true;
  if (rhs.service_worker_context < lhs.service_worker_context)
    return false;
  if (lhs.filter < rhs.filter)
    return true;
  if (rhs.filter < lhs.filter)
    return false;
  return false;
}


}  // extensions::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions::mojom::ServiceWorkerContext::DataView,
                                         ::extensions::mojom::ServiceWorkerContextPtr> {
  static bool IsNull(const ::extensions::mojom::ServiceWorkerContextPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::ServiceWorkerContextPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::ServiceWorkerContext::scope_url)& scope_url(
      const ::extensions::mojom::ServiceWorkerContextPtr& input) {
    return input->scope_url;
  }

  static decltype(::extensions::mojom::ServiceWorkerContext::version_id) version_id(
      const ::extensions::mojom::ServiceWorkerContextPtr& input) {
    return input->version_id;
  }

  static decltype(::extensions::mojom::ServiceWorkerContext::thread_id) thread_id(
      const ::extensions::mojom::ServiceWorkerContextPtr& input) {
    return input->thread_id;
  }

  static bool Read(::extensions::mojom::ServiceWorkerContext::DataView input, ::extensions::mojom::ServiceWorkerContextPtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::EventListener::DataView,
                                         ::extensions::mojom::EventListenerPtr> {
  static bool IsNull(const ::extensions::mojom::EventListenerPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::EventListenerPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::EventListener::listener_owner)& listener_owner(
      const ::extensions::mojom::EventListenerPtr& input) {
    return input->listener_owner;
  }

  static const decltype(::extensions::mojom::EventListener::event_name)& event_name(
      const ::extensions::mojom::EventListenerPtr& input) {
    return input->event_name;
  }

  static const decltype(::extensions::mojom::EventListener::service_worker_context)& service_worker_context(
      const ::extensions::mojom::EventListenerPtr& input) {
    return input->service_worker_context;
  }

  static const decltype(::extensions::mojom::EventListener::filter)& filter(
      const ::extensions::mojom::EventListenerPtr& input) {
    return input->filter;
  }

  static bool Read(::extensions::mojom::EventListener::DataView input, ::extensions::mojom::EventListenerPtr* output);
};


template <>
struct  UnionTraits<::extensions::mojom::EventListenerOwner::DataView,
                                        ::extensions::mojom::EventListenerOwnerPtr> {
  static bool IsNull(const ::extensions::mojom::EventListenerOwnerPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::EventListenerOwnerPtr* output) { output->reset(); }

  static ::extensions::mojom::EventListenerOwner::Tag GetTag(const ::extensions::mojom::EventListenerOwnerPtr& input) {
    return input->which();
  }

  static const ::extensions::ExtensionId& extension_id(const ::extensions::mojom::EventListenerOwnerPtr& input) {
    return input->get_extension_id();
  }

  static const ::GURL& listener_url(const ::extensions::mojom::EventListenerOwnerPtr& input) {
    return input->get_listener_url();
  }

  static bool Read(::extensions::mojom::EventListenerOwner::DataView input, ::extensions::mojom::EventListenerOwnerPtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_EVENT_ROUTER_MOJOM_H_