// extensions/common/mojom/event_router.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_EVENT_ROUTER_MOJOM_SHARED_H_
#define EXTENSIONS_COMMON_MOJOM_EVENT_ROUTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/event_router.mojom-shared-internal.h"
#include "extensions/common/mojom/extension_id.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "extensions/common/mojom/event_router.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::ServiceWorkerContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::ServiceWorkerContextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::ServiceWorkerContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::scope_url(input)) in_scope_url = Traits::scope_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope_url)::BaseType> scope_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_scope_url,
      scope_url_fragment);

    fragment->scope_url.Set(
        scope_url_fragment.is_null() ? nullptr : scope_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scope_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scope_url in ServiceWorkerContext struct");

    fragment->version_id = Traits::version_id(input);

    fragment->thread_id = Traits::thread_id(input);
  }

  static bool Deserialize(::extensions::mojom::internal::ServiceWorkerContext_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::ServiceWorkerContextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::EventListenerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::EventListenerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::EventListener_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::listener_owner(input)) in_listener_owner = Traits::listener_owner(input);
    mojo::internal::MessageFragment<decltype(fragment->listener_owner)>
        listener_owner_fragment(fragment.message());
    listener_owner_fragment.Claim(&fragment->listener_owner);
    
    mojo::internal::Serialize<::extensions::mojom::EventListenerOwnerDataView>(
      in_listener_owner,
      listener_owner_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->listener_owner.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null listener_owner in EventListener struct");

    decltype(Traits::event_name(input)) in_event_name = Traits::event_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->event_name)::BaseType> event_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_event_name,
      event_name_fragment);

    fragment->event_name.Set(
        event_name_fragment.is_null() ? nullptr : event_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->event_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_name in EventListener struct");

    decltype(Traits::service_worker_context(input)) in_service_worker_context = Traits::service_worker_context(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_worker_context)::BaseType> service_worker_context_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::extensions::mojom::ServiceWorkerContextDataView>(
      in_service_worker_context,
      service_worker_context_fragment);

    fragment->service_worker_context.Set(
        service_worker_context_fragment.is_null() ? nullptr : service_worker_context_fragment.data());

    decltype(Traits::filter(input)) in_filter = Traits::filter(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filter)::BaseType> filter_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_filter,
      filter_fragment);

    fragment->filter.Set(
        filter_fragment.is_null() ? nullptr : filter_fragment.data());
  }

  static bool Deserialize(::extensions::mojom::internal::EventListener_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::EventListenerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::EventListenerOwnerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::extensions::mojom::EventListenerOwnerDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::extensions::mojom::internal::EventListenerOwner_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::extensions::mojom::EventListenerOwnerDataView::Tag::kExtensionId: {
    decltype(Traits::extension_id(input))
    in_extension_id = Traits::extension_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_extension_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
  in_extension_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null extension_id in EventListenerOwner union");
    fragment->data.f_extension_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::extensions::mojom::EventListenerOwnerDataView::Tag::kListenerUrl: {
    decltype(Traits::listener_url(input))
    in_listener_url = Traits::listener_url(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_listener_url)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::url::mojom::UrlDataView>(
  in_listener_url,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null listener_url in EventListenerOwner union");
    fragment->data.f_listener_url.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::extensions::mojom::internal::EventListenerOwner_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::EventListenerOwnerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace extensions::mojom {

inline void ServiceWorkerContextDataView::GetScopeUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->scope_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void EventListenerDataView::GetListenerOwnerDataView(
    EventListenerOwnerDataView* output) {
  auto pointer = &data_->listener_owner;
  *output = EventListenerOwnerDataView(pointer, message_);
}
inline void EventListenerDataView::GetEventNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->event_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void EventListenerDataView::GetServiceWorkerContextDataView(
    ServiceWorkerContextDataView* output) {
  auto pointer = data_->service_worker_context.Get();
  *output = ServiceWorkerContextDataView(pointer, message_);
}
inline void EventListenerDataView::GetFilterDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->filter.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}


inline void EventListenerOwnerDataView::GetExtensionIdDataView(
    ::extensions::mojom::ExtensionIdDataView* output) const {
  CHECK(is_extension_id());
  *output = ::extensions::mojom::ExtensionIdDataView(data_->data.f_extension_id.Get(), message_);
}
inline void EventListenerOwnerDataView::GetListenerUrlDataView(
    ::url::mojom::UrlDataView* output) const {
  CHECK(is_listener_url());
  *output = ::url::mojom::UrlDataView(data_->data.f_listener_url.Get(), message_);
}


}  // extensions::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // EXTENSIONS_COMMON_MOJOM_EVENT_ROUTER_MOJOM_SHARED_H_