// extensions/common/mojom/event_router.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.DictionaryValue');
goog.require('extensions.mojom.ExtensionId');
goog.require('url.mojom.Url');






goog.provide('extensions.mojom.EventRouter');
goog.provide('extensions.mojom.EventRouterReceiver');
goog.provide('extensions.mojom.EventRouterCallbackRouter');
goog.provide('extensions.mojom.EventRouterInterface');
goog.provide('extensions.mojom.EventRouterRemote');
goog.provide('extensions.mojom.EventRouterPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.EventRouterPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.EventRouter.$interfaceName,
        scope);
  }
};

/** @interface */
extensions.mojom.EventRouterInterface = class {
  
  /**
   * @param { !extensions.mojom.EventListener } eventListener
   */

  addListenerForMainThread(eventListener) {}
  
  /**
   * @param { !extensions.mojom.EventListener } eventListener
   */

  addListenerForServiceWorker(eventListener) {}
  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } eventName
   */

  addLazyListenerForMainThread(extensionId, eventName) {}
  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !url.mojom.Url } workerScopeUrl
   * @param { !string } eventName
   */

  addLazyListenerForServiceWorker(extensionId, workerScopeUrl, eventName) {}
  
  /**
   * @param { !extensions.mojom.EventListenerOwner } listenerOwner
   * @param { !string } eventName
   * @param { !mojoBase.mojom.DictionaryValue } filter
   * @param { !boolean } addLazyListener
   */

  addFilteredListenerForMainThread(listenerOwner, eventName, filter, addLazyListener) {}
  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } eventName
   * @param { !extensions.mojom.ServiceWorkerContext } serviceWorkerContext
   * @param { !mojoBase.mojom.DictionaryValue } filter
   * @param { !boolean } addLazyListener
   */

  addFilteredListenerForServiceWorker(extensionId, eventName, serviceWorkerContext, filter, addLazyListener) {}
  
  /**
   * @param { !extensions.mojom.EventListener } eventListener
   */

  removeListenerForMainThread(eventListener) {}
  
  /**
   * @param { !extensions.mojom.EventListener } eventListener
   */

  removeListenerForServiceWorker(eventListener) {}
  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } eventName
   */

  removeLazyListenerForMainThread(extensionId, eventName) {}
  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !url.mojom.Url } workerScopeUrl
   * @param { !string } eventName
   */

  removeLazyListenerForServiceWorker(extensionId, workerScopeUrl, eventName) {}
  
  /**
   * @param { !extensions.mojom.EventListenerOwner } listenerOwner
   * @param { !string } eventName
   * @param { !mojoBase.mojom.DictionaryValue } filter
   * @param { !boolean } removeLazyListener
   */

  removeFilteredListenerForMainThread(listenerOwner, eventName, filter, removeLazyListener) {}
  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } eventName
   * @param { !extensions.mojom.ServiceWorkerContext } serviceWorkerContext
   * @param { !mojoBase.mojom.DictionaryValue } filter
   * @param { !boolean } removeLazyListener
   */

  removeFilteredListenerForServiceWorker(extensionId, eventName, serviceWorkerContext, filter, removeLazyListener) {}
};

/**
 * @export
 * @implements { extensions.mojom.EventRouterInterface }
 */
extensions.mojom.EventRouterRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.EventRouterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.EventRouterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.EventRouterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !extensions.mojom.EventListener } eventListener
   */

  addListenerForMainThread(
      eventListener) {
    this.proxy.sendMessage(
        0,
        extensions.mojom.EventRouter_AddListenerForMainThread_ParamsSpec.$,
        null,
        [
          eventListener
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.EventListener } eventListener
   */

  addListenerForServiceWorker(
      eventListener) {
    this.proxy.sendMessage(
        1,
        extensions.mojom.EventRouter_AddListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          eventListener
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } eventName
   */

  addLazyListenerForMainThread(
      extensionId,
      eventName) {
    this.proxy.sendMessage(
        2,
        extensions.mojom.EventRouter_AddLazyListenerForMainThread_ParamsSpec.$,
        null,
        [
          extensionId,
          eventName
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !url.mojom.Url } workerScopeUrl
   * @param { !string } eventName
   */

  addLazyListenerForServiceWorker(
      extensionId,
      workerScopeUrl,
      eventName) {
    this.proxy.sendMessage(
        3,
        extensions.mojom.EventRouter_AddLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          extensionId,
          workerScopeUrl,
          eventName
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.EventListenerOwner } listenerOwner
   * @param { !string } eventName
   * @param { !mojoBase.mojom.DictionaryValue } filter
   * @param { !boolean } addLazyListener
   */

  addFilteredListenerForMainThread(
      listenerOwner,
      eventName,
      filter,
      addLazyListener) {
    this.proxy.sendMessage(
        4,
        extensions.mojom.EventRouter_AddFilteredListenerForMainThread_ParamsSpec.$,
        null,
        [
          listenerOwner,
          eventName,
          filter,
          addLazyListener
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } eventName
   * @param { !extensions.mojom.ServiceWorkerContext } serviceWorkerContext
   * @param { !mojoBase.mojom.DictionaryValue } filter
   * @param { !boolean } addLazyListener
   */

  addFilteredListenerForServiceWorker(
      extensionId,
      eventName,
      serviceWorkerContext,
      filter,
      addLazyListener) {
    this.proxy.sendMessage(
        5,
        extensions.mojom.EventRouter_AddFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          extensionId,
          eventName,
          serviceWorkerContext,
          filter,
          addLazyListener
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.EventListener } eventListener
   */

  removeListenerForMainThread(
      eventListener) {
    this.proxy.sendMessage(
        6,
        extensions.mojom.EventRouter_RemoveListenerForMainThread_ParamsSpec.$,
        null,
        [
          eventListener
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.EventListener } eventListener
   */

  removeListenerForServiceWorker(
      eventListener) {
    this.proxy.sendMessage(
        7,
        extensions.mojom.EventRouter_RemoveListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          eventListener
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } eventName
   */

  removeLazyListenerForMainThread(
      extensionId,
      eventName) {
    this.proxy.sendMessage(
        8,
        extensions.mojom.EventRouter_RemoveLazyListenerForMainThread_ParamsSpec.$,
        null,
        [
          extensionId,
          eventName
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !url.mojom.Url } workerScopeUrl
   * @param { !string } eventName
   */

  removeLazyListenerForServiceWorker(
      extensionId,
      workerScopeUrl,
      eventName) {
    this.proxy.sendMessage(
        9,
        extensions.mojom.EventRouter_RemoveLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          extensionId,
          workerScopeUrl,
          eventName
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.EventListenerOwner } listenerOwner
   * @param { !string } eventName
   * @param { !mojoBase.mojom.DictionaryValue } filter
   * @param { !boolean } removeLazyListener
   */

  removeFilteredListenerForMainThread(
      listenerOwner,
      eventName,
      filter,
      removeLazyListener) {
    this.proxy.sendMessage(
        10,
        extensions.mojom.EventRouter_RemoveFilteredListenerForMainThread_ParamsSpec.$,
        null,
        [
          listenerOwner,
          eventName,
          filter,
          removeLazyListener
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !string } eventName
   * @param { !extensions.mojom.ServiceWorkerContext } serviceWorkerContext
   * @param { !mojoBase.mojom.DictionaryValue } filter
   * @param { !boolean } removeLazyListener
   */

  removeFilteredListenerForServiceWorker(
      extensionId,
      eventName,
      serviceWorkerContext,
      filter,
      removeLazyListener) {
    this.proxy.sendMessage(
        11,
        extensions.mojom.EventRouter_RemoveFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        [
          extensionId,
          eventName,
          serviceWorkerContext,
          filter,
          removeLazyListener
        ],
        false);
  }
};

/**
 * An object which receives request messages for the EventRouter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.EventRouterReceiver = class {
  /**
   * @param {!extensions.mojom.EventRouterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.EventRouterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.EventRouterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.EventRouterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.EventRouter_AddListenerForMainThread_ParamsSpec.$,
        null,
        impl.addListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.EventRouter_AddListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.addListenerForServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.EventRouter_AddLazyListenerForMainThread_ParamsSpec.$,
        null,
        impl.addLazyListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.EventRouter_AddLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.addLazyListenerForServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        extensions.mojom.EventRouter_AddFilteredListenerForMainThread_ParamsSpec.$,
        null,
        impl.addFilteredListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        extensions.mojom.EventRouter_AddFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.addFilteredListenerForServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        extensions.mojom.EventRouter_RemoveListenerForMainThread_ParamsSpec.$,
        null,
        impl.removeListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        extensions.mojom.EventRouter_RemoveListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.removeListenerForServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        extensions.mojom.EventRouter_RemoveLazyListenerForMainThread_ParamsSpec.$,
        null,
        impl.removeLazyListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        extensions.mojom.EventRouter_RemoveLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.removeLazyListenerForServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        extensions.mojom.EventRouter_RemoveFilteredListenerForMainThread_ParamsSpec.$,
        null,
        impl.removeFilteredListenerForMainThread.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        extensions.mojom.EventRouter_RemoveFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        impl.removeFilteredListenerForServiceWorker.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.EventRouter = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.EventRouter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.EventRouterRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.EventRouterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the EventRouter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.EventRouterCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.EventRouterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.EventRouterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.EventRouter_AddListenerForMainThread_ParamsSpec.$,
        null,
        this.addListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.EventRouter_AddListenerForServiceWorker_ParamsSpec.$,
        null,
        this.addListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addLazyListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.EventRouter_AddLazyListenerForMainThread_ParamsSpec.$,
        null,
        this.addLazyListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addLazyListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.EventRouter_AddLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        this.addLazyListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addFilteredListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        extensions.mojom.EventRouter_AddFilteredListenerForMainThread_ParamsSpec.$,
        null,
        this.addFilteredListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addFilteredListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        extensions.mojom.EventRouter_AddFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        this.addFilteredListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        extensions.mojom.EventRouter_RemoveListenerForMainThread_ParamsSpec.$,
        null,
        this.removeListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        extensions.mojom.EventRouter_RemoveListenerForServiceWorker_ParamsSpec.$,
        null,
        this.removeListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeLazyListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        extensions.mojom.EventRouter_RemoveLazyListenerForMainThread_ParamsSpec.$,
        null,
        this.removeLazyListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeLazyListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        extensions.mojom.EventRouter_RemoveLazyListenerForServiceWorker_ParamsSpec.$,
        null,
        this.removeLazyListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeFilteredListenerForMainThread =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        extensions.mojom.EventRouter_RemoveFilteredListenerForMainThread_ParamsSpec.$,
        null,
        this.removeFilteredListenerForMainThread.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeFilteredListenerForServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        extensions.mojom.EventRouter_RemoveFilteredListenerForServiceWorker_ParamsSpec.$,
        null,
        this.removeFilteredListenerForServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('extensions.mojom.ServiceWorkerContextSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ServiceWorkerContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventListenerSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventListenerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_AddListenerForMainThread_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_AddListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_AddListenerForServiceWorker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_AddListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_AddLazyListenerForMainThread_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_AddLazyListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_AddLazyListenerForServiceWorker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_AddLazyListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_AddFilteredListenerForMainThread_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_AddFilteredListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_AddFilteredListenerForServiceWorker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_AddFilteredListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_RemoveListenerForMainThread_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_RemoveListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_RemoveListenerForServiceWorker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_RemoveListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_RemoveLazyListenerForMainThread_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_RemoveLazyListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_RemoveLazyListenerForServiceWorker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_RemoveLazyListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_RemoveFilteredListenerForMainThread_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_RemoveFilteredListenerForMainThread_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventRouter_RemoveFilteredListenerForServiceWorker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventRouter_RemoveFilteredListenerForServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventListenerOwnerSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
extensions.mojom.EventListenerOwnerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    extensions.mojom.ServiceWorkerContextSpec.$,
    'ServiceWorkerContext',
    [
      mojo.internal.StructField(
        'scopeUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'versionId', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'threadId', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('extensions.mojom.ServiceWorkerContext');

/** @record */
extensions.mojom.ServiceWorkerContext = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.scopeUrl;
    /** @export { !bigint } */
    this.versionId;
    /** @export { !number } */
    this.threadId;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventListenerSpec.$,
    'EventListener',
    [
      mojo.internal.StructField(
        'listenerOwner', 0,
        0,
        extensions.mojom.EventListenerOwnerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerContext', 24,
        0,
        extensions.mojom.ServiceWorkerContextSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filter', 32,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('extensions.mojom.EventListener');

/** @record */
extensions.mojom.EventListener = class {
  constructor() {
    /** @export { !extensions.mojom.EventListenerOwner } */
    this.listenerOwner;
    /** @export { !string } */
    this.eventName;
    /** @export { (extensions.mojom.ServiceWorkerContext|undefined) } */
    this.serviceWorkerContext;
    /** @export { (mojoBase.mojom.DictionaryValue|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_AddListenerForMainThread_ParamsSpec.$,
    'EventRouter_AddListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'eventListener', 0,
        0,
        extensions.mojom.EventListenerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('extensions.mojom.EventRouter_AddListenerForMainThread_Params');

/** @record */
extensions.mojom.EventRouter_AddListenerForMainThread_Params = class {
  constructor() {
    /** @export { !extensions.mojom.EventListener } */
    this.eventListener;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_AddListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_AddListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'eventListener', 0,
        0,
        extensions.mojom.EventListenerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('extensions.mojom.EventRouter_AddListenerForServiceWorker_Params');

/** @record */
extensions.mojom.EventRouter_AddListenerForServiceWorker_Params = class {
  constructor() {
    /** @export { !extensions.mojom.EventListener } */
    this.eventListener;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_AddLazyListenerForMainThread_ParamsSpec.$,
    'EventRouter_AddLazyListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('extensions.mojom.EventRouter_AddLazyListenerForMainThread_Params');

/** @record */
extensions.mojom.EventRouter_AddLazyListenerForMainThread_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !string } */
    this.eventName;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_AddLazyListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_AddLazyListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'workerScopeUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('extensions.mojom.EventRouter_AddLazyListenerForServiceWorker_Params');

/** @record */
extensions.mojom.EventRouter_AddLazyListenerForServiceWorker_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !url.mojom.Url } */
    this.workerScopeUrl;
    /** @export { !string } */
    this.eventName;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_AddFilteredListenerForMainThread_ParamsSpec.$,
    'EventRouter_AddFilteredListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'listenerOwner', 0,
        0,
        extensions.mojom.EventListenerOwnerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filter', 24,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'addLazyListener', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('extensions.mojom.EventRouter_AddFilteredListenerForMainThread_Params');

/** @record */
extensions.mojom.EventRouter_AddFilteredListenerForMainThread_Params = class {
  constructor() {
    /** @export { !extensions.mojom.EventListenerOwner } */
    this.listenerOwner;
    /** @export { !string } */
    this.eventName;
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.filter;
    /** @export { !boolean } */
    this.addLazyListener;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_AddFilteredListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_AddFilteredListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerContext', 16,
        0,
        extensions.mojom.ServiceWorkerContextSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filter', 24,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'addLazyListener', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('extensions.mojom.EventRouter_AddFilteredListenerForServiceWorker_Params');

/** @record */
extensions.mojom.EventRouter_AddFilteredListenerForServiceWorker_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !string } */
    this.eventName;
    /** @export { !extensions.mojom.ServiceWorkerContext } */
    this.serviceWorkerContext;
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.filter;
    /** @export { !boolean } */
    this.addLazyListener;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_RemoveListenerForMainThread_ParamsSpec.$,
    'EventRouter_RemoveListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'eventListener', 0,
        0,
        extensions.mojom.EventListenerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('extensions.mojom.EventRouter_RemoveListenerForMainThread_Params');

/** @record */
extensions.mojom.EventRouter_RemoveListenerForMainThread_Params = class {
  constructor() {
    /** @export { !extensions.mojom.EventListener } */
    this.eventListener;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_RemoveListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_RemoveListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'eventListener', 0,
        0,
        extensions.mojom.EventListenerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('extensions.mojom.EventRouter_RemoveListenerForServiceWorker_Params');

/** @record */
extensions.mojom.EventRouter_RemoveListenerForServiceWorker_Params = class {
  constructor() {
    /** @export { !extensions.mojom.EventListener } */
    this.eventListener;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_RemoveLazyListenerForMainThread_ParamsSpec.$,
    'EventRouter_RemoveLazyListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('extensions.mojom.EventRouter_RemoveLazyListenerForMainThread_Params');

/** @record */
extensions.mojom.EventRouter_RemoveLazyListenerForMainThread_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !string } */
    this.eventName;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_RemoveLazyListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_RemoveLazyListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'workerScopeUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('extensions.mojom.EventRouter_RemoveLazyListenerForServiceWorker_Params');

/** @record */
extensions.mojom.EventRouter_RemoveLazyListenerForServiceWorker_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !url.mojom.Url } */
    this.workerScopeUrl;
    /** @export { !string } */
    this.eventName;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_RemoveFilteredListenerForMainThread_ParamsSpec.$,
    'EventRouter_RemoveFilteredListenerForMainThread_Params',
    [
      mojo.internal.StructField(
        'listenerOwner', 0,
        0,
        extensions.mojom.EventListenerOwnerSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filter', 24,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'removeLazyListener', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('extensions.mojom.EventRouter_RemoveFilteredListenerForMainThread_Params');

/** @record */
extensions.mojom.EventRouter_RemoveFilteredListenerForMainThread_Params = class {
  constructor() {
    /** @export { !extensions.mojom.EventListenerOwner } */
    this.listenerOwner;
    /** @export { !string } */
    this.eventName;
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.filter;
    /** @export { !boolean } */
    this.removeLazyListener;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventRouter_RemoveFilteredListenerForServiceWorker_ParamsSpec.$,
    'EventRouter_RemoveFilteredListenerForServiceWorker_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceWorkerContext', 16,
        0,
        extensions.mojom.ServiceWorkerContextSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filter', 24,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'removeLazyListener', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('extensions.mojom.EventRouter_RemoveFilteredListenerForServiceWorker_Params');

/** @record */
extensions.mojom.EventRouter_RemoveFilteredListenerForServiceWorker_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !string } */
    this.eventName;
    /** @export { !extensions.mojom.ServiceWorkerContext } */
    this.serviceWorkerContext;
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.filter;
    /** @export { !boolean } */
    this.removeLazyListener;
  }
};

goog.provide('extensions.mojom.EventListenerOwner');


mojo.internal.Union(
    extensions.mojom.EventListenerOwnerSpec.$, 'EventListenerOwner',
    {
      'extensionId': {
        'ordinal': 0,
        'type': extensions.mojom.ExtensionIdSpec.$,
      },
      'listenerUrl': {
        'ordinal': 1,
        'type': url.mojom.UrlSpec.$,
      },
    });

/**
 * @typedef { {
 *   extensionId: (!extensions.mojom.ExtensionId|undefined),
 *   listenerUrl: (!url.mojom.Url|undefined),
 * } }
 */
extensions.mojom.EventListenerOwner;
