// extensions/common/mojom/event_dispatcher.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  ListValue as mojoBase_mojom_ListValue,
  ListValueSpec as mojoBase_mojom_ListValueSpec
} from '../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../url/mojom/url.mojom.m.js';

import {
  HostID as extensions_mojom_HostID,
  HostIDSpec as extensions_mojom_HostIDSpec
} from './host_id.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class EventDispatcherPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mojom.EventDispatcher', scope);
  }
}

/** @interface */
export class EventDispatcherInterface {
  
  /**
   * @param { !DispatchEventParams } params
   * @param { !mojoBase_mojom_ListValue } eventArgs
   * @return {!Promise<{
        eventWillRunInLazyBackgroundPageScript: !boolean,
   *  }>}
   */

  dispatchEvent(params, eventArgs) {}
}

/**
 * @implements { EventDispatcherInterface }
 */
export class EventDispatcherRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!EventDispatcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          EventDispatcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!EventDispatcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !DispatchEventParams } params
   * @param { !mojoBase_mojom_ListValue } eventArgs
   * @return {!Promise<{
        eventWillRunInLazyBackgroundPageScript: !boolean,
   *  }>}
   */

  dispatchEvent(
      params,
      eventArgs) {
    return this.proxy.sendMessage(
        0,
        EventDispatcher_DispatchEvent_ParamsSpec.$,
        EventDispatcher_DispatchEvent_ResponseParamsSpec.$,
        [
          params,
          eventArgs
        ],
        false);
  }
}

/**
 * An object which receives request messages for the EventDispatcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class EventDispatcherReceiver {
  /**
   * @param {!EventDispatcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!EventDispatcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        EventDispatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EventDispatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        EventDispatcher_DispatchEvent_ParamsSpec.$,
        EventDispatcher_DispatchEvent_ResponseParamsSpec.$,
        impl.dispatchEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class EventDispatcher {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.EventDispatcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!EventDispatcherRemote}
   */
  static getRemote() {
    let remote = new EventDispatcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the EventDispatcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class EventDispatcherCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      EventDispatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EventDispatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        EventDispatcher_DispatchEvent_ParamsSpec.$,
        EventDispatcher_DispatchEvent_ResponseParamsSpec.$,
        this.dispatchEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventFilteringInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DispatchEventParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventDispatcher_DispatchEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EventDispatcher_DispatchEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    EventFilteringInfoSpec.$,
    'EventFilteringInfo',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceType', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasInstanceId', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'instanceId', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'windowType', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasWindowExposedByDefault', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'windowExposedByDefault', 16,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class EventFilteringInfo {
  constructor() {
    /** @type { (url_mojom_Url|undefined) } */
    this.url;
    /** @type { (string|undefined) } */
    this.serviceType;
    /** @type { !boolean } */
    this.hasInstanceId;
    /** @type { !number } */
    this.instanceId;
    /** @type { (string|undefined) } */
    this.windowType;
    /** @type { !boolean } */
    this.hasWindowExposedByDefault;
    /** @type { !boolean } */
    this.windowExposedByDefault;
  }
}



mojo.internal.Struct(
    DispatchEventParamsSpec.$,
    'DispatchEventParams',
    [
      mojo.internal.StructField(
        'workerThreadId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostId', 8,
        0,
        extensions_mojom_HostIDSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isUserGesture', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filteringInfo', 32,
        0,
        EventFilteringInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class DispatchEventParams {
  constructor() {
    /** @type { !number } */
    this.workerThreadId;
    /** @type { !extensions_mojom_HostID } */
    this.hostId;
    /** @type { !string } */
    this.eventName;
    /** @type { !number } */
    this.eventId;
    /** @type { !boolean } */
    this.isUserGesture;
    /** @type { !EventFilteringInfo } */
    this.filteringInfo;
  }
}



mojo.internal.Struct(
    EventDispatcher_DispatchEvent_ParamsSpec.$,
    'EventDispatcher_DispatchEvent_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        DispatchEventParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventArgs', 8,
        0,
        mojoBase_mojom_ListValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EventDispatcher_DispatchEvent_Params {
  constructor() {
    /** @type { !DispatchEventParams } */
    this.params;
    /** @type { !mojoBase_mojom_ListValue } */
    this.eventArgs;
  }
}



mojo.internal.Struct(
    EventDispatcher_DispatchEvent_ResponseParamsSpec.$,
    'EventDispatcher_DispatchEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'eventWillRunInLazyBackgroundPageScript', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EventDispatcher_DispatchEvent_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.eventWillRunInLazyBackgroundPageScript;
  }
}

