// extensions/common/mojom/event_dispatcher.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('extensions.mojom.HostID');
goog.require('mojoBase.mojom.ListValue');
goog.require('url.mojom.Url');






goog.provide('extensions.mojom.EventDispatcher');
goog.provide('extensions.mojom.EventDispatcherReceiver');
goog.provide('extensions.mojom.EventDispatcherCallbackRouter');
goog.provide('extensions.mojom.EventDispatcherInterface');
goog.provide('extensions.mojom.EventDispatcherRemote');
goog.provide('extensions.mojom.EventDispatcherPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.EventDispatcherPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.EventDispatcher.$interfaceName,
        scope);
  }
};

/** @interface */
extensions.mojom.EventDispatcherInterface = class {
  
  /**
   * @param { !extensions.mojom.DispatchEventParams } params
   * @param { !mojoBase.mojom.ListValue } eventArgs
   * @return {!Promise<{
        eventWillRunInLazyBackgroundPageScript: !boolean,
   *  }>}
   */

  dispatchEvent(params, eventArgs) {}
};

/**
 * @export
 * @implements { extensions.mojom.EventDispatcherInterface }
 */
extensions.mojom.EventDispatcherRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.EventDispatcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.EventDispatcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.EventDispatcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !extensions.mojom.DispatchEventParams } params
   * @param { !mojoBase.mojom.ListValue } eventArgs
   * @return {!Promise<{
        eventWillRunInLazyBackgroundPageScript: !boolean,
   *  }>}
   */

  dispatchEvent(
      params,
      eventArgs) {
    return this.proxy.sendMessage(
        0,
        extensions.mojom.EventDispatcher_DispatchEvent_ParamsSpec.$,
        extensions.mojom.EventDispatcher_DispatchEvent_ResponseParamsSpec.$,
        [
          params,
          eventArgs
        ],
        false);
  }
};

/**
 * An object which receives request messages for the EventDispatcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.EventDispatcherReceiver = class {
  /**
   * @param {!extensions.mojom.EventDispatcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.EventDispatcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.EventDispatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.EventDispatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.EventDispatcher_DispatchEvent_ParamsSpec.$,
        extensions.mojom.EventDispatcher_DispatchEvent_ResponseParamsSpec.$,
        impl.dispatchEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.EventDispatcher = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.EventDispatcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.EventDispatcherRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.EventDispatcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the EventDispatcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.EventDispatcherCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.EventDispatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.EventDispatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.EventDispatcher_DispatchEvent_ParamsSpec.$,
        extensions.mojom.EventDispatcher_DispatchEvent_ResponseParamsSpec.$,
        this.dispatchEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('extensions.mojom.EventFilteringInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventFilteringInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.DispatchEventParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.DispatchEventParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventDispatcher_DispatchEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventDispatcher_DispatchEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('extensions.mojom.EventDispatcher_DispatchEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.EventDispatcher_DispatchEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    extensions.mojom.EventFilteringInfoSpec.$,
    'EventFilteringInfo',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serviceType', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasInstanceId', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'instanceId', 20,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'windowType', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasWindowExposedByDefault', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'windowExposedByDefault', 16,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('extensions.mojom.EventFilteringInfo');

/** @record */
extensions.mojom.EventFilteringInfo = class {
  constructor() {
    /** @export { (url.mojom.Url|undefined) } */
    this.url;
    /** @export { (string|undefined) } */
    this.serviceType;
    /** @export { !boolean } */
    this.hasInstanceId;
    /** @export { !number } */
    this.instanceId;
    /** @export { (string|undefined) } */
    this.windowType;
    /** @export { !boolean } */
    this.hasWindowExposedByDefault;
    /** @export { !boolean } */
    this.windowExposedByDefault;
  }
};



mojo.internal.Struct(
    extensions.mojom.DispatchEventParamsSpec.$,
    'DispatchEventParams',
    [
      mojo.internal.StructField(
        'workerThreadId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostId', 8,
        0,
        extensions.mojom.HostIDSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventId', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isUserGesture', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filteringInfo', 32,
        0,
        extensions.mojom.EventFilteringInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('extensions.mojom.DispatchEventParams');

/** @record */
extensions.mojom.DispatchEventParams = class {
  constructor() {
    /** @export { !number } */
    this.workerThreadId;
    /** @export { !extensions.mojom.HostID } */
    this.hostId;
    /** @export { !string } */
    this.eventName;
    /** @export { !number } */
    this.eventId;
    /** @export { !boolean } */
    this.isUserGesture;
    /** @export { !extensions.mojom.EventFilteringInfo } */
    this.filteringInfo;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventDispatcher_DispatchEvent_ParamsSpec.$,
    'EventDispatcher_DispatchEvent_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        extensions.mojom.DispatchEventParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventArgs', 8,
        0,
        mojoBase.mojom.ListValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('extensions.mojom.EventDispatcher_DispatchEvent_Params');

/** @record */
extensions.mojom.EventDispatcher_DispatchEvent_Params = class {
  constructor() {
    /** @export { !extensions.mojom.DispatchEventParams } */
    this.params;
    /** @export { !mojoBase.mojom.ListValue } */
    this.eventArgs;
  }
};



mojo.internal.Struct(
    extensions.mojom.EventDispatcher_DispatchEvent_ResponseParamsSpec.$,
    'EventDispatcher_DispatchEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'eventWillRunInLazyBackgroundPageScript', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('extensions.mojom.EventDispatcher_DispatchEvent_ResponseParams');

/** @record */
extensions.mojom.EventDispatcher_DispatchEvent_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.eventWillRunInLazyBackgroundPageScript;
  }
};

