// extensions/common/mojom/event_dispatcher.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_DATA_VIEW_H_
#define EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "extensions/common/mojom/event_dispatcher.mojom-shared-internal.h"
#include "extensions/common/mojom/host_id.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace extensions::mojom {
class EventFilteringInfoDataView;

class DispatchEventParamsDataView;



}  // extensions::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::EventFilteringInfoDataView> {
  using Data = ::extensions::mojom::internal::EventFilteringInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::DispatchEventParamsDataView> {
  using Data = ::extensions::mojom::internal::DispatchEventParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {
// Interface base classes. They are used for type safety check.
class EventDispatcherInterfaceBase {};

using EventDispatcherPtrDataView =
    mojo::InterfacePtrDataView<EventDispatcherInterfaceBase>;
using EventDispatcherRequestDataView =
    mojo::InterfaceRequestDataView<EventDispatcherInterfaceBase>;
using EventDispatcherAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<EventDispatcherInterfaceBase>;
using EventDispatcherAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<EventDispatcherInterfaceBase>;


class EventFilteringInfoDataView {
 public:
  EventFilteringInfoDataView() = default;

  EventFilteringInfoDataView(
      internal::EventFilteringInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetServiceTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `service_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServiceType` instead "
    "of `ReadServiceType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->service_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_instance_id() const {
    return data_->has_instance_id;
  }
  int32_t instance_id() const {
    return data_->instance_id;
  }
  inline void GetWindowTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindowType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `window_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWindowType` instead "
    "of `ReadWindowType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->window_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_window_exposed_by_default() const {
    return data_->has_window_exposed_by_default;
  }
  bool window_exposed_by_default() const {
    return data_->window_exposed_by_default;
  }
 private:
  internal::EventFilteringInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DispatchEventParamsDataView {
 public:
  DispatchEventParamsDataView() = default;

  DispatchEventParamsDataView(
      internal::DispatchEventParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t worker_thread_id() const {
    return data_->worker_thread_id;
  }
  inline void GetHostIdDataView(
      ::extensions::mojom::HostIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostId(UserType* output) {
    
    auto* pointer = data_->host_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::HostIDDataView>(
        pointer, output, message_);
  }
  inline void GetEventNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventName(UserType* output) {
    
    auto* pointer = data_->event_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t event_id() const {
    return data_->event_id;
  }
  bool is_user_gesture() const {
    return data_->is_user_gesture;
  }
  inline void GetFilteringInfoDataView(
      EventFilteringInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilteringInfo(UserType* output) {
    
    auto* pointer = data_->filtering_info.Get();
    return mojo::internal::Deserialize<::extensions::mojom::EventFilteringInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::DispatchEventParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // extensions::mojom

#endif  // EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_DATA_VIEW_H_