// extensions/common/mojom/code_injection.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SEND_VALIDATION_H_
#define EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SEND_VALIDATION_H_

#include "extensions/common/mojom/code_injection.mojom-shared-internal.h"
#include "extensions/common/mojom/css_origin.mojom-shared.h"
#include "extensions/common/mojom/execution_world.mojom-shared.h"
#include "third_party/blink/public/mojom/script/script_evaluation_params.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "extensions/common/mojom/code_injection.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::JSSourceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::JSSourceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::JSSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::code(input)) in_code = Traits::code(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->code)::BaseType> code_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_code,
        code_fragment);

      fragment->code.Set(
          code_fragment.is_null() ? nullptr : code_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->code.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null code in JSSource struct");

      decltype(Traits::script_url(input)) in_script_url = Traits::script_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->script_url)::BaseType> script_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_script_url,
        script_url_fragment);

      fragment->script_url.Set(
          script_url_fragment.is_null() ? nullptr : script_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->script_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script_url in JSSource struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::CSSSourceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::CSSSourceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::CSSSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::code(input)) in_code = Traits::code(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->code)::BaseType> code_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_code,
        code_fragment);

      fragment->code.Set(
          code_fragment.is_null() ? nullptr : code_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->code.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null code in CSSSource struct");

      decltype(Traits::key(input)) in_key = Traits::key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key)::BaseType> key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_key,
        key_fragment);

      fragment->key.Set(
          key_fragment.is_null() ? nullptr : key_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::JSInjectionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::JSInjectionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::JSInjection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::sources(input)) in_sources = Traits::sources(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sources)::BaseType>
          sources_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::JSSourceDataView>, send_validation>(
        in_sources,
        sources_fragment,
        &sources_validate_params);

      fragment->sources.Set(
          sources_fragment.is_null() ? nullptr : sources_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sources.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sources in JSInjection struct");

      
      mojo::internal::Serialize<::extensions::mojom::ExecutionWorld>(
        Traits::world(input),
        &fragment->world);

      decltype(Traits::world_id(input)) in_world_id = Traits::world_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->world_id)::BaseType> world_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_world_id,
        world_id_fragment);

      fragment->world_id.Set(
          world_id_fragment.is_null() ? nullptr : world_id_fragment.data());

      
      mojo::internal::Serialize<::blink::mojom::WantResultOption>(
        Traits::wants_result(input),
        &fragment->wants_result);

      
      mojo::internal::Serialize<::blink::mojom::UserActivationOption>(
        Traits::user_gesture(input),
        &fragment->user_gesture);

      
      mojo::internal::Serialize<::blink::mojom::PromiseResultOption>(
        Traits::wait_for_promise(input),
        &fragment->wait_for_promise);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::CSSInjectionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::CSSInjectionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::CSSInjection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::sources(input)) in_sources = Traits::sources(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sources)::BaseType>
          sources_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::CSSSourceDataView>, send_validation>(
        in_sources,
        sources_fragment,
        &sources_validate_params);

      fragment->sources.Set(
          sources_fragment.is_null() ? nullptr : sources_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sources.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sources in CSSInjection struct");

      
      mojo::internal::Serialize<::extensions::mojom::CSSOrigin>(
        Traits::css_origin(input),
        &fragment->css_origin);

      
      mojo::internal::Serialize<::extensions::mojom::CSSInjection_Operation>(
        Traits::operation(input),
        &fragment->operation);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::CodeInjectionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::extensions::mojom::CodeInjectionDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::extensions::mojom::internal::CodeInjection_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::extensions::mojom::CodeInjectionDataView::Tag::kCss: {
    decltype(Traits::css(input))
    in_css = Traits::css(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_css)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::extensions::mojom::CSSInjectionDataView, send_validation>(
  in_css,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null css in CodeInjection union");
    fragment->data.f_css.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::extensions::mojom::CodeInjectionDataView::Tag::kJs: {
    decltype(Traits::js(input))
    in_js = Traits::js(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_js)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::extensions::mojom::JSInjectionDataView, send_validation>(
  in_js,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null js in CodeInjection union");
    fragment->data.f_js.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SEND_VALIDATION_H_