// extensions/common/api/mime_handler.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MimeHandlerServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mime_handler.MimeHandlerService', scope);
  }
}

/** @interface */
export class MimeHandlerServiceInterface {
  
  /**
   * @return {!Promise<{
        streamInfo: ?StreamInfo,
   *  }>}
   */

  getStreamInfo() {}
  
  /**
   * @param { !PdfPluginAttributes } pdfPluginAttributes
   */

  setPdfPluginAttributes(pdfPluginAttributes) {}
}

/**
 * @implements { MimeHandlerServiceInterface }
 */
export class MimeHandlerServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MimeHandlerServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MimeHandlerServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MimeHandlerServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        streamInfo: ?StreamInfo,
   *  }>}
   */

  getStreamInfo() {
    return this.proxy.sendMessage(
        0,
        MimeHandlerService_GetStreamInfo_ParamsSpec.$,
        MimeHandlerService_GetStreamInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !PdfPluginAttributes } pdfPluginAttributes
   */

  setPdfPluginAttributes(
      pdfPluginAttributes) {
    this.proxy.sendMessage(
        1,
        MimeHandlerService_SetPdfPluginAttributes_ParamsSpec.$,
        null,
        [
          pdfPluginAttributes
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MimeHandlerService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MimeHandlerServiceReceiver {
  /**
   * @param {!MimeHandlerServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MimeHandlerServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MimeHandlerServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MimeHandlerServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MimeHandlerService_GetStreamInfo_ParamsSpec.$,
        MimeHandlerService_GetStreamInfo_ResponseParamsSpec.$,
        impl.getStreamInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MimeHandlerService_SetPdfPluginAttributes_ParamsSpec.$,
        null,
        impl.setPdfPluginAttributes.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MimeHandlerService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mime_handler.MimeHandlerService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MimeHandlerServiceRemote}
   */
  static getRemote() {
    let remote = new MimeHandlerServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MimeHandlerService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MimeHandlerServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MimeHandlerServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MimeHandlerServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStreamInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MimeHandlerService_GetStreamInfo_ParamsSpec.$,
        MimeHandlerService_GetStreamInfo_ResponseParamsSpec.$,
        this.getStreamInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPdfPluginAttributes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MimeHandlerService_SetPdfPluginAttributes_ParamsSpec.$,
        null,
        this.setPdfPluginAttributes.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BeforeUnloadControlPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'extensions.mime_handler.BeforeUnloadControl', scope);
  }
}

/** @interface */
export class BeforeUnloadControlInterface {
  
  /**
   * @param { !boolean } showDialog
   * @return {!Promise}
   */

  setShowBeforeUnloadDialog(showDialog) {}
}

/**
 * @implements { BeforeUnloadControlInterface }
 */
export class BeforeUnloadControlRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BeforeUnloadControlPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BeforeUnloadControlPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BeforeUnloadControlPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } showDialog
   * @return {!Promise}
   */

  setShowBeforeUnloadDialog(
      showDialog) {
    return this.proxy.sendMessage(
        0,
        BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsSpec.$,
        BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsSpec.$,
        [
          showDialog
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BeforeUnloadControl
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BeforeUnloadControlReceiver {
  /**
   * @param {!BeforeUnloadControlInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BeforeUnloadControlRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BeforeUnloadControlRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BeforeUnloadControlRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsSpec.$,
        BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsSpec.$,
        impl.setShowBeforeUnloadDialog.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BeforeUnloadControl {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mime_handler.BeforeUnloadControl";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BeforeUnloadControlRemote}
   */
  static getRemote() {
    let remote = new BeforeUnloadControlRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BeforeUnloadControl
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BeforeUnloadControlCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BeforeUnloadControlRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BeforeUnloadControlRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setShowBeforeUnloadDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsSpec.$,
        BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsSpec.$,
        this.setShowBeforeUnloadDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StreamInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PdfPluginAttributesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MimeHandlerService_GetStreamInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MimeHandlerService_GetStreamInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MimeHandlerService_SetPdfPluginAttributes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    StreamInfoSpec.$,
    'StreamInfo',
    [
      mojo.internal.StructField(
        'mimeType', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originalUrl', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'streamUrl', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tabId', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseHeaders', 32,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'embedded', 28,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class StreamInfo {
  constructor() {
    /** @type { !string } */
    this.mimeType;
    /** @type { !string } */
    this.originalUrl;
    /** @type { !string } */
    this.streamUrl;
    /** @type { !number } */
    this.tabId;
    /** @type { !Object<!string, !string> } */
    this.responseHeaders;
    /** @type { !boolean } */
    this.embedded;
  }
}



mojo.internal.Struct(
    PdfPluginAttributesSpec.$,
    'PdfPluginAttributes',
    [
      mojo.internal.StructField(
        'backgroundColor', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowJavascript', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PdfPluginAttributes {
  constructor() {
    /** @type { !number } */
    this.backgroundColor;
    /** @type { !boolean } */
    this.allowJavascript;
  }
}



mojo.internal.Struct(
    MimeHandlerService_GetStreamInfo_ParamsSpec.$,
    'MimeHandlerService_GetStreamInfo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MimeHandlerService_GetStreamInfo_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MimeHandlerService_GetStreamInfo_ResponseParamsSpec.$,
    'MimeHandlerService_GetStreamInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'streamInfo', 0,
        0,
        StreamInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MimeHandlerService_GetStreamInfo_ResponseParams {
  constructor() {
    /** @type { (StreamInfo|undefined) } */
    this.streamInfo;
  }
}



mojo.internal.Struct(
    MimeHandlerService_SetPdfPluginAttributes_ParamsSpec.$,
    'MimeHandlerService_SetPdfPluginAttributes_Params',
    [
      mojo.internal.StructField(
        'pdfPluginAttributes', 0,
        0,
        PdfPluginAttributesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MimeHandlerService_SetPdfPluginAttributes_Params {
  constructor() {
    /** @type { !PdfPluginAttributes } */
    this.pdfPluginAttributes;
  }
}



mojo.internal.Struct(
    BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsSpec.$,
    'BeforeUnloadControl_SetShowBeforeUnloadDialog_Params',
    [
      mojo.internal.StructField(
        'showDialog', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BeforeUnloadControl_SetShowBeforeUnloadDialog_Params {
  constructor() {
    /** @type { !boolean } */
    this.showDialog;
  }
}



mojo.internal.Struct(
    BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsSpec.$,
    'BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams {
  constructor() {
  }
}

