// extensions/common/api/mime_handler.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_SEND_VALIDATION_H_
#define EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_SEND_VALIDATION_H_

#include "extensions/common/api/mime_handler.mojom-shared-internal.h"

#include "extensions/common/api/mime_handler.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mime_handler::StreamInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mime_handler::StreamInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mime_handler::internal::StreamInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in StreamInfo struct");

      decltype(Traits::original_url(input)) in_original_url = Traits::original_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->original_url)::BaseType> original_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_original_url,
        original_url_fragment);

      fragment->original_url.Set(
          original_url_fragment.is_null() ? nullptr : original_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->original_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null original_url in StreamInfo struct");

      decltype(Traits::stream_url(input)) in_stream_url = Traits::stream_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->stream_url)::BaseType> stream_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_stream_url,
        stream_url_fragment);

      fragment->stream_url.Set(
          stream_url_fragment.is_null() ? nullptr : stream_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->stream_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stream_url in StreamInfo struct");

      fragment->tab_id = Traits::tab_id(input);

      decltype(Traits::response_headers(input)) in_response_headers = Traits::response_headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->response_headers)::BaseType>
          response_headers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& response_headers_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>, send_validation>(
        in_response_headers,
        response_headers_fragment,
        &response_headers_validate_params);

      fragment->response_headers.Set(
          response_headers_fragment.is_null() ? nullptr : response_headers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->response_headers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_headers in StreamInfo struct");

      fragment->embedded = Traits::embedded(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mime_handler::PdfPluginAttributesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mime_handler::PdfPluginAttributesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mime_handler::internal::PdfPluginAttributes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->background_color = Traits::background_color(input);

      fragment->allow_javascript = Traits::allow_javascript(input);
  }
};

}  // namespace mojo::internal

#endif  // EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_SEND_VALIDATION_H_