// extensions/common/api/mime_handler.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_DATA_VIEW_H_
#define EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "extensions/common/api/mime_handler.mojom-shared-internal.h"


namespace extensions::mime_handler {
class StreamInfoDataView;

class PdfPluginAttributesDataView;



}  // extensions::mime_handler


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mime_handler::StreamInfoDataView> {
  using Data = ::extensions::mime_handler::internal::StreamInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mime_handler::PdfPluginAttributesDataView> {
  using Data = ::extensions::mime_handler::internal::PdfPluginAttributes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mime_handler {
// Interface base classes. They are used for type safety check.
class MimeHandlerServiceInterfaceBase {};

using MimeHandlerServicePtrDataView =
    mojo::InterfacePtrDataView<MimeHandlerServiceInterfaceBase>;
using MimeHandlerServiceRequestDataView =
    mojo::InterfaceRequestDataView<MimeHandlerServiceInterfaceBase>;
using MimeHandlerServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MimeHandlerServiceInterfaceBase>;
using MimeHandlerServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MimeHandlerServiceInterfaceBase>;
class BeforeUnloadControlInterfaceBase {};

using BeforeUnloadControlPtrDataView =
    mojo::InterfacePtrDataView<BeforeUnloadControlInterfaceBase>;
using BeforeUnloadControlRequestDataView =
    mojo::InterfaceRequestDataView<BeforeUnloadControlInterfaceBase>;
using BeforeUnloadControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BeforeUnloadControlInterfaceBase>;
using BeforeUnloadControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BeforeUnloadControlInterfaceBase>;


class StreamInfoDataView {
 public:
  StreamInfoDataView() = default;

  StreamInfoDataView(
      internal::StreamInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOriginalUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalUrl(UserType* output) {
    
    auto* pointer = data_->original_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStreamUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStreamUrl(UserType* output) {
    
    auto* pointer = data_->stream_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  inline void GetResponseHeadersDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseHeaders(UserType* output) {
    
    auto* pointer = data_->response_headers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool embedded() const {
    return data_->embedded;
  }
 private:
  internal::StreamInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PdfPluginAttributesDataView {
 public:
  PdfPluginAttributesDataView() = default;

  PdfPluginAttributesDataView(
      internal::PdfPluginAttributes_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double background_color() const {
    return data_->background_color;
  }
  bool allow_javascript() const {
    return data_->allow_javascript;
  }
 private:
  internal::PdfPluginAttributes_Data* data_ = nullptr;
};


}  // extensions::mime_handler

#endif  // EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_DATA_VIEW_H_