// device/vr/public/mojom/xr_session.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_DATA_VIEW_H_
#define DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "device/vr/public/mojom/xr_session.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace device::mojom {
class XRTrackedImageDataView;

class XRDepthOptionsDataView;

class XRSessionOptionsDataView;

class XrFrameStatisticsDataView;

class XrLogMessageDataView;



}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::XRTrackedImageDataView> {
  using Data = ::device::mojom::internal::XRTrackedImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDepthOptionsDataView> {
  using Data = ::device::mojom::internal::XRDepthOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRSessionOptionsDataView> {
  using Data = ::device::mojom::internal::XRSessionOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XrFrameStatisticsDataView> {
  using Data = ::device::mojom::internal::XrFrameStatistics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XrLogMessageDataView> {
  using Data = ::device::mojom::internal::XrLogMessage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class RequestSessionError : int32_t {
  
  EXISTING_IMMERSIVE_SESSION = 1,
  
  INVALID_CLIENT = 2,
  
  USER_DENIED_CONSENT = 3,
  
  NO_RUNTIME_FOUND = 4,
  
  UNKNOWN_RUNTIME_ERROR = 5,
  
  RUNTIME_INSTALL_FAILURE = 6,
  
  RUNTIMES_CHANGED = 7,
  
  FULLSCREEN_ERROR = 8,
  
  UNKNOWN_FAILURE = 9,
  kMinValue = 1,
  kMaxValue = 9,
};

COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, RequestSessionError value);
inline bool IsKnownEnumValue(RequestSessionError value) {
  return internal::RequestSessionError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRSessionFeature : int32_t {
  
  REF_SPACE_VIEWER = 1,
  
  REF_SPACE_LOCAL = 2,
  
  REF_SPACE_LOCAL_FLOOR = 3,
  
  REF_SPACE_BOUNDED_FLOOR = 4,
  
  REF_SPACE_UNBOUNDED = 5,
  
  DOM_OVERLAY = 6,
  
  HIT_TEST = 7,
  
  LIGHT_ESTIMATION = 8,
  
  ANCHORS = 9,
  
  CAMERA_ACCESS = 10,
  
  PLANE_DETECTION = 11,
  
  DEPTH = 12,
  
  IMAGE_TRACKING = 13,
  
  HAND_INPUT = 14,
  
  SECONDARY_VIEWS = 15,
  
  LAYERS = 16,
  
  FRONT_FACING = 17,
  
  WEBGPU = 18,
  kMinValue = 1,
  kMaxValue = 18,
};

COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRSessionFeature value);
inline bool IsKnownEnumValue(XRSessionFeature value) {
  return internal::XRSessionFeature_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRSessionMode : int32_t {
  
  kInline = 1,
  
  kImmersiveVr = 2,
  
  kImmersiveAr = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRSessionMode value);
inline bool IsKnownEnumValue(XRSessionMode value) {
  return internal::XRSessionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRDepthUsage : int32_t {
  
  kCPUOptimized = 1,
  
  kGPUOptimized = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRDepthUsage value);
inline bool IsKnownEnumValue(XRDepthUsage value) {
  return internal::XRDepthUsage_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRDepthDataFormat : int32_t {
  
  kLuminanceAlpha = 1,
  
  kFloat32 = 2,
  
  kUnsignedShort = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRDepthDataFormat value);
inline bool IsKnownEnumValue(XRDepthDataFormat value) {
  return internal::XRDepthDataFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRDepthType : int32_t {
  
  kRaw = 1,
  
  kSmooth = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRDepthType value);
inline bool IsKnownEnumValue(XRDepthType value) {
  return internal::XRDepthType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class XRTrackedImageDataView {
 public:
  XRTrackedImageDataView() = default;

  XRTrackedImageDataView(
      internal::XRTrackedImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBitmapDataView(
      ::skia::mojom::BitmapN32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) {
    
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        pointer, output, message_);
  }
  inline void GetSizeInPixelsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizeInPixels(UserType* output) {
    
    auto* pointer = data_->size_in_pixels.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float width_in_meters() const {
    return data_->width_in_meters;
  }
 private:
  internal::XRTrackedImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRDepthOptionsDataView {
 public:
  XRDepthOptionsDataView() = default;

  XRDepthOptionsDataView(
      internal::XRDepthOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUsagePreferencesDataView(
      mojo::ArrayDataView<XRDepthUsage>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsagePreferences(UserType* output) {
    
    auto* pointer = data_->usage_preferences.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRDepthUsage>>(
        pointer, output, message_);
  }
  inline void GetDataFormatPreferencesDataView(
      mojo::ArrayDataView<XRDepthDataFormat>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataFormatPreferences(UserType* output) {
    
    auto* pointer = data_->data_format_preferences.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRDepthDataFormat>>(
        pointer, output, message_);
  }
  inline void GetDepthTypeRequestDataView(
      mojo::ArrayDataView<XRDepthType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDepthTypeRequest(UserType* output) {
    
    auto* pointer = data_->depth_type_request.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRDepthType>>(
        pointer, output, message_);
  }
  bool match_depth_view() const {
    return data_->match_depth_view;
  }
 private:
  internal::XRDepthOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRSessionOptionsDataView {
 public:
  XRSessionOptionsDataView() = default;

  XRSessionOptionsDataView(
      internal::XRSessionOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::device::mojom::XRSessionMode>(
        data_value, output);
  }
  XRSessionMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRSessionMode>(data_->mode));
  }
  inline void GetRequiredFeaturesDataView(
      mojo::ArrayDataView<XRSessionFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequiredFeatures(UserType* output) {
    
    auto* pointer = data_->required_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, message_);
  }
  inline void GetOptionalFeaturesDataView(
      mojo::ArrayDataView<XRSessionFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptionalFeatures(UserType* output) {
    
    auto* pointer = data_->optional_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, message_);
  }
  inline void GetTrackedImagesDataView(
      mojo::ArrayDataView<XRTrackedImageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackedImages(UserType* output) {
    
    auto* pointer = data_->tracked_images.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataView>>(
        pointer, output, message_);
  }
  inline void GetDepthOptionsDataView(
      XRDepthOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDepthOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRDepthOptionsDataView, UserType>(),
    "Attempting to read the optional `depth_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDepthOptions` instead "
    "of `ReadDepthOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->depth_options.Get();
    return mojo::internal::Deserialize<::device::mojom::XRDepthOptionsDataView>(
        pointer, output, message_);
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
 private:
  internal::XRSessionOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XrFrameStatisticsDataView {
 public:
  XrFrameStatisticsDataView() = default;

  XrFrameStatisticsDataView(
      internal::XrFrameStatistics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint64_t num_frames() const {
    return data_->num_frames;
  }
  uint64_t dropped_frames() const {
    return data_->dropped_frames;
  }
  inline void GetFrameDataTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameDataTime(UserType* output) {
    
    auto* pointer = data_->frame_data_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetPageAnimationFrameTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageAnimationFrameTime(UserType* output) {
    
    auto* pointer = data_->page_animation_frame_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetSubmitFrameTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubmitFrameTime(UserType* output) {
    
    auto* pointer = data_->submit_frame_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::XrFrameStatistics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XrLogMessageDataView {
 public:
  XrLogMessageDataView() = default;

  XrLogMessageDataView(
      internal::XrLogMessage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::XrLogMessage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // device::mojom

#endif  // DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_DATA_VIEW_H_