// device/vr/public/mojom/xr_session.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_BLINK_H_
#define DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/xr_session.mojom-features.h"  // IWYU pragma: export
#include "device/vr/public/mojom/xr_session.mojom-shared.h"  // IWYU pragma: export
#include "device/vr/public/mojom/xr_session.mojom-blink-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {









class COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_BLINK) XrLogMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XrLogMessage, T>::value>;
  using DataView = XrLogMessageDataView;
  using Data_ = internal::XrLogMessage_Data;

  template <typename... Args>
  static XrLogMessagePtr New(Args&&... args) {
    return XrLogMessagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XrLogMessagePtr From(const U& u) {
    return mojo::TypeConverter<XrLogMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XrLogMessage>::Convert(*this);
  }


  XrLogMessage();

  XrLogMessage(
      uint64_t trace_id,
      const ::blink::String& message);


  ~XrLogMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XrLogMessagePtr>
  XrLogMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XrLogMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XrLogMessage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XrLogMessage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XrLogMessage::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XrLogMessage::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XrLogMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XrLogMessage_UnserializedMessageContext<
            UserType, XrLogMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XrLogMessage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XrLogMessage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XrLogMessage_UnserializedMessageContext<
            UserType, XrLogMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XrLogMessage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t trace_id;
  
  ::blink::String message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XrLogMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XrLogMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XrLogMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XrLogMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_BLINK) XRTrackedImage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRTrackedImage, T>::value>;
  using DataView = XRTrackedImageDataView;
  using Data_ = internal::XRTrackedImage_Data;

  template <typename... Args>
  static XRTrackedImagePtr New(Args&&... args) {
    return XRTrackedImagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRTrackedImagePtr From(const U& u) {
    return mojo::TypeConverter<XRTrackedImagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRTrackedImage>::Convert(*this);
  }


  XRTrackedImage();

  XRTrackedImage(
      const ::SkBitmap& bitmap,
      const ::gfx::Size& size_in_pixels,
      float width_in_meters);


  ~XRTrackedImage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRTrackedImagePtr>
  XRTrackedImagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRTrackedImage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRTrackedImage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRTrackedImage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRTrackedImage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRTrackedImage_UnserializedMessageContext<
            UserType, XRTrackedImage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRTrackedImage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRTrackedImage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRTrackedImage_UnserializedMessageContext<
            UserType, XRTrackedImage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRTrackedImage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkBitmap bitmap;
  
  ::gfx::Size size_in_pixels;
  
  float width_in_meters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRTrackedImage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRTrackedImage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRTrackedImage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRTrackedImage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_BLINK) XRDepthOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRDepthOptions, T>::value>;
  using DataView = XRDepthOptionsDataView;
  using Data_ = internal::XRDepthOptions_Data;

  template <typename... Args>
  static XRDepthOptionsPtr New(Args&&... args) {
    return XRDepthOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRDepthOptionsPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthOptions>::Convert(*this);
  }


  XRDepthOptions();

  XRDepthOptions(
      ::blink::Vector<XRDepthUsage> usage_preferences,
      ::blink::Vector<XRDepthDataFormat> data_format_preferences,
      ::blink::Vector<XRDepthType> depth_type_request,
      bool match_depth_view);


  ~XRDepthOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRDepthOptionsPtr>
  XRDepthOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRDepthOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRDepthOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRDepthOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDepthOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDepthOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRDepthOptions_UnserializedMessageContext<
            UserType, XRDepthOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRDepthOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRDepthOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRDepthOptions_UnserializedMessageContext<
            UserType, XRDepthOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRDepthOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<XRDepthUsage> usage_preferences;
  
  ::blink::Vector<XRDepthDataFormat> data_format_preferences;
  
  ::blink::Vector<XRDepthType> depth_type_request;
  
  bool match_depth_view;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRDepthOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRDepthOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRDepthOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRDepthOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_BLINK) XRSessionOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRSessionOptions, T>::value>;
  using DataView = XRSessionOptionsDataView;
  using Data_ = internal::XRSessionOptions_Data;

  template <typename... Args>
  static XRSessionOptionsPtr New(Args&&... args) {
    return XRSessionOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRSessionOptionsPtr From(const U& u) {
    return mojo::TypeConverter<XRSessionOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRSessionOptions>::Convert(*this);
  }


  XRSessionOptions();

  XRSessionOptions(
      XRSessionMode mode,
      ::blink::Vector<XRSessionFeature> required_features,
      ::blink::Vector<XRSessionFeature> optional_features,
      ::blink::Vector<XRTrackedImagePtr> tracked_images,
      XRDepthOptionsPtr depth_options,
      uint64_t trace_id);

XRSessionOptions(const XRSessionOptions&) = delete;
XRSessionOptions& operator=(const XRSessionOptions&) = delete;

  ~XRSessionOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRSessionOptionsPtr>
  XRSessionOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRSessionOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRSessionOptions_UnserializedMessageContext<
            UserType, XRSessionOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRSessionOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRSessionOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRSessionOptions_UnserializedMessageContext<
            UserType, XRSessionOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRSessionOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRSessionMode mode;
  
  ::blink::Vector<XRSessionFeature> required_features;
  
  ::blink::Vector<XRSessionFeature> optional_features;
  
  ::blink::Vector<XRTrackedImagePtr> tracked_images;
  
  XRDepthOptionsPtr depth_options;
  
  uint64_t trace_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRSessionOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_BLINK) XrFrameStatistics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XrFrameStatistics, T>::value>;
  using DataView = XrFrameStatisticsDataView;
  using Data_ = internal::XrFrameStatistics_Data;

  template <typename... Args>
  static XrFrameStatisticsPtr New(Args&&... args) {
    return XrFrameStatisticsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XrFrameStatisticsPtr From(const U& u) {
    return mojo::TypeConverter<XrFrameStatisticsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XrFrameStatistics>::Convert(*this);
  }


  XrFrameStatistics();

  XrFrameStatistics(
      uint64_t trace_id,
      ::base::TimeDelta duration,
      uint64_t num_frames,
      uint64_t dropped_frames,
      ::base::TimeDelta frame_data_time,
      ::base::TimeDelta page_animation_frame_time,
      ::base::TimeDelta submit_frame_time);


  ~XrFrameStatistics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XrFrameStatisticsPtr>
  XrFrameStatisticsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XrFrameStatistics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XrFrameStatistics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XrFrameStatistics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XrFrameStatistics::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XrFrameStatistics::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XrFrameStatistics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XrFrameStatistics_UnserializedMessageContext<
            UserType, XrFrameStatistics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XrFrameStatistics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XrFrameStatistics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XrFrameStatistics_UnserializedMessageContext<
            UserType, XrFrameStatistics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XrFrameStatistics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t trace_id;
  
  ::base::TimeDelta duration;
  
  uint64_t num_frames;
  
  uint64_t dropped_frames;
  
  ::base::TimeDelta frame_data_time;
  
  ::base::TimeDelta page_animation_frame_time;
  
  ::base::TimeDelta submit_frame_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XrFrameStatistics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XrFrameStatistics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XrFrameStatistics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XrFrameStatistics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
XRTrackedImagePtr XRTrackedImage::Clone() const {
  return New(
      mojo::Clone(bitmap),
      mojo::Clone(size_in_pixels),
      mojo::Clone(width_in_meters)
  );
}

template <typename T, XRTrackedImage::EnableIfSame<T>*>
bool XRTrackedImage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bitmap, other_struct.bitmap))
    return false;
  if (!mojo::Equals(this->size_in_pixels, other_struct.size_in_pixels))
    return false;
  if (!mojo::Equals(this->width_in_meters, other_struct.width_in_meters))
    return false;
  return true;
}

template <typename T, XRTrackedImage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bitmap < rhs.bitmap)
    return true;
  if (rhs.bitmap < lhs.bitmap)
    return false;
  if (lhs.size_in_pixels < rhs.size_in_pixels)
    return true;
  if (rhs.size_in_pixels < lhs.size_in_pixels)
    return false;
  if (lhs.width_in_meters < rhs.width_in_meters)
    return true;
  if (rhs.width_in_meters < lhs.width_in_meters)
    return false;
  return false;
}
template <typename StructPtrType>
XRDepthOptionsPtr XRDepthOptions::Clone() const {
  return New(
      mojo::Clone(usage_preferences),
      mojo::Clone(data_format_preferences),
      mojo::Clone(depth_type_request),
      mojo::Clone(match_depth_view)
  );
}

template <typename T, XRDepthOptions::EnableIfSame<T>*>
bool XRDepthOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->usage_preferences, other_struct.usage_preferences))
    return false;
  if (!mojo::Equals(this->data_format_preferences, other_struct.data_format_preferences))
    return false;
  if (!mojo::Equals(this->depth_type_request, other_struct.depth_type_request))
    return false;
  if (!mojo::Equals(this->match_depth_view, other_struct.match_depth_view))
    return false;
  return true;
}

template <typename T, XRDepthOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.usage_preferences < rhs.usage_preferences)
    return true;
  if (rhs.usage_preferences < lhs.usage_preferences)
    return false;
  if (lhs.data_format_preferences < rhs.data_format_preferences)
    return true;
  if (rhs.data_format_preferences < lhs.data_format_preferences)
    return false;
  if (lhs.depth_type_request < rhs.depth_type_request)
    return true;
  if (rhs.depth_type_request < lhs.depth_type_request)
    return false;
  if (lhs.match_depth_view < rhs.match_depth_view)
    return true;
  if (rhs.match_depth_view < lhs.match_depth_view)
    return false;
  return false;
}
template <typename StructPtrType>
XRSessionOptionsPtr XRSessionOptions::Clone() const {
  return New(
      mojo::Clone(mode),
      mojo::Clone(required_features),
      mojo::Clone(optional_features),
      mojo::Clone(tracked_images),
      mojo::Clone(depth_options),
      mojo::Clone(trace_id)
  );
}

template <typename T, XRSessionOptions::EnableIfSame<T>*>
bool XRSessionOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->required_features, other_struct.required_features))
    return false;
  if (!mojo::Equals(this->optional_features, other_struct.optional_features))
    return false;
  if (!mojo::Equals(this->tracked_images, other_struct.tracked_images))
    return false;
  if (!mojo::Equals(this->depth_options, other_struct.depth_options))
    return false;
  if (!mojo::Equals(this->trace_id, other_struct.trace_id))
    return false;
  return true;
}

template <typename T, XRSessionOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.required_features < rhs.required_features)
    return true;
  if (rhs.required_features < lhs.required_features)
    return false;
  if (lhs.optional_features < rhs.optional_features)
    return true;
  if (rhs.optional_features < lhs.optional_features)
    return false;
  if (lhs.tracked_images < rhs.tracked_images)
    return true;
  if (rhs.tracked_images < lhs.tracked_images)
    return false;
  if (lhs.depth_options < rhs.depth_options)
    return true;
  if (rhs.depth_options < lhs.depth_options)
    return false;
  if (lhs.trace_id < rhs.trace_id)
    return true;
  if (rhs.trace_id < lhs.trace_id)
    return false;
  return false;
}
template <typename StructPtrType>
XrFrameStatisticsPtr XrFrameStatistics::Clone() const {
  return New(
      mojo::Clone(trace_id),
      mojo::Clone(duration),
      mojo::Clone(num_frames),
      mojo::Clone(dropped_frames),
      mojo::Clone(frame_data_time),
      mojo::Clone(page_animation_frame_time),
      mojo::Clone(submit_frame_time)
  );
}

template <typename T, XrFrameStatistics::EnableIfSame<T>*>
bool XrFrameStatistics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->trace_id, other_struct.trace_id))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->num_frames, other_struct.num_frames))
    return false;
  if (!mojo::Equals(this->dropped_frames, other_struct.dropped_frames))
    return false;
  if (!mojo::Equals(this->frame_data_time, other_struct.frame_data_time))
    return false;
  if (!mojo::Equals(this->page_animation_frame_time, other_struct.page_animation_frame_time))
    return false;
  if (!mojo::Equals(this->submit_frame_time, other_struct.submit_frame_time))
    return false;
  return true;
}

template <typename T, XrFrameStatistics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.trace_id < rhs.trace_id)
    return true;
  if (rhs.trace_id < lhs.trace_id)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  if (lhs.num_frames < rhs.num_frames)
    return true;
  if (rhs.num_frames < lhs.num_frames)
    return false;
  if (lhs.dropped_frames < rhs.dropped_frames)
    return true;
  if (rhs.dropped_frames < lhs.dropped_frames)
    return false;
  if (lhs.frame_data_time < rhs.frame_data_time)
    return true;
  if (rhs.frame_data_time < lhs.frame_data_time)
    return false;
  if (lhs.page_animation_frame_time < rhs.page_animation_frame_time)
    return true;
  if (rhs.page_animation_frame_time < lhs.page_animation_frame_time)
    return false;
  if (lhs.submit_frame_time < rhs.submit_frame_time)
    return true;
  if (rhs.submit_frame_time < lhs.submit_frame_time)
    return false;
  return false;
}
template <typename StructPtrType>
XrLogMessagePtr XrLogMessage::Clone() const {
  return New(
      mojo::Clone(trace_id),
      mojo::Clone(message)
  );
}

template <typename T, XrLogMessage::EnableIfSame<T>*>
bool XrLogMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->trace_id, other_struct.trace_id))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  return true;
}

template <typename T, XrLogMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.trace_id < rhs.trace_id)
    return true;
  if (rhs.trace_id < lhs.trace_id)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  return false;
}


}  // device::mojom::blink

namespace mojo {


template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRTrackedImage::DataView,
                                         ::device::mojom::blink::XRTrackedImagePtr> {
  static bool IsNull(const ::device::mojom::blink::XRTrackedImagePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRTrackedImagePtr* output) { output->reset(); }

  static  decltype(::device::mojom::blink::XRTrackedImage::bitmap)& bitmap(
       ::device::mojom::blink::XRTrackedImagePtr& input) {
    return input->bitmap;
  }

  static const decltype(::device::mojom::blink::XRTrackedImage::size_in_pixels)& size_in_pixels(
      const ::device::mojom::blink::XRTrackedImagePtr& input) {
    return input->size_in_pixels;
  }

  static decltype(::device::mojom::blink::XRTrackedImage::width_in_meters) width_in_meters(
      const ::device::mojom::blink::XRTrackedImagePtr& input) {
    return input->width_in_meters;
  }

  static bool Read(::device::mojom::blink::XRTrackedImage::DataView input, ::device::mojom::blink::XRTrackedImagePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRDepthOptions::DataView,
                                         ::device::mojom::blink::XRDepthOptionsPtr> {
  static bool IsNull(const ::device::mojom::blink::XRDepthOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRDepthOptionsPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRDepthOptions::usage_preferences)& usage_preferences(
      const ::device::mojom::blink::XRDepthOptionsPtr& input) {
    return input->usage_preferences;
  }

  static const decltype(::device::mojom::blink::XRDepthOptions::data_format_preferences)& data_format_preferences(
      const ::device::mojom::blink::XRDepthOptionsPtr& input) {
    return input->data_format_preferences;
  }

  static const decltype(::device::mojom::blink::XRDepthOptions::depth_type_request)& depth_type_request(
      const ::device::mojom::blink::XRDepthOptionsPtr& input) {
    return input->depth_type_request;
  }

  static decltype(::device::mojom::blink::XRDepthOptions::match_depth_view) match_depth_view(
      const ::device::mojom::blink::XRDepthOptionsPtr& input) {
    return input->match_depth_view;
  }

  static bool Read(::device::mojom::blink::XRDepthOptions::DataView input, ::device::mojom::blink::XRDepthOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRSessionOptions::DataView,
                                         ::device::mojom::blink::XRSessionOptionsPtr> {
  static bool IsNull(const ::device::mojom::blink::XRSessionOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRSessionOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRSessionOptions::mode) mode(
      const ::device::mojom::blink::XRSessionOptionsPtr& input) {
    return input->mode;
  }

  static const decltype(::device::mojom::blink::XRSessionOptions::required_features)& required_features(
      const ::device::mojom::blink::XRSessionOptionsPtr& input) {
    return input->required_features;
  }

  static const decltype(::device::mojom::blink::XRSessionOptions::optional_features)& optional_features(
      const ::device::mojom::blink::XRSessionOptionsPtr& input) {
    return input->optional_features;
  }

  static  decltype(::device::mojom::blink::XRSessionOptions::tracked_images)& tracked_images(
       ::device::mojom::blink::XRSessionOptionsPtr& input) {
    return input->tracked_images;
  }

  static const decltype(::device::mojom::blink::XRSessionOptions::depth_options)& depth_options(
      const ::device::mojom::blink::XRSessionOptionsPtr& input) {
    return input->depth_options;
  }

  static decltype(::device::mojom::blink::XRSessionOptions::trace_id) trace_id(
      const ::device::mojom::blink::XRSessionOptionsPtr& input) {
    return input->trace_id;
  }

  static bool Read(::device::mojom::blink::XRSessionOptions::DataView input, ::device::mojom::blink::XRSessionOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XrFrameStatistics::DataView,
                                         ::device::mojom::blink::XrFrameStatisticsPtr> {
  static bool IsNull(const ::device::mojom::blink::XrFrameStatisticsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XrFrameStatisticsPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XrFrameStatistics::trace_id) trace_id(
      const ::device::mojom::blink::XrFrameStatisticsPtr& input) {
    return input->trace_id;
  }

  static const decltype(::device::mojom::blink::XrFrameStatistics::duration)& duration(
      const ::device::mojom::blink::XrFrameStatisticsPtr& input) {
    return input->duration;
  }

  static decltype(::device::mojom::blink::XrFrameStatistics::num_frames) num_frames(
      const ::device::mojom::blink::XrFrameStatisticsPtr& input) {
    return input->num_frames;
  }

  static decltype(::device::mojom::blink::XrFrameStatistics::dropped_frames) dropped_frames(
      const ::device::mojom::blink::XrFrameStatisticsPtr& input) {
    return input->dropped_frames;
  }

  static const decltype(::device::mojom::blink::XrFrameStatistics::frame_data_time)& frame_data_time(
      const ::device::mojom::blink::XrFrameStatisticsPtr& input) {
    return input->frame_data_time;
  }

  static const decltype(::device::mojom::blink::XrFrameStatistics::page_animation_frame_time)& page_animation_frame_time(
      const ::device::mojom::blink::XrFrameStatisticsPtr& input) {
    return input->page_animation_frame_time;
  }

  static const decltype(::device::mojom::blink::XrFrameStatistics::submit_frame_time)& submit_frame_time(
      const ::device::mojom::blink::XrFrameStatisticsPtr& input) {
    return input->submit_frame_time;
  }

  static bool Read(::device::mojom::blink::XrFrameStatistics::DataView input, ::device::mojom::blink::XrFrameStatisticsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XrLogMessage::DataView,
                                         ::device::mojom::blink::XrLogMessagePtr> {
  static bool IsNull(const ::device::mojom::blink::XrLogMessagePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XrLogMessagePtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XrLogMessage::trace_id) trace_id(
      const ::device::mojom::blink::XrLogMessagePtr& input) {
    return input->trace_id;
  }

  static const decltype(::device::mojom::blink::XrLogMessage::message)& message(
      const ::device::mojom::blink::XrLogMessagePtr& input) {
    return input->message;
  }

  static bool Read(::device::mojom::blink::XrLogMessage::DataView input, ::device::mojom::blink::XrLogMessagePtr* output);
};

}  // namespace mojo

#endif  // DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_BLINK_H_