// device/vr/public/mojom/xr_session.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/vr/public/mojom/xr_session.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/vr/public/mojom/xr_session.mojom-params-data.h"
#include "device/vr/public/mojom/xr_session.mojom-shared-message-ids.h"

#include "device/vr/public/mojom/xr_session.mojom-blink-import-headers.h"
#include "device/vr/public/mojom/xr_session.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
XRTrackedImage::XRTrackedImage()
    : bitmap(),
      size_in_pixels(),
      width_in_meters() {}

XRTrackedImage::XRTrackedImage(
    const ::SkBitmap& bitmap_in,
    const ::gfx::Size& size_in_pixels_in,
    float width_in_meters_in)
    : bitmap(std::move(bitmap_in)),
      size_in_pixels(std::move(size_in_pixels_in)),
      width_in_meters(std::move(width_in_meters_in)) {}

XRTrackedImage::~XRTrackedImage() = default;

void XRTrackedImage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitmap"), this->bitmap,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkBitmap&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_in_pixels"), this->size_in_pixels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width_in_meters"), this->width_in_meters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRTrackedImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRDepthOptions::XRDepthOptions()
    : usage_preferences(),
      data_format_preferences(),
      depth_type_request(),
      match_depth_view() {}

XRDepthOptions::XRDepthOptions(
    ::blink::Vector<XRDepthUsage> usage_preferences_in,
    ::blink::Vector<XRDepthDataFormat> data_format_preferences_in,
    ::blink::Vector<XRDepthType> depth_type_request_in,
    bool match_depth_view_in)
    : usage_preferences(std::move(usage_preferences_in)),
      data_format_preferences(std::move(data_format_preferences_in)),
      depth_type_request(std::move(depth_type_request_in)),
      match_depth_view(std::move(match_depth_view_in)) {}

XRDepthOptions::~XRDepthOptions() = default;

void XRDepthOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage_preferences"), this->usage_preferences,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<XRDepthUsage>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_format_preferences"), this->data_format_preferences,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<XRDepthDataFormat>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_type_request"), this->depth_type_request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<XRDepthType>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_depth_view"), this->match_depth_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRDepthOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XRSessionOptions::XRSessionOptions()
    : mode(),
      required_features(),
      optional_features(),
      tracked_images(),
      depth_options(),
      trace_id() {}

XRSessionOptions::XRSessionOptions(
    XRSessionMode mode_in,
    ::blink::Vector<XRSessionFeature> required_features_in,
    ::blink::Vector<XRSessionFeature> optional_features_in,
    ::blink::Vector<XRTrackedImagePtr> tracked_images_in,
    XRDepthOptionsPtr depth_options_in,
    uint64_t trace_id_in)
    : mode(std::move(mode_in)),
      required_features(std::move(required_features_in)),
      optional_features(std::move(optional_features_in)),
      tracked_images(std::move(tracked_images_in)),
      depth_options(std::move(depth_options_in)),
      trace_id(std::move(trace_id_in)) {}

XRSessionOptions::~XRSessionOptions() = default;

void XRSessionOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRSessionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "required_features"), this->required_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<XRSessionFeature>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optional_features"), this->optional_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<XRSessionFeature>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tracked_images"), this->tracked_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<XRTrackedImagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth_options"), this->depth_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type XRDepthOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_id"), this->trace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XRSessionOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XrFrameStatistics::XrFrameStatistics()
    : trace_id(),
      duration(),
      num_frames(),
      dropped_frames(),
      frame_data_time(),
      page_animation_frame_time(),
      submit_frame_time() {}

XrFrameStatistics::XrFrameStatistics(
    uint64_t trace_id_in,
    ::base::TimeDelta duration_in,
    uint64_t num_frames_in,
    uint64_t dropped_frames_in,
    ::base::TimeDelta frame_data_time_in,
    ::base::TimeDelta page_animation_frame_time_in,
    ::base::TimeDelta submit_frame_time_in)
    : trace_id(std::move(trace_id_in)),
      duration(std::move(duration_in)),
      num_frames(std::move(num_frames_in)),
      dropped_frames(std::move(dropped_frames_in)),
      frame_data_time(std::move(frame_data_time_in)),
      page_animation_frame_time(std::move(page_animation_frame_time_in)),
      submit_frame_time(std::move(submit_frame_time_in)) {}

XrFrameStatistics::~XrFrameStatistics() = default;

void XrFrameStatistics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_id"), this->trace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_frames"), this->num_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dropped_frames"), this->dropped_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_data_time"), this->frame_data_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_animation_frame_time"), this->page_animation_frame_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "submit_frame_time"), this->submit_frame_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XrFrameStatistics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
XrLogMessage::XrLogMessage()
    : trace_id(),
      message() {}

XrLogMessage::XrLogMessage(
    uint64_t trace_id_in,
    const ::blink::String& message_in)
    : trace_id(std::move(trace_id_in)),
      message(std::move(message_in)) {}

XrLogMessage::~XrLogMessage() = default;
size_t XrLogMessage::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->trace_id);
  seed = mojo::internal::WTFHash(seed, this->message);
  return seed;
}

void XrLogMessage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_id"), this->trace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool XrLogMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // device::mojom::blink


namespace mojo {


// static
bool StructTraits<::device::mojom::blink::XRTrackedImage::DataView, ::device::mojom::blink::XRTrackedImagePtr>::Read(
    ::device::mojom::blink::XRTrackedImage::DataView input,
    ::device::mojom::blink::XRTrackedImagePtr* output) {
  bool success = true;
  ::device::mojom::blink::XRTrackedImagePtr result(::device::mojom::blink::XRTrackedImage::New());
  
      if (success && !input.ReadBitmap(&result->bitmap))
        success = false;
      if (success && !input.ReadSizeInPixels(&result->size_in_pixels))
        success = false;
      if (success)
        result->width_in_meters = input.width_in_meters();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRDepthOptions::DataView, ::device::mojom::blink::XRDepthOptionsPtr>::Read(
    ::device::mojom::blink::XRDepthOptions::DataView input,
    ::device::mojom::blink::XRDepthOptionsPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRDepthOptionsPtr result(::device::mojom::blink::XRDepthOptions::New());
  
      if (success && !input.ReadUsagePreferences(&result->usage_preferences))
        success = false;
      if (success && !input.ReadDataFormatPreferences(&result->data_format_preferences))
        success = false;
      if (success && !input.ReadDepthTypeRequest(&result->depth_type_request))
        success = false;
      if (success)
        result->match_depth_view = input.match_depth_view();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XRSessionOptions::DataView, ::device::mojom::blink::XRSessionOptionsPtr>::Read(
    ::device::mojom::blink::XRSessionOptions::DataView input,
    ::device::mojom::blink::XRSessionOptionsPtr* output) {
  bool success = true;
  ::device::mojom::blink::XRSessionOptionsPtr result(::device::mojom::blink::XRSessionOptions::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadRequiredFeatures(&result->required_features))
        success = false;
      if (success && !input.ReadOptionalFeatures(&result->optional_features))
        success = false;
      if (success && !input.ReadTrackedImages(&result->tracked_images))
        success = false;
      if (success && !input.ReadDepthOptions(&result->depth_options))
        success = false;
      if (success)
        result->trace_id = input.trace_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XrFrameStatistics::DataView, ::device::mojom::blink::XrFrameStatisticsPtr>::Read(
    ::device::mojom::blink::XrFrameStatistics::DataView input,
    ::device::mojom::blink::XrFrameStatisticsPtr* output) {
  bool success = true;
  ::device::mojom::blink::XrFrameStatisticsPtr result(::device::mojom::blink::XrFrameStatistics::New());
  
      if (success)
        result->trace_id = input.trace_id();
      if (success && !input.ReadDuration(&result->duration))
        success = false;
      if (success)
        result->num_frames = input.num_frames();
      if (success)
        result->dropped_frames = input.dropped_frames();
      if (success && !input.ReadFrameDataTime(&result->frame_data_time))
        success = false;
      if (success && !input.ReadPageAnimationFrameTime(&result->page_animation_frame_time))
        success = false;
      if (success && !input.ReadSubmitFrameTime(&result->submit_frame_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::XrLogMessage::DataView, ::device::mojom::blink::XrLogMessagePtr>::Read(
    ::device::mojom::blink::XrLogMessage::DataView input,
    ::device::mojom::blink::XrLogMessagePtr* output) {
  bool success = true;
  ::device::mojom::blink::XrLogMessagePtr result(::device::mojom::blink::XrLogMessage::New());
  
      if (success)
        result->trace_id = input.trace_id();
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {




}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif