// device/vr/public/mojom/xr_hand_tracking_data.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_SHARED_H_
#define DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-shared-internal.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"




#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::device::mojom::XRHandJoint>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRHandJoint> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHandJoint, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRHandJoint, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRHandJoint>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHandJointDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHandJointDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHandJointData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::device::mojom::XRHandJoint>(
      Traits::joint(input),
      &fragment->joint);

    decltype(Traits::mojo_from_joint(input)) in_mojo_from_joint = Traits::mojo_from_joint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mojo_from_joint)::BaseType> mojo_from_joint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
      in_mojo_from_joint,
      mojo_from_joint_fragment);

    fragment->mojo_from_joint.Set(
        mojo_from_joint_fragment.is_null() ? nullptr : mojo_from_joint_fragment.data());

    fragment->radius = Traits::radius(input);
  }

  static bool Deserialize(::device::mojom::internal::XRHandJointData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHandJointDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRHandTrackingDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHandTrackingDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHandTrackingData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::hand_joint_data(input)) in_hand_joint_data = Traits::hand_joint_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hand_joint_data)::BaseType>
        hand_joint_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hand_joint_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRHandJointDataDataView>>(
      in_hand_joint_data,
      hand_joint_data_fragment,
      &hand_joint_data_validate_params);

    fragment->hand_joint_data.Set(
        hand_joint_data_fragment.is_null() ? nullptr : hand_joint_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hand_joint_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hand_joint_data in XRHandTrackingData struct");
  }

  static bool Deserialize(::device::mojom::internal::XRHandTrackingData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRHandTrackingDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void XRHandJointDataDataView::GetMojoFromJointDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->mojo_from_joint.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}


inline void XRHandTrackingDataDataView::GetHandJointDataDataView(
    mojo::ArrayDataView<XRHandJointDataDataView>* output) {
  auto pointer = data_->hand_joint_data.Get();
  *output = mojo::ArrayDataView<XRHandJointDataDataView>(pointer, message_);
}



}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRHandJoint> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRHandJoint value);
};

} // namespace perfetto

#endif  // DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_SHARED_H_