// device/vr/public/mojom/xr_hand_tracking_data.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_DATA_VIEW_H_
#define DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-shared-internal.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"


namespace device::mojom {
class XRHandJointDataDataView;

class XRHandTrackingDataDataView;



}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::XRHandJointDataDataView> {
  using Data = ::device::mojom::internal::XRHandJointData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRHandTrackingDataDataView> {
  using Data = ::device::mojom::internal::XRHandTrackingData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class XRHandJoint : int32_t {
  
  kWrist = 0,
  
  kThumbMetacarpal = 1,
  
  kThumbPhalanxProximal = 2,
  
  kThumbPhalanxDistal = 3,
  
  kThumbTip = 4,
  
  kIndexFingerMetacarpal = 5,
  
  kIndexFingerPhalanxProximal = 6,
  
  kIndexFingerPhalanxIntermediate = 7,
  
  kIndexFingerPhalanxDistal = 8,
  
  kIndexFingerTip = 9,
  
  kMiddleFingerMetacarpal = 10,
  
  kMiddleFingerPhalanxProximal = 11,
  
  kMiddleFingerPhalanxIntermediate = 12,
  
  kMiddleFingerPhalanxDistal = 13,
  
  kMiddleFingerTip = 14,
  
  kRingFingerMetacarpal = 15,
  
  kRingFingerPhalanxProximal = 16,
  
  kRingFingerPhalanxIntermediate = 17,
  
  kRingFingerPhalanxDistal = 18,
  
  kRingFingerTip = 19,
  
  kPinkyFingerMetacarpal = 20,
  
  kPinkyFingerPhalanxProximal = 21,
  
  kPinkyFingerPhalanxIntermediate = 22,
  
  kPinkyFingerPhalanxDistal = 23,
  
  kPinkyFingerTip = 24,
  kMinValue = 0,
  kMaxValue = 24,
};

COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRHandJoint value);
inline bool IsKnownEnumValue(XRHandJoint value) {
  return internal::XRHandJoint_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class XRHandJointDataDataView {
 public:
  XRHandJointDataDataView() = default;

  XRHandJointDataDataView(
      internal::XRHandJointData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadJoint(UserType* output) const {
    auto data_value = data_->joint;
    return mojo::internal::Deserialize<::device::mojom::XRHandJoint>(
        data_value, output);
  }
  XRHandJoint joint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRHandJoint>(data_->joint));
  }
  inline void GetMojoFromJointDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMojoFromJoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `mojo_from_joint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMojoFromJoint` instead "
    "of `ReadMojoFromJoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mojo_from_joint.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  float radius() const {
    return data_->radius;
  }
 private:
  internal::XRHandJointData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRHandTrackingDataDataView {
 public:
  XRHandTrackingDataDataView() = default;

  XRHandTrackingDataDataView(
      internal::XRHandTrackingData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHandJointDataDataView(
      mojo::ArrayDataView<XRHandJointDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHandJointData(UserType* output) {
    
    auto* pointer = data_->hand_joint_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRHandJointDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::XRHandTrackingData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // device::mojom

#endif  // DEVICE_VR_PUBLIC_MOJOM_XR_HAND_TRACKING_DATA_MOJOM_DATA_VIEW_H_