// device/vr/public/mojom/vr_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_BLINK_H_
#define DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/vr_service.mojom-features.h"  // IWYU pragma: export
#include "device/vr/public/mojom/vr_service.mojom-shared.h"  // IWYU pragma: export
#include "device/vr/public/mojom/vr_service.mojom-blink-forward.h"  // IWYU pragma: export
#include "device/gamepad/public/mojom/gamepad.mojom-blink.h"
#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-blink.h"
#include "device/vr/public/mojom/xr_session.mojom-blink-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "gpu/ipc/common/exported_shared_image.mojom-blink.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-blink-forward.h"
#include "gpu/ipc/common/mailbox_holder.mojom-blink.h"
#include "gpu/ipc/common/sync_token.mojom-blink.h"
#include "ui/display/mojom/display.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-blink.h"
#include "ui/gfx/mojom/transform.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "device/vr/public/mojom/vr_service_mojom_traits.h"
#include "base/component_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {

class VRServiceProxy;

template <typename ImplRefTraits>
class VRServiceStub;

class VRServiceRequestValidator;
class VRServiceResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRService
    : public VRServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.VRService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    5
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VRServiceInterfaceBase;
  using Proxy_ = VRServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = VRServiceStub<ImplRefTraits>;

  using RequestValidator_ = VRServiceRequestValidator;
  using ResponseValidator_ = VRServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kRequestSessionMinVersion = 0,
    kSupportsSessionMinVersion = 0,
    kExitPresentMinVersion = 0,
    kSetFramesThrottledMinVersion = 0,
    kMakeXrCompatibleMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SupportsSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExitPresent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFramesThrottled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MakeXrCompatible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VRService() = default;

  virtual void SetClient(::mojo::PendingRemote<VRServiceClient> client) = 0;

  using RequestSessionCallback = base::OnceCallback<void(RequestSessionResultPtr)>;
  using RequestSessionMojoCallback = base::OnceCallback<void(RequestSessionResultPtr)>;

  virtual void RequestSession(::device::mojom::blink::XRSessionOptionsPtr options, RequestSessionCallback callback) = 0;

  using SupportsSessionCallback = base::OnceCallback<void(bool)>;
  using SupportsSessionMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SupportsSession(::device::mojom::blink::XRSessionOptionsPtr options, SupportsSessionCallback callback) = 0;

  using ExitPresentCallback = base::OnceCallback<void()>;
  using ExitPresentMojoCallback = base::OnceCallback<void()>;

  virtual void ExitPresent(ExitPresentCallback callback) = 0;

  virtual void SetFramesThrottled(bool throttled) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool MakeXrCompatible(XrCompatibleResult* out_xr_compatible_result);
  using MakeXrCompatibleCallback = base::OnceCallback<void(XrCompatibleResult)>;
  using MakeXrCompatibleMojoCallback = base::OnceCallback<void(XrCompatibleResult)>;

  virtual void MakeXrCompatible(MakeXrCompatibleCallback callback) = 0;
};

class XRSessionMetricsRecorderProxy;

template <typename ImplRefTraits>
class XRSessionMetricsRecorderStub;

class XRSessionMetricsRecorderRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRSessionMetricsRecorder
    : public XRSessionMetricsRecorderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XRSessionMetricsRecorder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRSessionMetricsRecorderInterfaceBase;
  using Proxy_ = XRSessionMetricsRecorderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRSessionMetricsRecorderStub<ImplRefTraits>;

  using RequestValidator_ = XRSessionMetricsRecorderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReportFeatureUsedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReportFeatureUsed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRSessionMetricsRecorder() = default;

  virtual void ReportFeatureUsed(::device::mojom::blink::XRSessionFeature feature) = 0;
};

class VRServiceClientProxy;

template <typename ImplRefTraits>
class VRServiceClientStub;

class VRServiceClientRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRServiceClient
    : public VRServiceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.VRServiceClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VRServiceClientInterfaceBase;
  using Proxy_ = VRServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = VRServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = VRServiceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDeviceChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDeviceChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VRServiceClient() = default;

  virtual void OnDeviceChanged() = 0;
};

class XREnvironmentIntegrationProviderProxy;

template <typename ImplRefTraits>
class XREnvironmentIntegrationProviderStub;

class XREnvironmentIntegrationProviderRequestValidator;
class XREnvironmentIntegrationProviderResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XREnvironmentIntegrationProvider
    : public XREnvironmentIntegrationProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XREnvironmentIntegrationProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XREnvironmentIntegrationProviderInterfaceBase;
  using Proxy_ = XREnvironmentIntegrationProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XREnvironmentIntegrationProviderStub<ImplRefTraits>;

  using RequestValidator_ = XREnvironmentIntegrationProviderRequestValidator;
  using ResponseValidator_ = XREnvironmentIntegrationProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSubscribeToHitTestMinVersion = 0,
    kSubscribeToHitTestForTransientInputMinVersion = 0,
    kUnsubscribeFromHitTestMinVersion = 0,
    kCreateAnchorMinVersion = 0,
    kDetachAnchorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SubscribeToHitTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubscribeToHitTestForTransientInput_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnsubscribeFromHitTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateAnchor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DetachAnchor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XREnvironmentIntegrationProvider() = default;

  using SubscribeToHitTestCallback = base::OnceCallback<void(const std::optional<::device::HitTestSubscriptionId>&)>;
  using SubscribeToHitTestMojoCallback = base::OnceCallback<void(const std::optional<::device::HitTestSubscriptionId>&)>;

  virtual void SubscribeToHitTest(XRNativeOriginInformationPtr native_origin_information, const ::blink::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestCallback callback) = 0;

  using SubscribeToHitTestForTransientInputCallback = base::OnceCallback<void(const std::optional<::device::HitTestSubscriptionId>&)>;
  using SubscribeToHitTestForTransientInputMojoCallback = base::OnceCallback<void(const std::optional<::device::HitTestSubscriptionId>&)>;

  virtual void SubscribeToHitTestForTransientInput(const ::blink::String& profile_name, const ::blink::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestForTransientInputCallback callback) = 0;

  virtual void UnsubscribeFromHitTest(const ::device::HitTestSubscriptionId& subscription_id) = 0;

  using CreateAnchorCallback = base::OnceCallback<void(const std::optional<::device::AnchorId>&)>;
  using CreateAnchorMojoCallback = base::OnceCallback<void(const std::optional<::device::AnchorId>&)>;

  virtual void CreateAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, const std::optional<::device::PlaneId>& plane_id, CreateAnchorCallback callback) = 0;

  virtual void DetachAnchor(const ::device::AnchorId& anchor_id) = 0;
};

class XRFrameDataProviderProxy;

template <typename ImplRefTraits>
class XRFrameDataProviderStub;

class XRFrameDataProviderRequestValidator;
class XRFrameDataProviderResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRFrameDataProvider
    : public XRFrameDataProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XRFrameDataProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRFrameDataProviderInterfaceBase;
  using Proxy_ = XRFrameDataProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRFrameDataProviderStub<ImplRefTraits>;

  using RequestValidator_ = XRFrameDataProviderRequestValidator;
  using ResponseValidator_ = XRFrameDataProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetFrameDataMinVersion = 0,
    kGetEnvironmentIntegrationProviderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetFrameData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetEnvironmentIntegrationProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRFrameDataProvider() = default;

  using GetFrameDataCallback = base::OnceCallback<void(XRFrameDataPtr)>;
  using GetFrameDataMojoCallback = base::OnceCallback<void(XRFrameDataPtr)>;

  virtual void GetFrameData(XRFrameDataRequestOptionsPtr options, GetFrameDataCallback callback) = 0;

  virtual void GetEnvironmentIntegrationProvider(::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> environment_provider) = 0;
};

class XRPresentationProviderProxy;

template <typename ImplRefTraits>
class XRPresentationProviderStub;

class XRPresentationProviderRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPresentationProvider
    : public XRPresentationProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XRPresentationProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRPresentationProviderInterfaceBase;
  using Proxy_ = XRPresentationProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRPresentationProviderStub<ImplRefTraits>;

  using RequestValidator_ = XRPresentationProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateLayerBoundsMinVersion = 0,
    kSubmitFrameMissingMinVersion = 0,
    kSubmitFrameMinVersion = 0,
    kSubmitFrameDrawnIntoTextureMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateLayerBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitFrameMissing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitFrameDrawnIntoTexture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRPresentationProvider() = default;

  virtual void UpdateLayerBounds(int16_t frame_id, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, const ::gfx::Size& source_size) = 0;

  virtual void SubmitFrameMissing(int16_t frame_id, const ::gpu::SyncToken& sync_token) = 0;

  virtual void SubmitFrame(int16_t frame_id, const ::gpu::MailboxHolder& mailbox_holder, ::base::TimeDelta time_waited) = 0;

  virtual void SubmitFrameDrawnIntoTexture(int16_t frame_id, const ::blink::Vector<::device::LayerId>& layer_ids, const ::gpu::SyncToken& sync_token, ::base::TimeDelta time_waited) = 0;
};

class XRPresentationClientProxy;

template <typename ImplRefTraits>
class XRPresentationClientStub;

class XRPresentationClientRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPresentationClient
    : public XRPresentationClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XRPresentationClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRPresentationClientInterfaceBase;
  using Proxy_ = XRPresentationClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRPresentationClientStub<ImplRefTraits>;

  using RequestValidator_ = XRPresentationClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSubmitFrameTransferredMinVersion = 0,
    kOnSubmitFrameRenderedMinVersion = 0,
    kOnSubmitFrameGpuFenceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSubmitFrameTransferred_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSubmitFrameRendered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSubmitFrameGpuFence_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRPresentationClient() = default;

  virtual void OnSubmitFrameTransferred(bool success) = 0;

  virtual void OnSubmitFrameRendered() = 0;

  virtual void OnSubmitFrameGpuFence(::gfx::GpuFenceHandle gpu_fence_handle) = 0;
};

class XRSessionClientProxy;

template <typename ImplRefTraits>
class XRSessionClientStub;

class XRSessionClientRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRSessionClient
    : public XRSessionClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XRSessionClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRSessionClientInterfaceBase;
  using Proxy_ = XRSessionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRSessionClientStub<ImplRefTraits>;

  using RequestValidator_ = XRSessionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnExitPresentMinVersion = 0,
    kOnVisibilityStateChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnExitPresent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVisibilityStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRSessionClient() = default;

  virtual void OnExitPresent() = 0;

  virtual void OnVisibilityStateChanged(XRVisibilityState visibility_state) = 0;
};

class XRLayerManagerProxy;

template <typename ImplRefTraits>
class XRLayerManagerStub;

class XRLayerManagerRequestValidator;
class XRLayerManagerResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRLayerManager
    : public XRLayerManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.XRLayerManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRLayerManagerInterfaceBase;
  using Proxy_ = XRLayerManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRLayerManagerStub<ImplRefTraits>;

  using RequestValidator_ = XRLayerManagerRequestValidator;
  using ResponseValidator_ = XRLayerManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateCompositionLayerMinVersion = 0,
    kDestroyCompositionLayerMinVersion = 0,
    kUpdateCompositionLayerMinVersion = 0,
    kSetEnabledCompositionLayersMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateCompositionLayer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DestroyCompositionLayer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateCompositionLayer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetEnabledCompositionLayers_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRLayerManager() = default;

  using CreateCompositionLayerCallback = base::OnceCallback<void(CreateCompositionLayerResult)>;
  using CreateCompositionLayerMojoCallback = base::OnceCallback<void(CreateCompositionLayerResult)>;

  virtual void CreateCompositionLayer(XRCompositionLayerDataPtr create_data, CreateCompositionLayerCallback callback) = 0;

  virtual void DestroyCompositionLayer(const ::device::LayerId& layer_id) = 0;

  virtual void UpdateCompositionLayer(const ::device::LayerId& layer_id, XRLayerMutableDataPtr update_data) = 0;

  virtual void SetEnabledCompositionLayers(const ::blink::Vector<::device::LayerId>& layer_ids) = 0;
};

class WebXrInternalsRendererListenerProxy;

template <typename ImplRefTraits>
class WebXrInternalsRendererListenerStub;

class WebXrInternalsRendererListenerRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) WebXrInternalsRendererListener
    : public WebXrInternalsRendererListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.WebXrInternalsRendererListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebXrInternalsRendererListenerInterfaceBase;
  using Proxy_ = WebXrInternalsRendererListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebXrInternalsRendererListenerStub<ImplRefTraits>;

  using RequestValidator_ = WebXrInternalsRendererListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFrameDataMinVersion = 0,
    kOnConsoleLogMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFrameData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnConsoleLog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebXrInternalsRendererListener() = default;

  virtual void OnFrameData(::device::mojom::blink::XrFrameStatisticsPtr xrframe_statistics) = 0;

  virtual void OnConsoleLog(::device::mojom::blink::XrLogMessagePtr xrlogging_statistics) = 0;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRServiceProxy
    : public VRService {
 public:
  using InterfaceType = VRService;

  explicit VRServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingRemote<VRServiceClient> client) final;
  
  void RequestSession(::device::mojom::blink::XRSessionOptionsPtr options, RequestSessionCallback callback) final;
  
  void SupportsSession(::device::mojom::blink::XRSessionOptionsPtr options, SupportsSessionCallback callback) final;
  
  void ExitPresent(ExitPresentCallback callback) final;
  
  void SetFramesThrottled(bool throttled) final;
  
  bool MakeXrCompatible(XrCompatibleResult* out_xr_compatible_result) final;
  
  void MakeXrCompatible(MakeXrCompatibleCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRSessionMetricsRecorderProxy
    : public XRSessionMetricsRecorder {
 public:
  using InterfaceType = XRSessionMetricsRecorder;

  explicit XRSessionMetricsRecorderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReportFeatureUsed(::device::mojom::blink::XRSessionFeature feature) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRServiceClientProxy
    : public VRServiceClient {
 public:
  using InterfaceType = VRServiceClient;

  explicit VRServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDeviceChanged() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XREnvironmentIntegrationProviderProxy
    : public XREnvironmentIntegrationProvider {
 public:
  using InterfaceType = XREnvironmentIntegrationProvider;

  explicit XREnvironmentIntegrationProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SubscribeToHitTest(XRNativeOriginInformationPtr native_origin_information, const ::blink::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestCallback callback) final;
  
  void SubscribeToHitTestForTransientInput(const ::blink::String& profile_name, const ::blink::Vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestForTransientInputCallback callback) final;
  
  void UnsubscribeFromHitTest(const ::device::HitTestSubscriptionId& subscription_id) final;
  
  void CreateAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, const std::optional<::device::PlaneId>& plane_id, CreateAnchorCallback callback) final;
  
  void DetachAnchor(const ::device::AnchorId& anchor_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRFrameDataProviderProxy
    : public XRFrameDataProvider {
 public:
  using InterfaceType = XRFrameDataProvider;

  explicit XRFrameDataProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetFrameData(XRFrameDataRequestOptionsPtr options, GetFrameDataCallback callback) final;
  
  void GetEnvironmentIntegrationProvider(::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> environment_provider) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPresentationProviderProxy
    : public XRPresentationProvider {
 public:
  using InterfaceType = XRPresentationProvider;

  explicit XRPresentationProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateLayerBounds(int16_t frame_id, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, const ::gfx::Size& source_size) final;
  
  void SubmitFrameMissing(int16_t frame_id, const ::gpu::SyncToken& sync_token) final;
  
  void SubmitFrame(int16_t frame_id, const ::gpu::MailboxHolder& mailbox_holder, ::base::TimeDelta time_waited) final;
  
  void SubmitFrameDrawnIntoTexture(int16_t frame_id, const ::blink::Vector<::device::LayerId>& layer_ids, const ::gpu::SyncToken& sync_token, ::base::TimeDelta time_waited) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPresentationClientProxy
    : public XRPresentationClient {
 public:
  using InterfaceType = XRPresentationClient;

  explicit XRPresentationClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSubmitFrameTransferred(bool success) final;
  
  void OnSubmitFrameRendered() final;
  
  void OnSubmitFrameGpuFence(::gfx::GpuFenceHandle gpu_fence_handle) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRSessionClientProxy
    : public XRSessionClient {
 public:
  using InterfaceType = XRSessionClient;

  explicit XRSessionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnExitPresent() final;
  
  void OnVisibilityStateChanged(XRVisibilityState visibility_state) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRLayerManagerProxy
    : public XRLayerManager {
 public:
  using InterfaceType = XRLayerManager;

  explicit XRLayerManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateCompositionLayer(XRCompositionLayerDataPtr create_data, CreateCompositionLayerCallback callback) final;
  
  void DestroyCompositionLayer(const ::device::LayerId& layer_id) final;
  
  void UpdateCompositionLayer(const ::device::LayerId& layer_id, XRLayerMutableDataPtr update_data) final;
  
  void SetEnabledCompositionLayers(const ::blink::Vector<::device::LayerId>& layer_ids) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) WebXrInternalsRendererListenerProxy
    : public WebXrInternalsRendererListener {
 public:
  using InterfaceType = WebXrInternalsRendererListener;

  explicit WebXrInternalsRendererListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFrameData(::device::mojom::blink::XrFrameStatisticsPtr xrframe_statistics) final;
  
  void OnConsoleLog(::device::mojom::blink::XrLogMessagePtr xrlogging_statistics) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRServiceStubDispatch {
 public:
  static bool Accept(VRService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VRService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VRService>>
class VRServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VRServiceStub() = default;
  ~VRServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRSessionMetricsRecorderStubDispatch {
 public:
  static bool Accept(XRSessionMetricsRecorder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRSessionMetricsRecorder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRSessionMetricsRecorder>>
class XRSessionMetricsRecorderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRSessionMetricsRecorderStub() = default;
  ~XRSessionMetricsRecorderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionMetricsRecorderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionMetricsRecorderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRServiceClientStubDispatch {
 public:
  static bool Accept(VRServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VRServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VRServiceClient>>
class VRServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VRServiceClientStub() = default;
  ~VRServiceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XREnvironmentIntegrationProviderStubDispatch {
 public:
  static bool Accept(XREnvironmentIntegrationProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XREnvironmentIntegrationProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XREnvironmentIntegrationProvider>>
class XREnvironmentIntegrationProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XREnvironmentIntegrationProviderStub() = default;
  ~XREnvironmentIntegrationProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XREnvironmentIntegrationProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XREnvironmentIntegrationProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRFrameDataProviderStubDispatch {
 public:
  static bool Accept(XRFrameDataProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRFrameDataProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRFrameDataProvider>>
class XRFrameDataProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRFrameDataProviderStub() = default;
  ~XRFrameDataProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRFrameDataProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRFrameDataProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPresentationProviderStubDispatch {
 public:
  static bool Accept(XRPresentationProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRPresentationProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRPresentationProvider>>
class XRPresentationProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRPresentationProviderStub() = default;
  ~XRPresentationProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPresentationClientStubDispatch {
 public:
  static bool Accept(XRPresentationClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRPresentationClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRPresentationClient>>
class XRPresentationClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRPresentationClientStub() = default;
  ~XRPresentationClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRSessionClientStubDispatch {
 public:
  static bool Accept(XRSessionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRSessionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRSessionClient>>
class XRSessionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRSessionClientStub() = default;
  ~XRSessionClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRLayerManagerStubDispatch {
 public:
  static bool Accept(XRLayerManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRLayerManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRLayerManager>>
class XRLayerManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRLayerManagerStub() = default;
  ~XRLayerManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRLayerManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRLayerManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) WebXrInternalsRendererListenerStubDispatch {
 public:
  static bool Accept(WebXrInternalsRendererListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebXrInternalsRendererListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebXrInternalsRendererListener>>
class WebXrInternalsRendererListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebXrInternalsRendererListenerStub() = default;
  ~WebXrInternalsRendererListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebXrInternalsRendererListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebXrInternalsRendererListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRSessionMetricsRecorderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XREnvironmentIntegrationProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRFrameDataProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPresentationProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPresentationClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRSessionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRLayerManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) WebXrInternalsRendererListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XREnvironmentIntegrationProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRFrameDataProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRLayerManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRDepthConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRDepthConfig, T>::value>;
  using DataView = XRDepthConfigDataView;
  using Data_ = internal::XRDepthConfig_Data;

  template <typename... Args>
  static XRDepthConfigPtr New(Args&&... args) {
    return XRDepthConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRDepthConfigPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthConfig>::Convert(*this);
  }


  XRDepthConfig();

  XRDepthConfig(
      ::device::mojom::blink::XRDepthUsage depth_usage,
      ::device::mojom::blink::XRDepthDataFormat depth_data_format,
      std::optional<::device::mojom::blink::XRDepthType> depth_type);


  ~XRDepthConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRDepthConfigPtr>
  XRDepthConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDepthConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDepthConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRDepthConfig_UnserializedMessageContext<
            UserType, XRDepthConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRDepthConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRDepthConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRDepthConfig_UnserializedMessageContext<
            UserType, XRDepthConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRDepthConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::mojom::blink::XRDepthUsage depth_usage;
  
  ::device::mojom::blink::XRDepthDataFormat depth_data_format;
  
  std::optional<::device::mojom::blink::XRDepthType> depth_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRFieldOfView {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VRFieldOfView, T>::value>;
  using DataView = VRFieldOfViewDataView;
  using Data_ = internal::VRFieldOfView_Data;

  template <typename... Args>
  static VRFieldOfViewPtr New(Args&&... args) {
    return VRFieldOfViewPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VRFieldOfViewPtr From(const U& u) {
    return mojo::TypeConverter<VRFieldOfViewPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VRFieldOfView>::Convert(*this);
  }


  VRFieldOfView();

  VRFieldOfView(
      float up_degrees,
      float down_degrees,
      float left_degrees,
      float right_degrees);


  ~VRFieldOfView();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VRFieldOfViewPtr>
  VRFieldOfViewPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRFieldOfView::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRFieldOfView::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VRFieldOfView::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VRFieldOfView_UnserializedMessageContext<
            UserType, VRFieldOfView::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VRFieldOfView::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VRFieldOfView::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VRFieldOfView_UnserializedMessageContext<
            UserType, VRFieldOfView::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VRFieldOfView::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float up_degrees;
  
  float down_degrees;
  
  float left_degrees;
  
  float right_degrees;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) AnchorId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorId, T>::value>;
  using DataView = AnchorIdDataView;
  using Data_ = internal::AnchorId_Data;

  template <typename... Args>
  static AnchorIdPtr New(Args&&... args) {
    return AnchorIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorIdPtr From(const U& u) {
    return mojo::TypeConverter<AnchorIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorId>::Convert(*this);
  }


  AnchorId();

  explicit AnchorId(
      uint64_t id_value);


  ~AnchorId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorIdPtr>
  AnchorIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorId_UnserializedMessageContext<
            UserType, AnchorId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorId_UnserializedMessageContext<
            UserType, AnchorId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t id_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) HitTestSubscriptionId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HitTestSubscriptionId, T>::value>;
  using DataView = HitTestSubscriptionIdDataView;
  using Data_ = internal::HitTestSubscriptionId_Data;

  template <typename... Args>
  static HitTestSubscriptionIdPtr New(Args&&... args) {
    return HitTestSubscriptionIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HitTestSubscriptionIdPtr From(const U& u) {
    return mojo::TypeConverter<HitTestSubscriptionIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HitTestSubscriptionId>::Convert(*this);
  }


  HitTestSubscriptionId();

  explicit HitTestSubscriptionId(
      uint64_t id_value);


  ~HitTestSubscriptionId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HitTestSubscriptionIdPtr>
  HitTestSubscriptionIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HitTestSubscriptionId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HitTestSubscriptionId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HitTestSubscriptionId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HitTestSubscriptionId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HitTestSubscriptionId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HitTestSubscriptionId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HitTestSubscriptionId_UnserializedMessageContext<
            UserType, HitTestSubscriptionId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HitTestSubscriptionId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HitTestSubscriptionId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HitTestSubscriptionId_UnserializedMessageContext<
            UserType, HitTestSubscriptionId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HitTestSubscriptionId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t id_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HitTestSubscriptionId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HitTestSubscriptionId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HitTestSubscriptionId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HitTestSubscriptionId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) PlaneId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PlaneId, T>::value>;
  using DataView = PlaneIdDataView;
  using Data_ = internal::PlaneId_Data;

  template <typename... Args>
  static PlaneIdPtr New(Args&&... args) {
    return PlaneIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PlaneIdPtr From(const U& u) {
    return mojo::TypeConverter<PlaneIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PlaneId>::Convert(*this);
  }


  PlaneId();

  explicit PlaneId(
      uint64_t id_value);


  ~PlaneId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PlaneIdPtr>
  PlaneIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PlaneId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PlaneId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PlaneId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlaneId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlaneId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PlaneId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PlaneId_UnserializedMessageContext<
            UserType, PlaneId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PlaneId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PlaneId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PlaneId_UnserializedMessageContext<
            UserType, PlaneId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PlaneId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t id_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PlaneId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PlaneId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PlaneId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PlaneId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XrVisibilityMaskId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XrVisibilityMaskId, T>::value>;
  using DataView = XrVisibilityMaskIdDataView;
  using Data_ = internal::XrVisibilityMaskId_Data;

  template <typename... Args>
  static XrVisibilityMaskIdPtr New(Args&&... args) {
    return XrVisibilityMaskIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XrVisibilityMaskIdPtr From(const U& u) {
    return mojo::TypeConverter<XrVisibilityMaskIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XrVisibilityMaskId>::Convert(*this);
  }


  XrVisibilityMaskId();

  explicit XrVisibilityMaskId(
      uint64_t id_value);


  ~XrVisibilityMaskId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XrVisibilityMaskIdPtr>
  XrVisibilityMaskIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XrVisibilityMaskId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XrVisibilityMaskId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XrVisibilityMaskId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XrVisibilityMaskId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XrVisibilityMaskId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XrVisibilityMaskId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XrVisibilityMaskId_UnserializedMessageContext<
            UserType, XrVisibilityMaskId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XrVisibilityMaskId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XrVisibilityMaskId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XrVisibilityMaskId_UnserializedMessageContext<
            UserType, XrVisibilityMaskId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XrVisibilityMaskId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t id_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XrVisibilityMaskId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XrVisibilityMaskId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XrVisibilityMaskId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XrVisibilityMaskId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPresentationTransportOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPresentationTransportOptions, T>::value>;
  using DataView = XRPresentationTransportOptionsDataView;
  using Data_ = internal::XRPresentationTransportOptions_Data;

  template <typename... Args>
  static XRPresentationTransportOptionsPtr New(Args&&... args) {
    return XRPresentationTransportOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPresentationTransportOptionsPtr From(const U& u) {
    return mojo::TypeConverter<XRPresentationTransportOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPresentationTransportOptions>::Convert(*this);
  }


  XRPresentationTransportOptions();

  XRPresentationTransportOptions(
      XRPresentationTransportMethod transport_method,
      bool wait_for_transfer_notification,
      bool wait_for_render_notification,
      bool wait_for_gpu_fence);


  ~XRPresentationTransportOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPresentationTransportOptionsPtr>
  XRPresentationTransportOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPresentationTransportOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPresentationTransportOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPresentationTransportOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPresentationTransportOptions_UnserializedMessageContext<
            UserType, XRPresentationTransportOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRPresentationTransportOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRPresentationTransportOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPresentationTransportOptions_UnserializedMessageContext<
            UserType, XRPresentationTransportOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPresentationTransportOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRPresentationTransportMethod transport_method;
  
  bool wait_for_transfer_notification;
  
  bool wait_for_render_notification;
  
  bool wait_for_gpu_fence;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRInputSourceSpaceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRInputSourceSpaceInfo, T>::value>;
  using DataView = XRInputSourceSpaceInfoDataView;
  using Data_ = internal::XRInputSourceSpaceInfo_Data;

  template <typename... Args>
  static XRInputSourceSpaceInfoPtr New(Args&&... args) {
    return XRInputSourceSpaceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRInputSourceSpaceInfoPtr From(const U& u) {
    return mojo::TypeConverter<XRInputSourceSpaceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRInputSourceSpaceInfo>::Convert(*this);
  }


  XRInputSourceSpaceInfo();

  XRInputSourceSpaceInfo(
      uint32_t input_source_id,
      XRInputSourceSpaceType input_source_space_type);


  ~XRInputSourceSpaceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRInputSourceSpaceInfoPtr>
  XRInputSourceSpaceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRInputSourceSpaceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRInputSourceSpaceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRInputSourceSpaceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRInputSourceSpaceInfo_UnserializedMessageContext<
            UserType, XRInputSourceSpaceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRInputSourceSpaceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRInputSourceSpaceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRInputSourceSpaceInfo_UnserializedMessageContext<
            UserType, XRInputSourceSpaceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRInputSourceSpaceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t input_source_id;
  
  XRInputSourceSpaceType input_source_space_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRHandJointSpaceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHandJointSpaceInfo, T>::value>;
  using DataView = XRHandJointSpaceInfoDataView;
  using Data_ = internal::XRHandJointSpaceInfo_Data;

  template <typename... Args>
  static XRHandJointSpaceInfoPtr New(Args&&... args) {
    return XRHandJointSpaceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHandJointSpaceInfoPtr From(const U& u) {
    return mojo::TypeConverter<XRHandJointSpaceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHandJointSpaceInfo>::Convert(*this);
  }


  XRHandJointSpaceInfo();

  XRHandJointSpaceInfo(
      XRHandedness handedness,
      ::device::mojom::blink::XRHandJoint joint);


  ~XRHandJointSpaceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHandJointSpaceInfoPtr>
  XRHandJointSpaceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHandJointSpaceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHandJointSpaceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHandJointSpaceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHandJointSpaceInfo_UnserializedMessageContext<
            UserType, XRHandJointSpaceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHandJointSpaceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHandJointSpaceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHandJointSpaceInfo_UnserializedMessageContext<
            UserType, XRHandJointSpaceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHandJointSpaceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRHandedness handedness;
  
  ::device::mojom::blink::XRHandJoint joint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPlanePointData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPlanePointData, T>::value>;
  using DataView = XRPlanePointDataDataView;
  using Data_ = internal::XRPlanePointData_Data;

  template <typename... Args>
  static XRPlanePointDataPtr New(Args&&... args) {
    return XRPlanePointDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPlanePointDataPtr From(const U& u) {
    return mojo::TypeConverter<XRPlanePointDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPlanePointData>::Convert(*this);
  }


  XRPlanePointData();

  XRPlanePointData(
      float x,
      float z);


  ~XRPlanePointData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPlanePointDataPtr>
  XRPlanePointDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlanePointData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlanePointData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPlanePointData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPlanePointData_UnserializedMessageContext<
            UserType, XRPlanePointData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRPlanePointData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRPlanePointData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPlanePointData_UnserializedMessageContext<
            UserType, XRPlanePointData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPlanePointData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float x;
  
  float z;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) RgbTupleF32 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RgbTupleF32, T>::value>;
  using DataView = RgbTupleF32DataView;
  using Data_ = internal::RgbTupleF32_Data;

  template <typename... Args>
  static RgbTupleF32Ptr New(Args&&... args) {
    return RgbTupleF32Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RgbTupleF32Ptr From(const U& u) {
    return mojo::TypeConverter<RgbTupleF32Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RgbTupleF32>::Convert(*this);
  }


  RgbTupleF32();

  RgbTupleF32(
      float red,
      float green,
      float blue);


  ~RgbTupleF32();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RgbTupleF32Ptr>
  RgbTupleF32Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RgbTupleF32::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RgbTupleF32::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RgbTupleF32::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RgbTupleF32_UnserializedMessageContext<
            UserType, RgbTupleF32::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RgbTupleF32::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RgbTupleF32::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RgbTupleF32_UnserializedMessageContext<
            UserType, RgbTupleF32::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RgbTupleF32::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float red;
  
  float green;
  
  float blue;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRDepthDataStillValid {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRDepthDataStillValid, T>::value>;
  using DataView = XRDepthDataStillValidDataView;
  using Data_ = internal::XRDepthDataStillValid_Data;

  template <typename... Args>
  static XRDepthDataStillValidPtr New(Args&&... args) {
    return XRDepthDataStillValidPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRDepthDataStillValidPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthDataStillValidPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthDataStillValid>::Convert(*this);
  }


  XRDepthDataStillValid();


  ~XRDepthDataStillValid();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRDepthDataStillValidPtr>
  XRDepthDataStillValidPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDepthDataStillValid::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDepthDataStillValid::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthDataStillValid::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRDepthDataStillValid_UnserializedMessageContext<
            UserType, XRDepthDataStillValid::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRDepthDataStillValid::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRDepthDataStillValid::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRDepthDataStillValid_UnserializedMessageContext<
            UserType, XRDepthDataStillValid::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRDepthDataStillValid::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) LayerId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LayerId, T>::value>;
  using DataView = LayerIdDataView;
  using Data_ = internal::LayerId_Data;

  template <typename... Args>
  static LayerIdPtr New(Args&&... args) {
    return LayerIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayerIdPtr From(const U& u) {
    return mojo::TypeConverter<LayerIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayerId>::Convert(*this);
  }


  LayerId();

  explicit LayerId(
      uint64_t id_value);


  ~LayerId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayerIdPtr>
  LayerIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LayerId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LayerId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LayerId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayerId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LayerId_UnserializedMessageContext<
            UserType, LayerId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LayerId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LayerId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LayerId_UnserializedMessageContext<
            UserType, LayerId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LayerId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t id_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LayerId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LayerId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LayerId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LayerId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRProjectionLayerData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRProjectionLayerData, T>::value>;
  using DataView = XRProjectionLayerDataDataView;
  using Data_ = internal::XRProjectionLayerData_Data;

  template <typename... Args>
  static XRProjectionLayerDataPtr New(Args&&... args) {
    return XRProjectionLayerDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRProjectionLayerDataPtr From(const U& u) {
    return mojo::TypeConverter<XRProjectionLayerDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRProjectionLayerData>::Convert(*this);
  }


  XRProjectionLayerData();


  ~XRProjectionLayerData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRProjectionLayerDataPtr>
  XRProjectionLayerDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRProjectionLayerData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRProjectionLayerData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRProjectionLayerData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRProjectionLayerData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRProjectionLayerData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRProjectionLayerData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRProjectionLayerData_UnserializedMessageContext<
            UserType, XRProjectionLayerData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRProjectionLayerData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRProjectionLayerData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRProjectionLayerData_UnserializedMessageContext<
            UserType, XRProjectionLayerData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRProjectionLayerData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRProjectionLayerData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRProjectionLayerData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRProjectionLayerData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRProjectionLayerData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}
















class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRFrameDataRequestOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRFrameDataRequestOptions, T>::value>;
  using DataView = XRFrameDataRequestOptionsDataView;
  using Data_ = internal::XRFrameDataRequestOptions_Data;

  template <typename... Args>
  static XRFrameDataRequestOptionsPtr New(Args&&... args) {
    return XRFrameDataRequestOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRFrameDataRequestOptionsPtr From(const U& u) {
    return mojo::TypeConverter<XRFrameDataRequestOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRFrameDataRequestOptions>::Convert(*this);
  }


  XRFrameDataRequestOptions();

  XRFrameDataRequestOptions(
      bool include_lighting_estimation_data,
      bool depth_active,
      uint32_t stage_parameters_id);


  ~XRFrameDataRequestOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRFrameDataRequestOptionsPtr>
  XRFrameDataRequestOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRFrameDataRequestOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRFrameDataRequestOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRFrameDataRequestOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRFrameDataRequestOptions_UnserializedMessageContext<
            UserType, XRFrameDataRequestOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRFrameDataRequestOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRFrameDataRequestOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRFrameDataRequestOptions_UnserializedMessageContext<
            UserType, XRFrameDataRequestOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRFrameDataRequestOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool include_lighting_estimation_data;
  
  bool depth_active;
  
  uint32_t stage_parameters_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRNativeOriginInformation {
 public:
  using DataView = XRNativeOriginInformationDataView;
  using Data_ = internal::XRNativeOriginInformation_Data;
  using Tag = Data_::XRNativeOriginInformation_Tag;

  template <typename... Args>
  static XRNativeOriginInformationPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |input_source_space_info|.
  static XRNativeOriginInformationPtr NewInputSourceSpaceInfo(
      XRInputSourceSpaceInfoPtr value);
  // Construct an instance holding |plane_id|.
  static XRNativeOriginInformationPtr NewPlaneId(
      const ::device::PlaneId& value);
  // Construct an instance holding |anchor_id|.
  static XRNativeOriginInformationPtr NewAnchorId(
      const ::device::AnchorId& value);
  // Construct an instance holding |reference_space_type|.
  static XRNativeOriginInformationPtr NewReferenceSpaceType(
      XRReferenceSpaceType value);
  // Construct an instance holding |hand_joint_space_info|.
  static XRNativeOriginInformationPtr NewHandJointSpaceInfo(
      XRHandJointSpaceInfoPtr value);
  // Construct an instance holding |image_index|.
  static XRNativeOriginInformationPtr NewImageIndex(
      uint32_t value);

  template <typename U>
  static XRNativeOriginInformationPtr From(const U& u) {
    return mojo::TypeConverter<XRNativeOriginInformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRNativeOriginInformation>::Convert(*this);
  }
  ~XRNativeOriginInformation();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  XRNativeOriginInformation(const XRNativeOriginInformation& other) = delete;
  XRNativeOriginInformation& operator=(const XRNativeOriginInformation& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = XRNativeOriginInformationPtr>
  XRNativeOriginInformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRNativeOriginInformation>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRNativeOriginInformation>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_input_source_space_info() const { return tag_ == Tag::kInputSourceSpaceInfo; }
  const XRInputSourceSpaceInfoPtr& get_input_source_space_info() const {
    CHECK(tag_ == Tag::kInputSourceSpaceInfo);
    return data_.input_source_space_info;
  }
  XRInputSourceSpaceInfoPtr& get_input_source_space_info() {
    CHECK(tag_ == Tag::kInputSourceSpaceInfo);
    return data_.input_source_space_info;
  }
  void set_input_source_space_info(XRInputSourceSpaceInfoPtr input_source_space_info);

  bool is_plane_id() const { return tag_ == Tag::kPlaneId; }
  const ::device::PlaneId& get_plane_id() const {
    CHECK(tag_ == Tag::kPlaneId);
    return data_.plane_id;
  }
  ::device::PlaneId& get_plane_id() {
    CHECK(tag_ == Tag::kPlaneId);
    return data_.plane_id;
  }
  void set_plane_id(const ::device::PlaneId& plane_id);

  bool is_anchor_id() const { return tag_ == Tag::kAnchorId; }
  const ::device::AnchorId& get_anchor_id() const {
    CHECK(tag_ == Tag::kAnchorId);
    return data_.anchor_id;
  }
  ::device::AnchorId& get_anchor_id() {
    CHECK(tag_ == Tag::kAnchorId);
    return data_.anchor_id;
  }
  void set_anchor_id(const ::device::AnchorId& anchor_id);

  bool is_reference_space_type() const { return tag_ == Tag::kReferenceSpaceType; }
  XRReferenceSpaceType get_reference_space_type() const {
    CHECK(tag_ == Tag::kReferenceSpaceType);
    return data_.reference_space_type;
  }
  void set_reference_space_type(XRReferenceSpaceType reference_space_type);

  bool is_hand_joint_space_info() const { return tag_ == Tag::kHandJointSpaceInfo; }
  const XRHandJointSpaceInfoPtr& get_hand_joint_space_info() const {
    CHECK(tag_ == Tag::kHandJointSpaceInfo);
    return data_.hand_joint_space_info;
  }
  XRHandJointSpaceInfoPtr& get_hand_joint_space_info() {
    CHECK(tag_ == Tag::kHandJointSpaceInfo);
    return data_.hand_joint_space_info;
  }
  void set_hand_joint_space_info(XRHandJointSpaceInfoPtr hand_joint_space_info);

  bool is_image_index() const { return tag_ == Tag::kImageIndex; }
  uint32_t get_image_index() const {
    CHECK(tag_ == Tag::kImageIndex);
    return data_.image_index;
  }
  void set_image_index(uint32_t image_index);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRNativeOriginInformation::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<XRNativeOriginInformation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kInputSourceSpaceInfo)>,
        XRInputSourceSpaceInfoPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPlaneId)>,
        const ::device::PlaneId& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAnchorId)>,
        const ::device::AnchorId& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kReferenceSpaceType)>,
        XRReferenceSpaceType value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kHandJointSpaceInfo)>,
        XRHandJointSpaceInfoPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kImageIndex)>,
        uint32_t value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    XRInputSourceSpaceInfoPtr input_source_space_info;
    ::device::PlaneId plane_id;
    ::device::AnchorId anchor_id;
    XRReferenceSpaceType reference_space_type;
    XRHandJointSpaceInfoPtr hand_joint_space_info;
    uint32_t image_index;
  };

  XRNativeOriginInformation(
      std::in_place_index_t<static_cast<size_t>(Tag::kInputSourceSpaceInfo)>,
      XRInputSourceSpaceInfoPtr value);
  XRNativeOriginInformation(
      std::in_place_index_t<static_cast<size_t>(Tag::kPlaneId)>,
      const ::device::PlaneId& value);
  XRNativeOriginInformation(
      std::in_place_index_t<static_cast<size_t>(Tag::kAnchorId)>,
      const ::device::AnchorId& value);
  XRNativeOriginInformation(
      std::in_place_index_t<static_cast<size_t>(Tag::kReferenceSpaceType)>,
      XRReferenceSpaceType value);
  XRNativeOriginInformation(
      std::in_place_index_t<static_cast<size_t>(Tag::kHandJointSpaceInfo)>,
      XRHandJointSpaceInfoPtr value);
  XRNativeOriginInformation(
      std::in_place_index_t<static_cast<size_t>(Tag::kImageIndex)>,
      uint32_t value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRDepthData {
 public:
  using DataView = XRDepthDataDataView;
  using Data_ = internal::XRDepthData_Data;
  using Tag = Data_::XRDepthData_Tag;

  template <typename... Args>
  static XRDepthDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |data_still_valid|.
  static XRDepthDataPtr NewDataStillValid(
      XRDepthDataStillValidPtr value);
  // Construct an instance holding |updated_depth_data|.
  static XRDepthDataPtr NewUpdatedDepthData(
      XRDepthDataUpdatedPtr value);

  template <typename U>
  static XRDepthDataPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthData>::Convert(*this);
  }
  ~XRDepthData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  XRDepthData(const XRDepthData& other) = delete;
  XRDepthData& operator=(const XRDepthData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = XRDepthDataPtr>
  XRDepthDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRDepthData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRDepthData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_data_still_valid() const { return tag_ == Tag::kDataStillValid; }
  const XRDepthDataStillValidPtr& get_data_still_valid() const {
    CHECK(tag_ == Tag::kDataStillValid);
    return data_.data_still_valid;
  }
  XRDepthDataStillValidPtr& get_data_still_valid() {
    CHECK(tag_ == Tag::kDataStillValid);
    return data_.data_still_valid;
  }
  void set_data_still_valid(XRDepthDataStillValidPtr data_still_valid);

  bool is_updated_depth_data() const { return tag_ == Tag::kUpdatedDepthData; }
  const XRDepthDataUpdatedPtr& get_updated_depth_data() const {
    CHECK(tag_ == Tag::kUpdatedDepthData);
    return data_.updated_depth_data;
  }
  XRDepthDataUpdatedPtr& get_updated_depth_data() {
    CHECK(tag_ == Tag::kUpdatedDepthData);
    return data_.updated_depth_data;
  }
  void set_updated_depth_data(XRDepthDataUpdatedPtr updated_depth_data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<XRDepthData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDataStillValid)>,
        XRDepthDataStillValidPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUpdatedDepthData)>,
        XRDepthDataUpdatedPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    XRDepthDataStillValidPtr data_still_valid;
    XRDepthDataUpdatedPtr updated_depth_data;
  };

  XRDepthData(
      std::in_place_index_t<static_cast<size_t>(Tag::kDataStillValid)>,
      XRDepthDataStillValidPtr value);
  XRDepthData(
      std::in_place_index_t<static_cast<size_t>(Tag::kUpdatedDepthData)>,
      XRDepthDataUpdatedPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRLayerSpecificData {
 public:
  using DataView = XRLayerSpecificDataDataView;
  using Data_ = internal::XRLayerSpecificData_Data;
  using Tag = Data_::XRLayerSpecificData_Tag;

  template <typename... Args>
  static XRLayerSpecificDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |projection|.
  static XRLayerSpecificDataPtr NewProjection(
      XRProjectionLayerDataPtr value);
  // Construct an instance holding |quad|.
  static XRLayerSpecificDataPtr NewQuad(
      XRQuadLayerDataPtr value);
  // Construct an instance holding |cylinder|.
  static XRLayerSpecificDataPtr NewCylinder(
      XRCylinderLayerDataPtr value);
  // Construct an instance holding |equirect|.
  static XRLayerSpecificDataPtr NewEquirect(
      XREquirectLayerDataPtr value);
  // Construct an instance holding |cube|.
  static XRLayerSpecificDataPtr NewCube(
      XRCubeLayerDataPtr value);

  template <typename U>
  static XRLayerSpecificDataPtr From(const U& u) {
    return mojo::TypeConverter<XRLayerSpecificDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRLayerSpecificData>::Convert(*this);
  }
  ~XRLayerSpecificData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  XRLayerSpecificData(const XRLayerSpecificData& other) = delete;
  XRLayerSpecificData& operator=(const XRLayerSpecificData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = XRLayerSpecificDataPtr>
  XRLayerSpecificDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRLayerSpecificData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRLayerSpecificData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_projection() const { return tag_ == Tag::kProjection; }
  const XRProjectionLayerDataPtr& get_projection() const {
    CHECK(tag_ == Tag::kProjection);
    return data_.projection;
  }
  XRProjectionLayerDataPtr& get_projection() {
    CHECK(tag_ == Tag::kProjection);
    return data_.projection;
  }
  void set_projection(XRProjectionLayerDataPtr projection);

  bool is_quad() const { return tag_ == Tag::kQuad; }
  const XRQuadLayerDataPtr& get_quad() const {
    CHECK(tag_ == Tag::kQuad);
    return data_.quad;
  }
  XRQuadLayerDataPtr& get_quad() {
    CHECK(tag_ == Tag::kQuad);
    return data_.quad;
  }
  void set_quad(XRQuadLayerDataPtr quad);

  bool is_cylinder() const { return tag_ == Tag::kCylinder; }
  const XRCylinderLayerDataPtr& get_cylinder() const {
    CHECK(tag_ == Tag::kCylinder);
    return data_.cylinder;
  }
  XRCylinderLayerDataPtr& get_cylinder() {
    CHECK(tag_ == Tag::kCylinder);
    return data_.cylinder;
  }
  void set_cylinder(XRCylinderLayerDataPtr cylinder);

  bool is_equirect() const { return tag_ == Tag::kEquirect; }
  const XREquirectLayerDataPtr& get_equirect() const {
    CHECK(tag_ == Tag::kEquirect);
    return data_.equirect;
  }
  XREquirectLayerDataPtr& get_equirect() {
    CHECK(tag_ == Tag::kEquirect);
    return data_.equirect;
  }
  void set_equirect(XREquirectLayerDataPtr equirect);

  bool is_cube() const { return tag_ == Tag::kCube; }
  const XRCubeLayerDataPtr& get_cube() const {
    CHECK(tag_ == Tag::kCube);
    return data_.cube;
  }
  XRCubeLayerDataPtr& get_cube() {
    CHECK(tag_ == Tag::kCube);
    return data_.cube;
  }
  void set_cube(XRCubeLayerDataPtr cube);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRLayerSpecificData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<XRLayerSpecificData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kProjection)>,
        XRProjectionLayerDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kQuad)>,
        XRQuadLayerDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCylinder)>,
        XRCylinderLayerDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEquirect)>,
        XREquirectLayerDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCube)>,
        XRCubeLayerDataPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    XRProjectionLayerDataPtr projection;
    XRQuadLayerDataPtr quad;
    XRCylinderLayerDataPtr cylinder;
    XREquirectLayerDataPtr equirect;
    XRCubeLayerDataPtr cube;
  };

  XRLayerSpecificData(
      std::in_place_index_t<static_cast<size_t>(Tag::kProjection)>,
      XRProjectionLayerDataPtr value);
  XRLayerSpecificData(
      std::in_place_index_t<static_cast<size_t>(Tag::kQuad)>,
      XRQuadLayerDataPtr value);
  XRLayerSpecificData(
      std::in_place_index_t<static_cast<size_t>(Tag::kCylinder)>,
      XRCylinderLayerDataPtr value);
  XRLayerSpecificData(
      std::in_place_index_t<static_cast<size_t>(Tag::kEquirect)>,
      XREquirectLayerDataPtr value);
  XRLayerSpecificData(
      std::in_place_index_t<static_cast<size_t>(Tag::kCube)>,
      XRCubeLayerDataPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) RequestSessionResult {
 public:
  using DataView = RequestSessionResultDataView;
  using Data_ = internal::RequestSessionResult_Data;
  using Tag = Data_::RequestSessionResult_Tag;

  template <typename... Args>
  static RequestSessionResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static RequestSessionResultPtr NewSuccess(
      RequestSessionSuccessPtr value);
  // Construct an instance holding |failure_reason|.
  static RequestSessionResultPtr NewFailureReason(
      ::device::mojom::blink::RequestSessionError value);

  template <typename U>
  static RequestSessionResultPtr From(const U& u) {
    return mojo::TypeConverter<RequestSessionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestSessionResult>::Convert(*this);
  }
  ~RequestSessionResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  RequestSessionResult(const RequestSessionResult& other) = delete;
  RequestSessionResult& operator=(const RequestSessionResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = RequestSessionResultPtr>
  RequestSessionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RequestSessionResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, RequestSessionResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const RequestSessionSuccessPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  RequestSessionSuccessPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(RequestSessionSuccessPtr success);

  bool is_failure_reason() const { return tag_ == Tag::kFailureReason; }
  ::device::mojom::blink::RequestSessionError get_failure_reason() const {
    CHECK(tag_ == Tag::kFailureReason);
    return data_.failure_reason;
  }
  void set_failure_reason(::device::mojom::blink::RequestSessionError failure_reason);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestSessionResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<RequestSessionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        RequestSessionSuccessPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailureReason)>,
        ::device::mojom::blink::RequestSessionError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    RequestSessionSuccessPtr success;
    ::device::mojom::blink::RequestSessionError failure_reason;
  };

  RequestSessionResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      RequestSessionSuccessPtr value);
  RequestSessionResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailureReason)>,
      ::device::mojom::blink::RequestSessionError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRSessionDeviceConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRSessionDeviceConfig, T>::value>;
  using DataView = XRSessionDeviceConfigDataView;
  using Data_ = internal::XRSessionDeviceConfig_Data;

  template <typename... Args>
  static XRSessionDeviceConfigPtr New(Args&&... args) {
    return XRSessionDeviceConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRSessionDeviceConfigPtr From(const U& u) {
    return mojo::TypeConverter<XRSessionDeviceConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRSessionDeviceConfig>::Convert(*this);
  }


  XRSessionDeviceConfig();

  XRSessionDeviceConfig(
      float default_framebuffer_scale,
      ::blink::Vector<XRViewPtr> views,
      bool supports_viewport_scaling,
      bool enable_anti_aliasing,
      XRDepthConfigPtr depth_configuration);

XRSessionDeviceConfig(const XRSessionDeviceConfig&) = delete;
XRSessionDeviceConfig& operator=(const XRSessionDeviceConfig&) = delete;

  ~XRSessionDeviceConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRSessionDeviceConfigPtr>
  XRSessionDeviceConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRSessionDeviceConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRSessionDeviceConfig_UnserializedMessageContext<
            UserType, XRSessionDeviceConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRSessionDeviceConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRSessionDeviceConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRSessionDeviceConfig_UnserializedMessageContext<
            UserType, XRSessionDeviceConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRSessionDeviceConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float default_framebuffer_scale;
  
  ::blink::Vector<XRViewPtr> views;
  
  bool supports_viewport_scaling;
  
  bool enable_anti_aliasing;
  
  XRDepthConfigPtr depth_configuration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRSession {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRSession, T>::value>;
  using DataView = XRSessionDataView;
  using Data_ = internal::XRSession_Data;

  template <typename... Args>
  static XRSessionPtr New(Args&&... args) {
    return XRSessionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRSessionPtr From(const U& u) {
    return mojo::TypeConverter<XRSessionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRSession>::Convert(*this);
  }


  XRSession();

  XRSession(
      ::mojo::PendingRemote<XRFrameDataProvider> data_provider,
      ::mojo::PendingRemote<XRLayerManager> layer_manager,
      ::mojo::PendingReceiver<XRSessionClient> client_receiver,
      XRPresentationConnectionPtr submit_frame_sink,
      ::blink::Vector<::device::mojom::blink::XRSessionFeature> enabled_features,
      XRSessionDeviceConfigPtr device_config,
      XREnvironmentBlendMode enviroment_blend_mode,
      XRInteractionMode interaction_mode);

XRSession(const XRSession&) = delete;
XRSession& operator=(const XRSession&) = delete;

  ~XRSession();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRSessionPtr>
  XRSessionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRSession::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRSession::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRSession::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRSession::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRSession_UnserializedMessageContext<
            UserType, XRSession::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRSession::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRSession::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRSession_UnserializedMessageContext<
            UserType, XRSession::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRSession::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<XRFrameDataProvider> data_provider;
  
  ::mojo::PendingRemote<XRLayerManager> layer_manager;
  
  ::mojo::PendingReceiver<XRSessionClient> client_receiver;
  
  XRPresentationConnectionPtr submit_frame_sink;
  
  ::blink::Vector<::device::mojom::blink::XRSessionFeature> enabled_features;
  
  XRSessionDeviceConfigPtr device_config;
  
  XREnvironmentBlendMode enviroment_blend_mode;
  
  XRInteractionMode interaction_mode;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPresentationConnection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPresentationConnection, T>::value>;
  using DataView = XRPresentationConnectionDataView;
  using Data_ = internal::XRPresentationConnection_Data;

  template <typename... Args>
  static XRPresentationConnectionPtr New(Args&&... args) {
    return XRPresentationConnectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPresentationConnectionPtr From(const U& u) {
    return mojo::TypeConverter<XRPresentationConnectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPresentationConnection>::Convert(*this);
  }


  XRPresentationConnection();

  XRPresentationConnection(
      ::mojo::PendingRemote<XRPresentationProvider> provider,
      ::mojo::PendingReceiver<XRPresentationClient> client_receiver,
      XRPresentationTransportOptionsPtr transport_options);

XRPresentationConnection(const XRPresentationConnection&) = delete;
XRPresentationConnection& operator=(const XRPresentationConnection&) = delete;

  ~XRPresentationConnection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPresentationConnectionPtr>
  XRPresentationConnectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPresentationConnection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPresentationConnection_UnserializedMessageContext<
            UserType, XRPresentationConnection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRPresentationConnection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRPresentationConnection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPresentationConnection_UnserializedMessageContext<
            UserType, XRPresentationConnection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPresentationConnection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<XRPresentationProvider> provider;
  
  ::mojo::PendingReceiver<XRPresentationClient> client_receiver;
  
  XRPresentationTransportOptionsPtr transport_options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRInputSourceDescription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRInputSourceDescription, T>::value>;
  using DataView = XRInputSourceDescriptionDataView;
  using Data_ = internal::XRInputSourceDescription_Data;

  template <typename... Args>
  static XRInputSourceDescriptionPtr New(Args&&... args) {
    return XRInputSourceDescriptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRInputSourceDescriptionPtr From(const U& u) {
    return mojo::TypeConverter<XRInputSourceDescriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRInputSourceDescription>::Convert(*this);
  }


  XRInputSourceDescription();

  XRInputSourceDescription(
      XRTargetRayMode target_ray_mode,
      XRHandedness handedness,
      const std::optional<::gfx::Transform>& input_from_pointer,
      ::blink::Vector<::blink::String> profiles);


  ~XRInputSourceDescription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRInputSourceDescriptionPtr>
  XRInputSourceDescriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRInputSourceDescription::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRInputSourceDescription::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRInputSourceDescription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRInputSourceDescription_UnserializedMessageContext<
            UserType, XRInputSourceDescription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRInputSourceDescription::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRInputSourceDescription::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRInputSourceDescription_UnserializedMessageContext<
            UserType, XRInputSourceDescription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRInputSourceDescription::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRTargetRayMode target_ray_mode;
  
  XRHandedness handedness;
  
  std::optional<::gfx::Transform> input_from_pointer;
  
  ::blink::Vector<::blink::String> profiles;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRInputSourceState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRInputSourceState, T>::value>;
  using DataView = XRInputSourceStateDataView;
  using Data_ = internal::XRInputSourceState_Data;

  template <typename... Args>
  static XRInputSourceStatePtr New(Args&&... args) {
    return XRInputSourceStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRInputSourceStatePtr From(const U& u) {
    return mojo::TypeConverter<XRInputSourceStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRInputSourceState>::Convert(*this);
  }


  XRInputSourceState();

  XRInputSourceState(
      uint32_t source_id,
      XRInputSourceDescriptionPtr description,
      const std::optional<::gfx::Transform>& mojo_from_input,
      bool emulated_position,
      bool is_auxiliary,
      bool primary_input_pressed,
      bool primary_input_clicked,
      bool primary_squeeze_pressed,
      bool primary_squeeze_clicked,
      const std::optional<::device::Gamepad>& gamepad,
      const std::optional<::gfx::PointF>& overlay_pointer_position,
      ::device::mojom::blink::XRHandTrackingDataPtr hand_tracking_data);

XRInputSourceState(const XRInputSourceState&) = delete;
XRInputSourceState& operator=(const XRInputSourceState&) = delete;

  ~XRInputSourceState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRInputSourceStatePtr>
  XRInputSourceStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRInputSourceState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRInputSourceState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRInputSourceState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRInputSourceState_UnserializedMessageContext<
            UserType, XRInputSourceState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRInputSourceState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRInputSourceState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRInputSourceState_UnserializedMessageContext<
            UserType, XRInputSourceState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRInputSourceState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t source_id;
  
  XRInputSourceDescriptionPtr description;
  
  std::optional<::gfx::Transform> mojo_from_input;
  
  bool emulated_position;
  
  bool is_auxiliary;
  
  bool primary_input_pressed;
  
  bool primary_input_clicked;
  
  bool primary_squeeze_pressed;
  
  bool primary_squeeze_clicked;
  
  std::optional<::device::Gamepad> gamepad;
  
  std::optional<::gfx::PointF> overlay_pointer_position;
  
  ::device::mojom::blink::XRHandTrackingDataPtr hand_tracking_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRPose {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VRPose, T>::value>;
  using DataView = VRPoseDataView;
  using Data_ = internal::VRPose_Data;

  template <typename... Args>
  static VRPosePtr New(Args&&... args) {
    return VRPosePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VRPosePtr From(const U& u) {
    return mojo::TypeConverter<VRPosePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VRPose>::Convert(*this);
  }


  VRPose();

  VRPose(
      const std::optional<::gfx::Quaternion>& orientation,
      const std::optional<::gfx::Point3F>& position,
      bool emulated_position);


  ~VRPose();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VRPosePtr>
  VRPosePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VRPose::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VRPose::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VRPose::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRPose::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRPose::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VRPose::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VRPose_UnserializedMessageContext<
            UserType, VRPose::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VRPose::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VRPose::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VRPose_UnserializedMessageContext<
            UserType, VRPose::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VRPose::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::gfx::Quaternion> orientation;
  
  std::optional<::gfx::Point3F> position;
  
  bool emulated_position;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) Pose {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Pose, T>::value>;
  using DataView = PoseDataView;
  using Data_ = internal::Pose_Data;

  template <typename... Args>
  static PosePtr New(Args&&... args) {
    return PosePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PosePtr From(const U& u) {
    return mojo::TypeConverter<PosePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Pose>::Convert(*this);
  }


  Pose();

  Pose(
      const ::gfx::Quaternion& orientation,
      const ::gfx::Point3F& position);


  ~Pose();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PosePtr>
  PosePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Pose::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Pose::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Pose::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Pose::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Pose::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Pose::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Pose_UnserializedMessageContext<
            UserType, Pose::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Pose::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Pose::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Pose_UnserializedMessageContext<
            UserType, Pose::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Pose::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Quaternion orientation;
  
  ::gfx::Point3F position;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRRay {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRRay, T>::value>;
  using DataView = XRRayDataView;
  using Data_ = internal::XRRay_Data;

  template <typename... Args>
  static XRRayPtr New(Args&&... args) {
    return XRRayPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRRayPtr From(const U& u) {
    return mojo::TypeConverter<XRRayPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRRay>::Convert(*this);
  }


  XRRay();

  XRRay(
      const ::gfx::Point3F& origin,
      const ::gfx::Vector3dF& direction);


  ~XRRay();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRRayPtr>
  XRRayPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRRay::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRRay::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRRay::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRRay::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRRay::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRRay::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRRay_UnserializedMessageContext<
            UserType, XRRay::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRRay::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRRay::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRRay_UnserializedMessageContext<
            UserType, XRRay::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRRay::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Point3F origin;
  
  ::gfx::Vector3dF direction;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRHitResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitResult, T>::value>;
  using DataView = XRHitResultDataView;
  using Data_ = internal::XRHitResult_Data;

  template <typename... Args>
  static XRHitResultPtr New(Args&&... args) {
    return XRHitResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitResultPtr From(const U& u) {
    return mojo::TypeConverter<XRHitResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitResult>::Convert(*this);
  }


  XRHitResult();

  XRHitResult(
      const ::device::Pose& mojo_from_result,
      const std::optional<::device::PlaneId>& plane_id);


  ~XRHitResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitResultPtr>
  XRHitResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitResult_UnserializedMessageContext<
            UserType, XRHitResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHitResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHitResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitResult_UnserializedMessageContext<
            UserType, XRHitResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::Pose mojo_from_result;
  
  std::optional<::device::PlaneId> plane_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRViewGeometry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRViewGeometry, T>::value>;
  using DataView = XRViewGeometryDataView;
  using Data_ = internal::XRViewGeometry_Data;

  template <typename... Args>
  static XRViewGeometryPtr New(Args&&... args) {
    return XRViewGeometryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRViewGeometryPtr From(const U& u) {
    return mojo::TypeConverter<XRViewGeometryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRViewGeometry>::Convert(*this);
  }


  XRViewGeometry();

  XRViewGeometry(
      VRFieldOfViewPtr field_of_view,
      const ::gfx::Transform& mojo_from_view);

XRViewGeometry(const XRViewGeometry&) = delete;
XRViewGeometry& operator=(const XRViewGeometry&) = delete;

  ~XRViewGeometry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRViewGeometryPtr>
  XRViewGeometryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRViewGeometry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRViewGeometry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRViewGeometry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRViewGeometry::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRViewGeometry::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRViewGeometry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRViewGeometry_UnserializedMessageContext<
            UserType, XRViewGeometry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRViewGeometry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRViewGeometry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRViewGeometry_UnserializedMessageContext<
            UserType, XRViewGeometry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRViewGeometry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  VRFieldOfViewPtr field_of_view;
  
  ::gfx::Transform mojo_from_view;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRViewGeometry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRViewGeometry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRViewGeometry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRViewGeometry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRVisibilityMask {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRVisibilityMask, T>::value>;
  using DataView = XRVisibilityMaskDataView;
  using Data_ = internal::XRVisibilityMask_Data;

  template <typename... Args>
  static XRVisibilityMaskPtr New(Args&&... args) {
    return XRVisibilityMaskPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRVisibilityMaskPtr From(const U& u) {
    return mojo::TypeConverter<XRVisibilityMaskPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRVisibilityMask>::Convert(*this);
  }


  XRVisibilityMask();

  XRVisibilityMask(
      ::blink::Vector<::gfx::PointF> vertices,
      ::blink::Vector<uint32_t> unvalidated_indices);


  ~XRVisibilityMask();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRVisibilityMaskPtr>
  XRVisibilityMaskPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRVisibilityMask::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRVisibilityMask::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRVisibilityMask::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRVisibilityMask::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRVisibilityMask::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRVisibilityMask::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRVisibilityMask_UnserializedMessageContext<
            UserType, XRVisibilityMask::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRVisibilityMask::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRVisibilityMask::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRVisibilityMask_UnserializedMessageContext<
            UserType, XRVisibilityMask::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRVisibilityMask::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::gfx::PointF> vertices;
  
  ::blink::Vector<uint32_t> unvalidated_indices;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRVisibilityMask::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRVisibilityMask::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRVisibilityMask::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRVisibilityMask::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRView {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRView, T>::value>;
  using DataView = XRViewDataView;
  using Data_ = internal::XRView_Data;

  template <typename... Args>
  static XRViewPtr New(Args&&... args) {
    return XRViewPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRViewPtr From(const U& u) {
    return mojo::TypeConverter<XRViewPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRView>::Convert(*this);
  }


  XRView();

  XRView(
      XREye eye,
      XRViewGeometryPtr geometry,
      const ::gfx::Rect& viewport,
      XRDepthDataPtr depth_data,
      bool is_first_person_observer,
      XRVisibilityMaskPtr visibility_mask,
      const ::device::XrVisibilityMaskId& visibility_mask_id);

XRView(const XRView&) = delete;
XRView& operator=(const XRView&) = delete;

  ~XRView();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRViewPtr>
  XRViewPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRView::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRView::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRView::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRView::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRView_UnserializedMessageContext<
            UserType, XRView::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRView::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRView::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRView_UnserializedMessageContext<
            UserType, XRView::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRView::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XREye eye;
  
  XRViewGeometryPtr geometry;
  
  ::gfx::Rect viewport;
  
  XRDepthDataPtr depth_data;
  
  bool is_first_person_observer;
  
  XRVisibilityMaskPtr visibility_mask;
  
  ::device::XrVisibilityMaskId visibility_mask_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRView::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRView::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRView::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRView::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) VRStageParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VRStageParameters, T>::value>;
  using DataView = VRStageParametersDataView;
  using Data_ = internal::VRStageParameters_Data;

  template <typename... Args>
  static VRStageParametersPtr New(Args&&... args) {
    return VRStageParametersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VRStageParametersPtr From(const U& u) {
    return mojo::TypeConverter<VRStageParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VRStageParameters>::Convert(*this);
  }


  VRStageParameters();

  VRStageParameters(
      const ::gfx::Transform& mojo_from_stage,
      std::optional<::blink::Vector<::gfx::Point3F>> bounds);


  ~VRStageParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VRStageParametersPtr>
  VRStageParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRStageParameters::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRStageParameters::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VRStageParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VRStageParameters_UnserializedMessageContext<
            UserType, VRStageParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VRStageParameters::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VRStageParameters::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VRStageParameters_UnserializedMessageContext<
            UserType, VRStageParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VRStageParameters::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Transform mojo_from_stage;
  
  std::optional<::blink::Vector<::gfx::Point3F>> bounds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPlaneData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPlaneData, T>::value>;
  using DataView = XRPlaneDataDataView;
  using Data_ = internal::XRPlaneData_Data;

  template <typename... Args>
  static XRPlaneDataPtr New(Args&&... args) {
    return XRPlaneDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPlaneDataPtr From(const U& u) {
    return mojo::TypeConverter<XRPlaneDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPlaneData>::Convert(*this);
  }


  XRPlaneData();

  XRPlaneData(
      const ::device::PlaneId& id,
      XRPlaneOrientation orientation,
      const std::optional<::device::Pose>& mojo_from_plane,
      ::blink::Vector<XRPlanePointDataPtr> polygon);

XRPlaneData(const XRPlaneData&) = delete;
XRPlaneData& operator=(const XRPlaneData&) = delete;

  ~XRPlaneData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPlaneDataPtr>
  XRPlaneDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlaneData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlaneData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPlaneData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPlaneData_UnserializedMessageContext<
            UserType, XRPlaneData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRPlaneData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRPlaneData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPlaneData_UnserializedMessageContext<
            UserType, XRPlaneData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPlaneData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::PlaneId id;
  
  XRPlaneOrientation orientation;
  
  std::optional<::device::Pose> mojo_from_plane;
  
  ::blink::Vector<XRPlanePointDataPtr> polygon;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRPlaneDetectionData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPlaneDetectionData, T>::value>;
  using DataView = XRPlaneDetectionDataDataView;
  using Data_ = internal::XRPlaneDetectionData_Data;

  template <typename... Args>
  static XRPlaneDetectionDataPtr New(Args&&... args) {
    return XRPlaneDetectionDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPlaneDetectionDataPtr From(const U& u) {
    return mojo::TypeConverter<XRPlaneDetectionDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPlaneDetectionData>::Convert(*this);
  }


  XRPlaneDetectionData();

  XRPlaneDetectionData(
      ::blink::Vector<::device::PlaneId> all_planes_ids,
      ::blink::Vector<XRPlaneDataPtr> updated_planes_data);

XRPlaneDetectionData(const XRPlaneDetectionData&) = delete;
XRPlaneDetectionData& operator=(const XRPlaneDetectionData&) = delete;

  ~XRPlaneDetectionData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPlaneDetectionDataPtr>
  XRPlaneDetectionDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlaneDetectionData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlaneDetectionData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPlaneDetectionData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPlaneDetectionData_UnserializedMessageContext<
            UserType, XRPlaneDetectionData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRPlaneDetectionData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRPlaneDetectionData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPlaneDetectionData_UnserializedMessageContext<
            UserType, XRPlaneDetectionData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPlaneDetectionData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::device::PlaneId> all_planes_ids;
  
  ::blink::Vector<XRPlaneDataPtr> updated_planes_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRAnchorData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRAnchorData, T>::value>;
  using DataView = XRAnchorDataDataView;
  using Data_ = internal::XRAnchorData_Data;

  template <typename... Args>
  static XRAnchorDataPtr New(Args&&... args) {
    return XRAnchorDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRAnchorDataPtr From(const U& u) {
    return mojo::TypeConverter<XRAnchorDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRAnchorData>::Convert(*this);
  }


  XRAnchorData();

  XRAnchorData(
      const ::device::AnchorId& id,
      const std::optional<::device::Pose>& mojo_from_anchor);


  ~XRAnchorData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRAnchorDataPtr>
  XRAnchorDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRAnchorData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRAnchorData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRAnchorData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRAnchorData_UnserializedMessageContext<
            UserType, XRAnchorData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRAnchorData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRAnchorData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRAnchorData_UnserializedMessageContext<
            UserType, XRAnchorData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRAnchorData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::AnchorId id;
  
  std::optional<::device::Pose> mojo_from_anchor;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRAnchorsData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRAnchorsData, T>::value>;
  using DataView = XRAnchorsDataDataView;
  using Data_ = internal::XRAnchorsData_Data;

  template <typename... Args>
  static XRAnchorsDataPtr New(Args&&... args) {
    return XRAnchorsDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRAnchorsDataPtr From(const U& u) {
    return mojo::TypeConverter<XRAnchorsDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRAnchorsData>::Convert(*this);
  }


  XRAnchorsData();

  XRAnchorsData(
      ::blink::Vector<::device::AnchorId> all_anchors_ids,
      ::blink::Vector<XRAnchorDataPtr> updated_anchors_data);

XRAnchorsData(const XRAnchorsData&) = delete;
XRAnchorsData& operator=(const XRAnchorsData&) = delete;

  ~XRAnchorsData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRAnchorsDataPtr>
  XRAnchorsDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRAnchorsData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRAnchorsData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRAnchorsData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRAnchorsData_UnserializedMessageContext<
            UserType, XRAnchorsData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRAnchorsData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRAnchorsData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRAnchorsData_UnserializedMessageContext<
            UserType, XRAnchorsData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRAnchorsData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::device::AnchorId> all_anchors_ids;
  
  ::blink::Vector<XRAnchorDataPtr> updated_anchors_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRHitTestSubscriptionResultData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitTestSubscriptionResultData, T>::value>;
  using DataView = XRHitTestSubscriptionResultDataDataView;
  using Data_ = internal::XRHitTestSubscriptionResultData_Data;

  template <typename... Args>
  static XRHitTestSubscriptionResultDataPtr New(Args&&... args) {
    return XRHitTestSubscriptionResultDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitTestSubscriptionResultDataPtr From(const U& u) {
    return mojo::TypeConverter<XRHitTestSubscriptionResultDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitTestSubscriptionResultData>::Convert(*this);
  }


  XRHitTestSubscriptionResultData();

  XRHitTestSubscriptionResultData(
      const ::device::HitTestSubscriptionId& subscription_id,
      ::blink::Vector<XRHitResultPtr> hit_test_results);

XRHitTestSubscriptionResultData(const XRHitTestSubscriptionResultData&) = delete;
XRHitTestSubscriptionResultData& operator=(const XRHitTestSubscriptionResultData&) = delete;

  ~XRHitTestSubscriptionResultData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitTestSubscriptionResultDataPtr>
  XRHitTestSubscriptionResultDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestSubscriptionResultData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestSubscriptionResultData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitTestSubscriptionResultData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitTestSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHitTestSubscriptionResultData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitTestSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::HitTestSubscriptionId subscription_id;
  
  ::blink::Vector<XRHitResultPtr> hit_test_results;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRHitTestTransientInputSubscriptionResultData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitTestTransientInputSubscriptionResultData, T>::value>;
  using DataView = XRHitTestTransientInputSubscriptionResultDataDataView;
  using Data_ = internal::XRHitTestTransientInputSubscriptionResultData_Data;

  template <typename... Args>
  static XRHitTestTransientInputSubscriptionResultDataPtr New(Args&&... args) {
    return XRHitTestTransientInputSubscriptionResultDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitTestTransientInputSubscriptionResultDataPtr From(const U& u) {
    return mojo::TypeConverter<XRHitTestTransientInputSubscriptionResultDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitTestTransientInputSubscriptionResultData>::Convert(*this);
  }


  XRHitTestTransientInputSubscriptionResultData();

  XRHitTestTransientInputSubscriptionResultData(
      const ::device::HitTestSubscriptionId& subscription_id,
      ::blink::HashMap<uint32_t, ::blink::Vector<XRHitResultPtr>> input_source_id_to_hit_test_results);

XRHitTestTransientInputSubscriptionResultData(const XRHitTestTransientInputSubscriptionResultData&) = delete;
XRHitTestTransientInputSubscriptionResultData& operator=(const XRHitTestTransientInputSubscriptionResultData&) = delete;

  ~XRHitTestTransientInputSubscriptionResultData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitTestTransientInputSubscriptionResultDataPtr>
  XRHitTestTransientInputSubscriptionResultDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestTransientInputSubscriptionResultData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestTransientInputSubscriptionResultData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitTestTransientInputSubscriptionResultData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitTestTransientInputSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestTransientInputSubscriptionResultData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHitTestTransientInputSubscriptionResultData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHitTestTransientInputSubscriptionResultData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitTestTransientInputSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestTransientInputSubscriptionResultData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitTestTransientInputSubscriptionResultData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::HitTestSubscriptionId subscription_id;
  
  ::blink::HashMap<uint32_t, ::blink::Vector<XRHitResultPtr>> input_source_id_to_hit_test_results;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRHitTestSubscriptionResultsData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitTestSubscriptionResultsData, T>::value>;
  using DataView = XRHitTestSubscriptionResultsDataDataView;
  using Data_ = internal::XRHitTestSubscriptionResultsData_Data;

  template <typename... Args>
  static XRHitTestSubscriptionResultsDataPtr New(Args&&... args) {
    return XRHitTestSubscriptionResultsDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitTestSubscriptionResultsDataPtr From(const U& u) {
    return mojo::TypeConverter<XRHitTestSubscriptionResultsDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitTestSubscriptionResultsData>::Convert(*this);
  }


  XRHitTestSubscriptionResultsData();

  XRHitTestSubscriptionResultsData(
      ::blink::Vector<XRHitTestSubscriptionResultDataPtr> results,
      ::blink::Vector<XRHitTestTransientInputSubscriptionResultDataPtr> transient_input_results);

XRHitTestSubscriptionResultsData(const XRHitTestSubscriptionResultsData&) = delete;
XRHitTestSubscriptionResultsData& operator=(const XRHitTestSubscriptionResultsData&) = delete;

  ~XRHitTestSubscriptionResultsData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitTestSubscriptionResultsDataPtr>
  XRHitTestSubscriptionResultsDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestSubscriptionResultsData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestSubscriptionResultsData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitTestSubscriptionResultsData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitTestSubscriptionResultsData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultsData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultsData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHitTestSubscriptionResultsData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitTestSubscriptionResultsData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultsData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultsData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<XRHitTestSubscriptionResultDataPtr> results;
  
  ::blink::Vector<XRHitTestTransientInputSubscriptionResultDataPtr> transient_input_results;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRSphericalHarmonics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRSphericalHarmonics, T>::value>;
  using DataView = XRSphericalHarmonicsDataView;
  using Data_ = internal::XRSphericalHarmonics_Data;

  template <typename... Args>
  static XRSphericalHarmonicsPtr New(Args&&... args) {
    return XRSphericalHarmonicsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRSphericalHarmonicsPtr From(const U& u) {
    return mojo::TypeConverter<XRSphericalHarmonicsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRSphericalHarmonics>::Convert(*this);
  }


  XRSphericalHarmonics();

  explicit XRSphericalHarmonics(
      ::blink::Vector<::device::RgbTupleF32> coefficients);


  ~XRSphericalHarmonics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRSphericalHarmonicsPtr>
  XRSphericalHarmonicsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRSphericalHarmonics::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRSphericalHarmonics::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRSphericalHarmonics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRSphericalHarmonics_UnserializedMessageContext<
            UserType, XRSphericalHarmonics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRSphericalHarmonics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRSphericalHarmonics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRSphericalHarmonics_UnserializedMessageContext<
            UserType, XRSphericalHarmonics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRSphericalHarmonics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::device::RgbTupleF32> coefficients;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRCubeMap {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRCubeMap, T>::value>;
  using DataView = XRCubeMapDataView;
  using Data_ = internal::XRCubeMap_Data;
  
  static constexpr uint64_t kNumComponentsPerPixel = 4ULL;

  template <typename... Args>
  static XRCubeMapPtr New(Args&&... args) {
    return XRCubeMapPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRCubeMapPtr From(const U& u) {
    return mojo::TypeConverter<XRCubeMapPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRCubeMap>::Convert(*this);
  }


  XRCubeMap();

  XRCubeMap(
      uint32_t width_and_height,
      ::blink::Vector<uint16_t> positive_x,
      ::blink::Vector<uint16_t> negative_x,
      ::blink::Vector<uint16_t> positive_y,
      ::blink::Vector<uint16_t> negative_y,
      ::blink::Vector<uint16_t> positive_z,
      ::blink::Vector<uint16_t> negative_z);


  ~XRCubeMap();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRCubeMapPtr>
  XRCubeMapPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRCubeMap::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRCubeMap::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRCubeMap::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRCubeMap_UnserializedMessageContext<
            UserType, XRCubeMap::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRCubeMap::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRCubeMap::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRCubeMap_UnserializedMessageContext<
            UserType, XRCubeMap::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRCubeMap::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t width_and_height;
  
  ::blink::Vector<uint16_t> positive_x;
  
  ::blink::Vector<uint16_t> negative_x;
  
  ::blink::Vector<uint16_t> positive_y;
  
  ::blink::Vector<uint16_t> negative_y;
  
  ::blink::Vector<uint16_t> positive_z;
  
  ::blink::Vector<uint16_t> negative_z;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRLightProbe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRLightProbe, T>::value>;
  using DataView = XRLightProbeDataView;
  using Data_ = internal::XRLightProbe_Data;

  template <typename... Args>
  static XRLightProbePtr New(Args&&... args) {
    return XRLightProbePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRLightProbePtr From(const U& u) {
    return mojo::TypeConverter<XRLightProbePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRLightProbe>::Convert(*this);
  }


  XRLightProbe();

  XRLightProbe(
      XRSphericalHarmonicsPtr spherical_harmonics,
      const ::gfx::Vector3dF& main_light_direction,
      const ::device::RgbTupleF32& main_light_intensity);

XRLightProbe(const XRLightProbe&) = delete;
XRLightProbe& operator=(const XRLightProbe&) = delete;

  ~XRLightProbe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRLightProbePtr>
  XRLightProbePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLightProbe::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLightProbe::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRLightProbe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRLightProbe_UnserializedMessageContext<
            UserType, XRLightProbe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRLightProbe::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRLightProbe::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRLightProbe_UnserializedMessageContext<
            UserType, XRLightProbe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRLightProbe::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRSphericalHarmonicsPtr spherical_harmonics;
  
  ::gfx::Vector3dF main_light_direction;
  
  ::device::RgbTupleF32 main_light_intensity;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRReflectionProbe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRReflectionProbe, T>::value>;
  using DataView = XRReflectionProbeDataView;
  using Data_ = internal::XRReflectionProbe_Data;

  template <typename... Args>
  static XRReflectionProbePtr New(Args&&... args) {
    return XRReflectionProbePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRReflectionProbePtr From(const U& u) {
    return mojo::TypeConverter<XRReflectionProbePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRReflectionProbe>::Convert(*this);
  }


  XRReflectionProbe();

  explicit XRReflectionProbe(
      XRCubeMapPtr cube_map);

XRReflectionProbe(const XRReflectionProbe&) = delete;
XRReflectionProbe& operator=(const XRReflectionProbe&) = delete;

  ~XRReflectionProbe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRReflectionProbePtr>
  XRReflectionProbePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRReflectionProbe::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRReflectionProbe::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRReflectionProbe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRReflectionProbe_UnserializedMessageContext<
            UserType, XRReflectionProbe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRReflectionProbe::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRReflectionProbe::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRReflectionProbe_UnserializedMessageContext<
            UserType, XRReflectionProbe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRReflectionProbe::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRCubeMapPtr cube_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRLightEstimationData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRLightEstimationData, T>::value>;
  using DataView = XRLightEstimationDataDataView;
  using Data_ = internal::XRLightEstimationData_Data;

  template <typename... Args>
  static XRLightEstimationDataPtr New(Args&&... args) {
    return XRLightEstimationDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRLightEstimationDataPtr From(const U& u) {
    return mojo::TypeConverter<XRLightEstimationDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRLightEstimationData>::Convert(*this);
  }


  XRLightEstimationData();

  XRLightEstimationData(
      XRLightProbePtr light_probe,
      XRReflectionProbePtr reflection_probe);

XRLightEstimationData(const XRLightEstimationData&) = delete;
XRLightEstimationData& operator=(const XRLightEstimationData&) = delete;

  ~XRLightEstimationData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRLightEstimationDataPtr>
  XRLightEstimationDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLightEstimationData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLightEstimationData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRLightEstimationData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRLightEstimationData_UnserializedMessageContext<
            UserType, XRLightEstimationData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRLightEstimationData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRLightEstimationData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRLightEstimationData_UnserializedMessageContext<
            UserType, XRLightEstimationData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRLightEstimationData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRLightProbePtr light_probe;
  
  XRReflectionProbePtr reflection_probe;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRDepthDataUpdated {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRDepthDataUpdated, T>::value>;
  using DataView = XRDepthDataUpdatedDataView;
  using Data_ = internal::XRDepthDataUpdated_Data;

  template <typename... Args>
  static XRDepthDataUpdatedPtr New(Args&&... args) {
    return XRDepthDataUpdatedPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRDepthDataUpdatedPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthDataUpdatedPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthDataUpdated>::Convert(*this);
  }


  XRDepthDataUpdated();

  XRDepthDataUpdated(
      ::mojo_base::BigBuffer pixel_data,
      const ::gfx::Transform& norm_texture_from_norm_view,
      const ::gfx::Size& size,
      float raw_value_to_meters,
      XRViewGeometryPtr view_geometry);

XRDepthDataUpdated(const XRDepthDataUpdated&) = delete;
XRDepthDataUpdated& operator=(const XRDepthDataUpdated&) = delete;

  ~XRDepthDataUpdated();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRDepthDataUpdatedPtr>
  XRDepthDataUpdatedPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthDataUpdated::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRDepthDataUpdated_UnserializedMessageContext<
            UserType, XRDepthDataUpdated::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRDepthDataUpdated::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRDepthDataUpdated::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRDepthDataUpdated_UnserializedMessageContext<
            UserType, XRDepthDataUpdated::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRDepthDataUpdated::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo_base::BigBuffer pixel_data;
  
  ::gfx::Transform norm_texture_from_norm_view;
  
  ::gfx::Size size;
  
  float raw_value_to_meters;
  
  XRViewGeometryPtr view_geometry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRTrackedImageData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRTrackedImageData, T>::value>;
  using DataView = XRTrackedImageDataDataView;
  using Data_ = internal::XRTrackedImageData_Data;

  template <typename... Args>
  static XRTrackedImageDataPtr New(Args&&... args) {
    return XRTrackedImageDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRTrackedImageDataPtr From(const U& u) {
    return mojo::TypeConverter<XRTrackedImageDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRTrackedImageData>::Convert(*this);
  }


  XRTrackedImageData();

  XRTrackedImageData(
      uint32_t index,
      const ::device::Pose& mojo_from_image,
      bool actively_tracked,
      float width_in_meters);


  ~XRTrackedImageData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRTrackedImageDataPtr>
  XRTrackedImageDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRTrackedImageData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRTrackedImageData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRTrackedImageData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRTrackedImageData_UnserializedMessageContext<
            UserType, XRTrackedImageData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRTrackedImageData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRTrackedImageData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRTrackedImageData_UnserializedMessageContext<
            UserType, XRTrackedImageData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRTrackedImageData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t index;
  
  ::device::Pose mojo_from_image;
  
  bool actively_tracked;
  
  float width_in_meters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRTrackedImagesData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRTrackedImagesData, T>::value>;
  using DataView = XRTrackedImagesDataDataView;
  using Data_ = internal::XRTrackedImagesData_Data;

  template <typename... Args>
  static XRTrackedImagesDataPtr New(Args&&... args) {
    return XRTrackedImagesDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRTrackedImagesDataPtr From(const U& u) {
    return mojo::TypeConverter<XRTrackedImagesDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRTrackedImagesData>::Convert(*this);
  }


  XRTrackedImagesData();

  XRTrackedImagesData(
      ::blink::Vector<XRTrackedImageDataPtr> images_data,
      std::optional<::blink::Vector<bool>> image_trackable_scores);

XRTrackedImagesData(const XRTrackedImagesData&) = delete;
XRTrackedImagesData& operator=(const XRTrackedImagesData&) = delete;

  ~XRTrackedImagesData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRTrackedImagesDataPtr>
  XRTrackedImagesDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRTrackedImagesData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRTrackedImagesData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRTrackedImagesData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRTrackedImagesData_UnserializedMessageContext<
            UserType, XRTrackedImagesData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRTrackedImagesData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRTrackedImagesData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRTrackedImagesData_UnserializedMessageContext<
            UserType, XRTrackedImagesData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRTrackedImagesData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<XRTrackedImageDataPtr> images_data;
  
  std::optional<::blink::Vector<bool>> image_trackable_scores;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRQuadLayerData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRQuadLayerData, T>::value>;
  using DataView = XRQuadLayerDataDataView;
  using Data_ = internal::XRQuadLayerData_Data;

  template <typename... Args>
  static XRQuadLayerDataPtr New(Args&&... args) {
    return XRQuadLayerDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRQuadLayerDataPtr From(const U& u) {
    return mojo::TypeConverter<XRQuadLayerDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRQuadLayerData>::Convert(*this);
  }


  XRQuadLayerData();

  XRQuadLayerData(
      const ::gfx::Transform& native_origin_from_layer,
      float width,
      float height);


  ~XRQuadLayerData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRQuadLayerDataPtr>
  XRQuadLayerDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRQuadLayerData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRQuadLayerData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRQuadLayerData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRQuadLayerData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRQuadLayerData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRQuadLayerData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRQuadLayerData_UnserializedMessageContext<
            UserType, XRQuadLayerData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRQuadLayerData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRQuadLayerData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRQuadLayerData_UnserializedMessageContext<
            UserType, XRQuadLayerData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRQuadLayerData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Transform native_origin_from_layer;
  
  float width;
  
  float height;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRQuadLayerData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRQuadLayerData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRQuadLayerData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRQuadLayerData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRCylinderLayerData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRCylinderLayerData, T>::value>;
  using DataView = XRCylinderLayerDataDataView;
  using Data_ = internal::XRCylinderLayerData_Data;

  template <typename... Args>
  static XRCylinderLayerDataPtr New(Args&&... args) {
    return XRCylinderLayerDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRCylinderLayerDataPtr From(const U& u) {
    return mojo::TypeConverter<XRCylinderLayerDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRCylinderLayerData>::Convert(*this);
  }


  XRCylinderLayerData();

  XRCylinderLayerData(
      const ::gfx::Transform& native_origin_from_layer,
      float radius,
      float central_angle,
      float aspect_ratio);


  ~XRCylinderLayerData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRCylinderLayerDataPtr>
  XRCylinderLayerDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRCylinderLayerData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRCylinderLayerData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRCylinderLayerData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRCylinderLayerData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRCylinderLayerData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRCylinderLayerData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRCylinderLayerData_UnserializedMessageContext<
            UserType, XRCylinderLayerData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRCylinderLayerData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRCylinderLayerData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRCylinderLayerData_UnserializedMessageContext<
            UserType, XRCylinderLayerData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRCylinderLayerData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Transform native_origin_from_layer;
  
  float radius;
  
  float central_angle;
  
  float aspect_ratio;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRCylinderLayerData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRCylinderLayerData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRCylinderLayerData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRCylinderLayerData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XREquirectLayerData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XREquirectLayerData, T>::value>;
  using DataView = XREquirectLayerDataDataView;
  using Data_ = internal::XREquirectLayerData_Data;

  template <typename... Args>
  static XREquirectLayerDataPtr New(Args&&... args) {
    return XREquirectLayerDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XREquirectLayerDataPtr From(const U& u) {
    return mojo::TypeConverter<XREquirectLayerDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XREquirectLayerData>::Convert(*this);
  }


  XREquirectLayerData();

  XREquirectLayerData(
      const ::gfx::Transform& native_origin_from_layer,
      float radius,
      float central_horizontal_angle,
      float upper_vertical_angle,
      float lower_vertical_angle);


  ~XREquirectLayerData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XREquirectLayerDataPtr>
  XREquirectLayerDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XREquirectLayerData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XREquirectLayerData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XREquirectLayerData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XREquirectLayerData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XREquirectLayerData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XREquirectLayerData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XREquirectLayerData_UnserializedMessageContext<
            UserType, XREquirectLayerData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XREquirectLayerData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XREquirectLayerData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XREquirectLayerData_UnserializedMessageContext<
            UserType, XREquirectLayerData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XREquirectLayerData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Transform native_origin_from_layer;
  
  float radius;
  
  float central_horizontal_angle;
  
  float upper_vertical_angle;
  
  float lower_vertical_angle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XREquirectLayerData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XREquirectLayerData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XREquirectLayerData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XREquirectLayerData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRCubeLayerData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRCubeLayerData, T>::value>;
  using DataView = XRCubeLayerDataDataView;
  using Data_ = internal::XRCubeLayerData_Data;

  template <typename... Args>
  static XRCubeLayerDataPtr New(Args&&... args) {
    return XRCubeLayerDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRCubeLayerDataPtr From(const U& u) {
    return mojo::TypeConverter<XRCubeLayerDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRCubeLayerData>::Convert(*this);
  }


  XRCubeLayerData();

  explicit XRCubeLayerData(
      const ::gfx::Quaternion& orientation);


  ~XRCubeLayerData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRCubeLayerDataPtr>
  XRCubeLayerDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRCubeLayerData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRCubeLayerData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRCubeLayerData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRCubeLayerData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRCubeLayerData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRCubeLayerData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRCubeLayerData_UnserializedMessageContext<
            UserType, XRCubeLayerData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRCubeLayerData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRCubeLayerData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRCubeLayerData_UnserializedMessageContext<
            UserType, XRCubeLayerData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRCubeLayerData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Quaternion orientation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRCubeLayerData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRCubeLayerData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRCubeLayerData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRCubeLayerData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRLayerReadOnlyData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRLayerReadOnlyData, T>::value>;
  using DataView = XRLayerReadOnlyDataDataView;
  using Data_ = internal::XRLayerReadOnlyData_Data;

  template <typename... Args>
  static XRLayerReadOnlyDataPtr New(Args&&... args) {
    return XRLayerReadOnlyDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRLayerReadOnlyDataPtr From(const U& u) {
    return mojo::TypeConverter<XRLayerReadOnlyDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRLayerReadOnlyData>::Convert(*this);
  }


  XRLayerReadOnlyData();

  XRLayerReadOnlyData(
      const ::device::LayerId& layer_id,
      XRLayerLayout layout,
      uint32_t texture_width,
      uint32_t texture_height,
      bool is_static);


  ~XRLayerReadOnlyData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRLayerReadOnlyDataPtr>
  XRLayerReadOnlyDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRLayerReadOnlyData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRLayerReadOnlyData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRLayerReadOnlyData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLayerReadOnlyData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLayerReadOnlyData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRLayerReadOnlyData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRLayerReadOnlyData_UnserializedMessageContext<
            UserType, XRLayerReadOnlyData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRLayerReadOnlyData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRLayerReadOnlyData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRLayerReadOnlyData_UnserializedMessageContext<
            UserType, XRLayerReadOnlyData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRLayerReadOnlyData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::LayerId layer_id;
  
  XRLayerLayout layout;
  
  uint32_t texture_width;
  
  uint32_t texture_height;
  
  bool is_static;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRLayerReadOnlyData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRLayerReadOnlyData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRLayerReadOnlyData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRLayerReadOnlyData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRLayerMutableData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRLayerMutableData, T>::value>;
  using DataView = XRLayerMutableDataDataView;
  using Data_ = internal::XRLayerMutableData_Data;

  template <typename... Args>
  static XRLayerMutableDataPtr New(Args&&... args) {
    return XRLayerMutableDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRLayerMutableDataPtr From(const U& u) {
    return mojo::TypeConverter<XRLayerMutableDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRLayerMutableData>::Convert(*this);
  }


  XRLayerMutableData();

  XRLayerMutableData(
      bool blend_texture_source_alpha,
      float opacity,
      XRNativeOriginInformationPtr native_origin_information,
      XRLayerSpecificDataPtr layer_data);

XRLayerMutableData(const XRLayerMutableData&) = delete;
XRLayerMutableData& operator=(const XRLayerMutableData&) = delete;

  ~XRLayerMutableData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRLayerMutableDataPtr>
  XRLayerMutableDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRLayerMutableData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRLayerMutableData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRLayerMutableData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLayerMutableData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLayerMutableData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRLayerMutableData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRLayerMutableData_UnserializedMessageContext<
            UserType, XRLayerMutableData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRLayerMutableData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRLayerMutableData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRLayerMutableData_UnserializedMessageContext<
            UserType, XRLayerMutableData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRLayerMutableData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool blend_texture_source_alpha;
  
  float opacity;
  
  XRNativeOriginInformationPtr native_origin_information;
  
  XRLayerSpecificDataPtr layer_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRLayerMutableData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRLayerMutableData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRLayerMutableData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRLayerMutableData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRCompositionLayerData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRCompositionLayerData, T>::value>;
  using DataView = XRCompositionLayerDataDataView;
  using Data_ = internal::XRCompositionLayerData_Data;

  template <typename... Args>
  static XRCompositionLayerDataPtr New(Args&&... args) {
    return XRCompositionLayerDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRCompositionLayerDataPtr From(const U& u) {
    return mojo::TypeConverter<XRCompositionLayerDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRCompositionLayerData>::Convert(*this);
  }


  XRCompositionLayerData();

  XRCompositionLayerData(
      XRLayerReadOnlyDataPtr read_only_data,
      XRLayerMutableDataPtr mutable_data);

XRCompositionLayerData(const XRCompositionLayerData&) = delete;
XRCompositionLayerData& operator=(const XRCompositionLayerData&) = delete;

  ~XRCompositionLayerData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRCompositionLayerDataPtr>
  XRCompositionLayerDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRCompositionLayerData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRCompositionLayerData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRCompositionLayerData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRCompositionLayerData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRCompositionLayerData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRCompositionLayerData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRCompositionLayerData_UnserializedMessageContext<
            UserType, XRCompositionLayerData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRCompositionLayerData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRCompositionLayerData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRCompositionLayerData_UnserializedMessageContext<
            UserType, XRCompositionLayerData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRCompositionLayerData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRLayerReadOnlyDataPtr read_only_data;
  
  XRLayerMutableDataPtr mutable_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRCompositionLayerData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRCompositionLayerData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRCompositionLayerData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRCompositionLayerData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRLayerFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRLayerFrameData, T>::value>;
  using DataView = XRLayerFrameDataDataView;
  using Data_ = internal::XRLayerFrameData_Data;

  template <typename... Args>
  static XRLayerFrameDataPtr New(Args&&... args) {
    return XRLayerFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRLayerFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<XRLayerFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRLayerFrameData>::Convert(*this);
  }


  XRLayerFrameData();

  XRLayerFrameData(
      const ::device::LayerId& layer_id,
      ::gpu::ExportedSharedImage buffer_shared_image,
      const ::gpu::SyncToken& buffer_sync_token);

XRLayerFrameData(const XRLayerFrameData&) = delete;
XRLayerFrameData& operator=(const XRLayerFrameData&) = delete;

  ~XRLayerFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRLayerFrameDataPtr>
  XRLayerFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRLayerFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRLayerFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRLayerFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRLayerFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRLayerFrameData_UnserializedMessageContext<
            UserType, XRLayerFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRLayerFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRLayerFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRLayerFrameData_UnserializedMessageContext<
            UserType, XRLayerFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRLayerFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::LayerId layer_id;
  
  ::gpu::ExportedSharedImage buffer_shared_image;
  
  ::gpu::SyncToken buffer_sync_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRLayerFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRLayerFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRLayerFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRLayerFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRRenderInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRRenderInfo, T>::value>;
  using DataView = XRRenderInfoDataView;
  using Data_ = internal::XRRenderInfo_Data;

  template <typename... Args>
  static XRRenderInfoPtr New(Args&&... args) {
    return XRRenderInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRRenderInfoPtr From(const U& u) {
    return mojo::TypeConverter<XRRenderInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRRenderInfo>::Convert(*this);
  }


  XRRenderInfo();

  XRRenderInfo(
      int16_t frame_id,
      VRPosePtr mojo_from_viewer,
      ::blink::Vector<XRViewPtr> views);

XRRenderInfo(const XRRenderInfo&) = delete;
XRRenderInfo& operator=(const XRRenderInfo&) = delete;

  ~XRRenderInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRRenderInfoPtr>
  XRRenderInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRRenderInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRRenderInfo_UnserializedMessageContext<
            UserType, XRRenderInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRRenderInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRRenderInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRRenderInfo_UnserializedMessageContext<
            UserType, XRRenderInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRRenderInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int16_t frame_id;
  
  VRPosePtr mojo_from_viewer;
  
  ::blink::Vector<XRViewPtr> views;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRRenderInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) XRFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRFrameData, T>::value>;
  using DataView = XRFrameDataDataView;
  using Data_ = internal::XRFrameData_Data;

  template <typename... Args>
  static XRFrameDataPtr New(Args&&... args) {
    return XRFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<XRFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRFrameData>::Convert(*this);
  }


  XRFrameData();

  XRFrameData(
      XRRenderInfoPtr render_info,
      ::base::TimeDelta time_delta,
      std::optional<::gpu::ExportedSharedImage> buffer_shared_image,
      const std::optional<::gpu::SyncToken>& buffer_sync_token,
      std::optional<::gpu::ExportedSharedImage> camera_image_buffer_shared_image,
      const std::optional<::gpu::SyncToken>& camera_image_buffer_sync_token,
      const std::optional<::gfx::Size>& camera_image_size,
      bool mojo_space_reset,
      const std::optional<::gfx::Transform>& mojo_from_floor,
      std::optional<::blink::Vector<XRInputSourceStatePtr>> input_state,
      uint32_t stage_parameters_id,
      VRStageParametersPtr stage_parameters,
      XRPlaneDetectionDataPtr detected_planes_data,
      XRAnchorsDataPtr anchors_data,
      std::optional<::blink::Vector<XRLayerFrameDataPtr>> composition_layers_data,
      XRLightEstimationDataPtr light_estimation_data,
      XRHitTestSubscriptionResultsDataPtr hit_test_subscription_results,
      float rendering_time_ratio,
      XRTrackedImagesDataPtr tracked_images);

XRFrameData(const XRFrameData&) = delete;
XRFrameData& operator=(const XRFrameData&) = delete;

  ~XRFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRFrameDataPtr>
  XRFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRFrameData_UnserializedMessageContext<
            UserType, XRFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRFrameData_UnserializedMessageContext<
            UserType, XRFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRRenderInfoPtr render_info;
  
  ::base::TimeDelta time_delta;
  
  std::optional<::gpu::ExportedSharedImage> buffer_shared_image;
  
  std::optional<::gpu::SyncToken> buffer_sync_token;
  
  std::optional<::gpu::ExportedSharedImage> camera_image_buffer_shared_image;
  
  std::optional<::gpu::SyncToken> camera_image_buffer_sync_token;
  
  std::optional<::gfx::Size> camera_image_size;
  
  bool mojo_space_reset;
  
  std::optional<::gfx::Transform> mojo_from_floor;
  
  std::optional<::blink::Vector<XRInputSourceStatePtr>> input_state;
  
  uint32_t stage_parameters_id;
  
  VRStageParametersPtr stage_parameters;
  
  XRPlaneDetectionDataPtr detected_planes_data;
  
  XRAnchorsDataPtr anchors_data;
  
  std::optional<::blink::Vector<XRLayerFrameDataPtr>> composition_layers_data;
  
  XRLightEstimationDataPtr light_estimation_data;
  
  XRHitTestSubscriptionResultsDataPtr hit_test_subscription_results;
  
  float rendering_time_ratio;
  
  XRTrackedImagesDataPtr tracked_images;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) RequestSessionSuccess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestSessionSuccess, T>::value>;
  using DataView = RequestSessionSuccessDataView;
  using Data_ = internal::RequestSessionSuccess_Data;

  template <typename... Args>
  static RequestSessionSuccessPtr New(Args&&... args) {
    return RequestSessionSuccessPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestSessionSuccessPtr From(const U& u) {
    return mojo::TypeConverter<RequestSessionSuccessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestSessionSuccess>::Convert(*this);
  }


  RequestSessionSuccess();

  RequestSessionSuccess(
      XRSessionPtr session,
      uint64_t trace_id,
      ::mojo::PendingRemote<XRSessionMetricsRecorder> metrics_recorder,
      ::mojo::PendingRemote<WebXrInternalsRendererListener> xr_internals_listener);

RequestSessionSuccess(const RequestSessionSuccess&) = delete;
RequestSessionSuccess& operator=(const RequestSessionSuccess&) = delete;

  ~RequestSessionSuccess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestSessionSuccessPtr>
  RequestSessionSuccessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestSessionSuccess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestSessionSuccess_UnserializedMessageContext<
            UserType, RequestSessionSuccess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RequestSessionSuccess::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RequestSessionSuccess::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestSessionSuccess_UnserializedMessageContext<
            UserType, RequestSessionSuccess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestSessionSuccess::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRSessionPtr session;
  
  uint64_t trace_id;
  
  ::mojo::PendingRemote<XRSessionMetricsRecorder> metrics_recorder;
  
  ::mojo::PendingRemote<WebXrInternalsRendererListener> xr_internals_listener;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
XRNativeOriginInformationPtr XRNativeOriginInformation::Clone() const {
  switch (tag_) {
    case Tag::kInputSourceSpaceInfo:
      return NewInputSourceSpaceInfo(
          mojo::Clone(data_.input_source_space_info));
    case Tag::kPlaneId:
      return NewPlaneId(
          mojo::Clone(data_.plane_id));
    case Tag::kAnchorId:
      return NewAnchorId(
          mojo::Clone(data_.anchor_id));
    case Tag::kReferenceSpaceType:
      return NewReferenceSpaceType(
          mojo::Clone(data_.reference_space_type));
    case Tag::kHandJointSpaceInfo:
      return NewHandJointSpaceInfo(
          mojo::Clone(data_.hand_joint_space_info));
    case Tag::kImageIndex:
      return NewImageIndex(
          mojo::Clone(data_.image_index));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, XRNativeOriginInformation>::value>::type*>
bool XRNativeOriginInformation::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kInputSourceSpaceInfo:
      return mojo::Equals(data_.input_source_space_info, other.data_.input_source_space_info);
    case Tag::kPlaneId:
      return mojo::Equals(data_.plane_id, other.data_.plane_id);
    case Tag::kAnchorId:
      return mojo::Equals(data_.anchor_id, other.data_.anchor_id);
    case Tag::kReferenceSpaceType:
      return mojo::Equals(data_.reference_space_type, other.data_.reference_space_type);
    case Tag::kHandJointSpaceInfo:
      return mojo::Equals(data_.hand_joint_space_info, other.data_.hand_joint_space_info);
    case Tag::kImageIndex:
      return mojo::Equals(data_.image_index, other.data_.image_index);
  }

  return false;
}
template <typename UnionPtrType>
XRDepthDataPtr XRDepthData::Clone() const {
  switch (tag_) {
    case Tag::kDataStillValid:
      return NewDataStillValid(
          mojo::Clone(data_.data_still_valid));
    case Tag::kUpdatedDepthData:
      return NewUpdatedDepthData(
          mojo::Clone(data_.updated_depth_data));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, XRDepthData>::value>::type*>
bool XRDepthData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kDataStillValid:
      return mojo::Equals(data_.data_still_valid, other.data_.data_still_valid);
    case Tag::kUpdatedDepthData:
      return mojo::Equals(data_.updated_depth_data, other.data_.updated_depth_data);
  }

  return false;
}
template <typename UnionPtrType>
XRLayerSpecificDataPtr XRLayerSpecificData::Clone() const {
  switch (tag_) {
    case Tag::kProjection:
      return NewProjection(
          mojo::Clone(data_.projection));
    case Tag::kQuad:
      return NewQuad(
          mojo::Clone(data_.quad));
    case Tag::kCylinder:
      return NewCylinder(
          mojo::Clone(data_.cylinder));
    case Tag::kEquirect:
      return NewEquirect(
          mojo::Clone(data_.equirect));
    case Tag::kCube:
      return NewCube(
          mojo::Clone(data_.cube));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, XRLayerSpecificData>::value>::type*>
bool XRLayerSpecificData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kProjection:
      return mojo::Equals(data_.projection, other.data_.projection);
    case Tag::kQuad:
      return mojo::Equals(data_.quad, other.data_.quad);
    case Tag::kCylinder:
      return mojo::Equals(data_.cylinder, other.data_.cylinder);
    case Tag::kEquirect:
      return mojo::Equals(data_.equirect, other.data_.equirect);
    case Tag::kCube:
      return mojo::Equals(data_.cube, other.data_.cube);
  }

  return false;
}
template <typename UnionPtrType>
RequestSessionResultPtr RequestSessionResult::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailureReason:
      return NewFailureReason(
          mojo::Clone(data_.failure_reason));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RequestSessionResult>::value>::type*>
bool RequestSessionResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailureReason:
      return mojo::Equals(data_.failure_reason, other.data_.failure_reason);
  }

  return false;
}
template <typename StructPtrType>
XRDepthConfigPtr XRDepthConfig::Clone() const {
  return New(
      mojo::Clone(depth_usage),
      mojo::Clone(depth_data_format),
      mojo::Clone(depth_type)
  );
}

template <typename T, XRDepthConfig::EnableIfSame<T>*>
bool XRDepthConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->depth_usage, other_struct.depth_usage))
    return false;
  if (!mojo::Equals(this->depth_data_format, other_struct.depth_data_format))
    return false;
  if (!mojo::Equals(this->depth_type, other_struct.depth_type))
    return false;
  return true;
}

template <typename T, XRDepthConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.depth_usage < rhs.depth_usage)
    return true;
  if (rhs.depth_usage < lhs.depth_usage)
    return false;
  if (lhs.depth_data_format < rhs.depth_data_format)
    return true;
  if (rhs.depth_data_format < lhs.depth_data_format)
    return false;
  if (lhs.depth_type < rhs.depth_type)
    return true;
  if (rhs.depth_type < lhs.depth_type)
    return false;
  return false;
}
template <typename StructPtrType>
XRSessionDeviceConfigPtr XRSessionDeviceConfig::Clone() const {
  return New(
      mojo::Clone(default_framebuffer_scale),
      mojo::Clone(views),
      mojo::Clone(supports_viewport_scaling),
      mojo::Clone(enable_anti_aliasing),
      mojo::Clone(depth_configuration)
  );
}

template <typename T, XRSessionDeviceConfig::EnableIfSame<T>*>
bool XRSessionDeviceConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->default_framebuffer_scale, other_struct.default_framebuffer_scale))
    return false;
  if (!mojo::Equals(this->views, other_struct.views))
    return false;
  if (!mojo::Equals(this->supports_viewport_scaling, other_struct.supports_viewport_scaling))
    return false;
  if (!mojo::Equals(this->enable_anti_aliasing, other_struct.enable_anti_aliasing))
    return false;
  if (!mojo::Equals(this->depth_configuration, other_struct.depth_configuration))
    return false;
  return true;
}

template <typename T, XRSessionDeviceConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.default_framebuffer_scale < rhs.default_framebuffer_scale)
    return true;
  if (rhs.default_framebuffer_scale < lhs.default_framebuffer_scale)
    return false;
  if (lhs.views < rhs.views)
    return true;
  if (rhs.views < lhs.views)
    return false;
  if (lhs.supports_viewport_scaling < rhs.supports_viewport_scaling)
    return true;
  if (rhs.supports_viewport_scaling < lhs.supports_viewport_scaling)
    return false;
  if (lhs.enable_anti_aliasing < rhs.enable_anti_aliasing)
    return true;
  if (rhs.enable_anti_aliasing < lhs.enable_anti_aliasing)
    return false;
  if (lhs.depth_configuration < rhs.depth_configuration)
    return true;
  if (rhs.depth_configuration < lhs.depth_configuration)
    return false;
  return false;
}
template <typename StructPtrType>
XRSessionPtr XRSession::Clone() const {
  return New(
      mojo::Clone(data_provider),
      mojo::Clone(layer_manager),
      mojo::Clone(client_receiver),
      mojo::Clone(submit_frame_sink),
      mojo::Clone(enabled_features),
      mojo::Clone(device_config),
      mojo::Clone(enviroment_blend_mode),
      mojo::Clone(interaction_mode)
  );
}

template <typename T, XRSession::EnableIfSame<T>*>
bool XRSession::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data_provider, other_struct.data_provider))
    return false;
  if (!mojo::Equals(this->layer_manager, other_struct.layer_manager))
    return false;
  if (!mojo::Equals(this->client_receiver, other_struct.client_receiver))
    return false;
  if (!mojo::Equals(this->submit_frame_sink, other_struct.submit_frame_sink))
    return false;
  if (!mojo::Equals(this->enabled_features, other_struct.enabled_features))
    return false;
  if (!mojo::Equals(this->device_config, other_struct.device_config))
    return false;
  if (!mojo::Equals(this->enviroment_blend_mode, other_struct.enviroment_blend_mode))
    return false;
  if (!mojo::Equals(this->interaction_mode, other_struct.interaction_mode))
    return false;
  return true;
}

template <typename T, XRSession::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data_provider < rhs.data_provider)
    return true;
  if (rhs.data_provider < lhs.data_provider)
    return false;
  if (lhs.layer_manager < rhs.layer_manager)
    return true;
  if (rhs.layer_manager < lhs.layer_manager)
    return false;
  if (lhs.client_receiver < rhs.client_receiver)
    return true;
  if (rhs.client_receiver < lhs.client_receiver)
    return false;
  if (lhs.submit_frame_sink < rhs.submit_frame_sink)
    return true;
  if (rhs.submit_frame_sink < lhs.submit_frame_sink)
    return false;
  if (lhs.enabled_features < rhs.enabled_features)
    return true;
  if (rhs.enabled_features < lhs.enabled_features)
    return false;
  if (lhs.device_config < rhs.device_config)
    return true;
  if (rhs.device_config < lhs.device_config)
    return false;
  if (lhs.enviroment_blend_mode < rhs.enviroment_blend_mode)
    return true;
  if (rhs.enviroment_blend_mode < lhs.enviroment_blend_mode)
    return false;
  if (lhs.interaction_mode < rhs.interaction_mode)
    return true;
  if (rhs.interaction_mode < lhs.interaction_mode)
    return false;
  return false;
}
template <typename StructPtrType>
XRPresentationConnectionPtr XRPresentationConnection::Clone() const {
  return New(
      mojo::Clone(provider),
      mojo::Clone(client_receiver),
      mojo::Clone(transport_options)
  );
}

template <typename T, XRPresentationConnection::EnableIfSame<T>*>
bool XRPresentationConnection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->provider, other_struct.provider))
    return false;
  if (!mojo::Equals(this->client_receiver, other_struct.client_receiver))
    return false;
  if (!mojo::Equals(this->transport_options, other_struct.transport_options))
    return false;
  return true;
}

template <typename T, XRPresentationConnection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.provider < rhs.provider)
    return true;
  if (rhs.provider < lhs.provider)
    return false;
  if (lhs.client_receiver < rhs.client_receiver)
    return true;
  if (rhs.client_receiver < lhs.client_receiver)
    return false;
  if (lhs.transport_options < rhs.transport_options)
    return true;
  if (rhs.transport_options < lhs.transport_options)
    return false;
  return false;
}
template <typename StructPtrType>
XRInputSourceDescriptionPtr XRInputSourceDescription::Clone() const {
  return New(
      mojo::Clone(target_ray_mode),
      mojo::Clone(handedness),
      mojo::Clone(input_from_pointer),
      mojo::Clone(profiles)
  );
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>*>
bool XRInputSourceDescription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->target_ray_mode, other_struct.target_ray_mode))
    return false;
  if (!mojo::Equals(this->handedness, other_struct.handedness))
    return false;
  if (!mojo::Equals(this->input_from_pointer, other_struct.input_from_pointer))
    return false;
  if (!mojo::Equals(this->profiles, other_struct.profiles))
    return false;
  return true;
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.target_ray_mode < rhs.target_ray_mode)
    return true;
  if (rhs.target_ray_mode < lhs.target_ray_mode)
    return false;
  if (lhs.handedness < rhs.handedness)
    return true;
  if (rhs.handedness < lhs.handedness)
    return false;
  if (lhs.input_from_pointer < rhs.input_from_pointer)
    return true;
  if (rhs.input_from_pointer < lhs.input_from_pointer)
    return false;
  if (lhs.profiles < rhs.profiles)
    return true;
  if (rhs.profiles < lhs.profiles)
    return false;
  return false;
}
template <typename StructPtrType>
XRInputSourceStatePtr XRInputSourceState::Clone() const {
  return New(
      mojo::Clone(source_id),
      mojo::Clone(description),
      mojo::Clone(mojo_from_input),
      mojo::Clone(emulated_position),
      mojo::Clone(is_auxiliary),
      mojo::Clone(primary_input_pressed),
      mojo::Clone(primary_input_clicked),
      mojo::Clone(primary_squeeze_pressed),
      mojo::Clone(primary_squeeze_clicked),
      mojo::Clone(gamepad),
      mojo::Clone(overlay_pointer_position),
      mojo::Clone(hand_tracking_data)
  );
}

template <typename T, XRInputSourceState::EnableIfSame<T>*>
bool XRInputSourceState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source_id, other_struct.source_id))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->mojo_from_input, other_struct.mojo_from_input))
    return false;
  if (!mojo::Equals(this->emulated_position, other_struct.emulated_position))
    return false;
  if (!mojo::Equals(this->is_auxiliary, other_struct.is_auxiliary))
    return false;
  if (!mojo::Equals(this->primary_input_pressed, other_struct.primary_input_pressed))
    return false;
  if (!mojo::Equals(this->primary_input_clicked, other_struct.primary_input_clicked))
    return false;
  if (!mojo::Equals(this->primary_squeeze_pressed, other_struct.primary_squeeze_pressed))
    return false;
  if (!mojo::Equals(this->primary_squeeze_clicked, other_struct.primary_squeeze_clicked))
    return false;
  if (!mojo::Equals(this->gamepad, other_struct.gamepad))
    return false;
  if (!mojo::Equals(this->overlay_pointer_position, other_struct.overlay_pointer_position))
    return false;
  if (!mojo::Equals(this->hand_tracking_data, other_struct.hand_tracking_data))
    return false;
  return true;
}

template <typename T, XRInputSourceState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source_id < rhs.source_id)
    return true;
  if (rhs.source_id < lhs.source_id)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.mojo_from_input < rhs.mojo_from_input)
    return true;
  if (rhs.mojo_from_input < lhs.mojo_from_input)
    return false;
  if (lhs.emulated_position < rhs.emulated_position)
    return true;
  if (rhs.emulated_position < lhs.emulated_position)
    return false;
  if (lhs.is_auxiliary < rhs.is_auxiliary)
    return true;
  if (rhs.is_auxiliary < lhs.is_auxiliary)
    return false;
  if (lhs.primary_input_pressed < rhs.primary_input_pressed)
    return true;
  if (rhs.primary_input_pressed < lhs.primary_input_pressed)
    return false;
  if (lhs.primary_input_clicked < rhs.primary_input_clicked)
    return true;
  if (rhs.primary_input_clicked < lhs.primary_input_clicked)
    return false;
  if (lhs.primary_squeeze_pressed < rhs.primary_squeeze_pressed)
    return true;
  if (rhs.primary_squeeze_pressed < lhs.primary_squeeze_pressed)
    return false;
  if (lhs.primary_squeeze_clicked < rhs.primary_squeeze_clicked)
    return true;
  if (rhs.primary_squeeze_clicked < lhs.primary_squeeze_clicked)
    return false;
  if (lhs.gamepad < rhs.gamepad)
    return true;
  if (rhs.gamepad < lhs.gamepad)
    return false;
  if (lhs.overlay_pointer_position < rhs.overlay_pointer_position)
    return true;
  if (rhs.overlay_pointer_position < lhs.overlay_pointer_position)
    return false;
  if (lhs.hand_tracking_data < rhs.hand_tracking_data)
    return true;
  if (rhs.hand_tracking_data < lhs.hand_tracking_data)
    return false;
  return false;
}
template <typename StructPtrType>
VRFieldOfViewPtr VRFieldOfView::Clone() const {
  return New(
      mojo::Clone(up_degrees),
      mojo::Clone(down_degrees),
      mojo::Clone(left_degrees),
      mojo::Clone(right_degrees)
  );
}

template <typename T, VRFieldOfView::EnableIfSame<T>*>
bool VRFieldOfView::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->up_degrees, other_struct.up_degrees))
    return false;
  if (!mojo::Equals(this->down_degrees, other_struct.down_degrees))
    return false;
  if (!mojo::Equals(this->left_degrees, other_struct.left_degrees))
    return false;
  if (!mojo::Equals(this->right_degrees, other_struct.right_degrees))
    return false;
  return true;
}

template <typename T, VRFieldOfView::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.up_degrees < rhs.up_degrees)
    return true;
  if (rhs.up_degrees < lhs.up_degrees)
    return false;
  if (lhs.down_degrees < rhs.down_degrees)
    return true;
  if (rhs.down_degrees < lhs.down_degrees)
    return false;
  if (lhs.left_degrees < rhs.left_degrees)
    return true;
  if (rhs.left_degrees < lhs.left_degrees)
    return false;
  if (lhs.right_degrees < rhs.right_degrees)
    return true;
  if (rhs.right_degrees < lhs.right_degrees)
    return false;
  return false;
}
template <typename StructPtrType>
VRPosePtr VRPose::Clone() const {
  return New(
      mojo::Clone(orientation),
      mojo::Clone(position),
      mojo::Clone(emulated_position)
  );
}

template <typename T, VRPose::EnableIfSame<T>*>
bool VRPose::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  if (!mojo::Equals(this->emulated_position, other_struct.emulated_position))
    return false;
  return true;
}

template <typename T, VRPose::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.orientation < rhs.orientation)
    return true;
  if (rhs.orientation < lhs.orientation)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  if (lhs.emulated_position < rhs.emulated_position)
    return true;
  if (rhs.emulated_position < lhs.emulated_position)
    return false;
  return false;
}
template <typename StructPtrType>
PosePtr Pose::Clone() const {
  return New(
      mojo::Clone(orientation),
      mojo::Clone(position)
  );
}

template <typename T, Pose::EnableIfSame<T>*>
bool Pose::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  return true;
}

template <typename T, Pose::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.orientation < rhs.orientation)
    return true;
  if (rhs.orientation < lhs.orientation)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  return false;
}
template <typename StructPtrType>
AnchorIdPtr AnchorId::Clone() const {
  return New(
      mojo::Clone(id_value)
  );
}

template <typename T, AnchorId::EnableIfSame<T>*>
bool AnchorId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id_value, other_struct.id_value))
    return false;
  return true;
}

template <typename T, AnchorId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id_value < rhs.id_value)
    return true;
  if (rhs.id_value < lhs.id_value)
    return false;
  return false;
}
template <typename StructPtrType>
HitTestSubscriptionIdPtr HitTestSubscriptionId::Clone() const {
  return New(
      mojo::Clone(id_value)
  );
}

template <typename T, HitTestSubscriptionId::EnableIfSame<T>*>
bool HitTestSubscriptionId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id_value, other_struct.id_value))
    return false;
  return true;
}

template <typename T, HitTestSubscriptionId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id_value < rhs.id_value)
    return true;
  if (rhs.id_value < lhs.id_value)
    return false;
  return false;
}
template <typename StructPtrType>
PlaneIdPtr PlaneId::Clone() const {
  return New(
      mojo::Clone(id_value)
  );
}

template <typename T, PlaneId::EnableIfSame<T>*>
bool PlaneId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id_value, other_struct.id_value))
    return false;
  return true;
}

template <typename T, PlaneId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id_value < rhs.id_value)
    return true;
  if (rhs.id_value < lhs.id_value)
    return false;
  return false;
}
template <typename StructPtrType>
XrVisibilityMaskIdPtr XrVisibilityMaskId::Clone() const {
  return New(
      mojo::Clone(id_value)
  );
}

template <typename T, XrVisibilityMaskId::EnableIfSame<T>*>
bool XrVisibilityMaskId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id_value, other_struct.id_value))
    return false;
  return true;
}

template <typename T, XrVisibilityMaskId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id_value < rhs.id_value)
    return true;
  if (rhs.id_value < lhs.id_value)
    return false;
  return false;
}
template <typename StructPtrType>
XRRayPtr XRRay::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(direction)
  );
}

template <typename T, XRRay::EnableIfSame<T>*>
bool XRRay::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->direction, other_struct.direction))
    return false;
  return true;
}

template <typename T, XRRay::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.direction < rhs.direction)
    return true;
  if (rhs.direction < lhs.direction)
    return false;
  return false;
}
template <typename StructPtrType>
XRHitResultPtr XRHitResult::Clone() const {
  return New(
      mojo::Clone(mojo_from_result),
      mojo::Clone(plane_id)
  );
}

template <typename T, XRHitResult::EnableIfSame<T>*>
bool XRHitResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mojo_from_result, other_struct.mojo_from_result))
    return false;
  if (!mojo::Equals(this->plane_id, other_struct.plane_id))
    return false;
  return true;
}

template <typename T, XRHitResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mojo_from_result < rhs.mojo_from_result)
    return true;
  if (rhs.mojo_from_result < lhs.mojo_from_result)
    return false;
  if (lhs.plane_id < rhs.plane_id)
    return true;
  if (rhs.plane_id < lhs.plane_id)
    return false;
  return false;
}
template <typename StructPtrType>
XRViewGeometryPtr XRViewGeometry::Clone() const {
  return New(
      mojo::Clone(field_of_view),
      mojo::Clone(mojo_from_view)
  );
}

template <typename T, XRViewGeometry::EnableIfSame<T>*>
bool XRViewGeometry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->field_of_view, other_struct.field_of_view))
    return false;
  if (!mojo::Equals(this->mojo_from_view, other_struct.mojo_from_view))
    return false;
  return true;
}

template <typename T, XRViewGeometry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.field_of_view < rhs.field_of_view)
    return true;
  if (rhs.field_of_view < lhs.field_of_view)
    return false;
  if (lhs.mojo_from_view < rhs.mojo_from_view)
    return true;
  if (rhs.mojo_from_view < lhs.mojo_from_view)
    return false;
  return false;
}
template <typename StructPtrType>
XRVisibilityMaskPtr XRVisibilityMask::Clone() const {
  return New(
      mojo::Clone(vertices),
      mojo::Clone(unvalidated_indices)
  );
}

template <typename T, XRVisibilityMask::EnableIfSame<T>*>
bool XRVisibilityMask::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->vertices, other_struct.vertices))
    return false;
  if (!mojo::Equals(this->unvalidated_indices, other_struct.unvalidated_indices))
    return false;
  return true;
}

template <typename T, XRVisibilityMask::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.vertices < rhs.vertices)
    return true;
  if (rhs.vertices < lhs.vertices)
    return false;
  if (lhs.unvalidated_indices < rhs.unvalidated_indices)
    return true;
  if (rhs.unvalidated_indices < lhs.unvalidated_indices)
    return false;
  return false;
}
template <typename StructPtrType>
XRViewPtr XRView::Clone() const {
  return New(
      mojo::Clone(eye),
      mojo::Clone(geometry),
      mojo::Clone(viewport),
      mojo::Clone(depth_data),
      mojo::Clone(is_first_person_observer),
      mojo::Clone(visibility_mask),
      mojo::Clone(visibility_mask_id)
  );
}

template <typename T, XRView::EnableIfSame<T>*>
bool XRView::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->eye, other_struct.eye))
    return false;
  if (!mojo::Equals(this->geometry, other_struct.geometry))
    return false;
  if (!mojo::Equals(this->viewport, other_struct.viewport))
    return false;
  if (!mojo::Equals(this->depth_data, other_struct.depth_data))
    return false;
  if (!mojo::Equals(this->is_first_person_observer, other_struct.is_first_person_observer))
    return false;
  if (!mojo::Equals(this->visibility_mask, other_struct.visibility_mask))
    return false;
  if (!mojo::Equals(this->visibility_mask_id, other_struct.visibility_mask_id))
    return false;
  return true;
}

template <typename T, XRView::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.eye < rhs.eye)
    return true;
  if (rhs.eye < lhs.eye)
    return false;
  if (lhs.geometry < rhs.geometry)
    return true;
  if (rhs.geometry < lhs.geometry)
    return false;
  if (lhs.viewport < rhs.viewport)
    return true;
  if (rhs.viewport < lhs.viewport)
    return false;
  if (lhs.depth_data < rhs.depth_data)
    return true;
  if (rhs.depth_data < lhs.depth_data)
    return false;
  if (lhs.is_first_person_observer < rhs.is_first_person_observer)
    return true;
  if (rhs.is_first_person_observer < lhs.is_first_person_observer)
    return false;
  if (lhs.visibility_mask < rhs.visibility_mask)
    return true;
  if (rhs.visibility_mask < lhs.visibility_mask)
    return false;
  if (lhs.visibility_mask_id < rhs.visibility_mask_id)
    return true;
  if (rhs.visibility_mask_id < lhs.visibility_mask_id)
    return false;
  return false;
}
template <typename StructPtrType>
VRStageParametersPtr VRStageParameters::Clone() const {
  return New(
      mojo::Clone(mojo_from_stage),
      mojo::Clone(bounds)
  );
}

template <typename T, VRStageParameters::EnableIfSame<T>*>
bool VRStageParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mojo_from_stage, other_struct.mojo_from_stage))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  return true;
}

template <typename T, VRStageParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mojo_from_stage < rhs.mojo_from_stage)
    return true;
  if (rhs.mojo_from_stage < lhs.mojo_from_stage)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  return false;
}
template <typename StructPtrType>
XRPresentationTransportOptionsPtr XRPresentationTransportOptions::Clone() const {
  return New(
      mojo::Clone(transport_method),
      mojo::Clone(wait_for_transfer_notification),
      mojo::Clone(wait_for_render_notification),
      mojo::Clone(wait_for_gpu_fence)
  );
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>*>
bool XRPresentationTransportOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->transport_method, other_struct.transport_method))
    return false;
  if (!mojo::Equals(this->wait_for_transfer_notification, other_struct.wait_for_transfer_notification))
    return false;
  if (!mojo::Equals(this->wait_for_render_notification, other_struct.wait_for_render_notification))
    return false;
  if (!mojo::Equals(this->wait_for_gpu_fence, other_struct.wait_for_gpu_fence))
    return false;
  return true;
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.transport_method < rhs.transport_method)
    return true;
  if (rhs.transport_method < lhs.transport_method)
    return false;
  if (lhs.wait_for_transfer_notification < rhs.wait_for_transfer_notification)
    return true;
  if (rhs.wait_for_transfer_notification < lhs.wait_for_transfer_notification)
    return false;
  if (lhs.wait_for_render_notification < rhs.wait_for_render_notification)
    return true;
  if (rhs.wait_for_render_notification < lhs.wait_for_render_notification)
    return false;
  if (lhs.wait_for_gpu_fence < rhs.wait_for_gpu_fence)
    return true;
  if (rhs.wait_for_gpu_fence < lhs.wait_for_gpu_fence)
    return false;
  return false;
}
template <typename StructPtrType>
XRInputSourceSpaceInfoPtr XRInputSourceSpaceInfo::Clone() const {
  return New(
      mojo::Clone(input_source_id),
      mojo::Clone(input_source_space_type)
  );
}

template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>*>
bool XRInputSourceSpaceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_source_id, other_struct.input_source_id))
    return false;
  if (!mojo::Equals(this->input_source_space_type, other_struct.input_source_space_type))
    return false;
  return true;
}

template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_source_id < rhs.input_source_id)
    return true;
  if (rhs.input_source_id < lhs.input_source_id)
    return false;
  if (lhs.input_source_space_type < rhs.input_source_space_type)
    return true;
  if (rhs.input_source_space_type < lhs.input_source_space_type)
    return false;
  return false;
}
template <typename StructPtrType>
XRHandJointSpaceInfoPtr XRHandJointSpaceInfo::Clone() const {
  return New(
      mojo::Clone(handedness),
      mojo::Clone(joint)
  );
}

template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>*>
bool XRHandJointSpaceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->handedness, other_struct.handedness))
    return false;
  if (!mojo::Equals(this->joint, other_struct.joint))
    return false;
  return true;
}

template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.handedness < rhs.handedness)
    return true;
  if (rhs.handedness < lhs.handedness)
    return false;
  if (lhs.joint < rhs.joint)
    return true;
  if (rhs.joint < lhs.joint)
    return false;
  return false;
}
template <typename StructPtrType>
XRPlanePointDataPtr XRPlanePointData::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(z)
  );
}

template <typename T, XRPlanePointData::EnableIfSame<T>*>
bool XRPlanePointData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->z, other_struct.z))
    return false;
  return true;
}

template <typename T, XRPlanePointData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.z < rhs.z)
    return true;
  if (rhs.z < lhs.z)
    return false;
  return false;
}
template <typename StructPtrType>
XRPlaneDataPtr XRPlaneData::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(orientation),
      mojo::Clone(mojo_from_plane),
      mojo::Clone(polygon)
  );
}

template <typename T, XRPlaneData::EnableIfSame<T>*>
bool XRPlaneData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->mojo_from_plane, other_struct.mojo_from_plane))
    return false;
  if (!mojo::Equals(this->polygon, other_struct.polygon))
    return false;
  return true;
}

template <typename T, XRPlaneData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.orientation < rhs.orientation)
    return true;
  if (rhs.orientation < lhs.orientation)
    return false;
  if (lhs.mojo_from_plane < rhs.mojo_from_plane)
    return true;
  if (rhs.mojo_from_plane < lhs.mojo_from_plane)
    return false;
  if (lhs.polygon < rhs.polygon)
    return true;
  if (rhs.polygon < lhs.polygon)
    return false;
  return false;
}
template <typename StructPtrType>
XRPlaneDetectionDataPtr XRPlaneDetectionData::Clone() const {
  return New(
      mojo::Clone(all_planes_ids),
      mojo::Clone(updated_planes_data)
  );
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>*>
bool XRPlaneDetectionData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->all_planes_ids, other_struct.all_planes_ids))
    return false;
  if (!mojo::Equals(this->updated_planes_data, other_struct.updated_planes_data))
    return false;
  return true;
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.all_planes_ids < rhs.all_planes_ids)
    return true;
  if (rhs.all_planes_ids < lhs.all_planes_ids)
    return false;
  if (lhs.updated_planes_data < rhs.updated_planes_data)
    return true;
  if (rhs.updated_planes_data < lhs.updated_planes_data)
    return false;
  return false;
}
template <typename StructPtrType>
XRAnchorDataPtr XRAnchorData::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(mojo_from_anchor)
  );
}

template <typename T, XRAnchorData::EnableIfSame<T>*>
bool XRAnchorData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->mojo_from_anchor, other_struct.mojo_from_anchor))
    return false;
  return true;
}

template <typename T, XRAnchorData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.mojo_from_anchor < rhs.mojo_from_anchor)
    return true;
  if (rhs.mojo_from_anchor < lhs.mojo_from_anchor)
    return false;
  return false;
}
template <typename StructPtrType>
XRAnchorsDataPtr XRAnchorsData::Clone() const {
  return New(
      mojo::Clone(all_anchors_ids),
      mojo::Clone(updated_anchors_data)
  );
}

template <typename T, XRAnchorsData::EnableIfSame<T>*>
bool XRAnchorsData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->all_anchors_ids, other_struct.all_anchors_ids))
    return false;
  if (!mojo::Equals(this->updated_anchors_data, other_struct.updated_anchors_data))
    return false;
  return true;
}

template <typename T, XRAnchorsData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.all_anchors_ids < rhs.all_anchors_ids)
    return true;
  if (rhs.all_anchors_ids < lhs.all_anchors_ids)
    return false;
  if (lhs.updated_anchors_data < rhs.updated_anchors_data)
    return true;
  if (rhs.updated_anchors_data < lhs.updated_anchors_data)
    return false;
  return false;
}
template <typename StructPtrType>
XRHitTestSubscriptionResultDataPtr XRHitTestSubscriptionResultData::Clone() const {
  return New(
      mojo::Clone(subscription_id),
      mojo::Clone(hit_test_results)
  );
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>*>
bool XRHitTestSubscriptionResultData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->subscription_id, other_struct.subscription_id))
    return false;
  if (!mojo::Equals(this->hit_test_results, other_struct.hit_test_results))
    return false;
  return true;
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.subscription_id < rhs.subscription_id)
    return true;
  if (rhs.subscription_id < lhs.subscription_id)
    return false;
  if (lhs.hit_test_results < rhs.hit_test_results)
    return true;
  if (rhs.hit_test_results < lhs.hit_test_results)
    return false;
  return false;
}
template <typename StructPtrType>
XRHitTestTransientInputSubscriptionResultDataPtr XRHitTestTransientInputSubscriptionResultData::Clone() const {
  return New(
      mojo::Clone(subscription_id),
      mojo::Clone(input_source_id_to_hit_test_results)
  );
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>*>
bool XRHitTestTransientInputSubscriptionResultData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->subscription_id, other_struct.subscription_id))
    return false;
  if (!mojo::Equals(this->input_source_id_to_hit_test_results, other_struct.input_source_id_to_hit_test_results))
    return false;
  return true;
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.subscription_id < rhs.subscription_id)
    return true;
  if (rhs.subscription_id < lhs.subscription_id)
    return false;
  if (lhs.input_source_id_to_hit_test_results < rhs.input_source_id_to_hit_test_results)
    return true;
  if (rhs.input_source_id_to_hit_test_results < lhs.input_source_id_to_hit_test_results)
    return false;
  return false;
}
template <typename StructPtrType>
XRHitTestSubscriptionResultsDataPtr XRHitTestSubscriptionResultsData::Clone() const {
  return New(
      mojo::Clone(results),
      mojo::Clone(transient_input_results)
  );
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>*>
bool XRHitTestSubscriptionResultsData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->results, other_struct.results))
    return false;
  if (!mojo::Equals(this->transient_input_results, other_struct.transient_input_results))
    return false;
  return true;
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.results < rhs.results)
    return true;
  if (rhs.results < lhs.results)
    return false;
  if (lhs.transient_input_results < rhs.transient_input_results)
    return true;
  if (rhs.transient_input_results < lhs.transient_input_results)
    return false;
  return false;
}
template <typename StructPtrType>
RgbTupleF32Ptr RgbTupleF32::Clone() const {
  return New(
      mojo::Clone(red),
      mojo::Clone(green),
      mojo::Clone(blue)
  );
}

template <typename T, RgbTupleF32::EnableIfSame<T>*>
bool RgbTupleF32::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->red, other_struct.red))
    return false;
  if (!mojo::Equals(this->green, other_struct.green))
    return false;
  if (!mojo::Equals(this->blue, other_struct.blue))
    return false;
  return true;
}

template <typename T, RgbTupleF32::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.red < rhs.red)
    return true;
  if (rhs.red < lhs.red)
    return false;
  if (lhs.green < rhs.green)
    return true;
  if (rhs.green < lhs.green)
    return false;
  if (lhs.blue < rhs.blue)
    return true;
  if (rhs.blue < lhs.blue)
    return false;
  return false;
}
template <typename StructPtrType>
XRSphericalHarmonicsPtr XRSphericalHarmonics::Clone() const {
  return New(
      mojo::Clone(coefficients)
  );
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>*>
bool XRSphericalHarmonics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->coefficients, other_struct.coefficients))
    return false;
  return true;
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.coefficients < rhs.coefficients)
    return true;
  if (rhs.coefficients < lhs.coefficients)
    return false;
  return false;
}
template <typename StructPtrType>
XRCubeMapPtr XRCubeMap::Clone() const {
  return New(
      mojo::Clone(width_and_height),
      mojo::Clone(positive_x),
      mojo::Clone(negative_x),
      mojo::Clone(positive_y),
      mojo::Clone(negative_y),
      mojo::Clone(positive_z),
      mojo::Clone(negative_z)
  );
}

template <typename T, XRCubeMap::EnableIfSame<T>*>
bool XRCubeMap::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width_and_height, other_struct.width_and_height))
    return false;
  if (!mojo::Equals(this->positive_x, other_struct.positive_x))
    return false;
  if (!mojo::Equals(this->negative_x, other_struct.negative_x))
    return false;
  if (!mojo::Equals(this->positive_y, other_struct.positive_y))
    return false;
  if (!mojo::Equals(this->negative_y, other_struct.negative_y))
    return false;
  if (!mojo::Equals(this->positive_z, other_struct.positive_z))
    return false;
  if (!mojo::Equals(this->negative_z, other_struct.negative_z))
    return false;
  return true;
}

template <typename T, XRCubeMap::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.width_and_height < rhs.width_and_height)
    return true;
  if (rhs.width_and_height < lhs.width_and_height)
    return false;
  if (lhs.positive_x < rhs.positive_x)
    return true;
  if (rhs.positive_x < lhs.positive_x)
    return false;
  if (lhs.negative_x < rhs.negative_x)
    return true;
  if (rhs.negative_x < lhs.negative_x)
    return false;
  if (lhs.positive_y < rhs.positive_y)
    return true;
  if (rhs.positive_y < lhs.positive_y)
    return false;
  if (lhs.negative_y < rhs.negative_y)
    return true;
  if (rhs.negative_y < lhs.negative_y)
    return false;
  if (lhs.positive_z < rhs.positive_z)
    return true;
  if (rhs.positive_z < lhs.positive_z)
    return false;
  if (lhs.negative_z < rhs.negative_z)
    return true;
  if (rhs.negative_z < lhs.negative_z)
    return false;
  return false;
}
template <typename StructPtrType>
XRLightProbePtr XRLightProbe::Clone() const {
  return New(
      mojo::Clone(spherical_harmonics),
      mojo::Clone(main_light_direction),
      mojo::Clone(main_light_intensity)
  );
}

template <typename T, XRLightProbe::EnableIfSame<T>*>
bool XRLightProbe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->spherical_harmonics, other_struct.spherical_harmonics))
    return false;
  if (!mojo::Equals(this->main_light_direction, other_struct.main_light_direction))
    return false;
  if (!mojo::Equals(this->main_light_intensity, other_struct.main_light_intensity))
    return false;
  return true;
}

template <typename T, XRLightProbe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.spherical_harmonics < rhs.spherical_harmonics)
    return true;
  if (rhs.spherical_harmonics < lhs.spherical_harmonics)
    return false;
  if (lhs.main_light_direction < rhs.main_light_direction)
    return true;
  if (rhs.main_light_direction < lhs.main_light_direction)
    return false;
  if (lhs.main_light_intensity < rhs.main_light_intensity)
    return true;
  if (rhs.main_light_intensity < lhs.main_light_intensity)
    return false;
  return false;
}
template <typename StructPtrType>
XRReflectionProbePtr XRReflectionProbe::Clone() const {
  return New(
      mojo::Clone(cube_map)
  );
}

template <typename T, XRReflectionProbe::EnableIfSame<T>*>
bool XRReflectionProbe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cube_map, other_struct.cube_map))
    return false;
  return true;
}

template <typename T, XRReflectionProbe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cube_map < rhs.cube_map)
    return true;
  if (rhs.cube_map < lhs.cube_map)
    return false;
  return false;
}
template <typename StructPtrType>
XRLightEstimationDataPtr XRLightEstimationData::Clone() const {
  return New(
      mojo::Clone(light_probe),
      mojo::Clone(reflection_probe)
  );
}

template <typename T, XRLightEstimationData::EnableIfSame<T>*>
bool XRLightEstimationData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->light_probe, other_struct.light_probe))
    return false;
  if (!mojo::Equals(this->reflection_probe, other_struct.reflection_probe))
    return false;
  return true;
}

template <typename T, XRLightEstimationData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.light_probe < rhs.light_probe)
    return true;
  if (rhs.light_probe < lhs.light_probe)
    return false;
  if (lhs.reflection_probe < rhs.reflection_probe)
    return true;
  if (rhs.reflection_probe < lhs.reflection_probe)
    return false;
  return false;
}
template <typename StructPtrType>
XRDepthDataStillValidPtr XRDepthDataStillValid::Clone() const {
  return New(
  );
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>*>
bool XRDepthDataStillValid::Equals(const T& other_struct) const {
  return true;
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
XRDepthDataUpdatedPtr XRDepthDataUpdated::Clone() const {
  return New(
      mojo::Clone(pixel_data),
      mojo::Clone(norm_texture_from_norm_view),
      mojo::Clone(size),
      mojo::Clone(raw_value_to_meters),
      mojo::Clone(view_geometry)
  );
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>*>
bool XRDepthDataUpdated::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pixel_data, other_struct.pixel_data))
    return false;
  if (!mojo::Equals(this->norm_texture_from_norm_view, other_struct.norm_texture_from_norm_view))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->raw_value_to_meters, other_struct.raw_value_to_meters))
    return false;
  if (!mojo::Equals(this->view_geometry, other_struct.view_geometry))
    return false;
  return true;
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pixel_data < rhs.pixel_data)
    return true;
  if (rhs.pixel_data < lhs.pixel_data)
    return false;
  if (lhs.norm_texture_from_norm_view < rhs.norm_texture_from_norm_view)
    return true;
  if (rhs.norm_texture_from_norm_view < lhs.norm_texture_from_norm_view)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.raw_value_to_meters < rhs.raw_value_to_meters)
    return true;
  if (rhs.raw_value_to_meters < lhs.raw_value_to_meters)
    return false;
  if (lhs.view_geometry < rhs.view_geometry)
    return true;
  if (rhs.view_geometry < lhs.view_geometry)
    return false;
  return false;
}
template <typename StructPtrType>
XRTrackedImageDataPtr XRTrackedImageData::Clone() const {
  return New(
      mojo::Clone(index),
      mojo::Clone(mojo_from_image),
      mojo::Clone(actively_tracked),
      mojo::Clone(width_in_meters)
  );
}

template <typename T, XRTrackedImageData::EnableIfSame<T>*>
bool XRTrackedImageData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->index, other_struct.index))
    return false;
  if (!mojo::Equals(this->mojo_from_image, other_struct.mojo_from_image))
    return false;
  if (!mojo::Equals(this->actively_tracked, other_struct.actively_tracked))
    return false;
  if (!mojo::Equals(this->width_in_meters, other_struct.width_in_meters))
    return false;
  return true;
}

template <typename T, XRTrackedImageData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.index < rhs.index)
    return true;
  if (rhs.index < lhs.index)
    return false;
  if (lhs.mojo_from_image < rhs.mojo_from_image)
    return true;
  if (rhs.mojo_from_image < lhs.mojo_from_image)
    return false;
  if (lhs.actively_tracked < rhs.actively_tracked)
    return true;
  if (rhs.actively_tracked < lhs.actively_tracked)
    return false;
  if (lhs.width_in_meters < rhs.width_in_meters)
    return true;
  if (rhs.width_in_meters < lhs.width_in_meters)
    return false;
  return false;
}
template <typename StructPtrType>
XRTrackedImagesDataPtr XRTrackedImagesData::Clone() const {
  return New(
      mojo::Clone(images_data),
      mojo::Clone(image_trackable_scores)
  );
}

template <typename T, XRTrackedImagesData::EnableIfSame<T>*>
bool XRTrackedImagesData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->images_data, other_struct.images_data))
    return false;
  if (!mojo::Equals(this->image_trackable_scores, other_struct.image_trackable_scores))
    return false;
  return true;
}

template <typename T, XRTrackedImagesData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.images_data < rhs.images_data)
    return true;
  if (rhs.images_data < lhs.images_data)
    return false;
  if (lhs.image_trackable_scores < rhs.image_trackable_scores)
    return true;
  if (rhs.image_trackable_scores < lhs.image_trackable_scores)
    return false;
  return false;
}
template <typename StructPtrType>
LayerIdPtr LayerId::Clone() const {
  return New(
      mojo::Clone(id_value)
  );
}

template <typename T, LayerId::EnableIfSame<T>*>
bool LayerId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id_value, other_struct.id_value))
    return false;
  return true;
}

template <typename T, LayerId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id_value < rhs.id_value)
    return true;
  if (rhs.id_value < lhs.id_value)
    return false;
  return false;
}
template <typename StructPtrType>
XRProjectionLayerDataPtr XRProjectionLayerData::Clone() const {
  return New(
  );
}

template <typename T, XRProjectionLayerData::EnableIfSame<T>*>
bool XRProjectionLayerData::Equals(const T& other_struct) const {
  return true;
}

template <typename T, XRProjectionLayerData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
XRQuadLayerDataPtr XRQuadLayerData::Clone() const {
  return New(
      mojo::Clone(native_origin_from_layer),
      mojo::Clone(width),
      mojo::Clone(height)
  );
}

template <typename T, XRQuadLayerData::EnableIfSame<T>*>
bool XRQuadLayerData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->native_origin_from_layer, other_struct.native_origin_from_layer))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  return true;
}

template <typename T, XRQuadLayerData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.native_origin_from_layer < rhs.native_origin_from_layer)
    return true;
  if (rhs.native_origin_from_layer < lhs.native_origin_from_layer)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  return false;
}
template <typename StructPtrType>
XRCylinderLayerDataPtr XRCylinderLayerData::Clone() const {
  return New(
      mojo::Clone(native_origin_from_layer),
      mojo::Clone(radius),
      mojo::Clone(central_angle),
      mojo::Clone(aspect_ratio)
  );
}

template <typename T, XRCylinderLayerData::EnableIfSame<T>*>
bool XRCylinderLayerData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->native_origin_from_layer, other_struct.native_origin_from_layer))
    return false;
  if (!mojo::Equals(this->radius, other_struct.radius))
    return false;
  if (!mojo::Equals(this->central_angle, other_struct.central_angle))
    return false;
  if (!mojo::Equals(this->aspect_ratio, other_struct.aspect_ratio))
    return false;
  return true;
}

template <typename T, XRCylinderLayerData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.native_origin_from_layer < rhs.native_origin_from_layer)
    return true;
  if (rhs.native_origin_from_layer < lhs.native_origin_from_layer)
    return false;
  if (lhs.radius < rhs.radius)
    return true;
  if (rhs.radius < lhs.radius)
    return false;
  if (lhs.central_angle < rhs.central_angle)
    return true;
  if (rhs.central_angle < lhs.central_angle)
    return false;
  if (lhs.aspect_ratio < rhs.aspect_ratio)
    return true;
  if (rhs.aspect_ratio < lhs.aspect_ratio)
    return false;
  return false;
}
template <typename StructPtrType>
XREquirectLayerDataPtr XREquirectLayerData::Clone() const {
  return New(
      mojo::Clone(native_origin_from_layer),
      mojo::Clone(radius),
      mojo::Clone(central_horizontal_angle),
      mojo::Clone(upper_vertical_angle),
      mojo::Clone(lower_vertical_angle)
  );
}

template <typename T, XREquirectLayerData::EnableIfSame<T>*>
bool XREquirectLayerData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->native_origin_from_layer, other_struct.native_origin_from_layer))
    return false;
  if (!mojo::Equals(this->radius, other_struct.radius))
    return false;
  if (!mojo::Equals(this->central_horizontal_angle, other_struct.central_horizontal_angle))
    return false;
  if (!mojo::Equals(this->upper_vertical_angle, other_struct.upper_vertical_angle))
    return false;
  if (!mojo::Equals(this->lower_vertical_angle, other_struct.lower_vertical_angle))
    return false;
  return true;
}

template <typename T, XREquirectLayerData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.native_origin_from_layer < rhs.native_origin_from_layer)
    return true;
  if (rhs.native_origin_from_layer < lhs.native_origin_from_layer)
    return false;
  if (lhs.radius < rhs.radius)
    return true;
  if (rhs.radius < lhs.radius)
    return false;
  if (lhs.central_horizontal_angle < rhs.central_horizontal_angle)
    return true;
  if (rhs.central_horizontal_angle < lhs.central_horizontal_angle)
    return false;
  if (lhs.upper_vertical_angle < rhs.upper_vertical_angle)
    return true;
  if (rhs.upper_vertical_angle < lhs.upper_vertical_angle)
    return false;
  if (lhs.lower_vertical_angle < rhs.lower_vertical_angle)
    return true;
  if (rhs.lower_vertical_angle < lhs.lower_vertical_angle)
    return false;
  return false;
}
template <typename StructPtrType>
XRCubeLayerDataPtr XRCubeLayerData::Clone() const {
  return New(
      mojo::Clone(orientation)
  );
}

template <typename T, XRCubeLayerData::EnableIfSame<T>*>
bool XRCubeLayerData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  return true;
}

template <typename T, XRCubeLayerData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.orientation < rhs.orientation)
    return true;
  if (rhs.orientation < lhs.orientation)
    return false;
  return false;
}
template <typename StructPtrType>
XRLayerReadOnlyDataPtr XRLayerReadOnlyData::Clone() const {
  return New(
      mojo::Clone(layer_id),
      mojo::Clone(layout),
      mojo::Clone(texture_width),
      mojo::Clone(texture_height),
      mojo::Clone(is_static)
  );
}

template <typename T, XRLayerReadOnlyData::EnableIfSame<T>*>
bool XRLayerReadOnlyData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->layer_id, other_struct.layer_id))
    return false;
  if (!mojo::Equals(this->layout, other_struct.layout))
    return false;
  if (!mojo::Equals(this->texture_width, other_struct.texture_width))
    return false;
  if (!mojo::Equals(this->texture_height, other_struct.texture_height))
    return false;
  if (!mojo::Equals(this->is_static, other_struct.is_static))
    return false;
  return true;
}

template <typename T, XRLayerReadOnlyData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.layer_id < rhs.layer_id)
    return true;
  if (rhs.layer_id < lhs.layer_id)
    return false;
  if (lhs.layout < rhs.layout)
    return true;
  if (rhs.layout < lhs.layout)
    return false;
  if (lhs.texture_width < rhs.texture_width)
    return true;
  if (rhs.texture_width < lhs.texture_width)
    return false;
  if (lhs.texture_height < rhs.texture_height)
    return true;
  if (rhs.texture_height < lhs.texture_height)
    return false;
  if (lhs.is_static < rhs.is_static)
    return true;
  if (rhs.is_static < lhs.is_static)
    return false;
  return false;
}
template <typename StructPtrType>
XRLayerMutableDataPtr XRLayerMutableData::Clone() const {
  return New(
      mojo::Clone(blend_texture_source_alpha),
      mojo::Clone(opacity),
      mojo::Clone(native_origin_information),
      mojo::Clone(layer_data)
  );
}

template <typename T, XRLayerMutableData::EnableIfSame<T>*>
bool XRLayerMutableData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->blend_texture_source_alpha, other_struct.blend_texture_source_alpha))
    return false;
  if (!mojo::Equals(this->opacity, other_struct.opacity))
    return false;
  if (!mojo::Equals(this->native_origin_information, other_struct.native_origin_information))
    return false;
  if (!mojo::Equals(this->layer_data, other_struct.layer_data))
    return false;
  return true;
}

template <typename T, XRLayerMutableData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.blend_texture_source_alpha < rhs.blend_texture_source_alpha)
    return true;
  if (rhs.blend_texture_source_alpha < lhs.blend_texture_source_alpha)
    return false;
  if (lhs.opacity < rhs.opacity)
    return true;
  if (rhs.opacity < lhs.opacity)
    return false;
  if (lhs.native_origin_information < rhs.native_origin_information)
    return true;
  if (rhs.native_origin_information < lhs.native_origin_information)
    return false;
  if (lhs.layer_data < rhs.layer_data)
    return true;
  if (rhs.layer_data < lhs.layer_data)
    return false;
  return false;
}
template <typename StructPtrType>
XRCompositionLayerDataPtr XRCompositionLayerData::Clone() const {
  return New(
      mojo::Clone(read_only_data),
      mojo::Clone(mutable_data)
  );
}

template <typename T, XRCompositionLayerData::EnableIfSame<T>*>
bool XRCompositionLayerData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->read_only_data, other_struct.read_only_data))
    return false;
  if (!mojo::Equals(this->mutable_data, other_struct.mutable_data))
    return false;
  return true;
}

template <typename T, XRCompositionLayerData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.read_only_data < rhs.read_only_data)
    return true;
  if (rhs.read_only_data < lhs.read_only_data)
    return false;
  if (lhs.mutable_data < rhs.mutable_data)
    return true;
  if (rhs.mutable_data < lhs.mutable_data)
    return false;
  return false;
}
template <typename StructPtrType>
XRLayerFrameDataPtr XRLayerFrameData::Clone() const {
  return New(
      mojo::Clone(layer_id),
      mojo::Clone(buffer_shared_image),
      mojo::Clone(buffer_sync_token)
  );
}

template <typename T, XRLayerFrameData::EnableIfSame<T>*>
bool XRLayerFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->layer_id, other_struct.layer_id))
    return false;
  if (!mojo::Equals(this->buffer_shared_image, other_struct.buffer_shared_image))
    return false;
  if (!mojo::Equals(this->buffer_sync_token, other_struct.buffer_sync_token))
    return false;
  return true;
}

template <typename T, XRLayerFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.layer_id < rhs.layer_id)
    return true;
  if (rhs.layer_id < lhs.layer_id)
    return false;
  if (lhs.buffer_shared_image < rhs.buffer_shared_image)
    return true;
  if (rhs.buffer_shared_image < lhs.buffer_shared_image)
    return false;
  if (lhs.buffer_sync_token < rhs.buffer_sync_token)
    return true;
  if (rhs.buffer_sync_token < lhs.buffer_sync_token)
    return false;
  return false;
}
template <typename StructPtrType>
XRRenderInfoPtr XRRenderInfo::Clone() const {
  return New(
      mojo::Clone(frame_id),
      mojo::Clone(mojo_from_viewer),
      mojo::Clone(views)
  );
}

template <typename T, XRRenderInfo::EnableIfSame<T>*>
bool XRRenderInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_id, other_struct.frame_id))
    return false;
  if (!mojo::Equals(this->mojo_from_viewer, other_struct.mojo_from_viewer))
    return false;
  if (!mojo::Equals(this->views, other_struct.views))
    return false;
  return true;
}

template <typename T, XRRenderInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_id < rhs.frame_id)
    return true;
  if (rhs.frame_id < lhs.frame_id)
    return false;
  if (lhs.mojo_from_viewer < rhs.mojo_from_viewer)
    return true;
  if (rhs.mojo_from_viewer < lhs.mojo_from_viewer)
    return false;
  if (lhs.views < rhs.views)
    return true;
  if (rhs.views < lhs.views)
    return false;
  return false;
}
template <typename StructPtrType>
XRFrameDataPtr XRFrameData::Clone() const {
  return New(
      mojo::Clone(render_info),
      mojo::Clone(time_delta),
      mojo::Clone(buffer_shared_image),
      mojo::Clone(buffer_sync_token),
      mojo::Clone(camera_image_buffer_shared_image),
      mojo::Clone(camera_image_buffer_sync_token),
      mojo::Clone(camera_image_size),
      mojo::Clone(mojo_space_reset),
      mojo::Clone(mojo_from_floor),
      mojo::Clone(input_state),
      mojo::Clone(stage_parameters_id),
      mojo::Clone(stage_parameters),
      mojo::Clone(detected_planes_data),
      mojo::Clone(anchors_data),
      mojo::Clone(composition_layers_data),
      mojo::Clone(light_estimation_data),
      mojo::Clone(hit_test_subscription_results),
      mojo::Clone(rendering_time_ratio),
      mojo::Clone(tracked_images)
  );
}

template <typename T, XRFrameData::EnableIfSame<T>*>
bool XRFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->render_info, other_struct.render_info))
    return false;
  if (!mojo::Equals(this->time_delta, other_struct.time_delta))
    return false;
  if (!mojo::Equals(this->buffer_shared_image, other_struct.buffer_shared_image))
    return false;
  if (!mojo::Equals(this->buffer_sync_token, other_struct.buffer_sync_token))
    return false;
  if (!mojo::Equals(this->camera_image_buffer_shared_image, other_struct.camera_image_buffer_shared_image))
    return false;
  if (!mojo::Equals(this->camera_image_buffer_sync_token, other_struct.camera_image_buffer_sync_token))
    return false;
  if (!mojo::Equals(this->camera_image_size, other_struct.camera_image_size))
    return false;
  if (!mojo::Equals(this->mojo_space_reset, other_struct.mojo_space_reset))
    return false;
  if (!mojo::Equals(this->mojo_from_floor, other_struct.mojo_from_floor))
    return false;
  if (!mojo::Equals(this->input_state, other_struct.input_state))
    return false;
  if (!mojo::Equals(this->stage_parameters_id, other_struct.stage_parameters_id))
    return false;
  if (!mojo::Equals(this->stage_parameters, other_struct.stage_parameters))
    return false;
  if (!mojo::Equals(this->detected_planes_data, other_struct.detected_planes_data))
    return false;
  if (!mojo::Equals(this->anchors_data, other_struct.anchors_data))
    return false;
  if (!mojo::Equals(this->composition_layers_data, other_struct.composition_layers_data))
    return false;
  if (!mojo::Equals(this->light_estimation_data, other_struct.light_estimation_data))
    return false;
  if (!mojo::Equals(this->hit_test_subscription_results, other_struct.hit_test_subscription_results))
    return false;
  if (!mojo::Equals(this->rendering_time_ratio, other_struct.rendering_time_ratio))
    return false;
  if (!mojo::Equals(this->tracked_images, other_struct.tracked_images))
    return false;
  return true;
}

template <typename T, XRFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.render_info < rhs.render_info)
    return true;
  if (rhs.render_info < lhs.render_info)
    return false;
  if (lhs.time_delta < rhs.time_delta)
    return true;
  if (rhs.time_delta < lhs.time_delta)
    return false;
  if (lhs.buffer_shared_image < rhs.buffer_shared_image)
    return true;
  if (rhs.buffer_shared_image < lhs.buffer_shared_image)
    return false;
  if (lhs.buffer_sync_token < rhs.buffer_sync_token)
    return true;
  if (rhs.buffer_sync_token < lhs.buffer_sync_token)
    return false;
  if (lhs.camera_image_buffer_shared_image < rhs.camera_image_buffer_shared_image)
    return true;
  if (rhs.camera_image_buffer_shared_image < lhs.camera_image_buffer_shared_image)
    return false;
  if (lhs.camera_image_buffer_sync_token < rhs.camera_image_buffer_sync_token)
    return true;
  if (rhs.camera_image_buffer_sync_token < lhs.camera_image_buffer_sync_token)
    return false;
  if (lhs.camera_image_size < rhs.camera_image_size)
    return true;
  if (rhs.camera_image_size < lhs.camera_image_size)
    return false;
  if (lhs.mojo_space_reset < rhs.mojo_space_reset)
    return true;
  if (rhs.mojo_space_reset < lhs.mojo_space_reset)
    return false;
  if (lhs.mojo_from_floor < rhs.mojo_from_floor)
    return true;
  if (rhs.mojo_from_floor < lhs.mojo_from_floor)
    return false;
  if (lhs.input_state < rhs.input_state)
    return true;
  if (rhs.input_state < lhs.input_state)
    return false;
  if (lhs.stage_parameters_id < rhs.stage_parameters_id)
    return true;
  if (rhs.stage_parameters_id < lhs.stage_parameters_id)
    return false;
  if (lhs.stage_parameters < rhs.stage_parameters)
    return true;
  if (rhs.stage_parameters < lhs.stage_parameters)
    return false;
  if (lhs.detected_planes_data < rhs.detected_planes_data)
    return true;
  if (rhs.detected_planes_data < lhs.detected_planes_data)
    return false;
  if (lhs.anchors_data < rhs.anchors_data)
    return true;
  if (rhs.anchors_data < lhs.anchors_data)
    return false;
  if (lhs.composition_layers_data < rhs.composition_layers_data)
    return true;
  if (rhs.composition_layers_data < lhs.composition_layers_data)
    return false;
  if (lhs.light_estimation_data < rhs.light_estimation_data)
    return true;
  if (rhs.light_estimation_data < lhs.light_estimation_data)
    return false;
  if (lhs.hit_test_subscription_results < rhs.hit_test_subscription_results)
    return true;
  if (rhs.hit_test_subscription_results < lhs.hit_test_subscription_results)
    return false;
  if (lhs.rendering_time_ratio < rhs.rendering_time_ratio)
    return true;
  if (rhs.rendering_time_ratio < lhs.rendering_time_ratio)
    return false;
  if (lhs.tracked_images < rhs.tracked_images)
    return true;
  if (rhs.tracked_images < lhs.tracked_images)
    return false;
  return false;
}
template <typename StructPtrType>
RequestSessionSuccessPtr RequestSessionSuccess::Clone() const {
  return New(
      mojo::Clone(session),
      mojo::Clone(trace_id),
      mojo::Clone(metrics_recorder),
      mojo::Clone(xr_internals_listener)
  );
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>*>
bool RequestSessionSuccess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->session, other_struct.session))
    return false;
  if (!mojo::Equals(this->trace_id, other_struct.trace_id))
    return false;
  if (!mojo::Equals(this->metrics_recorder, other_struct.metrics_recorder))
    return false;
  if (!mojo::Equals(this->xr_internals_listener, other_struct.xr_internals_listener))
    return false;
  return true;
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.session < rhs.session)
    return true;
  if (rhs.session < lhs.session)
    return false;
  if (lhs.trace_id < rhs.trace_id)
    return true;
  if (rhs.trace_id < lhs.trace_id)
    return false;
  if (lhs.metrics_recorder < rhs.metrics_recorder)
    return true;
  if (rhs.metrics_recorder < lhs.metrics_recorder)
    return false;
  if (lhs.xr_internals_listener < rhs.xr_internals_listener)
    return true;
  if (rhs.xr_internals_listener < lhs.xr_internals_listener)
    return false;
  return false;
}
template <typename StructPtrType>
XRFrameDataRequestOptionsPtr XRFrameDataRequestOptions::Clone() const {
  return New(
      mojo::Clone(include_lighting_estimation_data),
      mojo::Clone(depth_active),
      mojo::Clone(stage_parameters_id)
  );
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>*>
bool XRFrameDataRequestOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->include_lighting_estimation_data, other_struct.include_lighting_estimation_data))
    return false;
  if (!mojo::Equals(this->depth_active, other_struct.depth_active))
    return false;
  if (!mojo::Equals(this->stage_parameters_id, other_struct.stage_parameters_id))
    return false;
  return true;
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.include_lighting_estimation_data < rhs.include_lighting_estimation_data)
    return true;
  if (rhs.include_lighting_estimation_data < lhs.include_lighting_estimation_data)
    return false;
  if (lhs.depth_active < rhs.depth_active)
    return true;
  if (rhs.depth_active < lhs.depth_active)
    return false;
  if (lhs.stage_parameters_id < rhs.stage_parameters_id)
    return true;
  if (rhs.stage_parameters_id < lhs.stage_parameters_id)
    return false;
  return false;
}


}  // device::mojom::blink

namespace mojo {


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRDepthConfig::DataView,
                                         ::device::mojom::blink::XRDepthConfigPtr> {
  static bool IsNull(const ::device::mojom::blink::XRDepthConfigPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRDepthConfigPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRDepthConfig::depth_usage) depth_usage(
      const ::device::mojom::blink::XRDepthConfigPtr& input) {
    return input->depth_usage;
  }

  static decltype(::device::mojom::blink::XRDepthConfig::depth_data_format) depth_data_format(
      const ::device::mojom::blink::XRDepthConfigPtr& input) {
    return input->depth_data_format;
  }

  static decltype(::device::mojom::blink::XRDepthConfig::depth_type) depth_type(
      const ::device::mojom::blink::XRDepthConfigPtr& input) {
    return input->depth_type;
  }

  static bool Read(::device::mojom::blink::XRDepthConfig::DataView input, ::device::mojom::blink::XRDepthConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRSessionDeviceConfig::DataView,
                                         ::device::mojom::blink::XRSessionDeviceConfigPtr> {
  static bool IsNull(const ::device::mojom::blink::XRSessionDeviceConfigPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRSessionDeviceConfigPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRSessionDeviceConfig::default_framebuffer_scale) default_framebuffer_scale(
      const ::device::mojom::blink::XRSessionDeviceConfigPtr& input) {
    return input->default_framebuffer_scale;
  }

  static  decltype(::device::mojom::blink::XRSessionDeviceConfig::views)& views(
       ::device::mojom::blink::XRSessionDeviceConfigPtr& input) {
    return input->views;
  }

  static decltype(::device::mojom::blink::XRSessionDeviceConfig::supports_viewport_scaling) supports_viewport_scaling(
      const ::device::mojom::blink::XRSessionDeviceConfigPtr& input) {
    return input->supports_viewport_scaling;
  }

  static decltype(::device::mojom::blink::XRSessionDeviceConfig::enable_anti_aliasing) enable_anti_aliasing(
      const ::device::mojom::blink::XRSessionDeviceConfigPtr& input) {
    return input->enable_anti_aliasing;
  }

  static const decltype(::device::mojom::blink::XRSessionDeviceConfig::depth_configuration)& depth_configuration(
      const ::device::mojom::blink::XRSessionDeviceConfigPtr& input) {
    return input->depth_configuration;
  }

  static bool Read(::device::mojom::blink::XRSessionDeviceConfig::DataView input, ::device::mojom::blink::XRSessionDeviceConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRSession::DataView,
                                         ::device::mojom::blink::XRSessionPtr> {
  static bool IsNull(const ::device::mojom::blink::XRSessionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRSessionPtr* output) { output->reset(); }

  static  decltype(::device::mojom::blink::XRSession::data_provider)& data_provider(
       ::device::mojom::blink::XRSessionPtr& input) {
    return input->data_provider;
  }

  static  decltype(::device::mojom::blink::XRSession::layer_manager)& layer_manager(
       ::device::mojom::blink::XRSessionPtr& input) {
    return input->layer_manager;
  }

  static  decltype(::device::mojom::blink::XRSession::client_receiver)& client_receiver(
       ::device::mojom::blink::XRSessionPtr& input) {
    return input->client_receiver;
  }

  static  decltype(::device::mojom::blink::XRSession::submit_frame_sink)& submit_frame_sink(
       ::device::mojom::blink::XRSessionPtr& input) {
    return input->submit_frame_sink;
  }

  static const decltype(::device::mojom::blink::XRSession::enabled_features)& enabled_features(
      const ::device::mojom::blink::XRSessionPtr& input) {
    return input->enabled_features;
  }

  static  decltype(::device::mojom::blink::XRSession::device_config)& device_config(
       ::device::mojom::blink::XRSessionPtr& input) {
    return input->device_config;
  }

  static decltype(::device::mojom::blink::XRSession::enviroment_blend_mode) enviroment_blend_mode(
      const ::device::mojom::blink::XRSessionPtr& input) {
    return input->enviroment_blend_mode;
  }

  static decltype(::device::mojom::blink::XRSession::interaction_mode) interaction_mode(
      const ::device::mojom::blink::XRSessionPtr& input) {
    return input->interaction_mode;
  }

  static bool Read(::device::mojom::blink::XRSession::DataView input, ::device::mojom::blink::XRSessionPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRPresentationConnection::DataView,
                                         ::device::mojom::blink::XRPresentationConnectionPtr> {
  static bool IsNull(const ::device::mojom::blink::XRPresentationConnectionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRPresentationConnectionPtr* output) { output->reset(); }

  static  decltype(::device::mojom::blink::XRPresentationConnection::provider)& provider(
       ::device::mojom::blink::XRPresentationConnectionPtr& input) {
    return input->provider;
  }

  static  decltype(::device::mojom::blink::XRPresentationConnection::client_receiver)& client_receiver(
       ::device::mojom::blink::XRPresentationConnectionPtr& input) {
    return input->client_receiver;
  }

  static const decltype(::device::mojom::blink::XRPresentationConnection::transport_options)& transport_options(
      const ::device::mojom::blink::XRPresentationConnectionPtr& input) {
    return input->transport_options;
  }

  static bool Read(::device::mojom::blink::XRPresentationConnection::DataView input, ::device::mojom::blink::XRPresentationConnectionPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRInputSourceDescription::DataView,
                                         ::device::mojom::blink::XRInputSourceDescriptionPtr> {
  static bool IsNull(const ::device::mojom::blink::XRInputSourceDescriptionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRInputSourceDescriptionPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRInputSourceDescription::target_ray_mode) target_ray_mode(
      const ::device::mojom::blink::XRInputSourceDescriptionPtr& input) {
    return input->target_ray_mode;
  }

  static decltype(::device::mojom::blink::XRInputSourceDescription::handedness) handedness(
      const ::device::mojom::blink::XRInputSourceDescriptionPtr& input) {
    return input->handedness;
  }

  static const decltype(::device::mojom::blink::XRInputSourceDescription::input_from_pointer)& input_from_pointer(
      const ::device::mojom::blink::XRInputSourceDescriptionPtr& input) {
    return input->input_from_pointer;
  }

  static const decltype(::device::mojom::blink::XRInputSourceDescription::profiles)& profiles(
      const ::device::mojom::blink::XRInputSourceDescriptionPtr& input) {
    return input->profiles;
  }

  static bool Read(::device::mojom::blink::XRInputSourceDescription::DataView input, ::device::mojom::blink::XRInputSourceDescriptionPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRInputSourceState::DataView,
                                         ::device::mojom::blink::XRInputSourceStatePtr> {
  static bool IsNull(const ::device::mojom::blink::XRInputSourceStatePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRInputSourceStatePtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRInputSourceState::source_id) source_id(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->source_id;
  }

  static const decltype(::device::mojom::blink::XRInputSourceState::description)& description(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->description;
  }

  static const decltype(::device::mojom::blink::XRInputSourceState::mojo_from_input)& mojo_from_input(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->mojo_from_input;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::emulated_position) emulated_position(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->emulated_position;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::is_auxiliary) is_auxiliary(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->is_auxiliary;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::primary_input_pressed) primary_input_pressed(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->primary_input_pressed;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::primary_input_clicked) primary_input_clicked(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->primary_input_clicked;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::primary_squeeze_pressed) primary_squeeze_pressed(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->primary_squeeze_pressed;
  }

  static decltype(::device::mojom::blink::XRInputSourceState::primary_squeeze_clicked) primary_squeeze_clicked(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->primary_squeeze_clicked;
  }

  static const decltype(::device::mojom::blink::XRInputSourceState::gamepad)& gamepad(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->gamepad;
  }

  static const decltype(::device::mojom::blink::XRInputSourceState::overlay_pointer_position)& overlay_pointer_position(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->overlay_pointer_position;
  }

  static const decltype(::device::mojom::blink::XRInputSourceState::hand_tracking_data)& hand_tracking_data(
      const ::device::mojom::blink::XRInputSourceStatePtr& input) {
    return input->hand_tracking_data;
  }

  static bool Read(::device::mojom::blink::XRInputSourceState::DataView input, ::device::mojom::blink::XRInputSourceStatePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::VRFieldOfView::DataView,
                                         ::device::mojom::blink::VRFieldOfViewPtr> {
  static bool IsNull(const ::device::mojom::blink::VRFieldOfViewPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::VRFieldOfViewPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::VRFieldOfView::up_degrees) up_degrees(
      const ::device::mojom::blink::VRFieldOfViewPtr& input) {
    return input->up_degrees;
  }

  static decltype(::device::mojom::blink::VRFieldOfView::down_degrees) down_degrees(
      const ::device::mojom::blink::VRFieldOfViewPtr& input) {
    return input->down_degrees;
  }

  static decltype(::device::mojom::blink::VRFieldOfView::left_degrees) left_degrees(
      const ::device::mojom::blink::VRFieldOfViewPtr& input) {
    return input->left_degrees;
  }

  static decltype(::device::mojom::blink::VRFieldOfView::right_degrees) right_degrees(
      const ::device::mojom::blink::VRFieldOfViewPtr& input) {
    return input->right_degrees;
  }

  static bool Read(::device::mojom::blink::VRFieldOfView::DataView input, ::device::mojom::blink::VRFieldOfViewPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::VRPose::DataView,
                                         ::device::mojom::blink::VRPosePtr> {
  static bool IsNull(const ::device::mojom::blink::VRPosePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::VRPosePtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::VRPose::orientation)& orientation(
      const ::device::mojom::blink::VRPosePtr& input) {
    return input->orientation;
  }

  static const decltype(::device::mojom::blink::VRPose::position)& position(
      const ::device::mojom::blink::VRPosePtr& input) {
    return input->position;
  }

  static decltype(::device::mojom::blink::VRPose::emulated_position) emulated_position(
      const ::device::mojom::blink::VRPosePtr& input) {
    return input->emulated_position;
  }

  static bool Read(::device::mojom::blink::VRPose::DataView input, ::device::mojom::blink::VRPosePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::Pose::DataView,
                                         ::device::mojom::blink::PosePtr> {
  static bool IsNull(const ::device::mojom::blink::PosePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::PosePtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::Pose::orientation)& orientation(
      const ::device::mojom::blink::PosePtr& input) {
    return input->orientation;
  }

  static const decltype(::device::mojom::blink::Pose::position)& position(
      const ::device::mojom::blink::PosePtr& input) {
    return input->position;
  }

  static bool Read(::device::mojom::blink::Pose::DataView input, ::device::mojom::blink::PosePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::AnchorId::DataView,
                                         ::device::mojom::blink::AnchorIdPtr> {
  static bool IsNull(const ::device::mojom::blink::AnchorIdPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::AnchorIdPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::AnchorId::id_value) id_value(
      const ::device::mojom::blink::AnchorIdPtr& input) {
    return input->id_value;
  }

  static bool Read(::device::mojom::blink::AnchorId::DataView input, ::device::mojom::blink::AnchorIdPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::HitTestSubscriptionId::DataView,
                                         ::device::mojom::blink::HitTestSubscriptionIdPtr> {
  static bool IsNull(const ::device::mojom::blink::HitTestSubscriptionIdPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::HitTestSubscriptionIdPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::HitTestSubscriptionId::id_value) id_value(
      const ::device::mojom::blink::HitTestSubscriptionIdPtr& input) {
    return input->id_value;
  }

  static bool Read(::device::mojom::blink::HitTestSubscriptionId::DataView input, ::device::mojom::blink::HitTestSubscriptionIdPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::PlaneId::DataView,
                                         ::device::mojom::blink::PlaneIdPtr> {
  static bool IsNull(const ::device::mojom::blink::PlaneIdPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::PlaneIdPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::PlaneId::id_value) id_value(
      const ::device::mojom::blink::PlaneIdPtr& input) {
    return input->id_value;
  }

  static bool Read(::device::mojom::blink::PlaneId::DataView input, ::device::mojom::blink::PlaneIdPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XrVisibilityMaskId::DataView,
                                         ::device::mojom::blink::XrVisibilityMaskIdPtr> {
  static bool IsNull(const ::device::mojom::blink::XrVisibilityMaskIdPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XrVisibilityMaskIdPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XrVisibilityMaskId::id_value) id_value(
      const ::device::mojom::blink::XrVisibilityMaskIdPtr& input) {
    return input->id_value;
  }

  static bool Read(::device::mojom::blink::XrVisibilityMaskId::DataView input, ::device::mojom::blink::XrVisibilityMaskIdPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRRay::DataView,
                                         ::device::mojom::blink::XRRayPtr> {
  static bool IsNull(const ::device::mojom::blink::XRRayPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRRayPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRRay::origin)& origin(
      const ::device::mojom::blink::XRRayPtr& input) {
    return input->origin;
  }

  static const decltype(::device::mojom::blink::XRRay::direction)& direction(
      const ::device::mojom::blink::XRRayPtr& input) {
    return input->direction;
  }

  static bool Read(::device::mojom::blink::XRRay::DataView input, ::device::mojom::blink::XRRayPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRHitResult::DataView,
                                         ::device::mojom::blink::XRHitResultPtr> {
  static bool IsNull(const ::device::mojom::blink::XRHitResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRHitResultPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRHitResult::mojo_from_result)& mojo_from_result(
      const ::device::mojom::blink::XRHitResultPtr& input) {
    return input->mojo_from_result;
  }

  static const decltype(::device::mojom::blink::XRHitResult::plane_id)& plane_id(
      const ::device::mojom::blink::XRHitResultPtr& input) {
    return input->plane_id;
  }

  static bool Read(::device::mojom::blink::XRHitResult::DataView input, ::device::mojom::blink::XRHitResultPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRViewGeometry::DataView,
                                         ::device::mojom::blink::XRViewGeometryPtr> {
  static bool IsNull(const ::device::mojom::blink::XRViewGeometryPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRViewGeometryPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRViewGeometry::field_of_view)& field_of_view(
      const ::device::mojom::blink::XRViewGeometryPtr& input) {
    return input->field_of_view;
  }

  static const decltype(::device::mojom::blink::XRViewGeometry::mojo_from_view)& mojo_from_view(
      const ::device::mojom::blink::XRViewGeometryPtr& input) {
    return input->mojo_from_view;
  }

  static bool Read(::device::mojom::blink::XRViewGeometry::DataView input, ::device::mojom::blink::XRViewGeometryPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRVisibilityMask::DataView,
                                         ::device::mojom::blink::XRVisibilityMaskPtr> {
  static bool IsNull(const ::device::mojom::blink::XRVisibilityMaskPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRVisibilityMaskPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRVisibilityMask::vertices)& vertices(
      const ::device::mojom::blink::XRVisibilityMaskPtr& input) {
    return input->vertices;
  }

  static const decltype(::device::mojom::blink::XRVisibilityMask::unvalidated_indices)& unvalidated_indices(
      const ::device::mojom::blink::XRVisibilityMaskPtr& input) {
    return input->unvalidated_indices;
  }

  static bool Read(::device::mojom::blink::XRVisibilityMask::DataView input, ::device::mojom::blink::XRVisibilityMaskPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRView::DataView,
                                         ::device::mojom::blink::XRViewPtr> {
  static bool IsNull(const ::device::mojom::blink::XRViewPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRViewPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRView::eye) eye(
      const ::device::mojom::blink::XRViewPtr& input) {
    return input->eye;
  }

  static const decltype(::device::mojom::blink::XRView::geometry)& geometry(
      const ::device::mojom::blink::XRViewPtr& input) {
    return input->geometry;
  }

  static const decltype(::device::mojom::blink::XRView::viewport)& viewport(
      const ::device::mojom::blink::XRViewPtr& input) {
    return input->viewport;
  }

  static  decltype(::device::mojom::blink::XRView::depth_data)& depth_data(
       ::device::mojom::blink::XRViewPtr& input) {
    return input->depth_data;
  }

  static decltype(::device::mojom::blink::XRView::is_first_person_observer) is_first_person_observer(
      const ::device::mojom::blink::XRViewPtr& input) {
    return input->is_first_person_observer;
  }

  static const decltype(::device::mojom::blink::XRView::visibility_mask)& visibility_mask(
      const ::device::mojom::blink::XRViewPtr& input) {
    return input->visibility_mask;
  }

  static const decltype(::device::mojom::blink::XRView::visibility_mask_id)& visibility_mask_id(
      const ::device::mojom::blink::XRViewPtr& input) {
    return input->visibility_mask_id;
  }

  static bool Read(::device::mojom::blink::XRView::DataView input, ::device::mojom::blink::XRViewPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::VRStageParameters::DataView,
                                         ::device::mojom::blink::VRStageParametersPtr> {
  static bool IsNull(const ::device::mojom::blink::VRStageParametersPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::VRStageParametersPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::VRStageParameters::mojo_from_stage)& mojo_from_stage(
      const ::device::mojom::blink::VRStageParametersPtr& input) {
    return input->mojo_from_stage;
  }

  static const decltype(::device::mojom::blink::VRStageParameters::bounds)& bounds(
      const ::device::mojom::blink::VRStageParametersPtr& input) {
    return input->bounds;
  }

  static bool Read(::device::mojom::blink::VRStageParameters::DataView input, ::device::mojom::blink::VRStageParametersPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRPresentationTransportOptions::DataView,
                                         ::device::mojom::blink::XRPresentationTransportOptionsPtr> {
  static bool IsNull(const ::device::mojom::blink::XRPresentationTransportOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRPresentationTransportOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRPresentationTransportOptions::transport_method) transport_method(
      const ::device::mojom::blink::XRPresentationTransportOptionsPtr& input) {
    return input->transport_method;
  }

  static decltype(::device::mojom::blink::XRPresentationTransportOptions::wait_for_transfer_notification) wait_for_transfer_notification(
      const ::device::mojom::blink::XRPresentationTransportOptionsPtr& input) {
    return input->wait_for_transfer_notification;
  }

  static decltype(::device::mojom::blink::XRPresentationTransportOptions::wait_for_render_notification) wait_for_render_notification(
      const ::device::mojom::blink::XRPresentationTransportOptionsPtr& input) {
    return input->wait_for_render_notification;
  }

  static decltype(::device::mojom::blink::XRPresentationTransportOptions::wait_for_gpu_fence) wait_for_gpu_fence(
      const ::device::mojom::blink::XRPresentationTransportOptionsPtr& input) {
    return input->wait_for_gpu_fence;
  }

  static bool Read(::device::mojom::blink::XRPresentationTransportOptions::DataView input, ::device::mojom::blink::XRPresentationTransportOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRInputSourceSpaceInfo::DataView,
                                         ::device::mojom::blink::XRInputSourceSpaceInfoPtr> {
  static bool IsNull(const ::device::mojom::blink::XRInputSourceSpaceInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRInputSourceSpaceInfoPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRInputSourceSpaceInfo::input_source_id) input_source_id(
      const ::device::mojom::blink::XRInputSourceSpaceInfoPtr& input) {
    return input->input_source_id;
  }

  static decltype(::device::mojom::blink::XRInputSourceSpaceInfo::input_source_space_type) input_source_space_type(
      const ::device::mojom::blink::XRInputSourceSpaceInfoPtr& input) {
    return input->input_source_space_type;
  }

  static bool Read(::device::mojom::blink::XRInputSourceSpaceInfo::DataView input, ::device::mojom::blink::XRInputSourceSpaceInfoPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRHandJointSpaceInfo::DataView,
                                         ::device::mojom::blink::XRHandJointSpaceInfoPtr> {
  static bool IsNull(const ::device::mojom::blink::XRHandJointSpaceInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRHandJointSpaceInfoPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRHandJointSpaceInfo::handedness) handedness(
      const ::device::mojom::blink::XRHandJointSpaceInfoPtr& input) {
    return input->handedness;
  }

  static decltype(::device::mojom::blink::XRHandJointSpaceInfo::joint) joint(
      const ::device::mojom::blink::XRHandJointSpaceInfoPtr& input) {
    return input->joint;
  }

  static bool Read(::device::mojom::blink::XRHandJointSpaceInfo::DataView input, ::device::mojom::blink::XRHandJointSpaceInfoPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRPlanePointData::DataView,
                                         ::device::mojom::blink::XRPlanePointDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRPlanePointDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRPlanePointDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRPlanePointData::x) x(
      const ::device::mojom::blink::XRPlanePointDataPtr& input) {
    return input->x;
  }

  static decltype(::device::mojom::blink::XRPlanePointData::z) z(
      const ::device::mojom::blink::XRPlanePointDataPtr& input) {
    return input->z;
  }

  static bool Read(::device::mojom::blink::XRPlanePointData::DataView input, ::device::mojom::blink::XRPlanePointDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRPlaneData::DataView,
                                         ::device::mojom::blink::XRPlaneDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRPlaneDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRPlaneDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRPlaneData::id)& id(
      const ::device::mojom::blink::XRPlaneDataPtr& input) {
    return input->id;
  }

  static decltype(::device::mojom::blink::XRPlaneData::orientation) orientation(
      const ::device::mojom::blink::XRPlaneDataPtr& input) {
    return input->orientation;
  }

  static const decltype(::device::mojom::blink::XRPlaneData::mojo_from_plane)& mojo_from_plane(
      const ::device::mojom::blink::XRPlaneDataPtr& input) {
    return input->mojo_from_plane;
  }

  static const decltype(::device::mojom::blink::XRPlaneData::polygon)& polygon(
      const ::device::mojom::blink::XRPlaneDataPtr& input) {
    return input->polygon;
  }

  static bool Read(::device::mojom::blink::XRPlaneData::DataView input, ::device::mojom::blink::XRPlaneDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRPlaneDetectionData::DataView,
                                         ::device::mojom::blink::XRPlaneDetectionDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRPlaneDetectionDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRPlaneDetectionDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRPlaneDetectionData::all_planes_ids)& all_planes_ids(
      const ::device::mojom::blink::XRPlaneDetectionDataPtr& input) {
    return input->all_planes_ids;
  }

  static const decltype(::device::mojom::blink::XRPlaneDetectionData::updated_planes_data)& updated_planes_data(
      const ::device::mojom::blink::XRPlaneDetectionDataPtr& input) {
    return input->updated_planes_data;
  }

  static bool Read(::device::mojom::blink::XRPlaneDetectionData::DataView input, ::device::mojom::blink::XRPlaneDetectionDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRAnchorData::DataView,
                                         ::device::mojom::blink::XRAnchorDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRAnchorDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRAnchorDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRAnchorData::id)& id(
      const ::device::mojom::blink::XRAnchorDataPtr& input) {
    return input->id;
  }

  static const decltype(::device::mojom::blink::XRAnchorData::mojo_from_anchor)& mojo_from_anchor(
      const ::device::mojom::blink::XRAnchorDataPtr& input) {
    return input->mojo_from_anchor;
  }

  static bool Read(::device::mojom::blink::XRAnchorData::DataView input, ::device::mojom::blink::XRAnchorDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRAnchorsData::DataView,
                                         ::device::mojom::blink::XRAnchorsDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRAnchorsDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRAnchorsDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRAnchorsData::all_anchors_ids)& all_anchors_ids(
      const ::device::mojom::blink::XRAnchorsDataPtr& input) {
    return input->all_anchors_ids;
  }

  static const decltype(::device::mojom::blink::XRAnchorsData::updated_anchors_data)& updated_anchors_data(
      const ::device::mojom::blink::XRAnchorsDataPtr& input) {
    return input->updated_anchors_data;
  }

  static bool Read(::device::mojom::blink::XRAnchorsData::DataView input, ::device::mojom::blink::XRAnchorsDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRHitTestSubscriptionResultData::DataView,
                                         ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRHitTestSubscriptionResultDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRHitTestSubscriptionResultData::subscription_id)& subscription_id(
      const ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr& input) {
    return input->subscription_id;
  }

  static const decltype(::device::mojom::blink::XRHitTestSubscriptionResultData::hit_test_results)& hit_test_results(
      const ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr& input) {
    return input->hit_test_results;
  }

  static bool Read(::device::mojom::blink::XRHitTestSubscriptionResultData::DataView input, ::device::mojom::blink::XRHitTestSubscriptionResultDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::DataView,
                                         ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::subscription_id)& subscription_id(
      const ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr& input) {
    return input->subscription_id;
  }

  static const decltype(::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::input_source_id_to_hit_test_results)& input_source_id_to_hit_test_results(
      const ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr& input) {
    return input->input_source_id_to_hit_test_results;
  }

  static bool Read(::device::mojom::blink::XRHitTestTransientInputSubscriptionResultData::DataView input, ::device::mojom::blink::XRHitTestTransientInputSubscriptionResultDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRHitTestSubscriptionResultsData::DataView,
                                         ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRHitTestSubscriptionResultsData::results)& results(
      const ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr& input) {
    return input->results;
  }

  static const decltype(::device::mojom::blink::XRHitTestSubscriptionResultsData::transient_input_results)& transient_input_results(
      const ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr& input) {
    return input->transient_input_results;
  }

  static bool Read(::device::mojom::blink::XRHitTestSubscriptionResultsData::DataView input, ::device::mojom::blink::XRHitTestSubscriptionResultsDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::RgbTupleF32::DataView,
                                         ::device::mojom::blink::RgbTupleF32Ptr> {
  static bool IsNull(const ::device::mojom::blink::RgbTupleF32Ptr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::RgbTupleF32Ptr* output) { output->reset(); }

  static decltype(::device::mojom::blink::RgbTupleF32::red) red(
      const ::device::mojom::blink::RgbTupleF32Ptr& input) {
    return input->red;
  }

  static decltype(::device::mojom::blink::RgbTupleF32::green) green(
      const ::device::mojom::blink::RgbTupleF32Ptr& input) {
    return input->green;
  }

  static decltype(::device::mojom::blink::RgbTupleF32::blue) blue(
      const ::device::mojom::blink::RgbTupleF32Ptr& input) {
    return input->blue;
  }

  static bool Read(::device::mojom::blink::RgbTupleF32::DataView input, ::device::mojom::blink::RgbTupleF32Ptr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRSphericalHarmonics::DataView,
                                         ::device::mojom::blink::XRSphericalHarmonicsPtr> {
  static bool IsNull(const ::device::mojom::blink::XRSphericalHarmonicsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRSphericalHarmonicsPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRSphericalHarmonics::coefficients)& coefficients(
      const ::device::mojom::blink::XRSphericalHarmonicsPtr& input) {
    return input->coefficients;
  }

  static bool Read(::device::mojom::blink::XRSphericalHarmonics::DataView input, ::device::mojom::blink::XRSphericalHarmonicsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRCubeMap::DataView,
                                         ::device::mojom::blink::XRCubeMapPtr> {
  static bool IsNull(const ::device::mojom::blink::XRCubeMapPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRCubeMapPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRCubeMap::width_and_height) width_and_height(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->width_and_height;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::positive_x)& positive_x(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->positive_x;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::negative_x)& negative_x(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->negative_x;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::positive_y)& positive_y(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->positive_y;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::negative_y)& negative_y(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->negative_y;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::positive_z)& positive_z(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->positive_z;
  }

  static const decltype(::device::mojom::blink::XRCubeMap::negative_z)& negative_z(
      const ::device::mojom::blink::XRCubeMapPtr& input) {
    return input->negative_z;
  }

  static bool Read(::device::mojom::blink::XRCubeMap::DataView input, ::device::mojom::blink::XRCubeMapPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRLightProbe::DataView,
                                         ::device::mojom::blink::XRLightProbePtr> {
  static bool IsNull(const ::device::mojom::blink::XRLightProbePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRLightProbePtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRLightProbe::spherical_harmonics)& spherical_harmonics(
      const ::device::mojom::blink::XRLightProbePtr& input) {
    return input->spherical_harmonics;
  }

  static const decltype(::device::mojom::blink::XRLightProbe::main_light_direction)& main_light_direction(
      const ::device::mojom::blink::XRLightProbePtr& input) {
    return input->main_light_direction;
  }

  static const decltype(::device::mojom::blink::XRLightProbe::main_light_intensity)& main_light_intensity(
      const ::device::mojom::blink::XRLightProbePtr& input) {
    return input->main_light_intensity;
  }

  static bool Read(::device::mojom::blink::XRLightProbe::DataView input, ::device::mojom::blink::XRLightProbePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRReflectionProbe::DataView,
                                         ::device::mojom::blink::XRReflectionProbePtr> {
  static bool IsNull(const ::device::mojom::blink::XRReflectionProbePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRReflectionProbePtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRReflectionProbe::cube_map)& cube_map(
      const ::device::mojom::blink::XRReflectionProbePtr& input) {
    return input->cube_map;
  }

  static bool Read(::device::mojom::blink::XRReflectionProbe::DataView input, ::device::mojom::blink::XRReflectionProbePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRLightEstimationData::DataView,
                                         ::device::mojom::blink::XRLightEstimationDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRLightEstimationDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRLightEstimationDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRLightEstimationData::light_probe)& light_probe(
      const ::device::mojom::blink::XRLightEstimationDataPtr& input) {
    return input->light_probe;
  }

  static const decltype(::device::mojom::blink::XRLightEstimationData::reflection_probe)& reflection_probe(
      const ::device::mojom::blink::XRLightEstimationDataPtr& input) {
    return input->reflection_probe;
  }

  static bool Read(::device::mojom::blink::XRLightEstimationData::DataView input, ::device::mojom::blink::XRLightEstimationDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRDepthDataStillValid::DataView,
                                         ::device::mojom::blink::XRDepthDataStillValidPtr> {
  static bool IsNull(const ::device::mojom::blink::XRDepthDataStillValidPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRDepthDataStillValidPtr* output) { output->reset(); }

  static bool Read(::device::mojom::blink::XRDepthDataStillValid::DataView input, ::device::mojom::blink::XRDepthDataStillValidPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRDepthDataUpdated::DataView,
                                         ::device::mojom::blink::XRDepthDataUpdatedPtr> {
  static bool IsNull(const ::device::mojom::blink::XRDepthDataUpdatedPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRDepthDataUpdatedPtr* output) { output->reset(); }

  static  decltype(::device::mojom::blink::XRDepthDataUpdated::pixel_data)& pixel_data(
       ::device::mojom::blink::XRDepthDataUpdatedPtr& input) {
    return input->pixel_data;
  }

  static const decltype(::device::mojom::blink::XRDepthDataUpdated::norm_texture_from_norm_view)& norm_texture_from_norm_view(
      const ::device::mojom::blink::XRDepthDataUpdatedPtr& input) {
    return input->norm_texture_from_norm_view;
  }

  static const decltype(::device::mojom::blink::XRDepthDataUpdated::size)& size(
      const ::device::mojom::blink::XRDepthDataUpdatedPtr& input) {
    return input->size;
  }

  static decltype(::device::mojom::blink::XRDepthDataUpdated::raw_value_to_meters) raw_value_to_meters(
      const ::device::mojom::blink::XRDepthDataUpdatedPtr& input) {
    return input->raw_value_to_meters;
  }

  static const decltype(::device::mojom::blink::XRDepthDataUpdated::view_geometry)& view_geometry(
      const ::device::mojom::blink::XRDepthDataUpdatedPtr& input) {
    return input->view_geometry;
  }

  static bool Read(::device::mojom::blink::XRDepthDataUpdated::DataView input, ::device::mojom::blink::XRDepthDataUpdatedPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRTrackedImageData::DataView,
                                         ::device::mojom::blink::XRTrackedImageDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRTrackedImageDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRTrackedImageDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRTrackedImageData::index) index(
      const ::device::mojom::blink::XRTrackedImageDataPtr& input) {
    return input->index;
  }

  static const decltype(::device::mojom::blink::XRTrackedImageData::mojo_from_image)& mojo_from_image(
      const ::device::mojom::blink::XRTrackedImageDataPtr& input) {
    return input->mojo_from_image;
  }

  static decltype(::device::mojom::blink::XRTrackedImageData::actively_tracked) actively_tracked(
      const ::device::mojom::blink::XRTrackedImageDataPtr& input) {
    return input->actively_tracked;
  }

  static decltype(::device::mojom::blink::XRTrackedImageData::width_in_meters) width_in_meters(
      const ::device::mojom::blink::XRTrackedImageDataPtr& input) {
    return input->width_in_meters;
  }

  static bool Read(::device::mojom::blink::XRTrackedImageData::DataView input, ::device::mojom::blink::XRTrackedImageDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRTrackedImagesData::DataView,
                                         ::device::mojom::blink::XRTrackedImagesDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRTrackedImagesDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRTrackedImagesDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRTrackedImagesData::images_data)& images_data(
      const ::device::mojom::blink::XRTrackedImagesDataPtr& input) {
    return input->images_data;
  }

  static const decltype(::device::mojom::blink::XRTrackedImagesData::image_trackable_scores)& image_trackable_scores(
      const ::device::mojom::blink::XRTrackedImagesDataPtr& input) {
    return input->image_trackable_scores;
  }

  static bool Read(::device::mojom::blink::XRTrackedImagesData::DataView input, ::device::mojom::blink::XRTrackedImagesDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::LayerId::DataView,
                                         ::device::mojom::blink::LayerIdPtr> {
  static bool IsNull(const ::device::mojom::blink::LayerIdPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::LayerIdPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::LayerId::id_value) id_value(
      const ::device::mojom::blink::LayerIdPtr& input) {
    return input->id_value;
  }

  static bool Read(::device::mojom::blink::LayerId::DataView input, ::device::mojom::blink::LayerIdPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRProjectionLayerData::DataView,
                                         ::device::mojom::blink::XRProjectionLayerDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRProjectionLayerDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRProjectionLayerDataPtr* output) { output->reset(); }

  static bool Read(::device::mojom::blink::XRProjectionLayerData::DataView input, ::device::mojom::blink::XRProjectionLayerDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRQuadLayerData::DataView,
                                         ::device::mojom::blink::XRQuadLayerDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRQuadLayerDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRQuadLayerDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRQuadLayerData::native_origin_from_layer)& native_origin_from_layer(
      const ::device::mojom::blink::XRQuadLayerDataPtr& input) {
    return input->native_origin_from_layer;
  }

  static decltype(::device::mojom::blink::XRQuadLayerData::width) width(
      const ::device::mojom::blink::XRQuadLayerDataPtr& input) {
    return input->width;
  }

  static decltype(::device::mojom::blink::XRQuadLayerData::height) height(
      const ::device::mojom::blink::XRQuadLayerDataPtr& input) {
    return input->height;
  }

  static bool Read(::device::mojom::blink::XRQuadLayerData::DataView input, ::device::mojom::blink::XRQuadLayerDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRCylinderLayerData::DataView,
                                         ::device::mojom::blink::XRCylinderLayerDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRCylinderLayerDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRCylinderLayerDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRCylinderLayerData::native_origin_from_layer)& native_origin_from_layer(
      const ::device::mojom::blink::XRCylinderLayerDataPtr& input) {
    return input->native_origin_from_layer;
  }

  static decltype(::device::mojom::blink::XRCylinderLayerData::radius) radius(
      const ::device::mojom::blink::XRCylinderLayerDataPtr& input) {
    return input->radius;
  }

  static decltype(::device::mojom::blink::XRCylinderLayerData::central_angle) central_angle(
      const ::device::mojom::blink::XRCylinderLayerDataPtr& input) {
    return input->central_angle;
  }

  static decltype(::device::mojom::blink::XRCylinderLayerData::aspect_ratio) aspect_ratio(
      const ::device::mojom::blink::XRCylinderLayerDataPtr& input) {
    return input->aspect_ratio;
  }

  static bool Read(::device::mojom::blink::XRCylinderLayerData::DataView input, ::device::mojom::blink::XRCylinderLayerDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XREquirectLayerData::DataView,
                                         ::device::mojom::blink::XREquirectLayerDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XREquirectLayerDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XREquirectLayerDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XREquirectLayerData::native_origin_from_layer)& native_origin_from_layer(
      const ::device::mojom::blink::XREquirectLayerDataPtr& input) {
    return input->native_origin_from_layer;
  }

  static decltype(::device::mojom::blink::XREquirectLayerData::radius) radius(
      const ::device::mojom::blink::XREquirectLayerDataPtr& input) {
    return input->radius;
  }

  static decltype(::device::mojom::blink::XREquirectLayerData::central_horizontal_angle) central_horizontal_angle(
      const ::device::mojom::blink::XREquirectLayerDataPtr& input) {
    return input->central_horizontal_angle;
  }

  static decltype(::device::mojom::blink::XREquirectLayerData::upper_vertical_angle) upper_vertical_angle(
      const ::device::mojom::blink::XREquirectLayerDataPtr& input) {
    return input->upper_vertical_angle;
  }

  static decltype(::device::mojom::blink::XREquirectLayerData::lower_vertical_angle) lower_vertical_angle(
      const ::device::mojom::blink::XREquirectLayerDataPtr& input) {
    return input->lower_vertical_angle;
  }

  static bool Read(::device::mojom::blink::XREquirectLayerData::DataView input, ::device::mojom::blink::XREquirectLayerDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRCubeLayerData::DataView,
                                         ::device::mojom::blink::XRCubeLayerDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRCubeLayerDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRCubeLayerDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRCubeLayerData::orientation)& orientation(
      const ::device::mojom::blink::XRCubeLayerDataPtr& input) {
    return input->orientation;
  }

  static bool Read(::device::mojom::blink::XRCubeLayerData::DataView input, ::device::mojom::blink::XRCubeLayerDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRLayerReadOnlyData::DataView,
                                         ::device::mojom::blink::XRLayerReadOnlyDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRLayerReadOnlyDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRLayerReadOnlyDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRLayerReadOnlyData::layer_id)& layer_id(
      const ::device::mojom::blink::XRLayerReadOnlyDataPtr& input) {
    return input->layer_id;
  }

  static decltype(::device::mojom::blink::XRLayerReadOnlyData::layout) layout(
      const ::device::mojom::blink::XRLayerReadOnlyDataPtr& input) {
    return input->layout;
  }

  static decltype(::device::mojom::blink::XRLayerReadOnlyData::texture_width) texture_width(
      const ::device::mojom::blink::XRLayerReadOnlyDataPtr& input) {
    return input->texture_width;
  }

  static decltype(::device::mojom::blink::XRLayerReadOnlyData::texture_height) texture_height(
      const ::device::mojom::blink::XRLayerReadOnlyDataPtr& input) {
    return input->texture_height;
  }

  static decltype(::device::mojom::blink::XRLayerReadOnlyData::is_static) is_static(
      const ::device::mojom::blink::XRLayerReadOnlyDataPtr& input) {
    return input->is_static;
  }

  static bool Read(::device::mojom::blink::XRLayerReadOnlyData::DataView input, ::device::mojom::blink::XRLayerReadOnlyDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRLayerMutableData::DataView,
                                         ::device::mojom::blink::XRLayerMutableDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRLayerMutableDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRLayerMutableDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRLayerMutableData::blend_texture_source_alpha) blend_texture_source_alpha(
      const ::device::mojom::blink::XRLayerMutableDataPtr& input) {
    return input->blend_texture_source_alpha;
  }

  static decltype(::device::mojom::blink::XRLayerMutableData::opacity) opacity(
      const ::device::mojom::blink::XRLayerMutableDataPtr& input) {
    return input->opacity;
  }

  static const decltype(::device::mojom::blink::XRLayerMutableData::native_origin_information)& native_origin_information(
      const ::device::mojom::blink::XRLayerMutableDataPtr& input) {
    return input->native_origin_information;
  }

  static const decltype(::device::mojom::blink::XRLayerMutableData::layer_data)& layer_data(
      const ::device::mojom::blink::XRLayerMutableDataPtr& input) {
    return input->layer_data;
  }

  static bool Read(::device::mojom::blink::XRLayerMutableData::DataView input, ::device::mojom::blink::XRLayerMutableDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRCompositionLayerData::DataView,
                                         ::device::mojom::blink::XRCompositionLayerDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRCompositionLayerDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRCompositionLayerDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRCompositionLayerData::read_only_data)& read_only_data(
      const ::device::mojom::blink::XRCompositionLayerDataPtr& input) {
    return input->read_only_data;
  }

  static const decltype(::device::mojom::blink::XRCompositionLayerData::mutable_data)& mutable_data(
      const ::device::mojom::blink::XRCompositionLayerDataPtr& input) {
    return input->mutable_data;
  }

  static bool Read(::device::mojom::blink::XRCompositionLayerData::DataView input, ::device::mojom::blink::XRCompositionLayerDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRLayerFrameData::DataView,
                                         ::device::mojom::blink::XRLayerFrameDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRLayerFrameDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRLayerFrameDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::XRLayerFrameData::layer_id)& layer_id(
      const ::device::mojom::blink::XRLayerFrameDataPtr& input) {
    return input->layer_id;
  }

  static  decltype(::device::mojom::blink::XRLayerFrameData::buffer_shared_image)& buffer_shared_image(
       ::device::mojom::blink::XRLayerFrameDataPtr& input) {
    return input->buffer_shared_image;
  }

  static const decltype(::device::mojom::blink::XRLayerFrameData::buffer_sync_token)& buffer_sync_token(
      const ::device::mojom::blink::XRLayerFrameDataPtr& input) {
    return input->buffer_sync_token;
  }

  static bool Read(::device::mojom::blink::XRLayerFrameData::DataView input, ::device::mojom::blink::XRLayerFrameDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRRenderInfo::DataView,
                                         ::device::mojom::blink::XRRenderInfoPtr> {
  static bool IsNull(const ::device::mojom::blink::XRRenderInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRRenderInfoPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRRenderInfo::frame_id) frame_id(
      const ::device::mojom::blink::XRRenderInfoPtr& input) {
    return input->frame_id;
  }

  static const decltype(::device::mojom::blink::XRRenderInfo::mojo_from_viewer)& mojo_from_viewer(
      const ::device::mojom::blink::XRRenderInfoPtr& input) {
    return input->mojo_from_viewer;
  }

  static  decltype(::device::mojom::blink::XRRenderInfo::views)& views(
       ::device::mojom::blink::XRRenderInfoPtr& input) {
    return input->views;
  }

  static bool Read(::device::mojom::blink::XRRenderInfo::DataView input, ::device::mojom::blink::XRRenderInfoPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRFrameData::DataView,
                                         ::device::mojom::blink::XRFrameDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRFrameDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRFrameDataPtr* output) { output->reset(); }

  static  decltype(::device::mojom::blink::XRFrameData::render_info)& render_info(
       ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->render_info;
  }

  static const decltype(::device::mojom::blink::XRFrameData::time_delta)& time_delta(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->time_delta;
  }

  static  decltype(::device::mojom::blink::XRFrameData::buffer_shared_image)& buffer_shared_image(
       ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->buffer_shared_image;
  }

  static const decltype(::device::mojom::blink::XRFrameData::buffer_sync_token)& buffer_sync_token(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->buffer_sync_token;
  }

  static  decltype(::device::mojom::blink::XRFrameData::camera_image_buffer_shared_image)& camera_image_buffer_shared_image(
       ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->camera_image_buffer_shared_image;
  }

  static const decltype(::device::mojom::blink::XRFrameData::camera_image_buffer_sync_token)& camera_image_buffer_sync_token(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->camera_image_buffer_sync_token;
  }

  static const decltype(::device::mojom::blink::XRFrameData::camera_image_size)& camera_image_size(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->camera_image_size;
  }

  static decltype(::device::mojom::blink::XRFrameData::mojo_space_reset) mojo_space_reset(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->mojo_space_reset;
  }

  static const decltype(::device::mojom::blink::XRFrameData::mojo_from_floor)& mojo_from_floor(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->mojo_from_floor;
  }

  static const decltype(::device::mojom::blink::XRFrameData::input_state)& input_state(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->input_state;
  }

  static decltype(::device::mojom::blink::XRFrameData::stage_parameters_id) stage_parameters_id(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->stage_parameters_id;
  }

  static const decltype(::device::mojom::blink::XRFrameData::stage_parameters)& stage_parameters(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->stage_parameters;
  }

  static const decltype(::device::mojom::blink::XRFrameData::detected_planes_data)& detected_planes_data(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->detected_planes_data;
  }

  static const decltype(::device::mojom::blink::XRFrameData::anchors_data)& anchors_data(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->anchors_data;
  }

  static  decltype(::device::mojom::blink::XRFrameData::composition_layers_data)& composition_layers_data(
       ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->composition_layers_data;
  }

  static const decltype(::device::mojom::blink::XRFrameData::light_estimation_data)& light_estimation_data(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->light_estimation_data;
  }

  static const decltype(::device::mojom::blink::XRFrameData::hit_test_subscription_results)& hit_test_subscription_results(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->hit_test_subscription_results;
  }

  static decltype(::device::mojom::blink::XRFrameData::rendering_time_ratio) rendering_time_ratio(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->rendering_time_ratio;
  }

  static const decltype(::device::mojom::blink::XRFrameData::tracked_images)& tracked_images(
      const ::device::mojom::blink::XRFrameDataPtr& input) {
    return input->tracked_images;
  }

  static bool Read(::device::mojom::blink::XRFrameData::DataView input, ::device::mojom::blink::XRFrameDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::RequestSessionSuccess::DataView,
                                         ::device::mojom::blink::RequestSessionSuccessPtr> {
  static bool IsNull(const ::device::mojom::blink::RequestSessionSuccessPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::RequestSessionSuccessPtr* output) { output->reset(); }

  static  decltype(::device::mojom::blink::RequestSessionSuccess::session)& session(
       ::device::mojom::blink::RequestSessionSuccessPtr& input) {
    return input->session;
  }

  static decltype(::device::mojom::blink::RequestSessionSuccess::trace_id) trace_id(
      const ::device::mojom::blink::RequestSessionSuccessPtr& input) {
    return input->trace_id;
  }

  static  decltype(::device::mojom::blink::RequestSessionSuccess::metrics_recorder)& metrics_recorder(
       ::device::mojom::blink::RequestSessionSuccessPtr& input) {
    return input->metrics_recorder;
  }

  static  decltype(::device::mojom::blink::RequestSessionSuccess::xr_internals_listener)& xr_internals_listener(
       ::device::mojom::blink::RequestSessionSuccessPtr& input) {
    return input->xr_internals_listener;
  }

  static bool Read(::device::mojom::blink::RequestSessionSuccess::DataView input, ::device::mojom::blink::RequestSessionSuccessPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) StructTraits<::device::mojom::blink::XRFrameDataRequestOptions::DataView,
                                         ::device::mojom::blink::XRFrameDataRequestOptionsPtr> {
  static bool IsNull(const ::device::mojom::blink::XRFrameDataRequestOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRFrameDataRequestOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::XRFrameDataRequestOptions::include_lighting_estimation_data) include_lighting_estimation_data(
      const ::device::mojom::blink::XRFrameDataRequestOptionsPtr& input) {
    return input->include_lighting_estimation_data;
  }

  static decltype(::device::mojom::blink::XRFrameDataRequestOptions::depth_active) depth_active(
      const ::device::mojom::blink::XRFrameDataRequestOptionsPtr& input) {
    return input->depth_active;
  }

  static decltype(::device::mojom::blink::XRFrameDataRequestOptions::stage_parameters_id) stage_parameters_id(
      const ::device::mojom::blink::XRFrameDataRequestOptionsPtr& input) {
    return input->stage_parameters_id;
  }

  static bool Read(::device::mojom::blink::XRFrameDataRequestOptions::DataView input, ::device::mojom::blink::XRFrameDataRequestOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) UnionTraits<::device::mojom::blink::XRNativeOriginInformation::DataView,
                                        ::device::mojom::blink::XRNativeOriginInformationPtr> {
  static bool IsNull(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRNativeOriginInformationPtr* output) { output->reset(); }

  static ::device::mojom::blink::XRNativeOriginInformation::Tag GetTag(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->which();
  }

  static const ::device::mojom::blink::XRInputSourceSpaceInfoPtr& input_source_space_info(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->get_input_source_space_info();
  }

  static const ::device::PlaneId& plane_id(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->get_plane_id();
  }

  static const ::device::AnchorId& anchor_id(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->get_anchor_id();
  }

  static  ::device::mojom::blink::XRReferenceSpaceType reference_space_type(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->get_reference_space_type();
  }

  static const ::device::mojom::blink::XRHandJointSpaceInfoPtr& hand_joint_space_info(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->get_hand_joint_space_info();
  }

  static  uint32_t image_index(const ::device::mojom::blink::XRNativeOriginInformationPtr& input) {
    return input->get_image_index();
  }

  static bool Read(::device::mojom::blink::XRNativeOriginInformation::DataView input, ::device::mojom::blink::XRNativeOriginInformationPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) UnionTraits<::device::mojom::blink::XRDepthData::DataView,
                                        ::device::mojom::blink::XRDepthDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRDepthDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRDepthDataPtr* output) { output->reset(); }

  static ::device::mojom::blink::XRDepthData::Tag GetTag(const ::device::mojom::blink::XRDepthDataPtr& input) {
    return input->which();
  }

  static const ::device::mojom::blink::XRDepthDataStillValidPtr& data_still_valid(const ::device::mojom::blink::XRDepthDataPtr& input) {
    return input->get_data_still_valid();
  }

  static  ::device::mojom::blink::XRDepthDataUpdatedPtr& updated_depth_data( ::device::mojom::blink::XRDepthDataPtr& input) {
    return input->get_updated_depth_data();
  }

  static bool Read(::device::mojom::blink::XRDepthData::DataView input, ::device::mojom::blink::XRDepthDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) UnionTraits<::device::mojom::blink::XRLayerSpecificData::DataView,
                                        ::device::mojom::blink::XRLayerSpecificDataPtr> {
  static bool IsNull(const ::device::mojom::blink::XRLayerSpecificDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::XRLayerSpecificDataPtr* output) { output->reset(); }

  static ::device::mojom::blink::XRLayerSpecificData::Tag GetTag(const ::device::mojom::blink::XRLayerSpecificDataPtr& input) {
    return input->which();
  }

  static const ::device::mojom::blink::XRProjectionLayerDataPtr& projection(const ::device::mojom::blink::XRLayerSpecificDataPtr& input) {
    return input->get_projection();
  }

  static const ::device::mojom::blink::XRQuadLayerDataPtr& quad(const ::device::mojom::blink::XRLayerSpecificDataPtr& input) {
    return input->get_quad();
  }

  static const ::device::mojom::blink::XRCylinderLayerDataPtr& cylinder(const ::device::mojom::blink::XRLayerSpecificDataPtr& input) {
    return input->get_cylinder();
  }

  static const ::device::mojom::blink::XREquirectLayerDataPtr& equirect(const ::device::mojom::blink::XRLayerSpecificDataPtr& input) {
    return input->get_equirect();
  }

  static const ::device::mojom::blink::XRCubeLayerDataPtr& cube(const ::device::mojom::blink::XRLayerSpecificDataPtr& input) {
    return input->get_cube();
  }

  static bool Read(::device::mojom::blink::XRLayerSpecificData::DataView input, ::device::mojom::blink::XRLayerSpecificDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS_BLINK) UnionTraits<::device::mojom::blink::RequestSessionResult::DataView,
                                        ::device::mojom::blink::RequestSessionResultPtr> {
  static bool IsNull(const ::device::mojom::blink::RequestSessionResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::RequestSessionResultPtr* output) { output->reset(); }

  static ::device::mojom::blink::RequestSessionResult::Tag GetTag(const ::device::mojom::blink::RequestSessionResultPtr& input) {
    return input->which();
  }

  static  ::device::mojom::blink::RequestSessionSuccessPtr& success( ::device::mojom::blink::RequestSessionResultPtr& input) {
    return input->get_success();
  }

  static  ::device::mojom::blink::RequestSessionError failure_reason(const ::device::mojom::blink::RequestSessionResultPtr& input) {
    return input->get_failure_reason();
  }

  static bool Read(::device::mojom::blink::RequestSessionResult::DataView input, ::device::mojom::blink::RequestSessionResultPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_BLINK_H_