// device/vr/public/mojom/test/browser_test_interfaces.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_TEST_BROWSER_TEST_INTERFACES_MOJOM_SHARED_H_
#define DEVICE_VR_PUBLIC_MOJOM_TEST_BROWSER_TEST_INTERFACES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/test/browser_test_interfaces.mojom-shared-internal.h"
#include "device/vr/public/mojom/openxr_interaction_profile_type.mojom-shared.h"
#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "device/vr/public/mojom/test/browser_test_interfaces.mojom-data-view.h"




namespace std {

template <>
struct hash<::device_test::mojom::Eye>
    : public mojo::internal::EnumHashImpl<::device_test::mojom::Eye> {};

template <>
struct hash<::device_test::mojom::ControllerRole>
    : public mojo::internal::EnumHashImpl<::device_test::mojom::ControllerRole> {};

template <>
struct hash<::device_test::mojom::EventType>
    : public mojo::internal::EnumHashImpl<::device_test::mojom::EventType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::Eye, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device_test::mojom::Eye, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device_test::mojom::Eye>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::ControllerRole, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device_test::mojom::ControllerRole, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device_test::mojom::ControllerRole>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::EventType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device_test::mojom::EventType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device_test::mojom::EventType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::ColorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ColorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::Color_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->r = Traits::r(input);

    fragment->g = Traits::g(input);

    fragment->b = Traits::b(input);

    fragment->a = Traits::a(input);
  }

  static bool Deserialize(::device_test::mojom::internal::Color_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::ColorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::ViewDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ViewDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::ViewData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::color(input)) in_color = Traits::color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color)::BaseType> color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device_test::mojom::ColorDataView>(
      in_color,
      color_fragment);

    fragment->color.Set(
        color_fragment.is_null() ? nullptr : color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color in ViewData struct");

    
    mojo::internal::Serialize<::device_test::mojom::Eye>(
      Traits::eye(input),
      &fragment->eye);

    decltype(Traits::viewport(input)) in_viewport = Traits::viewport(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewport)::BaseType> viewport_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_viewport,
      viewport_fragment);

    fragment->viewport.Set(
        viewport_fragment.is_null() ? nullptr : viewport_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->viewport.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null viewport in ViewData struct");
  }

  static bool Deserialize(::device_test::mojom::internal::ViewData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::ViewDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::DeviceConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::DeviceConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::DeviceConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->interpupillary_distance = Traits::interpupillary_distance(input);
  }

  static bool Deserialize(::device_test::mojom::internal::DeviceConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::DeviceConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::ControllerAxisDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ControllerAxisDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::ControllerAxisData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->x = Traits::x(input);

    fragment->y = Traits::y(input);

    fragment->axis_type = Traits::axis_type(input);
  }

  static bool Deserialize(::device_test::mojom::internal::ControllerAxisData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::ControllerAxisDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::ControllerFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ControllerFrameDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::ControllerFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->packet_number = Traits::packet_number(input);

    fragment->buttons_pressed = Traits::buttons_pressed(input);

    fragment->buttons_touched = Traits::buttons_touched(input);

    fragment->supported_buttons = Traits::supported_buttons(input);

    decltype(Traits::axis_data(input)) in_axis_data = Traits::axis_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->axis_data)::BaseType>
        axis_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& axis_data_validate_params =
        mojo::internal::GetArrayValidator<5, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device_test::mojom::ControllerAxisDataDataView>>(
      in_axis_data,
      axis_data_fragment,
      &axis_data_validate_params);

    fragment->axis_data.Set(
        axis_data_fragment.is_null() ? nullptr : axis_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->axis_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null axis_data in ControllerFrameData struct");

    decltype(Traits::pose_data(input)) in_pose_data = Traits::pose_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pose_data)::BaseType> pose_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
      in_pose_data,
      pose_data_fragment);

    fragment->pose_data.Set(
        pose_data_fragment.is_null() ? nullptr : pose_data_fragment.data());

    
    mojo::internal::Serialize<::device_test::mojom::ControllerRole>(
      Traits::role(input),
      &fragment->role);

    decltype(Traits::hand_data(input)) in_hand_data = Traits::hand_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hand_data)::BaseType> hand_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::XRHandTrackingDataDataView>(
      in_hand_data,
      hand_data_fragment);

    fragment->hand_data.Set(
        hand_data_fragment.is_null() ? nullptr : hand_data_fragment.data());

    fragment->is_valid = Traits::is_valid(input);
  }

  static bool Deserialize(::device_test::mojom::internal::ControllerFrameData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::ControllerFrameDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::EventDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::EventDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::EventData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::device_test::mojom::EventType>(
      Traits::type(input),
      &fragment->type);

    
    mojo::internal::Serialize<::device::mojom::OpenXrInteractionProfileType>(
      Traits::interaction_profile(input),
      &fragment->interaction_profile);
  }

  static bool Deserialize(::device_test::mojom::internal::EventData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::EventDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::XRVisibilityMaskDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::XRVisibilityMaskDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device_test::mojom::internal::XRVisibilityMask_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::vertices(input)) in_vertices = Traits::vertices(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->vertices)::BaseType>
        vertices_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& vertices_validate_params =
        mojo::internal::GetArrayValidator<6, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_vertices,
      vertices_fragment,
      &vertices_validate_params);

    fragment->vertices.Set(
        vertices_fragment.is_null() ? nullptr : vertices_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->vertices.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vertices in XRVisibilityMask struct");

    decltype(Traits::indices(input)) in_indices = Traits::indices(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->indices)::BaseType>
        indices_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& indices_validate_params =
        mojo::internal::GetArrayValidator<3, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_indices,
      indices_fragment,
      &indices_validate_params);

    fragment->indices.Set(
        indices_fragment.is_null() ? nullptr : indices_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->indices.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null indices in XRVisibilityMask struct");
  }

  static bool Deserialize(::device_test::mojom::internal::XRVisibilityMask_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::XRVisibilityMaskDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device_test::mojom {



inline void ViewDataDataView::GetColorDataView(
    ColorDataView* output) {
  auto pointer = data_->color.Get();
  *output = ColorDataView(pointer, message_);
}
inline void ViewDataDataView::GetViewportDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->viewport.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}






inline void ControllerFrameDataDataView::GetAxisDataDataView(
    mojo::ArrayDataView<ControllerAxisDataDataView>* output) {
  auto pointer = data_->axis_data.Get();
  *output = mojo::ArrayDataView<ControllerAxisDataDataView>(pointer, message_);
}
inline void ControllerFrameDataDataView::GetPoseDataDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->pose_data.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}
inline void ControllerFrameDataDataView::GetHandDataDataView(
    ::device::mojom::XRHandTrackingDataDataView* output) {
  auto pointer = data_->hand_data.Get();
  *output = ::device::mojom::XRHandTrackingDataDataView(pointer, message_);
}




inline void XRVisibilityMaskDataView::GetVerticesDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->vertices.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void XRVisibilityMaskDataView::GetIndicesDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->indices.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}



}  // device_test::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::device_test::mojom::Eye> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device_test::mojom::Eye value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device_test::mojom::ControllerRole> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device_test::mojom::ControllerRole value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device_test::mojom::EventType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device_test::mojom::EventType value);
};

} // namespace perfetto

#endif  // DEVICE_VR_PUBLIC_MOJOM_TEST_BROWSER_TEST_INTERFACES_MOJOM_SHARED_H_